/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.config.add;

import java.util.Map;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import ru.softlogic.config.BaseSection;
import ru.softlogic.config.ParceException;
import ru.softlogic.config.add.GuiConfiguration;

public class GuiSection
extends BaseSection {
    private static final String SIZE = "size";
    private static final String ON_TOP = "on-top";
    private static final String SHOW_CURSOR = "cursor";
    private GuiConfiguration conf;

    public GuiSection() {
        this.conf = new GuiConfiguration("", false, true);
    }

    public GuiSection(GuiConfiguration conf) {
        if (conf == null) {
            throw new NullPointerException("GuiConfiguration is null");
        }
        this.conf = conf;
    }

    @Override
    public String getKey() {
        return "gui";
    }

    @Override
    public void parce(Element element) throws ParceException {
        Map<String, String> opts = this.readOptions(element);
        this.conf = new GuiConfiguration(this.readString(opts, SIZE, ""), this.readBoolean(opts, SHOW_CURSOR, false), this.readBoolean(opts, ON_TOP, true));
    }

    @Override
    public Element generate(Document doc) {
        Element root = doc.createElement(this.getKey());
        this.writeOption(doc, root, SIZE, this.conf.getSize());
        this.writeOption(doc, root, ON_TOP, Boolean.toString(this.conf.isOnTop()));
        this.writeOption(doc, root, SHOW_CURSOR, Boolean.toString(this.conf.isShowCursor()));
        return root;
    }

    public GuiConfiguration getConfiguration() {
        return this.conf;
    }

    @Override
    public String getGroup() {
        return "various";
    }
}

