/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.config.add;

import java.util.Map;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import ru.softlogic.config.BaseSection;
import ru.softlogic.config.ParceException;
import ru.softlogic.config.add.ConConfiguration;
import ru.softlogic.config.add.Proxy;
import ru.softlogic.config.add.ServerProfile;

public class ConSection
extends BaseSection {
    private static final String PROFILES = "profiles";
    private static final String PROFILE = "profile";
    private static final String SELECTED = "selected";
    private static final String ID = "id";
    private static final String HOST = "host";
    private static final String HTTP_PORT = "http-port";
    private static final String HTTPS_PORT = "https-port";
    private static final String POINT = "point";
    private static final String TIMEOUT = "timeout";
    private static final String PROXY = "proxy";
    private static final String PROXY_USE = "use";
    private static final String PROXY_HOST = "host";
    private static final String PROXY_PORT = "port";
    private static final String PROXY_AUTH = "auth";
    private static final String PROXY_USER = "username";
    private static final String PROXY_PASS = "password";
    private static final String NETWORK = "network";
    private static final String PRIMARY = "primary";
    private ConConfiguration conf;

    public ConSection() {
    }

    public ConSection(ConConfiguration conf) {
        this.conf = conf;
    }

    @Override
    public String getGroup() {
        return null;
    }

    @Override
    public String getKey() {
        return "connection";
    }

    @Override
    public void parce(Element element) throws ParceException {
        Element prs = this.getElement(element, PROFILES);
        String sp = null;
        ServerProfile[] profiles = null;
        if (prs != null) {
            sp = prs.getAttribute(SELECTED);
            NodeList nl = element.getElementsByTagName(PROFILE);
            if (nl != null && nl.getLength() > 0) {
                profiles = new ServerProfile[nl.getLength()];
                for (int i = 0; i < nl.getLength(); ++i) {
                    Element pr = (Element)nl.item(i);
                    profiles[i] = new ServerProfile(pr.getAttribute(ID), pr.getAttribute("host"), this.readInt(pr.getAttribute(HTTP_PORT)), this.readInt(pr.getAttribute(HTTPS_PORT)), this.readInt(pr.getAttribute(POINT)), this.readInt(pr.getAttribute(TIMEOUT), 60));
                }
            }
        }
        String dialup = null;
        Element network = this.getElement(element, NETWORK);
        if (network != null) {
            dialup = network.getAttribute(PRIMARY);
        }
        Element proxy = this.getElement(element, PROXY);
        Proxy p = null;
        if (proxy != null) {
            Map<String, String> opt = this.readOptions(proxy);
            p = new Proxy(this.readBoolean(opt, PROXY_USE, false), this.readString(opt, "host", ""), this.readInt(opt, PROXY_PORT), this.readBoolean(opt, PROXY_AUTH, false), this.readString(opt, PROXY_USER, ""), this.readString(opt, PROXY_PASS, ""));
        }
        this.conf = new ConConfiguration(profiles, sp, p, dialup);
    }

    @Override
    public Node generate(Document doc) {
        Element root = null;
        if (this.conf != null) {
            root = doc.createElement(this.getKey());
            if (this.conf.getProfiles() != null) {
                Element profiles = doc.createElement(PROFILES);
                profiles.setAttribute(SELECTED, this.conf.getSelected());
                for (ServerProfile sp : this.conf.getProfiles()) {
                    Element profile = doc.createElement(PROFILE);
                    profile.setAttribute(ID, sp.getId());
                    profile.setAttribute(POINT, Integer.toString(sp.getPointId()));
                    profile.setAttribute("host", sp.getHost());
                    profile.setAttribute(HTTP_PORT, Integer.toString(sp.getHttpPort()));
                    profile.setAttribute(HTTPS_PORT, Integer.toString(sp.getHttpsPort()));
                    if (sp.getTimeout() != 60) {
                        profile.setAttribute(TIMEOUT, Integer.toString(sp.getTimeout()));
                    }
                    profiles.appendChild(profile);
                }
                root.appendChild(profiles);
            }
            if (this.conf.getDialup() != null && !this.conf.getDialup().isEmpty()) {
                Element network = doc.createElement(NETWORK);
                network.setAttribute(PRIMARY, this.conf.getDialup());
                root.appendChild(network);
            }
            if (this.conf.getProxy() != null && this.conf.getProxy().hasOptions()) {
                Proxy p = this.conf.getProxy();
                Element proxy = doc.createElement(PROXY);
                this.writeOption(doc, proxy, PROXY_USE, Boolean.toString(p.isUse()));
                this.writeOption(doc, proxy, "host", p.getHost());
                this.writeOption(doc, proxy, PROXY_PORT, Integer.toString(p.getPort()));
                if (p.hasAuth()) {
                    this.writeOption(doc, proxy, PROXY_AUTH, Boolean.toString(p.isAuth()));
                    this.writeOption(doc, proxy, PROXY_USER, p.getUsername());
                    this.writeOption(doc, proxy, PROXY_PASS, p.getPassword());
                }
                root.appendChild(proxy);
            }
        }
        return root;
    }

    public ConConfiguration getConfiguration() {
        return this.conf;
    }

    private Element getElement(Element root, String name) {
        NodeList nl = root.getElementsByTagName(name);
        if (nl.getLength() > 0) {
            return (Element)nl.item(0);
        }
        return null;
    }
}

