/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.config;

import java.util.HashMap;
import java.util.Map;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import ru.softlogic.config.ParceException;
import ru.softlogic.config.Section;

public abstract class BaseSection
implements Section {
    public static final String OPTION = "option";
    public static final String KEY = "key";
    public static final String VALUE = "value";

    protected void writeOptions(Document doc, Element root, Map<String, String> options) {
        for (Map.Entry<String, String> e : options.entrySet()) {
            Element opt = doc.createElement(OPTION);
            opt.setAttribute(KEY, e.getKey());
            opt.setAttribute(VALUE, e.getValue());
            root.appendChild(opt);
        }
    }

    protected void writeOption(Document doc, Element root, String key, String value) {
        Element opt = doc.createElement(OPTION);
        opt.setAttribute(KEY, key);
        opt.setAttribute(VALUE, value);
        root.appendChild(opt);
    }

    protected void writeOption(Document doc, Element root, String key, int value) {
        this.writeOption(doc, root, key, Integer.toString(value));
    }

    protected Map<String, String> readOptions(Element element) {
        NodeList nl = element.getElementsByTagName(OPTION);
        if (nl == null || nl.getLength() == 0) {
            return new HashMap<String, String>();
        }
        HashMap<String, String> res = new HashMap<String, String>();
        for (int i = 0; i < nl.getLength(); ++i) {
            Element el = (Element)nl.item(i);
            res.put(el.getAttribute(KEY), el.getAttribute(VALUE));
        }
        return res;
    }

    protected boolean readBoolean(Map<String, String> map, String key) throws ParceException {
        String val = map.get(key);
        this.checkNull(val, key);
        return Boolean.parseBoolean(val);
    }

    protected boolean readBoolean(Map<String, String> map, String key, boolean def) {
        String val = map.get(key);
        if (val == null) {
            return def;
        }
        return Boolean.parseBoolean(val);
    }

    protected boolean readBoolean(String value) throws ParceException {
        if (value == null) {
            throw new ParceException("Value is null");
        }
        return Boolean.parseBoolean(value);
    }

    protected boolean readBoolean(String value, boolean def) {
        if (value == null || value.isEmpty()) {
            return def;
        }
        return Boolean.parseBoolean(value);
    }

    protected int readInt(Map<String, String> map, String key) throws ParceException {
        String val = map.get(key);
        this.checkNull(val, key);
        return this.readInt(val);
    }

    protected int readInt(Map<String, String> map, String key, int def) {
        String val = map.get(key);
        if (val == null) {
            return def;
        }
        try {
            return Integer.parseInt(val);
        }
        catch (NumberFormatException ex) {
            return def;
        }
    }

    protected int readInt(String value) throws ParceException {
        try {
            return Integer.parseInt(value);
        }
        catch (NumberFormatException ex) {
            throw new ParceException("Param '" + value + "' has wrong value", ex);
        }
    }

    protected int readInt(String value, int def) throws ParceException {
        if (value != null) {
            try {
                return Integer.parseInt(value);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return def;
    }

    protected String readString(Map<String, String> map, String key, String def) {
        String val = map.get(key);
        return val == null ? def : val;
    }

    private void checkNull(String val, String key) throws ParceException {
        if (val == null) {
            throw new ParceException("Param '" + key + "' is not found");
        }
    }
}

