/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.io;

import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import ru.softlogic.io.BasePort;
import ru.softlogic.io.Storage;
import ru.softlogic.io.utils.BU;

public class StopStorage
implements Storage {
    private final List<Byte> buf = new LinkedList<Byte>();
    private final byte stop;
    private final int depth;

    public StopStorage(byte stop, int depth) {
        if (depth <= 0 || depth > 255) {
            throw new IllegalArgumentException("Depth is wrong: " + depth + ", value must be in range [0..255]");
        }
        this.stop = stop;
        this.depth = depth;
    }

    public StopStorage(byte stop) {
        this(stop, 255);
    }

    @Override
    public boolean add(byte b, BasePort port) throws IOException {
        this.buf.add(b);
        if (b == this.stop) {
            return false;
        }
        if (this.buf.size() > this.depth) {
            throw new IOException("Can't find stop byte " + BU.toHex(this.stop) + ", readed: " + BU.toString(this.buf));
        }
        return true;
    }

    @Override
    public byte[] getResult() {
        return BU.convert(this.buf);
    }
}

