/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.io;

import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import ru.softlogic.io.BasePort;
import ru.softlogic.io.Storage;
import ru.softlogic.io.utils.BU;

public class StartStopStorage
implements Storage {
    private final List<Byte> buf = new LinkedList<Byte>();
    private List<Byte> garbage = null;
    private final byte start;
    private final int depth;
    private final int maxLen;
    private final byte stop;
    private final int add;

    public StartStopStorage(byte start, byte stop, int add) {
        this(start, 24, 128, stop, add);
    }

    public StartStopStorage(byte start, int depth, int maxLen, byte stop, int add) {
        if (depth <= 0 || depth > 255) {
            throw new IllegalArgumentException("Depth is wrong: " + depth + ", value must be in range [0..255]");
        }
        if (maxLen <= 0) {
            throw new IllegalArgumentException("MaxLen is wrong: " + maxLen + ", value must be positive");
        }
        if (add < 0 || add > 16) {
            throw new IllegalArgumentException("Add is wrong: " + add + ", value must be in range [0..16]");
        }
        this.start = start;
        this.depth = depth;
        this.maxLen = maxLen;
        this.stop = stop;
        this.add = add;
    }

    @Override
    public boolean add(byte b, BasePort port) throws IOException {
        if (this.buf.isEmpty()) {
            if (b == this.start) {
                this.buf.add(b);
            } else {
                if (this.garbage == null) {
                    this.garbage = new LinkedList<Byte>();
                }
                this.garbage.add(b);
                if (this.garbage.size() > this.depth) {
                    throw new IOException("Can't find start byte " + BU.toHex(this.start) + ", readed: " + BU.toString(this.garbage));
                }
            }
        } else {
            this.buf.add(b);
            if (b == this.stop) {
                if (this.add > 0) {
                    byte[] tail;
                    for (byte tb : tail = port.read(this.add)) {
                        this.buf.add(tb);
                    }
                }
                return false;
            }
            if (this.buf.size() > this.maxLen) {
                throw new IOException("Value is too long: " + BU.toString(this.buf));
            }
        }
        return true;
    }

    @Override
    public byte[] getResult() {
        return BU.convert(this.buf);
    }
}

