/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.io;

import java.util.LinkedList;
import ru.softlogic.io.Loader;
import ru.softlogic.io.Port;
import ru.softlogic.io.PortId;
import ru.softlogic.io.PortType;
import ru.softlogic.io.parallel.ParallelPort;
import ru.softlogic.io.serial.SerialPort;
import ru.softlogic.io.usb.UsbPort;

public class PortScanner
extends Loader {
    public static PortId[] scan() {
        String[] usb;
        String[] lpt;
        LinkedList<PortId> ports = new LinkedList<PortId>();
        String[] com = PortScanner.scanSerialNative();
        if (com != null && com.length > 0) {
            for (String port : PortScanner.filter(com)) {
                ports.add(new PortId(port, PortType.SerialPort));
            }
        }
        if ((lpt = PortScanner.scanParallelNative()) != null && lpt.length > 0) {
            for (String port : PortScanner.filter(lpt)) {
                ports.add(new PortId(port, PortType.ParallelPort));
            }
        }
        if ((usb = PortScanner.scanUsbNative()) != null && usb.length > 0) {
            for (String port : PortScanner.filter(usb)) {
                ports.add(new PortId(port, PortType.UsbPort));
            }
        }
        return ports.toArray(new PortId[ports.size()]);
    }

    public static String[] scanSerial() {
        String[] res = PortScanner.scanSerialNative();
        if (res != null && res.length > 0) {
            return PortScanner.filter(res);
        }
        return new String[]{PortScanner.serialNameNative()};
    }

    public static String[] scanParallel() {
        String[] res = PortScanner.scanParallelNative();
        if (res != null && res.length > 0) {
            return PortScanner.filter(res);
        }
        return new String[]{PortScanner.parallelNameNative()};
    }

    public static String[] scanUsb() {
        String[] res = PortScanner.scanUsbNative();
        return res != null ? PortScanner.filter(res) : new String[]{};
    }

    public static PortType getType(String name) {
        if (name == null || name.isEmpty()) {
            return null;
        }
        for (PortId portId : PortScanner.scan()) {
            if (!portId.getName().equals(name)) continue;
            return portId.getType();
        }
        return null;
    }

    private static String[] filter(String[] ports) {
        String denystr = System.getProperty("port.deny");
        if (denystr == null || denystr.isEmpty() || ports == null || ports.length == 0) {
            return ports;
        }
        LinkedList<String> res = new LinkedList<String>();
        String[] denys = denystr.split(",");
        for (String p : ports) {
            boolean deny = false;
            for (String d : denys) {
                if (!p.contains(d)) continue;
                deny = true;
                break;
            }
            if (deny) continue;
            res.add(p);
        }
        return res.toArray(new String[res.size()]);
    }

    public static PortType suggestType(String name) {
        if (name == null || name.isEmpty()) {
            return null;
        }
        if (name.matches("^COM[1-9]+[0-9]?$")) {
            return PortType.SerialPort;
        }
        if (name.matches("^/dev/ttyS[0-9]{1,2}$")) {
            return PortType.SerialPort;
        }
        if (name.matches("^/dev/ttyD[0-9]{1,2}$")) {
            return PortType.SerialPort;
        }
        if (name.matches("^/dev/ttyUSB[0-9]{1,2}$")) {
            return PortType.SerialPort;
        }
        if (name.matches("^/dev/ttyMP[0-9]{1,2}$")) {
            return PortType.SerialPort;
        }
        if (name.matches("^/dev/ttyACM[0-9]{1,2}$")) {
            return PortType.SerialPort;
        }
        if (name.matches("^/dev/ttyF[0-9]{1,2}$")) {
            return PortType.SerialPort;
        }
        if (name.matches("^/dev/ttyM[0-9]{1,2}$")) {
            return PortType.SerialPort;
        }
        if (name.matches("^/dev/paylogic/.*$")) {
            return PortType.SerialPort;
        }
        if (name.matches("^/dev/serial/by-path/.*$")) {
            return PortType.SerialPort;
        }
        if (name.matches("^/dev/serial/by-id/.*$")) {
            return PortType.SerialPort;
        }
        if (name.matches("^LPT[1-9]+[0-9]?$")) {
            return PortType.ParallelPort;
        }
        if (name.matches("^/dev/lp[0-9]{1,2}$")) {
            return PortType.ParallelPort;
        }
        if (name.matches("^/dev/usb/lp[0-9]{1,2}$")) {
            return PortType.UsbPort;
        }
        if ("VCOM1".equals(name)) {
            return PortType.SerialPort;
        }
        if ("/dev/ttyVS0".equals(name)) {
            return PortType.SerialPort;
        }
        if ("VLPT1".equals(name)) {
            return PortType.ParallelPort;
        }
        if ("/dev/vlp0".equals(name)) {
            return PortType.ParallelPort;
        }
        return null;
    }

    public static Port createPort(String name) {
        PortType type = PortScanner.getType(name);
        if (type == PortType.ParallelPort) {
            return new ParallelPort(name);
        }
        if (type == PortType.SerialPort) {
            return new SerialPort(name);
        }
        if (type == PortType.UsbPort) {
            return new UsbPort(name);
        }
        return null;
    }

    private static native String[] scanSerialNative();

    private static native String[] scanParallelNative();

    private static native String[] scanUsbNative();

    private static native String serialNameNative();

    private static native String parallelNameNative();
}

