/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.io;

import java.io.IOException;
import java.util.LinkedList;
import ru.softlogic.io.Loader;
import ru.softlogic.io.Port;
import ru.softlogic.io.PortBusyException;
import ru.softlogic.io.PortNotExistException;
import ru.softlogic.io.Storage;
import ru.softlogic.io.WrongTypePortException;
import ru.softlogic.io.utils.BU;

public abstract class BasePort
extends Loader
implements Port {
    protected final String name;
    protected int fd;
    protected int timeout;

    public BasePort(String name) {
        if (name == null || name.isEmpty()) {
            throw new IllegalArgumentException("'name' is required");
        }
        this.name = name;
        this.timeout = 100;
        this.fd = -1;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void close() {
        this.closeNative();
        this.fd = -1;
    }

    @Override
    public void reopen() throws PortNotExistException, WrongTypePortException, PortBusyException, IOException {
        if (this.isOpen()) {
            this.close();
        }
        this.open();
    }

    @Override
    public boolean isOpen() {
        return this.isOpenNative();
    }

    @Override
    public void setTimeout(int timeout) {
        this.timeout = timeout;
    }

    @Override
    public int avaliable() throws IOException {
        return this.avaliableNative();
    }

    @Override
    public byte[] tryRead() throws IOException {
        return this.tryReadNative();
    }

    @Override
    public byte[] tryRead(int maxSize) throws IOException {
        if (maxSize <= 0) {
            throw new IllegalArgumentException("Max size is wrong: " + maxSize + ", value must be positive");
        }
        return this.tryReadNative(maxSize);
    }

    @Override
    public byte[] read() throws IOException {
        return this.readNative();
    }

    @Override
    public byte[] read(int needs) throws IOException {
        if (needs <= 0) {
            throw new IllegalArgumentException("Count is wrong: " + needs + ", value must be positive");
        }
        return this.readNative(needs);
    }

    @Override
    public byte[] read(int needs, byte start) throws IOException {
        return this.read(needs, start, 24);
    }

    @Override
    public byte[] read(int needs, byte start, int depth) throws IOException {
        if (needs <= 0) {
            throw new IllegalArgumentException("Count is wrong: " + needs + ", value must be positive");
        }
        if (depth <= 0 || depth > 255) {
            throw new IllegalArgumentException("Depth is wrong: " + depth + ", value must be in range [0..255]");
        }
        LinkedList<Byte> garbage = null;
        for (int i = 0; i < depth; ++i) {
            int b = this.readByte();
            if (b == start) {
                if (needs > 1) {
                    byte[] oth = this.read(needs - 1);
                    byte[] res = new byte[needs];
                    res[0] = start;
                    System.arraycopy(oth, 0, res, 1, oth.length);
                    return res;
                }
                return new byte[]{start};
            }
            if (garbage == null) {
                garbage = new LinkedList<Byte>();
            }
            garbage.add(BU.c(b));
        }
        throw new IOException("Can't find start byte " + BU.toHex(start) + ", readed: " + BU.toString(garbage));
    }

    @Override
    public byte[] read(Storage storage) throws IOException {
        while (storage.add(this.read(1)[0], this)) {
        }
        return storage.getResult();
    }

    @Override
    public int readByte() throws IOException {
        byte[] res = this.read(1);
        return BU.c(res[0]);
    }

    @Override
    public void write(byte ... data) throws IOException {
        if (data != null && data.length > 0) {
            this.writeNative(data);
        }
    }

    @Override
    public void write(byte data) throws IOException {
        this.writeNative(data);
    }

    private native boolean isOpenNative();

    private native void closeNative();

    private native int avaliableNative() throws IOException;

    private native byte[] tryReadNative() throws IOException;

    private native byte[] tryReadNative(int var1) throws IOException;

    private native byte[] readNative() throws IOException;

    private native byte[] readNative(int var1) throws IOException;

    private native void writeNative(byte[] var1) throws IOException;

    private native void writeNative(byte var1) throws IOException;

    private static native String getVersionNative();

    protected boolean isInterrupt() {
        return Thread.currentThread().isInterrupted();
    }

    public static String getVersion() {
        return "3.5.0";
    }

    public static String getNativeVersion() {
        return BasePort.getVersionNative();
    }
}

