/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.system.util;

import it.sauronsoftware.ftp4j.FTPClient;
import it.sauronsoftware.ftp4j.FTPException;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;

public class FtpSender {
    private String server;
    private Integer port;
    private String login;
    private String password;
    private boolean useSSL;
    private String keyStorePath;
    private String keyStoreType;
    private String keyStorePassword;
    private boolean useExplicit;

    public FtpSender(String server, String login, String password) {
        this.server = server;
        this.login = login;
        this.password = password;
    }

    public FtpSender(String server, Integer port, String login, String password) {
        this.server = server;
        this.port = port;
        this.login = login;
        this.password = password;
    }

    public FtpSender(String server, Integer port, String login, String password, boolean useSSL) {
        this.server = server;
        this.port = port;
        this.login = login;
        this.password = password;
        this.useSSL = useSSL;
    }

    public FtpSender(String server, Integer port, String login, String password, boolean useSSL, String keyStorePath, String keyStoreType, String keyStorePassword) {
        this.server = server;
        this.port = port;
        this.login = login;
        this.password = password;
        this.useSSL = useSSL;
        this.keyStorePath = keyStorePath;
        this.keyStoreType = keyStoreType;
        this.keyStorePassword = keyStorePassword;
    }

    public FtpSender(String server, Integer port, String login, String password, boolean useSSL, String keyStorePath, String keyStoreType, String keyStorePassword, boolean useExplicit) {
        this.server = server;
        this.port = port;
        this.login = login;
        this.password = password;
        this.useSSL = useSSL;
        this.keyStorePath = keyStorePath;
        this.keyStoreType = keyStoreType;
        this.keyStorePassword = keyStorePassword;
        this.useExplicit = useExplicit;
    }

    public void send(InputStream in, String fileName) throws IOException {
        this.send(in, fileName, null);
    }

    public void send(InputStream in, String fileName, String path) throws IOException {
        FTPClient client = new FTPClient();
        client.getConnector().setReadTimeout(60000);
        try {
            if (this.useSSL) {
                client.setSSLSocketFactory(this.getSocketFactory());
                if (this.useExplicit) {
                    client.setSecurity(2);
                } else {
                    client.setSecurity(1);
                }
            }
            if (this.port != null && this.port > 0) {
                client.connect(this.server, this.port.intValue());
            } else {
                client.connect(this.server);
            }
            if (this.login != null) {
                client.login(this.login, this.password);
            }
            client.setPassive(true);
            client.setType(2);
            if (path != null && !path.isEmpty()) {
                try {
                    client.changeDirectory(path.substring(1));
                }
                catch (FTPException e) {
                    String[] paths;
                    for (String p : paths = path.substring(1).split("/")) {
                        try {
                            client.createDirectory(p);
                        }
                        catch (FTPException fTPException) {
                            // empty catch block
                        }
                        client.changeDirectory(p);
                    }
                }
            }
            client.upload(fileName, in, 0L, 0L, null);
            try {
                client.logout();
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        catch (Exception e) {
            throw new IOException(e);
        }
        finally {
            try {
                client.disconnect(false);
            }
            catch (Exception exception) {}
        }
    }

    private SSLSocketFactory getSocketFactory() throws NoSuchAlgorithmException, KeyManagementException, KeyStoreException, IOException, UnrecoverableKeyException, CertificateException {
        KeyManager[] keymanagers = null;
        if (this.keyStorePath != null && this.keyStoreType != null && this.keyStorePassword != null) {
            KeyStore keystore = KeyStore.getInstance(this.keyStoreType);
            keystore.load(new FileInputStream(this.keyStorePath), this.keyStorePassword.toCharArray());
            keymanagers = FtpSender.createKeyManagers(keystore, this.keyStorePassword);
        }
        TrustManager[] trustManager = new TrustManager[]{new X509TrustManager(){

            @Override
            public X509Certificate[] getAcceptedIssuers() {
                return null;
            }

            @Override
            public void checkClientTrusted(X509Certificate[] certs, String authType) {
            }

            @Override
            public void checkServerTrusted(X509Certificate[] certs, String authType) {
            }
        }};
        SSLContext sslContext = SSLContext.getInstance("SSL");
        sslContext.init(keymanagers, trustManager, new SecureRandom());
        return sslContext.getSocketFactory();
    }

    private static KeyManager[] createKeyManagers(KeyStore keystore, String password) throws KeyStoreException, NoSuchAlgorithmException, UnrecoverableKeyException {
        if (keystore == null) {
            throw new IllegalArgumentException("Keystore may not be null");
        }
        KeyManagerFactory kmfactory = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
        kmfactory.init(keystore, password != null ? password.toCharArray() : null);
        return kmfactory.getKeyManagers();
    }
}

