/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.system.util;

import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import org.apache.log4j.Logger;
import ru.softlogic.app.context.ApplicationContext;
import ru.softlogic.gui.factory.ComponentFactory;
import ru.softlogic.gui.screen.popup.dialog.DialogInterface;
import ru.softlogic.gui.screen.popup.dialog.UserCase;
import ru.softlogic.gui.screen.popup.dialog.custom.CollectorPasswordPanel;
import ru.softlogic.gui.screen.popup.dialog.custom.CustomDialogListener;
import ru.softlogic.gui.screen.popup.dialog.custom.CustomPanel;
import ru.softlogic.gui.screen.popup.dialog.custom.CustomPopupDialog;
import ru.softlogic.gui.useraction.UserAction;
import ru.softlogic.module.ModuleHelper;
import ru.softlogic.reference.ReferenceException;
import ru.softlogic.reference.ReferenceManager;
import ru.softlogic.reference.point.ServerUser;

public class CheckCollectorPwdHelper {
    private static final int MAX_ATTEMPS = 5;
    private static boolean cancel;
    private static boolean timeout;
    private static boolean passwordSet;
    private static boolean correctPassword;
    private static ServerUser serverUser;
    private static final Logger log;

    public static void checkPassword(final ApplicationContext context, final Runnable nextListener, final int attemp) {
        block7: {
            cancel = false;
            timeout = false;
            correctPassword = false;
            serverUser = null;
            passwordSet = CheckCollectorPwdHelper.checkCollectorPwdSet();
            if (passwordSet) {
                if (attemp == 0) {
                    log.info((Object)"\u041f\u0430\u0440\u043e\u043b\u044c \u0438\u043d\u043a\u0430\u0441\u0441\u0430\u0442\u043e\u0440\u0430 \u0437\u0430\u0434\u0430\u043d, \u043f\u043e\u043a\u0430\u0437\u044b\u0432\u0430\u044e \u044d\u043a\u0440\u0430\u043d \u0434\u043b\u044f \u0432\u0432\u043e\u0434\u0430 \u043f\u0430\u0440\u043e\u043b\u044f");
                }
                try {
                    CustomPanel cp = ComponentFactory.getInstance().createDialogPanel("panel.collector.password");
                    if (cp != null) {
                        if (cp instanceof CollectorPasswordPanel) {
                            ((CollectorPasswordPanel)cp).setFailAttemp(attemp != 0);
                        }
                        CustomPopupDialog dialog = new CustomPopupDialog(cp, 20, (Object)UserCase.Timeout);
                        dialog.addListener(new CustomDialogListener(){

                            public void onClose(Object data) {
                                if (data instanceof String) {
                                    log.info((Object)"\u041f\u0440\u043e\u0432\u0435\u0440\u044f\u0435\u043c \u0432\u0432\u0435\u0434\u0435\u043d\u043d\u044b\u0439 \u043f\u0430\u0440\u043e\u043b\u044c");
                                    String inputPwd = CheckCollectorPwdHelper.getMd5((String)data);
                                    serverUser = CheckCollectorPwdHelper.getServerUser(inputPwd);
                                    if (serverUser != null || CheckCollectorPwdHelper.checkPwdPoint(inputPwd)) {
                                        correctPassword = true;
                                        log.info((Object)"\u041f\u0430\u0440\u043e\u043b\u044c \u0432\u0435\u0440\u043d\u044b\u0439");
                                    } else {
                                        log.info((Object)"\u041f\u0430\u0440\u043e\u043b\u044c \u043d\u0435\u0432\u0435\u0440\u043d\u044b\u0439");
                                        if (attemp < 4) {
                                            CheckCollectorPwdHelper.checkPassword(context, nextListener, attemp + 1);
                                            return;
                                        }
                                    }
                                } else if (UserCase.Timeout.equals(data)) {
                                    log.info((Object)"\u0418\u0441\u0442\u0435\u043a \u0442\u0430\u0439\u043c\u0430\u0443\u0442 \u043d\u0430 \u044d\u043a\u0440\u0430\u043d\u0435 \u0432\u0432\u043e\u0434\u0430 \u043f\u0430\u0440\u043e\u043b\u044f \u0438\u043d\u043a\u0430\u0441\u0441\u0430\u0442\u043e\u0440\u0430");
                                    timeout = true;
                                } else {
                                    log.info((Object)"\u041e\u0442\u043c\u0435\u043d\u0430 \u043d\u0430 \u044d\u043a\u0440\u0430\u043d\u0435 \u0432\u0432\u043e\u0434\u0430 \u043f\u0430\u0440\u043e\u043b\u044f \u0438\u043d\u043a\u0430\u0441\u0441\u0430\u0442\u043e\u0440\u0430");
                                    cancel = true;
                                }
                                ModuleHelper.invoke(nextListener);
                            }
                        });
                        UserAction.getInstance().update();
                        context.showDialog((DialogInterface)dialog);
                        break block7;
                    }
                    passwordSet = false;
                    ModuleHelper.invoke(nextListener);
                }
                catch (Exception ex) {
                    log.error((Object)ex);
                    passwordSet = false;
                    ModuleHelper.invoke(nextListener);
                }
            } else {
                log.info((Object)"\u041f\u0430\u0440\u043e\u043b\u044c \u0438\u043d\u043a\u0430\u0441\u0441\u0430\u0442\u043e\u0440\u0430 \u043d\u0435 \u0437\u0430\u0434\u0430\u043d");
                ModuleHelper.invoke(nextListener);
            }
        }
    }

    private static boolean checkPwdServerUsers() {
        ServerUser[] users = null;
        try {
            users = ReferenceManager.getInstance().getServerUsers();
        }
        catch (ReferenceException ex) {
            return false;
        }
        if (users != null && users.length > 0) {
            for (ServerUser su : users) {
                if (su.getCollectorPassword() == null || su.getCollectorPassword().trim().isEmpty()) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean checkPwdPoint(String password) {
        try {
            String pwd = ReferenceManager.getInstance().getPoint().getCollectorPassword();
            if (pwd != null && !pwd.trim().isEmpty() && (password == null || pwd.equals(password))) {
                return true;
            }
        }
        catch (ReferenceException ex) {
            return false;
        }
        return false;
    }

    public static boolean checkCollectorPwdSet() {
        return CheckCollectorPwdHelper.checkPwdServerUsers() || CheckCollectorPwdHelper.checkPwdPoint(null);
    }

    public static ServerUser getServerUser(String password) {
        ServerUser[] users = null;
        try {
            users = ReferenceManager.getInstance().getServerUsers();
        }
        catch (ReferenceException ex) {
            return null;
        }
        if (users != null && users.length > 0) {
            for (ServerUser su : users) {
                if (su.getCollectorPassword() == null || !su.getCollectorPassword().equals(password)) continue;
                return su;
            }
        }
        return null;
    }

    private static String getMd5(String source) {
        try {
            MessageDigest md = MessageDigest.getInstance("MD5");
            md.reset();
            byte[] result = md.digest(source.getBytes());
            StringBuilder sb = new StringBuilder();
            for (byte bt : result) {
                sb.append(String.format("%02x", bt & 0xFF));
            }
            return sb.toString();
        }
        catch (NoSuchAlgorithmException ex) {
            return null;
        }
    }

    public static boolean isCancel() {
        return cancel;
    }

    public static boolean isTimeout() {
        return timeout;
    }

    public static boolean isCorrectPassword() {
        return correctPassword;
    }

    public static ServerUser getServerUser() {
        return serverUser;
    }

    public static boolean isPasswordSet() {
        return passwordSet;
    }

    static {
        log = Logger.getLogger((String)"maintenance");
    }
}

