/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.system.util;

import ru.softlogic.app.session.CashBackCard;
import ru.softlogic.app.session.Pack;
import ru.softlogic.app.session.Session;
import ru.softlogic.cash.Keeper;
import ru.softlogic.cash.Sum;
import ru.softlogic.module.input.Environment;
import ru.softlogic.operation.Operation;
import ru.softlogic.service.comission.Commission;
import ru.softlogic.service.comission.SumResult;
import ru.softlogic.system.util.PinCodeGenerator;

public class CbcUtil {
    public static void cancelOperation(Operation operation) {
        if (operation == null) {
            throw new IllegalArgumentException("Operation \u043d\u0435 \u043c\u043e\u0436\u0435\u0442 \u0431\u044b\u0442\u044c null");
        }
        Keeper keeper = operation.getKeeper();
        if (keeper != null) {
            operation.setPinCode(PinCodeGenerator.generate());
            if (operation.getSumResult() != null) {
                operation.setPinCodeNominal(operation.getSumResult().getOut().add(operation.getSumResult().getCommission()));
            }
            SumResult sumResult = new SumResult(keeper.getCashSum(), keeper.getCashlessSum(), new Sum(0), new Sum(0), new Sum(0), keeper.getSum(), null, null);
            operation.setSumResult(sumResult);
            Keeper change = new Keeper();
            change.addPayback(keeper.getSum());
            operation.setChange(change);
        }
    }

    public static void cancelOperationToSave(Operation operation) {
        if (operation == null) {
            throw new IllegalArgumentException("Operation \u043d\u0435 \u043c\u043e\u0436\u0435\u0442 \u0431\u044b\u0442\u044c null");
        }
        SumResult sr = operation.getSumResult();
        if (sr != null) {
            SumResult sumResult = new SumResult(sr.getCash(), sr.getCashLess(), sr.getOut().add(sr.getCommission()), sr.getOut().add(sr.getCommission()), new Sum(0), sr.getChange(), null, sr.getCommService());
            operation.setSumResult(sumResult);
            operation.setCommission(new Commission(1));
            operation.setFlags(operation.getFlags() | 0x100);
        }
    }

    public static void cancelOnlineOperationWithPIN(Operation operation, Pack pack) {
        if (operation == null) {
            throw new IllegalArgumentException("Operation \u043d\u0435 \u043c\u043e\u0436\u0435\u0442 \u0431\u044b\u0442\u044c null");
        }
        Keeper keeper = operation.getKeeper();
        if (keeper != null) {
            if (operation.getPinCode() == null) {
                operation.setPinCode(PinCodeGenerator.generate());
            }
            operation.setPinCodeNominal(keeper.getSum());
            pack.setCbc(new CashBackCard(operation.getPinCode(), keeper.getSum()));
            SumResult sumResult = new SumResult(keeper.getCashSum(), keeper.getCashlessSum(), new Sum(0), new Sum(0), new Sum(0), keeper.getSum(), null, null);
            operation.setSumResult(sumResult);
            Keeper change = new Keeper();
            change.addPayback(keeper.getSum());
            operation.setChange(change);
            if (pack != null && pack.getSumResult() != null) {
                pack.getSumResult().setChange(new Sum(0));
            }
        }
    }

    public static boolean cancelOnlineOperationWithPINAfterReboot(Operation operation, Pack pack) {
        if (operation == null) {
            throw new IllegalArgumentException("Operation \u043d\u0435 \u043c\u043e\u0436\u0435\u0442 \u0431\u044b\u0442\u044c null");
        }
        Keeper keeper = operation.getKeeper();
        if (keeper != null) {
            SumResult sr = pack.getSumResult();
            if (sr.getOut().add(sr.getCommission()).isEmpty()) {
                return false;
            }
            if (operation.getPinCode() == null) {
                operation.setPinCode(PinCodeGenerator.generate());
            }
            operation.setPinCodeNominal(sr.getOut().add(sr.getCommission()));
            SumResult sumResult = new SumResult(new Sum(0), new Sum(0), new Sum(0), new Sum(0), new Sum(0), sr.getOut().add(sr.getCommission()), null, null);
            operation.setSumResult(sumResult);
            Keeper change = new Keeper();
            change.addPayback(sr.getOut().add(sr.getCommission()));
            operation.setChange(change);
        }
        return true;
    }

    public static void cancelOnlineOperationAfterReboot(Operation operation) {
        if (operation == null) {
            throw new IllegalArgumentException("Operation \u043d\u0435 \u043c\u043e\u0436\u0435\u0442 \u0431\u044b\u0442\u044c null");
        }
        Keeper keeper = operation.getKeeper();
        if (keeper != null) {
            if (operation.getPinCode() == null) {
                operation.setPinCode(PinCodeGenerator.generate());
            }
            operation.setPinCodeNominal(operation.getSumResult().getOut());
            Keeper change = new Keeper();
            change.addPayback(operation.getSumResult().getOut());
            operation.setChange(change);
        }
    }

    public static void cancelOperationArabicWithoutPIN(Operation operation, Environment env) {
        if (operation == null) {
            throw new IllegalArgumentException("Operation \u043d\u0435 \u043c\u043e\u0436\u0435\u0442 \u0431\u044b\u0442\u044c null");
        }
        Keeper keeper = operation.getKeeper();
        if (keeper != null) {
            SumResult sumResult = new SumResult(keeper.getCashSum(), keeper.getCashlessSum(), new Sum(0), new Sum(0), new Sum(0), keeper.getSum(), null, null);
            operation.setSumResult(sumResult);
            Keeper change = new Keeper();
            change.addPayback(keeper.getSum());
            operation.setChange(change);
            Session.getInstance().getPack().setSumResult(new SumResult(new Sum(0), keeper.getSum(), new Sum(0), new Sum(0), new Sum(0), keeper.getSum(), null, null));
            Session.getInstance().getPack().setChange(change);
            Session.getInstance().getPack().setCancel(true);
        }
    }

    public static void cancelOperationArabic(Operation operation) {
        if (operation == null) {
            throw new IllegalArgumentException("Operation \u043d\u0435 \u043c\u043e\u0436\u0435\u0442 \u0431\u044b\u0442\u044c null");
        }
        Keeper keeper = operation.getKeeper();
        if (keeper != null) {
            operation.setPinCode(PinCodeGenerator.generate());
            if (operation.getSumResult() != null) {
                operation.setPinCodeNominal(operation.getSumResult().getOut().add(operation.getSumResult().getCommission()));
            }
            SumResult sumResult = new SumResult(keeper.getCashSum(), keeper.getCashlessSum(), new Sum(0), new Sum(0), new Sum(0), keeper.getSum(), null, null);
            operation.setSumResult(sumResult);
            Keeper change = new Keeper();
            change.addPayback(keeper.getSum().sub(operation.getPinCodeNominal()));
            operation.setChange(change);
        }
    }
}

