/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.module.reinit;

import i18n.B;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Random;
import org.apache.log4j.Logger;
import ru.softlogic.app.CommissionCalculator;
import ru.softlogic.app.configuration.AppDefaults;
import ru.softlogic.app.context.ApplicationContext;
import ru.softlogic.app.context.ChequeGenerator;
import ru.softlogic.app.context.PaymentHelper;
import ru.softlogic.app.session.CashBackCard;
import ru.softlogic.app.session.Pack;
import ru.softlogic.app.session.Payment;
import ru.softlogic.app.session.Session;
import ru.softlogic.cash.Keeper;
import ru.softlogic.cash.Sum;
import ru.softlogic.gui.factory.ComponentFactory;
import ru.softlogic.gui.screen.popup.dialog.DC;
import ru.softlogic.gui.screen.popup.dialog.DialogInterface;
import ru.softlogic.gui.screen.popup.dialog.DialogListener;
import ru.softlogic.gui.screen.popup.dialog.DialogScreen;
import ru.softlogic.gui.screen.popup.dialog.DialogType;
import ru.softlogic.gui.screen.popup.dialog.UserCase;
import ru.softlogic.gui.utils.menu.MenuByServiceIdVisitor;
import ru.softlogic.gui.utils.menu.MenuUtils;
import ru.softlogic.gui.utils.menu.MenuVisitor;
import ru.softlogic.gui2.screen.ActionType;
import ru.softlogic.gui2.screen.ScreenAdapter;
import ru.softlogic.input.model.InputElement;
import ru.softlogic.input.model.StoreHelper;
import ru.softlogic.intent.Intent;
import ru.softlogic.module.ModuleFactory;
import ru.softlogic.module.ModuleHelper;
import ru.softlogic.module.PackUtility;
import ru.softlogic.module.ending.EndingModule;
import ru.softlogic.module.ending.SimpleEndingModule;
import ru.softlogic.module.input.DescriptionException;
import ru.softlogic.module.input.Environment;
import ru.softlogic.module.input.InputModule;
import ru.softlogic.module.input.InputModuleFactory;
import ru.softlogic.module.input.ModuleInitException;
import ru.softlogic.module.processing.ObsoleteProcessingModule;
import ru.softlogic.module.processing.ProcessingModule;
import ru.softlogic.module.reinit.ReinitModule;
import ru.softlogic.operation.Operation;
import ru.softlogic.provider.ProviderHelper;
import ru.softlogic.reference.menu.MenuItem;
import ru.softlogic.sequence.SequenceManager;
import ru.softlogic.service.comission.Commission;
import ru.softlogic.service.comission.FeeSum;
import ru.softlogic.service.comission.SumResult;
import ru.softlogic.srv.api.event.Event;
import ru.softlogic.srv.api.event.EventType;
import ru.softlogic.srv.api.operation.ProcessingResult;
import ru.softlogic.srv.api.operation.ProcessingResultType;
import ru.softlogic.srv.connector.ConnectorException;
import ru.softlogic.system.util.PinCodeGenerator;

public class BaseReinitModule
implements ReinitModule {
    private ApplicationContext context;
    private Environment environment;
    private LocalScreenListener listener;
    private Logger log;
    private ProcessingModule pm;
    private EndingModule em;
    private Runnable cancelListener;
    private boolean packChanged;

    public BaseReinitModule(ApplicationContext context) {
        this.context = context;
        this.pm = new ObsoleteProcessingModule(context);
        this.em = new SimpleEndingModule(context);
        this.listener = new LocalScreenListener();
        this.log = Logger.getLogger((String)"pay");
    }

    @Override
    public void process(Environment environment) {
        this.packChanged = false;
        Logger.getLogger((String)"pay").info((Object)B.get((String)"Module.reinit", (Locale)environment.getLocale()));
        this.context.setModule(this);
        this.environment = environment;
        Pack pack = Session.getInstance().getPack();
        PackUtility.printPack("Reinit module payout pack", pack);
        if (pack.getSumResult().getChange() == null || pack.getSumResult().getChange().isEmpty()) {
            this.log.info((Object)"Payment has no payback");
            environment.getPresentModule().takePresent(environment);
        } else if (pack.getPaybackType() == 3) {
            this.log.info((Object)"Do payout to service");
            environment.getPresentModule().takePresent(environment);
        } else if (pack.getPaybackType() == 6 && pack.getPaybackData() instanceof InputElement) {
            this.toReinitMobile(pack);
            environment.getPresentModule().takePresent(environment);
        } else if (pack.getPaybackType() == 8) {
            this.toReinitMobile(pack);
            environment.getPresentModule().takePresent(environment);
        } else if (pack.getPaybackType() == 4) {
            this.log.info((Object)"Do deferred payback");
            Pack pb = new Pack();
            pb.setPaymentType(2);
            Payment parent = (Payment)Session.getInstance().getPack().getPayments().get(0);
            Payment payment = new Payment();
            payment.setSumOut(new Sum());
            payment.setData(parent.getData());
            pb.getPayments().add(payment);
            pb.setService(Session.getInstance().getPack().getService());
            pb.setCommission(Session.getInstance().getPack().getCommission());
            pb.setFraud(Session.getInstance().getPack().isFraud());
            Keeper keeper = new Keeper();
            keeper.addPayback(Session.getInstance().getPack().getSumResult().getChange());
            pb.setKeeper(keeper);
            pb.setSumResult(new SumResult(keeper.getCashSum(), keeper.getCashlessSum(), new Sum(), new Sum(), new Sum(), keeper.getSum(), null, null));
            Session.getInstance().setPack(pb);
            PackUtility.printPack("Deferred payout pack", pb);
            environment.getPayoutModule().startPayout(environment);
        } else if (pack.getPaybackType() == 5) {
            this.log.info((Object)"Do to save service payback");
            Pack pb = new Pack();
            pb.setPaymentType(2);
            Payment parent = (Payment)Session.getInstance().getPack().getPayments().get(0);
            Payment payment = new Payment();
            payment.setSumOut(new Sum());
            payment.setData(parent.getData());
            pb.getPayments().add(payment);
            pb.setService(Session.getInstance().getPack().getService());
            pb.setCommission(Session.getInstance().getPack().getCommission());
            pb.setFraud(Session.getInstance().getPack().isFraud());
            Keeper keeper = new Keeper();
            keeper.addPayback(Session.getInstance().getPack().getSumResult().getChange());
            pb.setKeeper(keeper);
            pb.setSumResult(new SumResult(keeper.getCashSum(), keeper.getCashlessSum(), new Sum(), new Sum(), new Sum(), keeper.getSum(), null, null));
            pb.setPaybackType(5);
            Session.getInstance().setPack(pb);
            PackUtility.printPack("Do to save service pack", pb);
            environment.getProcessingModule().process(environment);
        } else if (pack.getSumResult().getChange() != null && !pack.getSumResult().getChange().isEmpty() && pack.getPaybackType() != 3) {
            this.log.info((Object)"Payment has payback, but payback already make. ");
            environment.getPresentModule().takePresent(environment);
        }
    }

    @Override
    public int getType() {
        return 9;
    }

    @Override
    public int getInactivityTimeout() {
        return 120;
    }

    @Override
    public void cancel(Intent intent) {
        this.onCancel(true);
    }

    private void onCancel(boolean timeout) {
        this.log.info((Object)"Request to cancel payback");
        DialogScreen dialog = ComponentFactory.getInstance().createDialog(DialogType.Question, B.get((String)"Module.reinit.cancel", (Locale)this.environment.getLocale()), 20, DC.cases((int)9, (Locale)this.environment.getLocale(), (Object[])new Object[0]), UserCase.Ok);
        dialog.addListener(new DialogListener(){

            public void dialogClosed(UserCase userCase) {
                BaseReinitModule.this.log.info((Object)("User make choise " + userCase));
                if (userCase == UserCase.Ok) {
                    BaseReinitModule.this.log.info((Object)"Exit to main menu, generate payout operation");
                    Pack pack = new Pack();
                    pack.setPaymentType(2);
                    Payment parent = (Payment)Session.getInstance().getPack().getPayments().get(0);
                    Payment payment = new Payment();
                    payment.setSumOut(new Sum());
                    payment.setData(parent.getData());
                    if (ModuleHelper.toSavePayout(Session.getInstance().getPack())) {
                        pack.setPaybackType(5);
                    } else {
                        pack.setPaybackType(1);
                        pack.setCbc(new CashBackCard(PinCodeGenerator.generate(), Session.getInstance().getPack().getSumResult().getChange()));
                    }
                    pack.getPayments().add(payment);
                    pack.setService(Session.getInstance().getPack().getService());
                    pack.setCommission(Session.getInstance().getPack().getCommission());
                    Keeper keeper = new Keeper();
                    keeper.addPayback(Session.getInstance().getPack().getSumResult().getChange());
                    pack.setKeeper(keeper);
                    pack.setSumResult(new SumResult(keeper.getCashSum(), keeper.getCashlessSum(), new Sum(), new Sum(), new Sum(), keeper.getSum(), null, null));
                    Session.getInstance().setPack(pack);
                    BaseReinitModule.this.environment.getProcessingModule().process(BaseReinitModule.this.environment);
                } else {
                    BaseReinitModule.this.log.info((Object)"Cancel action");
                    ModuleHelper.invoke(BaseReinitModule.this.cancelListener);
                }
            }
        });
        dialog.show(this.context.getShell());
    }

    private void toReinitMobile(Pack pack) {
        Operation lastPayment;
        InputElement phone = (InputElement)pack.getPaybackData();
        Random random = new Random();
        int id = SequenceManager.getValueQuietly((String)"operation-id");
        Operation operation = new Operation();
        operation.setFeHash(PaymentHelper.getFeHash());
        operation.setIdOperation(id % 32000);
        operation.setCheckNumber(random.nextInt(32000));
        if (AppDefaults.getInstance().getBooleanProperty("printer.cheque.complexformat", false)) {
            operation.getInputElements().put("cheque_number", new InputElement("cheque_number", "cheque_number", ChequeGenerator.getInstance().getChequeNumber()));
        }
        operation.setDate(new Date());
        operation.setService(pack.getPaybackService());
        operation.setCommission(new Commission(1));
        operation.setDealer(this.environment.getDealer());
        operation.setPoint(this.environment.getPoint());
        operation.setPaymentSystem(this.environment.getPaymentSystem());
        operation.getForm().put("id1", phone.getValue());
        operation.getViews().put("id1", phone.getValueTitle());
        operation.getTitles().put("id1", phone.getKeyTitle());
        operation.getInputElements().put("id1", new InputElement("id1", phone.getKeyTitle(), phone.getValue(), phone.getValueTitle(), 0));
        Keeper keeper = Session.getInstance().getCurrentKeeper();
        operation.setSumResult(new SumResult(keeper.getCashSum(), keeper.getCashlessSum(), keeper.getSum(), keeper.getSum(), new Sum(), new Sum(), null, null));
        if (AppDefaults.getInstance().getBooleanProperty("Module.reinit.change.modile.use-menu-comm", false) && pack.getPaybackType() == 6) {
            MenuByServiceIdVisitor v = new MenuByServiceIdVisitor(pack.getPaybackService().getId());
            MenuUtils.processMenu((MenuVisitor)v);
            if (v.getMenuItem() != null) {
                HashMap<String, Object> tmp = new HashMap<String, Object>(operation.getInputElements());
                Commission personal = ProviderHelper.getPersonalCommission(tmp, pack.getPaybackService().getId(), pack.getPaybackService().getServiceTypeId());
                Commission comm = personal != null ? personal : v.getMenuItem().getCommission();
                SumResult sr = CommissionCalculator.calculate((Sum)keeper.getSum(), (Keeper)keeper, (Commission)comm, (Commission)pack.getPaybackService().getMinComm(), (Commission)pack.getPaybackService().getCommission(), null, (Sum)pack.getPaybackService().getMaxSum(), null, (Date)new Date(), (String)"CASH", (boolean)v.getMenuItem().isIgnoreMinMaxCommission(), (FeeSum)pack.getProviderFee(), null);
                if (!sr.getOut().isEmpty()) {
                    if (sr.getChange().isEmpty()) {
                        operation.setSumResult(sr);
                        operation.setCommission(comm);
                    } else {
                        operation.setService(pack.getService());
                        operation.setCommission(pack.getCommission());
                        operation.setPaymentTool(pack.getPaymentTool());
                        operation.setCashlessData(pack.getCashlessData());
                        operation.setPaybackType(1);
                        operation.setSumResult(new SumResult(keeper.getCashSum(), keeper.getCashlessSum(), new Sum(), new Sum(), new Sum(), keeper.getSum(), null, null));
                        for (InputElement ie : StoreHelper.clear((Map)((Payment)pack.getPayments().get(0)).getData()).values()) {
                            operation.getForm().put(ie.getKey(), ie.getValue());
                            operation.getViews().put(ie.getKey(), ie.getValueTitle());
                            operation.getTitles().put(ie.getKey(), ie.getKeyTitle());
                            operation.getInputElements().put(ie.getKey(), ie);
                        }
                    }
                }
            }
        }
        if ((lastPayment = Session.getInstance().getLastPayment()) != null) {
            operation.setChangeDate(Session.getInstance().getChangeDate());
        }
        operation.setLocale(Locale.getDefault());
        operation.setKeeper(keeper);
        operation.setChange(new Keeper());
        operation.setChangeDate(Session.getInstance().getChangeDate());
        operation.setOfflinePayment(true);
        try {
            ProcessingResult process = this.context.getServerConnector().process(operation);
            this.log.info((Object)("Process mobile change " + operation + " with result: " + process));
            if (process != null && process.getType() == ProcessingResultType.Ok) {
                Session.getInstance().setCurrentKeeper(null);
                if (pack.getService().isPrintSingleCheckOnMobileChange() && pack.getPaybackType() == 6) {
                    this.context.getPrinterQueue().print(operation);
                }
            }
        }
        catch (ConnectorException ex) {
            this.log.error((Object)ex);
        }
    }

    private class LocalScreenListener
    extends ScreenAdapter {
        private Pack prevPack;

        private LocalScreenListener() {
        }

        public void setPack(Pack pack) {
            this.prevPack = pack;
        }

        public void onAction(String action, Map<String, Object> data, Runnable cancelListener) {
            BaseReinitModule.this.cancelListener = cancelListener;
            if (ActionType.isNext((String)action)) {
                MenuItem mi = (MenuItem)data.get("item");
                BaseReinitModule.this.log.info((Object)("Select: " + mi.getService().getName() + ", id=" + mi.getService().getId()));
                InputModule im = InputModuleFactory.getModule(mi.getService().getProviderType());
                String srvId = mi.getService().getName() + "," + mi.getService().getId();
                String messageId = null;
                try {
                    if (!BaseReinitModule.this.packChanged) {
                        Pack pack = new Pack();
                        Keeper keeper = new Keeper();
                        keeper.addPayback(Session.getInstance().getPack().getSumResult().getChange());
                        pack.setKeeper(keeper);
                        Session.getInstance().setPack(pack);
                        BaseReinitModule.this.packChanged = true;
                    }
                    BaseReinitModule.this.em = ModuleFactory.createEndingModule(BaseReinitModule.this.context, mi, new SimpleEndingModule(BaseReinitModule.this.context));
                    BaseReinitModule.this.environment.setMenuItem(mi);
                    BaseReinitModule.this.environment.setProcessingModule(BaseReinitModule.this.pm);
                    BaseReinitModule.this.environment.setEndingModule(BaseReinitModule.this.em);
                    Date now = new Date();
                    BaseReinitModule.this.environment.setAllowedCoins(PaymentHelper.getAllowedUnits(mi, 4, now));
                    BaseReinitModule.this.environment.setAllowedNotes(PaymentHelper.getAllowedUnits(mi, 3, now));
                    BaseReinitModule.this.environment.setInitData(ModuleHelper.getPaymentParams(this.prevPack, Integer.toString(mi.getService().getId())));
                    BaseReinitModule.this.log.info((Object)("Redirect params: " + BaseReinitModule.this.environment.getInitData()));
                    im.start(BaseReinitModule.this.environment, null);
                }
                catch (DescriptionException ex) {
                    BaseReinitModule.this.log.error((Object)"Can't run module", (Throwable)ex);
                    BaseReinitModule.this.context.getServerConnector().sendEvent(new Event(EventType.SoftwareFault, srvId + "->DescriptionError: " + ex.getMessage()));
                    messageId = "Module.entry.create.desc";
                    ModuleHelper.invoke(cancelListener);
                }
                catch (ModuleInitException ex) {
                    BaseReinitModule.this.log.error((Object)"Can't run module", (Throwable)ex);
                    BaseReinitModule.this.context.getServerConnector().sendEvent(new Event(EventType.SoftwareFault, srvId + "->InitError: " + ex.getMessage()));
                    messageId = "Module.entry.create.init";
                    ModuleHelper.invoke(cancelListener);
                }
                catch (Throwable ex) {
                    BaseReinitModule.this.log.error((Object)"Unknown error", ex);
                    BaseReinitModule.this.context.getServerConnector().sendEvent(new Event(EventType.SoftwareFault, srvId + "->Unknown: " + ex.getMessage()));
                    messageId = "Module.entry.create.init";
                    ModuleHelper.invoke(cancelListener);
                }
                if (messageId != null) {
                    DialogScreen dlg = ComponentFactory.getInstance().createDialog(DialogType.Error, B.get((String)messageId, (Locale)BaseReinitModule.this.environment.getLocale()), 10, DC.cases((int)1), UserCase.Ok);
                    BaseReinitModule.this.context.showDialog((DialogInterface)dlg);
                }
            } else if (ActionType.isExit((String)action)) {
                BaseReinitModule.this.log.info((Object)"User press Exit");
                BaseReinitModule.this.onCancel(false);
            }
        }
    }
}

