/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.module.processing;

import i18n.B;
import java.text.MessageFormat;
import java.util.Locale;
import ru.softlogic.app.context.ApplicationContext;
import ru.softlogic.app.session.Pack;
import ru.softlogic.app.session.Payment;
import ru.softlogic.app.session.Session;
import ru.softlogic.cash.Keeper;
import ru.softlogic.cash.Sum;
import ru.softlogic.gui.factory.ComponentFactory;
import ru.softlogic.gui.screen.popup.dialog.DC;
import ru.softlogic.gui.screen.popup.dialog.DialogListener;
import ru.softlogic.gui.screen.popup.dialog.DialogScreen;
import ru.softlogic.gui.screen.popup.dialog.DialogType;
import ru.softlogic.gui.screen.popup.dialog.UserCase;
import ru.softlogic.input.model.InputElement;
import ru.softlogic.module.ModuleHelper;
import ru.softlogic.module.card.CardModuleStore;
import ru.softlogic.module.card.UniversalGuiListener;
import ru.softlogic.module.input.Environment;
import ru.softlogic.module.processing.ObsoleteProcessingModule;
import ru.softlogic.service.comission.SumResult;
import ru.softlogic.srv.api.operation.ProcessingResult;

public class CardRevertProcessingModule
extends ObsoleteProcessingModule {
    public CardRevertProcessingModule(ApplicationContext context) {
        super(context);
    }

    @Override
    protected void endProcess() {
        boolean closeSession;
        int pt = Session.getInstance().getPack().getPaymentTool();
        boolean bl = closeSession = pt == 2 || pt == 3;
        if (closeSession) {
            CardModuleStore.getInstance().getEventsProxy().setListener(new LocalGuiListener(this.context, this.environment, false));
            CardModuleStore.getInstance().closeSessionSafe(true);
        } else {
            this.baseEndProcess();
        }
    }

    private void baseEndProcess() {
        super.endProcess();
    }

    @Override
    protected boolean onOnlineError(final ProcessingResult pr) {
        log.info((Object)"OnOnlineError in cardRevert");
        log.info((Object)"Ask about action");
        ModuleHelper.clearCardData((Payment)Session.getInstance().getPack().getPayments().get(0));
        DialogScreen dialog = null;
        dialog = pr.getErrorText() != null && !pr.getErrorText().trim().isEmpty() ? ComponentFactory.getInstance().createDialog(DialogType.Question, MessageFormat.format(B.get((String)"Module.processing.online.error.action.text", (Locale)this.environment.getLocale()), pr.getErrorText()), 20, DC.cases((int)17, (Locale)this.environment.getLocale(), (Object[])new Object[0]), UserCase.Cancel) : ComponentFactory.getInstance().createDialog(DialogType.Question, B.get((String)"Module.processing.online.error.action", (Locale)this.environment.getLocale()), 20, DC.cases((int)17, (Locale)this.environment.getLocale(), (Object[])new Object[0]), UserCase.Cancel);
        dialog.addListener(new DialogListener(){

            public void dialogClosed(UserCase userCase) {
                boolean cardRevert;
                int pt = Session.getInstance().getPack().getPaymentTool();
                boolean bl = cardRevert = pt == 2 || pt == 3;
                if (cardRevert) {
                    ObsoleteProcessingModule.log.info((Object)"Add revert task ");
                    CardModuleStore.getInstance().reverse();
                    Session.getInstance().getPack().setSumResult(new SumResult());
                    Session.getInstance().getPack().setKeeper(new Keeper());
                }
                ObsoleteProcessingModule.log.info((Object)("User make choise " + userCase));
                if (userCase == UserCase.Ok) {
                    ObsoleteProcessingModule.log.info((Object)"Go to input module");
                    CardRevertProcessingModule.this.environment.getInputModule().restore();
                } else {
                    CardRevertProcessingModule.this.fullPayout(pr.getErrorText(), cardRevert);
                }
            }
        });
        dialog.show(this.context.getShell());
        return true;
    }

    private void fullPayout(String errorText, boolean cardRevert) {
        Pack pack = Session.getInstance().getPack();
        if (cardRevert) {
            log.info((Object)"Make cardRevert ending");
            pack.setSumResult(new SumResult(new Sum(), new Sum(), new Sum(), new Sum(), new Sum(), new Sum(), pack.getProviderFee(), null));
            pack.setPaybackType(7);
        } else {
            log.info((Object)"Make full payout");
            SumResult sr = pack.getSumResult();
            sr.setCommission(new Sum());
            sr.setOut(new Sum());
            sr.setOutProv(new Sum());
            sr.setChange(sr.getCash().add(sr.getCashLess()));
        }
        pack.setCancel(true);
        ((Payment)pack.getPayments().get(0)).setSumOut(new Sum());
        if (errorText != null) {
            ((Payment)pack.getPayments().get(0)).getData().put("online-error-text", new InputElement("online-error-text", "Error Text", errorText));
        }
        if (cardRevert) {
            pack.setKeeper(new Keeper());
            CardModuleStore.getInstance().setUserEventInterfaceListener(new LocalGuiListener(this.context, this.environment, true));
            CardModuleStore.getInstance().reverse();
            CardModuleStore.getInstance().closeSessionSafe(false);
        } else {
            this.environment.getPayoutModule().startPayout(this.environment);
        }
    }

    private class LocalGuiListener
    extends UniversalGuiListener {
        private boolean isError;

        public LocalGuiListener(ApplicationContext context, Environment environment, boolean isError) {
            super(context, environment, ObsoleteProcessingModule.log);
            this.isError = isError;
        }

        @Override
        public synchronized void _onClosed() {
            ObsoleteProcessingModule.log.info((Object)"Session closed. Go to ending module");
            if (this.isError) {
                CardRevertProcessingModule.this.environment.getEndingModule().end(CardRevertProcessingModule.this.environment);
            } else {
                CardRevertProcessingModule.this.baseEndProcess();
            }
        }
    }
}

