/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.module.payment;

import i18n.B;
import java.util.Locale;
import java.util.concurrent.Callable;
import org.apache.log4j.Logger;
import ru.softlogic.app.configuration.AppDefaults;
import ru.softlogic.app.context.ApplicationContext;
import ru.softlogic.app.session.Session;
import ru.softlogic.app.state.StateFacade;
import ru.softlogic.app.state.TerminalState;
import ru.softlogic.cash.CashFactory;
import ru.softlogic.cash.manager.observer.KeeperObserver;
import ru.softlogic.gui.factory.ComponentFactory;
import ru.softlogic.gui.screen.popup.dialog.DC;
import ru.softlogic.gui.screen.popup.dialog.DialogInterface;
import ru.softlogic.gui.screen.popup.dialog.DialogListener;
import ru.softlogic.gui.screen.popup.dialog.DialogScreen;
import ru.softlogic.gui.screen.popup.dialog.DialogType;
import ru.softlogic.gui.screen.popup.dialog.DisplayedUserCase;
import ru.softlogic.gui.screen.popup.dialog.UserCase;
import ru.softlogic.gui.screen.popup.wait.WaitScreen;
import ru.softlogic.gui2.screen.CommonSumScreen;
import ru.softlogic.intent.Intent;
import ru.softlogic.module.ModuleFactory;
import ru.softlogic.module.card.CardModuleStore;
import ru.softlogic.module.input.Environment;
import ru.softlogic.module.payment.BasePaymentModule;
import ru.softlogic.module.payment.CardPaymentModule;
import ru.softlogic.module.payment.CashCurrencyPaymentModule;
import ru.softlogic.module.payment.CashPaymentModule;
import ru.softlogic.reference.menu.MenuItem;
import ru.softlogic.reference.service.Service;

public class DispatchPaymentModule
extends BasePaymentModule {
    private BasePaymentModule cspm;
    private BasePaymentModule ccpm;
    private BasePaymentModule cardPM;
    private BasePaymentModule pm;
    private Logger log = Logger.getLogger((String)"pay");

    public DispatchPaymentModule(ApplicationContext context) {
        super(context);
        try {
            if (CardModuleStore.getInstance().isInit()) {
                this.cardPM = new CardPaymentModule(context);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    @Override
    protected void _startPayment(final Environment environment, final CommonSumScreen sumScreen, KeeperObserver externalObserver) {
        boolean cashinError;
        Service service = Session.getInstance().getPack().getService();
        this.cspm = ModuleFactory.createCashPaymentModule(this.context, environment.getMenuItem(), new CashPaymentModule(this.context));
        this.ccpm = ModuleFactory.createCashCurrencyPaymentModule(this.context, environment.getMenuItem(), new CashCurrencyPaymentModule(this.context));
        this.log.info((Object)("Payment schema flags =  " + service.getPaymentSchemaFlags() + " for service id = " + service.getId()));
        boolean canCard = true;
        if (Session.getInstance().getPack().getKeeper() != null && !Session.getInstance().getPack().getKeeper().getSum().isEmpty()) {
            canCard = false;
        }
        TerminalState terminalStatus = StateFacade.getState();
        this.log.info((Object)("Terminal state: " + terminalStatus));
        boolean bl = cashinError = (terminalStatus.getWarningMask() & 0x20) > 0;
        if (canCard && (service.getPaymentSchemaFlags() & 4) > 0) {
            final boolean isCash = (service.getPaymentSchemaFlags() & 1) > 0;
            final boolean isCbc = (service.getPaymentSchemaFlags() & 2) > 0;
            this.context.getTaskExecutor().submit(new Callable(){

                public Object call() throws Exception {
                    WaitScreen waitScreen = ComponentFactory.getInstance().createWaitScreen(B.get((String)"Dialog.wait", (Locale)environment.getLocale()));
                    waitScreen.setText(B.get((String)"Dialog.wait"));
                    DispatchPaymentModule.this.context.showWait(waitScreen);
                    if (DispatchPaymentModule.this.cardPM == null || !CardModuleStore.getInstance().isReady() || CardModuleStore.getInstance().isCardReaderOnly()) {
                        DispatchPaymentModule.this.context.showWait(null);
                        if (!isCash && !isCbc || cashinError) {
                            DispatchPaymentModule.this.log.info((Object)"Card module is not present, show error");
                            DialogScreen dialog = ComponentFactory.getInstance().createDialog(DialogType.Error, B.get((String)"Provider.card.nocm", (Locale)environment.getLocale()), 10, DC.cases((int)8, (Locale)environment.getLocale(), (Object[])new Object[0]), UserCase.Ok);
                            dialog.addListener(new DialogListener(){

                                public void dialogClosed(UserCase userCase) {
                                    DispatchPaymentModule.this.context.toMainMenu();
                                }
                            });
                            DispatchPaymentModule.this.context.showDialog((DialogInterface)dialog);
                        } else {
                            DispatchPaymentModule.this.toCash(environment, sumScreen);
                        }
                    } else {
                        DispatchPaymentModule.this.context.showWait(null);
                        CardModuleStore.getInstance().setReference(environment.getPoint());
                        if (!isCash && !isCbc || CardModuleStore.getInstance().getCurrentSession() != null) {
                            DispatchPaymentModule.this.toCard(environment, sumScreen);
                        } else if (cashinError) {
                            DispatchPaymentModule.this.log.info((Object)"Cashin in error. Ask about card-payment method");
                            DisplayedUserCase[] cases = new DisplayedUserCase[]{new DisplayedUserCase(UserCase.Ok, B.get((String)"Module.payment.cashinerror.ok", (Locale)environment.getLocale())), new DisplayedUserCase(UserCase.Cancel, B.get((String)"Module.payment.cashinerror.cancel", (Locale)environment.getLocale()))};
                            DialogScreen dialog = ComponentFactory.getInstance().createDialog(DialogType.Question, B.get((String)"Module.payment.cashinerror.title", (Locale)environment.getLocale()), 20, cases, UserCase.Cancel);
                            dialog.addListener(new DialogListener(){

                                public void dialogClosed(UserCase userCase) {
                                    if (userCase == UserCase.Ok) {
                                        DispatchPaymentModule.this.toCard(environment, sumScreen);
                                    } else {
                                        DispatchPaymentModule.this.context.toMainMenu();
                                    }
                                }
                            });
                            dialog.show(DispatchPaymentModule.this.context.getShell());
                        } else {
                            DispatchPaymentModule.this.log.info((Object)"Card module is present, ask about payment method");
                            DisplayedUserCase[] cases = new DisplayedUserCase[]{new DisplayedUserCase(UserCase.Ok, B.get((String)"Module.payment.variant.cash", (Locale)environment.getLocale())), new DisplayedUserCase(UserCase.Cancel, B.get((String)"Module.payment.variant.card", (Locale)environment.getLocale()))};
                            DisplayedUserCase[] casesCommission = new DisplayedUserCase[]{new DisplayedUserCase(UserCase.Ok, B.get((String)"Module.payment.card.dialog.commission.ok", (Locale)environment.getLocale())), new DisplayedUserCase(UserCase.Cancel, B.get((String)"Module.payment.card.dialog.commission.cancel", (Locale)environment.getLocale()))};
                            DialogScreen dialog = ComponentFactory.getInstance().createDialog(DialogType.Question, B.get((String)"Module.payment.variant", (Locale)environment.getLocale()), 20, cases, UserCase.Ok);
                            class LocalDialogListener
                            implements DialogListener {
                                final /* synthetic */ DisplayedUserCase[] val$casesCommission;
                                final /* synthetic */ DisplayedUserCase[] val$cases;

                                LocalDialogListener() {
                                    this.val$casesCommission = displayedUserCaseArray;
                                    this.val$cases = displayedUserCaseArray2;
                                }

                                public void dialogClosed(UserCase userCase) {
                                    if (userCase == UserCase.Ok) {
                                        DispatchPaymentModule.this.toCash(environment, sumScreen);
                                    } else if (AppDefaults.getInstance().getBooleanProperty("Module.payment.card.show-commission-confirm", false)) {
                                        DialogScreen dialogCommission = ComponentFactory.getInstance().createDialog(DialogType.Question, B.get((String)"Module.payment.card.dialog.commission", (Locale)environment.getLocale()), 20, this.val$casesCommission, UserCase.Cancel);
                                        dialogCommission.addListener(new DialogListener(){

                                            public void dialogClosed(UserCase userCase) {
                                                if (userCase == UserCase.Ok) {
                                                    DispatchPaymentModule.this.toCard(environment, sumScreen);
                                                } else {
                                                    DialogScreen dialog = ComponentFactory.getInstance().createDialog(DialogType.Question, B.get((String)"Module.payment.variant", (Locale)environment.getLocale()), 20, val$cases, UserCase.Ok);
                                                    dialog.addListener((DialogListener)new LocalDialogListener(this, val$casesCommission, val$cases));
                                                    dialog.show(DispatchPaymentModule.this.context.getShell());
                                                }
                                            }
                                        });
                                        dialogCommission.show(DispatchPaymentModule.this.context.getShell());
                                    } else {
                                        DispatchPaymentModule.this.toCard(environment, sumScreen);
                                    }
                                }
                            }
                            dialog.addListener((DialogListener)new LocalDialogListener());
                            dialog.show(DispatchPaymentModule.this.context.getShell());
                        }
                    }
                    return null;
                }
            });
        } else if (cashinError) {
            this.log.info((Object)"Can not pay with card, show error");
            DialogScreen dialog = ComponentFactory.getInstance().createDialog(DialogType.Error, B.get((String)"Provider.payment.error.card", (Locale)environment.getLocale()), 10, DC.cases((int)8, (Locale)environment.getLocale(), (Object[])new Object[0]), UserCase.Ok);
            dialog.addListener(new DialogListener(){

                public void dialogClosed(UserCase userCase) {
                    DispatchPaymentModule.this.context.toMainMenu();
                }
            });
            this.context.showDialog((DialogInterface)dialog);
        } else {
            this.toCash(environment, sumScreen);
        }
    }

    @Override
    public void startPaymentByCash(Environment environment, CommonSumScreen sumScreen) {
        this.toCash(environment, sumScreen);
    }

    private void toCard(Environment environment, CommonSumScreen sumScreen) {
        this.log.info((Object)"Dispathcher: open card payment module");
        this.pm = this.cardPM;
        this.cardPM._startPayment(environment, sumScreen, null);
    }

    private void toCash(Environment environment, CommonSumScreen sumScreen) {
        Service service;
        MenuItem mi = environment.getMenuItem();
        Service service2 = service = Session.getInstance().getPack().getService() == null ? mi.getService() : Session.getInstance().getPack().getService();
        if (service.getCurrencyCode() != null && !service.getCurrencyCode().isEmpty() && !CashFactory.getDefaultInstance().getCurrency().equals(service.getCurrencyCode())) {
            this.log.info((Object)"Dispathcher: open currency cash payment module");
            this.pm = this.ccpm;
            this.ccpm._startPayment(environment, sumScreen, null);
        } else {
            this.log.info((Object)"Dispathcher: open simple cash payment module");
            this.pm = this.cspm;
            this.cspm._startPayment(environment, sumScreen, null);
        }
    }

    @Override
    public void cancel(Intent intent) {
        this.pm.cancel(intent);
    }

    @Override
    public boolean canRedirect() {
        return this.pm.canRedirect();
    }
}

