/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.module.payment;

import java.awt.EventQueue;
import org.apache.log4j.Logger;
import ru.softlogic.app.session.Session;
import ru.softlogic.cash.Keeper;
import ru.softlogic.cash.Sum;
import ru.softlogic.cash.manager.observer.KeeperObserver;
import ru.softlogic.cash.unit.CashBackCard;
import ru.softlogic.gui2.screen.CommonSumScreen;
import ru.softlogic.gui2.screen.ScreenListener;
import ru.softlogic.module.payment.CashMobuleHelper;
import ru.softlogic.module.payment.PayDetector;
import ru.softlogic.reference.service.Service;
import ru.softlogic.service.comission.SumResult;

public class CurrencyKeeperListener
implements KeeperObserver {
    private CommonSumScreen css;
    private Sum operSum;
    private Sum requireSum;
    private Sum fullComm;
    private Service service;
    private PayDetector detector;
    private boolean autoFinishPayment;
    private ScreenListener listener;
    private Logger log;

    public CurrencyKeeperListener(CommonSumScreen css, Sum operSum, Sum requireSum, Service service, PayDetector detector, boolean autoFinishPayment, ScreenListener listener) {
        this.css = css;
        this.operSum = operSum;
        this.requireSum = requireSum;
        this.service = service;
        this.detector = detector;
        this.autoFinishPayment = autoFinishPayment;
        this.listener = listener;
        this.log = Logger.getLogger((String)"pay");
    }

    public void updateLimits(Keeper keeper, Sum maxSum, Sum minSum, Sum newRequireSum) {
        boolean canPayPart;
        this.detector.setMax(maxSum);
        this.detector.setMin(minSum);
        if (newRequireSum != null) {
            this.requireSum = newRequireSum;
        }
        SumResult sr = (canPayPart = this.detector.canCalculatePayPartSumResult(keeper)) ? this.detector.calculatePayPartSum(keeper) : this.detector.calculate(keeper);
        SumResult viewResult = new SumResult(sr.getCash(), sr.getCashLess(), sr.getOut().add(sr.getCommission()), new Sum(), new Sum(), sr.getChange(), Session.getInstance().getPack().getProviderFee(), null);
        EventQueue.invokeLater(new ViewUpdater(keeper, viewResult, this.detector.canPay(sr) && !canPayPart));
    }

    public void update(Keeper keeper, Sum sum) {
        SumResult sr;
        Session.getInstance().setCurrentKeeper(keeper);
        boolean canPayPart = this.detector.canCalculatePayPartSumResult(keeper);
        if (this.fullComm == null) {
            Keeper k = new Keeper();
            k.addCashBackCard(new CashBackCard(0, this.requireSum == null ? new Sum(1000) : this.requireSum));
            this.fullComm = this.detector.canCalculatePayPartSumResult(k) ? this.detector.calculatePayPartSum(k).getCommission() : this.detector.calculate(k).getCommission();
        }
        SumResult sumResult = sr = canPayPart ? this.detector.calculatePayPartSum(keeper) : this.detector.calculate(keeper);
        if (!keeper.getSum().isEmpty()) {
            this.log.info((Object)("--> Get sum : " + sum));
            this.log.info((Object)("Keeper      : " + keeper.getSum() + ", " + keeper));
            this.log.info((Object)("Amount      : " + sr));
        }
        SumResult viewResult = new SumResult(sr.getCash(), sr.getCashLess(), sr.getOut().add(sr.getCommission()), new Sum(), new Sum(), sr.getChange(), Session.getInstance().getPack().getProviderFee(), null);
        EventQueue.invokeLater(new ViewUpdater(keeper, viewResult, this.detector.canPay(sr) && !canPayPart));
    }

    public void notifyNoMoreNeed() {
    }

    private class ViewUpdater
    implements Runnable {
        private Keeper keeper;
        private SumResult sr;
        private boolean canPay;

        public ViewUpdater(Keeper keeper, SumResult sr, boolean canPay) {
            this.keeper = keeper;
            this.sr = sr;
            this.canPay = canPay;
        }

        @Override
        public void run() {
            CurrencyKeeperListener.this.css.updateSums(this.keeper.getSum(), CurrencyKeeperListener.this.operSum, CurrencyKeeperListener.this.requireSum, null, this.sr, CurrencyKeeperListener.this.fullComm, this.canPay, this.sr.getIncome().isEmpty(), CashMobuleHelper.isAllowCBC(CurrencyKeeperListener.this.service, this.keeper == null ? false : !this.keeper.getCashSum().isEmpty()));
            if (CurrencyKeeperListener.this.autoFinishPayment && this.canPay) {
                EventQueue.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        CurrencyKeeperListener.this.listener.onAction("Next", null, new Runnable(){

                            @Override
                            public void run() {
                            }
                        });
                    }
                });
            }
        }
    }
}

