/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.module.input.universal;

import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Stack;
import ru.softlogic.app.ProblemNotifier;
import ru.softlogic.app.context.ApplicationContext;
import ru.softlogic.app.session.Session;
import ru.softlogic.application.ContentScreenAdapterKbr;
import ru.softlogic.cash.Keeper;
import ru.softlogic.cash.Sum;
import ru.softlogic.cash.manager.CashManager;
import ru.softlogic.gui.factory.ComponentFactory;
import ru.softlogic.gui.screen.popup.dialog.DC;
import ru.softlogic.gui.screen.popup.dialog.DialogInterface;
import ru.softlogic.gui.screen.popup.dialog.DialogListener;
import ru.softlogic.gui.screen.popup.dialog.DialogScreen;
import ru.softlogic.gui.screen.popup.dialog.DialogType;
import ru.softlogic.gui.screen.popup.dialog.UserCase;
import ru.softlogic.gui2.screen.ActionType;
import ru.softlogic.gui2.screen.CommonScreen;
import ru.softlogic.gui2.screen.CommonScreenStore;
import ru.softlogic.gui2.screen.ScreenAdapter;
import ru.softlogic.gui2.screen.ScreenHelper;
import ru.softlogic.gui2.screen.ScreenListener;
import ru.softlogic.hardware.device.scanner.BarcodeScannerListener;
import ru.softlogic.input.model.InputElement;
import ru.softlogic.input.model.StoreHelper;
import ru.softlogic.input.model.TransactionSum;
import ru.softlogic.input.model.advanced.PaymentParams;
import ru.softlogic.input.model.field.InitException;
import ru.softlogic.input.model.field.ScreenSequence;
import ru.softlogic.input.model.field.barcode.BarcodeData;
import ru.softlogic.input.model.field.barcode.BarcodeException;
import ru.softlogic.input.model.field.barcode.BarcodeScanner;
import ru.softlogic.input.model.field.selector.custom.RedirectCustomData;
import ru.softlogic.input.model.field.selector.custom.SequenceCustomData;
import ru.softlogic.input.model.form.Form;
import ru.softlogic.input.model.screen.ButtonInit;
import ru.softlogic.input.model.screen.description.ConfirmScreenDescription;
import ru.softlogic.input.model.screen.description.ScreenDescription;
import ru.softlogic.input.model.screen.description.SumScreenDescription;
import ru.softlogic.media.MediaPlayer;
import ru.softlogic.module.ModuleHelper;
import ru.softlogic.module.Restorable;
import ru.softlogic.module.input.BaseInputModule;
import ru.softlogic.module.input.ComplexScreenListener;
import ru.softlogic.module.input.DataRender;
import ru.softlogic.module.input.DescriptionException;
import ru.softlogic.module.input.Environment;
import ru.softlogic.module.input.InitModuleHelper;
import ru.softlogic.module.input.ModuleInitException;
import ru.softlogic.module.input.universal.FormHelper;
import ru.softlogic.module.input.universal.ScreenPos;
import ru.softlogic.module.utils.ExitDialogListener;
import ru.softlogic.provider.ProviderHelper;
import ru.softlogic.provider.ProviderHelperListener;
import ru.softlogic.reference.menu.MenuItem;
import ru.softlogic.reference.service.Service;
import ru.softlogic.sequence.SequenceManager;
import ru.softlogic.srv.api.oth.Demand;
import ru.softlogic.srv.api.verify.ArgumentType;
import ru.softlogic.srv.api.verify.VerifyDataItem;
import ru.softlogic.srv.api.verify.VerifyResult;

public class UniversalInputModule
extends BaseInputModule {
    private Environment environment;
    private Restorable parent;
    private final ComplexScreenListener screenListener;
    private final ProviderHelper helper;
    private Map<String, Object> data;
    private Form form;
    private Stack<Stack<ScreenPos>> states;
    private ScreenDescription currentScreenDescription;
    private boolean confirmShowed;

    public UniversalInputModule(ApplicationContext context) {
        super(context);
        this.helper = new ProviderHelper(context);
        this.screenListener = new LocalScreenListener(context);
    }

    @Override
    public void _start(Environment environment, Restorable parent) throws DescriptionException, ModuleInitException {
        this.environment = environment;
        this.parent = parent;
        this.states = new Stack();
        this.screenListener.setEnvironment(environment);
        this.confirmShowed = false;
        this.data = new LinkedHashMap<String, Object>();
        try {
            this.log.info((Object)"Start parce forms");
            long begin = System.currentTimeMillis();
            Service srv = environment.getMenuItem().getService();
            this.form = FormHelper.parseForm(srv.getCode(), environment.getLocale());
            ModuleHelper.prefillStore(this.form.getPrefillItem(), environment, this.data);
            ModuleHelper.fillStore(environment.getInitData(), this.data);
            environment.setChangeNumber(this.form.getChangeNumber());
            long end = System.currentTimeMillis();
            if (end - begin > 300L) {
                ProblemNotifier.getDefaultNotifier().onProblem("Parsing form is too slow. Timeout=" + (end - begin) + " ms, service=" + srv.getName() + "," + srv.getId());
            } else if (end - begin > 5L) {
                this.log.debug((Object)("Parsing timeout: " + (end - begin)));
            }
            this.parceInit();
            this.log.info((Object)("Form = " + this.form));
            if (this.form.getScreenSequence().getScreens() == null || this.form.getScreenSequence().getScreens().isEmpty()) {
                StoreHelper.mergeData(this.data, (List)this.form.getScreenSequence().getFields());
                if (this.form.getDemandMessage() != null && !this.form.getDemandMessage().isEmpty()) {
                    this.toSendRequest();
                } else {
                    this.showConfirm();
                }
            } else {
                this.showNext(this.form.getScreenSequence());
            }
            this.log.info((Object)"Screen show");
        }
        catch (Exception ex) {
            throw new ModuleInitException(ex);
        }
    }

    @Override
    public Map<String, Object> getDataContext() {
        return this.data;
    }

    private void parceInit() {
        Map<String, Object> initData = this.environment.getInitData();
        if (initData == null || initData.isEmpty()) {
            return;
        }
        this.log.info((Object)("Init data: " + initData));
        Object initBarcodeData = initData.get("barcode");
        if (initBarcodeData instanceof String) {
            String sp = (String)initBarcodeData;
            try {
                List screens = this.form.getScreenSequence().getScreens();
                BarcodeScanner bScanner = ((ScreenDescription)screens.get(0)).getBarcodeScanner();
                if (bScanner != null) {
                    BarcodeData bData = bScanner.getParser().parse(sp);
                    StoreHelper.mergeData(this.data, (List)bData.getElements());
                }
            }
            catch (BarcodeException ex) {
                this.log.error((Object)"Error on parsing input data", (Throwable)ex);
            }
        }
    }

    private void showNext(ScreenSequence ss) throws InitException {
        StoreHelper.mergeData(this.data, (List)ss.getFields());
        Stack<ScreenPos> sses = new Stack<ScreenPos>();
        if (!this.states.isEmpty()) {
            sses.addAll((Collection)this.states.peek());
        }
        sses.push(new ScreenPos(ss, 0));
        this.states.push(sses);
        this.showScreenSafe((ScreenDescription)ss.getScreens().get(0));
    }

    private void showNext() {
        Stack<ScreenPos> copy = new Stack<ScreenPos>();
        copy.addAll((Collection)this.states.peek());
        while (!copy.isEmpty()) {
            ScreenPos sp = (ScreenPos)copy.pop();
            ScreenSequence ss = sp.getSequence();
            if (sp.getIndex() + 1 >= ss.getScreens().size()) continue;
            copy.push(new ScreenPos(sp.getSequence(), sp.getIndex() + 1));
            this.states.add(copy);
            this.showScreenSafe((ScreenDescription)sp.getSequence().getScreens().get(sp.getIndex() + 1));
            return;
        }
        if (this.form.getDemandMessage() != null && !this.form.getDemandMessage().isEmpty()) {
            this.toSendRequest();
        } else {
            this.showConfirm();
        }
    }

    private void showConfirm() {
        if (this.environment.getMenuItem().getService().isShowConfirm()) {
            String confirmSound;
            ConfirmScreenDescription sd = new ConfirmScreenDescription();
            sd.setId("confirm");
            String confirmScreen = this.form.getConfirmScreen();
            if (confirmScreen != null && !confirmScreen.isEmpty()) {
                sd.setType(confirmScreen);
            }
            if ((confirmSound = this.form.getConfirmSound()) != null && !confirmSound.isEmpty()) {
                sd.setSound(confirmSound);
            }
            sd.setButtons(InitModuleHelper.createKeyMap());
            sd.setTitle(ModuleHelper.getMessage("Provider.universal.confirm.title", this.environment.getLocale(), this.environment.getMenuItem().getService().getName()));
            this.confirmShowed = true;
            this.showScreenSafe((ScreenDescription)sd, (ScreenListener)new ConfirmScreenListener());
        } else {
            this.startVerify();
        }
    }

    private void startVerify() {
        MenuItem mi = this.environment.getMenuItem();
        this.helper.verify(mi.getService(), mi.getCommission(), mi.isVerify(), this.data, (ProviderHelperListener)new LocalHelperListener(), this.environment.getLocale(), mi.isIgnoreMinMaxCommission());
    }

    private void showPrev() {
        Stack<ScreenPos> current = this.states.pop();
        if (!this.states.empty()) {
            ScreenPos sp = this.states.peek().peek();
            this.showScreenSafe((ScreenDescription)sp.getSequence().getScreens().get(sp.getIndex()));
        } else {
            this.states.push(current);
            this.back();
        }
    }

    private void showScreenSafe(ScreenDescription sd) {
        try {
            this.showScreen(sd, (ScreenListener)this.screenListener, true);
        }
        catch (InitException ex) {
            ProblemNotifier.getDefaultNotifier().onError((Exception)((Object)ex));
        }
    }

    private void showScreenSafe(ScreenDescription sd, boolean canDisaleNext) {
        try {
            this.showScreen(sd, (ScreenListener)this.screenListener, canDisaleNext);
        }
        catch (InitException ex) {
            ProblemNotifier.getDefaultNotifier().onError((Exception)((Object)ex));
        }
    }

    private void showScreenSafe(ScreenDescription sd, ScreenListener sl) {
        try {
            this.showScreen(sd, sl, true);
        }
        catch (InitException ex) {
            ProblemNotifier.getDefaultNotifier().onError((Exception)((Object)ex));
        }
    }

    private void showScreen(ScreenDescription sd, ScreenListener listener, boolean canDisableNext) throws InitException {
        this.log.info((Object)(">>>>>>" + sd.getType() + "," + sd.getTitle()));
        sd.setId("" + this.states.size());
        DataRender.printStack(this.states);
        CommonScreen cs = CommonScreenStore.getScreen((String)sd.getType(), (String)sd.getDecor());
        if (cs == null) {
            throw new InitException("Can't get screen type: " + sd.getType());
        }
        this.currentScreenDescription = sd;
        this.barcodeScanner = sd.getBarcodeScanner();
        if (this.barcodeScanner != null && this.barcodeScanner.isDisableButtonNext()) {
            ButtonInit bi = (ButtonInit)sd.getButtons().get("Next");
            if (bi == null) {
                bi = (ButtonInit)sd.getButtons().get("Next".toLowerCase());
            }
            if (bi != null) {
                bi.setEnable(!canDisableNext);
            }
        }
        cs.setListener(listener);
        cs.init(ScreenHelper.processBack((ScreenDescription)sd, (this.states.size() == 1 && this.states.peek().peek().getIndex() == 0 ? 1 : 0) != 0, (this.parent != null ? 1 : 0) != 0), InitModuleHelper.buildScreenInit(this.environment, this.data));
        this.context.showScreen(new ContentScreenAdapterKbr(cs));
        if (sd.getSound() != null) {
            MediaPlayer.getInstance().play(sd.getSound());
        }
    }

    @Override
    protected void mergeData(Map<String, Object> local) {
        if (local != null) {
            this.data.putAll(local);
        }
    }

    @Override
    protected void showCurrentScreen() {
        this.showScreenSafe(this.currentScreenDescription, false);
    }

    @Override
    protected void showNextScreen() {
        this.showNext();
    }

    @Override
    public BarcodeScannerListener getBarcodeScannerListener() {
        return null;
    }

    @Override
    public void _restore() {
        this.log.info((Object)"Restore input module");
        if (this.confirmShowed) {
            this.showConfirm();
        } else {
            ScreenPos sp = this.states.peek().peek();
            this.showScreenSafe((ScreenDescription)sp.getSequence().getScreens().get(sp.getIndex()));
        }
    }

    private void toSendRequest() {
        this.log.info((Object)"Send demand request");
        int val = SequenceManager.getValueQuietly((String)"question");
        StringBuilder sb = new StringBuilder();
        for (InputElement ie : StoreHelper.convert(this.data)) {
            sb.append(ie.getKey()).append("=").append(ie.getValue()).append(";");
        }
        this.context.getServerConnector().putDemand(new Demand(val, (short)this.environment.getMenuItem().getService().getId(), sb.toString()));
        this.log.info((Object)"Show message");
        String message = this.form.getDemandMessage();
        DialogScreen dlg = ComponentFactory.getInstance().createDialog(DialogType.Info, message, 10, DC.cases((int)1), UserCase.Ok);
        dlg.addListener((DialogListener)new ExitDialogListener(this));
        this.context.showDialog((DialogInterface)dlg);
    }

    private void toPayment() {
        InputElement ie;
        TransactionSum ts;
        DataRender.dataToStr(this.data);
        Object obj = this.data.get("#sum");
        Sum operationSum = Session.getInstance().getPack().getOperationSum();
        Sum minSumLimit = null;
        Sum maxSumLimit = null;
        if (obj != null) {
            if (obj instanceof TransactionSum) {
                ts = (TransactionSum)obj;
                operationSum = new Sum((double)ts.getSum() * Math.pow(10.0, -ts.getFractionDigits()));
            } else if (obj instanceof InputElement) {
                ie = (InputElement)obj;
                if (ie.getValue().matches("^\\d+(\\.\\d{0,2})?")) {
                    operationSum = new Sum(Double.parseDouble(ie.getValue()));
                } else if (ie.hasFlag(2048)) {
                    this.log.error((Object)("Wrong sum format: " + ie));
                } else {
                    this.log.error((Object)("Wrong sum format: " + ie.getValue()));
                }
            } else if (obj instanceof Sum) {
                operationSum = (Sum)obj;
            }
        }
        if (this.form.getMinSumLimit() != null) {
            obj = this.data.get(this.form.getMinSumLimit());
            if (obj instanceof TransactionSum) {
                ts = (TransactionSum)obj;
                minSumLimit = new Sum((double)ts.getSum() * Math.pow(10.0, -ts.getFractionDigits()));
            } else if (obj instanceof InputElement) {
                ie = (InputElement)obj;
                if (ie.getValue().matches("^\\d+(\\.\\d{0,2})?")) {
                    minSumLimit = new Sum(Double.parseDouble(ie.getValue()));
                } else if (ie.hasFlag(2048)) {
                    this.log.error((Object)("Wrong sum-min format: " + ie));
                } else {
                    this.log.error((Object)("Wrong sum-min format: " + ie.getValue()));
                }
            } else if (obj instanceof Sum) {
                minSumLimit = (Sum)obj;
            }
            Session.getInstance().getPack().setMinSum(minSumLimit);
        }
        if (this.form.getMaxSumLimit() != null) {
            obj = this.data.get(this.form.getMaxSumLimit());
            if (obj instanceof TransactionSum) {
                ts = (TransactionSum)obj;
                maxSumLimit = new Sum((double)ts.getSum() * Math.pow(10.0, -ts.getFractionDigits()));
            } else if (obj instanceof InputElement) {
                ie = (InputElement)obj;
                if (ie.getValue().matches("^\\d+(\\.\\d{0,2})?")) {
                    maxSumLimit = new Sum(Double.parseDouble(ie.getValue()));
                } else if (ie.hasFlag(2048)) {
                    this.log.error((Object)("Wrong sum-max format: " + ie));
                } else {
                    this.log.error((Object)("Wrong sum-max format: " + ie.getValue()));
                }
            } else if (obj instanceof Sum) {
                maxSumLimit = (Sum)obj;
            }
            Session.getInstance().getPack().setMaxSum(maxSumLimit);
        }
        PaymentParams pp = this.form.getPaymentParams();
        Session.getInstance().getPack().setPrintByOne(pp == null ? false : pp.isSingleCheck());
        Session.getInstance().getPack().setAllowReturn(pp == null ? false : pp.isAllowReturn());
        InitModuleHelper.processData(this.data);
        this._startPayment(this.environment, (SumScreenDescription)this.form.getSumDescription(), this.data, operationSum, null, null);
    }

    private Map<String, Object> getRedirectParams(List<String> params) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        if (params == null || params.isEmpty()) {
            return map;
        }
        if (params.size() == 1 && "$all".equals(params.get(0))) {
            map.putAll(this.data);
        } else {
            for (String param : params) {
                map.put(param, this.data.get(param));
            }
        }
        return map;
    }

    private class LocalHelperListener
    implements ProviderHelperListener {
        private LocalHelperListener() {
        }

        @Override
        public void onVerifyComplete(VerifyResult result) {
            UniversalInputModule.this.log.info((Object)("Verify complete: " + result));
            if (result.getDataItems() != null && result.getDataItems().length > 0) {
                boolean addItem = false;
                for (VerifyDataItem vdi : result.getDataItems()) {
                    if (ArgumentType.In.equals((Object)vdi.getType()) || ArgumentType.InOut.equals((Object)vdi.getType())) {
                        UniversalInputModule.this.data.put(vdi.getKey(), new InputElement(vdi.getKey(), vdi.getKeyTitle(), vdi.getValue(), vdi.getValueTitle(), vdi.getFlags() != null ? vdi.getFlags() : 0));
                        addItem = true;
                        continue;
                    }
                    InputElement ie = new InputElement(vdi.getKey(), vdi.getKeyTitle(), vdi.getValue(), vdi.getValueTitle(), vdi.getFlags() != null ? vdi.getFlags() : 0);
                    ie.setFlags(3);
                    UniversalInputModule.this.data.put(vdi.getKey(), ie);
                }
                if (result.getSumPurchase() != null) {
                    UniversalInputModule.this.data.put("#sum", result.getSumPurchase());
                }
                if (!addItem) {
                    UniversalInputModule.this.log.info((Object)"Not added items to confirm, go to payment");
                    UniversalInputModule.this.toPayment();
                    return;
                }
                if (UniversalInputModule.this.environment.getMenuItem().getService().isShowVerifyResult()) {
                    ConfirmScreenDescription sd = new ConfirmScreenDescription();
                    sd.setButtons(InitModuleHelper.createKeyMap());
                    sd.setTitle(result.getTitle());
                    UniversalInputModule.this.showScreenSafe((ScreenDescription)sd, (ScreenListener)new VerifyConfirmScreenListener());
                } else {
                    UniversalInputModule.this.toPayment();
                }
            } else {
                UniversalInputModule.this.toPayment();
            }
        }

        @Override
        public void onVerifyError() {
            UniversalInputModule.this.log.info((Object)"Verify error");
            ModuleHelper.invoke(UniversalInputModule.this.cancelListener);
        }

        @Override
        public void toPayment() {
            UniversalInputModule.this.toPayment();
        }
    }

    private class LocalScreenListener
    extends ComplexScreenListener {
        public LocalScreenListener(ApplicationContext context) {
            super(context);
        }

        @Override
        public void _onAction(String action, Map<String, Object> local, Runnable cancelListener) {
            UniversalInputModule.this.log.info((Object)("action=" + action));
            UniversalInputModule.this.cancelListener = cancelListener;
            UniversalInputModule.this.data.putAll(local);
            Object redirect = local.get("#redirect");
            if (redirect instanceof RedirectCustomData) {
                RedirectCustomData rcd = (RedirectCustomData)redirect;
                UniversalInputModule.this._redirect(rcd.getService().intValue(), UniversalInputModule.this.getRedirectParams(rcd.getParams()));
            } else {
                Object sequence = local.remove("#sequence");
                DataRender.dataToStr(UniversalInputModule.this.data);
                try {
                    if (sequence instanceof SequenceCustomData) {
                        SequenceCustomData scd = (SequenceCustomData)sequence;
                        ScreenSequence ss = scd.getScreenSequence();
                        if (ss.getScreens() != null && !ss.getScreens().isEmpty()) {
                            UniversalInputModule.this.showNext(ss);
                        } else {
                            StoreHelper.mergeData((Map)UniversalInputModule.this.data, (List)ss.getFields());
                            UniversalInputModule.this.showNext();
                        }
                    } else if ("Next".equals(action)) {
                        UniversalInputModule.this.showNext();
                    } else if ("Prev".equals(action)) {
                        UniversalInputModule.this.showPrev();
                    } else if ("Exit".equals(action)) {
                        UniversalInputModule.this.cancel(null);
                    }
                }
                catch (InitException ex) {
                    ProblemNotifier.getDefaultNotifier().onError((Exception)((Object)ex));
                }
            }
        }

        public void onRedirect(int serviceId) {
            UniversalInputModule.this._redirect(serviceId, UniversalInputModule.this.getRedirectParams(null));
        }
    }

    private class VerifyConfirmScreenListener
    extends ScreenAdapter {
        private VerifyConfirmScreenListener() {
        }

        public void onAction(String action, Map<String, Object> data, Runnable cancelListener) {
            UniversalInputModule.this.log.info((Object)("Action " + action + " on confirm screen"));
            UniversalInputModule.this.cancelListener = cancelListener;
            if (ActionType.isNext((String)action)) {
                UniversalInputModule.this.toPayment();
            } else if (ActionType.isExit((String)action)) {
                UniversalInputModule.this.cancel(null);
            } else if (ActionType.isPrev((String)action)) {
                UniversalInputModule.this._restore();
            }
        }

        public void onLocale(Locale locale) {
            UniversalInputModule.this.environment.setLocale(locale);
        }
    }

    private class ConfirmScreenListener
    extends ScreenAdapter {
        private ConfirmScreenListener() {
        }

        public void onAction(String action, Map<String, Object> data, Runnable cancelListener) {
            UniversalInputModule.this.log.info((Object)("Action " + action + " on confirm screen"));
            UniversalInputModule.this.cancelListener = cancelListener;
            if (ActionType.isNext((String)action)) {
                UniversalInputModule.this.startVerify();
            } else if (ActionType.isExit((String)action)) {
                UniversalInputModule.this.cancel(null);
            } else if (ActionType.isPrev((String)action)) {
                UniversalInputModule.this.confirmShowed = false;
                UniversalInputModule.this._restore();
            }
        }

        public void onLocale(Locale locale) {
            UniversalInputModule.this.environment.setLocale(locale);
        }

        public void onRedirect(int serviceId) {
            Keeper current = CashManager.getDefaultInstance().current();
            UniversalInputModule.this.log.info((Object)"canRedirect: Request for permission to redirect from PaymentModule");
            if (current == null || current.getSum().isEmpty()) {
                UniversalInputModule.this.log.info((Object)"canRedirect: Keeper is empty.");
                UniversalInputModule.this._redirect(serviceId);
            } else {
                UniversalInputModule.this.log.info((Object)"canRedirect: Current keeper is not empty. Skip redirect");
            }
        }
    }
}

