/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.module.input.paystat;

import i18n.B;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import ru.softlogic.app.context.ApplicationContext;
import ru.softlogic.app.task.Task;
import ru.softlogic.application.ContentScreenAdapterKbr;
import ru.softlogic.gui.factory.ComponentFactory;
import ru.softlogic.gui.screen.popup.dialog.DC;
import ru.softlogic.gui.screen.popup.dialog.DialogInterface;
import ru.softlogic.gui.screen.popup.dialog.DialogListener;
import ru.softlogic.gui.screen.popup.dialog.DialogScreen;
import ru.softlogic.gui.screen.popup.dialog.DialogType;
import ru.softlogic.gui.screen.popup.dialog.UserCase;
import ru.softlogic.gui2.screen.ActionType;
import ru.softlogic.gui2.screen.CommonScreen;
import ru.softlogic.gui2.screen.CommonScreenStore;
import ru.softlogic.gui2.screen.ScreenAdapter;
import ru.softlogic.gui2.screen.ScreenHelper;
import ru.softlogic.gui2.screen.ScreenListener;
import ru.softlogic.input.model.InputElement;
import ru.softlogic.input.model.field.InitException;
import ru.softlogic.input.model.form.Form;
import ru.softlogic.input.model.screen.description.ScreenDescription;
import ru.softlogic.module.ModuleHelper;
import ru.softlogic.module.Restorable;
import ru.softlogic.module.input.BaseInputModule;
import ru.softlogic.module.input.DescriptionException;
import ru.softlogic.module.input.Environment;
import ru.softlogic.module.input.InitModuleHelper;
import ru.softlogic.module.input.ModuleInitException;
import ru.softlogic.module.input.universal.FormHelper;
import ru.softlogic.module.utils.ExitDialogListener;
import ru.softlogic.parser.ParseException;
import ru.softlogic.srv.api.oth.FindOperationResult;
import ru.softlogic.srv.connector.ConnectorException;

public class PayStatusInputModule
extends BaseInputModule {
    private static final SimpleDateFormat sdf = new SimpleDateFormat("dd.MM.yyyy");
    private Environment environment;

    public PayStatusInputModule(ApplicationContext context) {
        super(context);
    }

    @Override
    protected void _start(Environment environment, Restorable parent) throws DescriptionException, ModuleInitException {
        this.environment = environment;
        try {
            Form f = FormHelper.parseUtility("paystatus", environment.getLocale());
            List screens = f.getScreenSequence().getScreens();
            if (screens.size() != 1) {
                throw new ParseException("Wrong number of screens");
            }
            int fsize = ((ScreenDescription)screens.get(0)).getSequence().getFields().size();
            if (fsize < 4 || fsize > 5) {
                throw new ParseException("Wrong number of fields: " + screens.size());
            }
            HashMap<String, Object> obj = new HashMap<String, Object>();
            obj.put("point", new InputElement("point", "point", "" + environment.getPoint().getId()));
            CommonScreen cs = CommonScreenStore.getScreen((String)"letter", (String)((ScreenDescription)f.getScreenSequence().getScreens().get(0)).getDecor());
            cs.init(ScreenHelper.processBack((ScreenDescription)((ScreenDescription)screens.get(0)), (boolean)true, (parent != null ? 1 : 0) != 0), InitModuleHelper.buildScreenInit(environment, obj));
            cs.setListener((ScreenListener)new LocalScreenListener());
            this.context.showScreen(new ContentScreenAdapterKbr(cs));
        }
        catch (InitException ex) {
            throw new ModuleInitException(ex);
        }
        catch (ParseException ex) {
            throw new DescriptionException(ex);
        }
    }

    @Override
    protected void _restore() {
    }

    private class RequestTask
    implements Task {
        private final String account;
        private final Integer sum;
        private final String date;
        private final Integer checkNumber;
        private final Short point;

        public RequestTask(String account, int sum, String date, Integer checkNumber, short point) {
            this.account = account;
            this.sum = sum;
            this.date = date;
            this.checkNumber = checkNumber;
            this.point = point;
        }

        @Override
        public String getMessage() {
            return B.get((String)"Request.wait");
        }

        @Override
        public Object execute() {
            PayStatusInputModule.this.log.info((Object)("Make request, data=" + this.account + ", " + this.sum + ", " + this.date + ", " + this.checkNumber + ", " + this.point));
            try {
                return PayStatusInputModule.this.context.getServerConnector().findOperation(this.point, this.checkNumber, this.date, this.account, this.sum);
            }
            catch (ConnectorException ex) {
                return ex;
            }
        }

        @Override
        public void onResult(Object object) {
            PayStatusInputModule.this.log.info(object);
            if (object instanceof FindOperationResult) {
                FindOperationResult fr = (FindOperationResult)object;
                DialogScreen dialog = ComponentFactory.getInstance().createDialog(DialogType.Info, MessageFormat.format(B.get((String)("Provider.paystat.state." + fr.getState())), PayStatusInputModule.this.environment.getDealer().getSupport()), 20, DC.cases((int)1), UserCase.Ok);
                Object listener = null;
                listener = fr.getState() < 0 ? new DialogListener(){

                    public void dialogClosed(UserCase userCase) {
                        ModuleHelper.invoke(PayStatusInputModule.this.cancelListener);
                    }
                } : new ExitDialogListener(PayStatusInputModule.this);
                dialog.addListener(listener);
                PayStatusInputModule.this.context.showDialog((DialogInterface)dialog);
            } else {
                Exception ex = (Exception)object;
                PayStatusInputModule.this.log.error((Object)"\u0421\u0431\u043e\u0439 \u043f\u0440\u0438 \u043e\u043d\u043b\u0430\u0439\u043d \u0437\u0430\u043f\u0440\u043e\u0441\u0435", (Throwable)ex);
                DialogScreen dialog = ComponentFactory.getInstance().createDialog(DialogType.Error, B.get((String)"Request.failure.connect"), 10, DC.cases((int)1), UserCase.Ok);
                PayStatusInputModule.this.context.showDialog((DialogInterface)dialog);
                ModuleHelper.invoke(PayStatusInputModule.this.cancelListener);
            }
        }
    }

    private class LocalScreenListener
    extends ScreenAdapter {
        private LocalScreenListener() {
        }

        public void onAction(String action, Map<String, Object> data, Runnable cancelListener) {
            PayStatusInputModule.this.cancelListener = cancelListener;
            if (ActionType.isNext((String)action)) {
                int pnt;
                Date d;
                PayStatusInputModule.this.log.info(data);
                InputElement account = (InputElement)data.get("account");
                InputElement sm = (InputElement)data.get("sum");
                InputElement date = (InputElement)data.get("date");
                InputElement doc = (InputElement)data.get("doc");
                InputElement point = (InputElement)data.get("point");
                int sum = Math.round(Float.parseFloat(sm.getValue()) * 100.0f);
                try {
                    GregorianCalendar cal;
                    if (date.getValue().matches("\\d+")) {
                        cal = new GregorianCalendar();
                        ((Calendar)cal).add(6, -Integer.parseInt(date.getValue()));
                        d = cal.getTime();
                    } else {
                        d = sdf.parse(date.getValue());
                    }
                    cal = new GregorianCalendar();
                    if (d.after(cal.getTime())) {
                        DialogScreen dialog = ComponentFactory.getInstance().createDialog(DialogType.Error, B.get((String)"Provider.paystat.date.error"), 10, DC.cases((int)1), UserCase.Ok);
                        PayStatusInputModule.this.context.showDialog((DialogInterface)dialog);
                        ModuleHelper.invoke(cancelListener);
                        return;
                    }
                    ((Calendar)cal).add(5, -3);
                    if (d.before(cal.getTime())) {
                        DialogScreen dialog = ComponentFactory.getInstance().createDialog(DialogType.Error, B.get((String)"Provider.paystat.date.error"), 10, DC.cases((int)1), UserCase.Ok);
                        PayStatusInputModule.this.context.showDialog((DialogInterface)dialog);
                        ModuleHelper.invoke(cancelListener);
                        return;
                    }
                }
                catch (java.text.ParseException ex) {
                    DialogScreen dialog = ComponentFactory.getInstance().createDialog(DialogType.Error, B.get((String)"Provider.paystat.date.failure"), 10, DC.cases((int)1), UserCase.Ok);
                    PayStatusInputModule.this.context.showDialog((DialogInterface)dialog);
                    ModuleHelper.invoke(cancelListener);
                    return;
                }
                Integer docNum = null;
                if (doc != null && doc.getValue().matches("^\\d{1,5}$") && ((docNum = Integer.valueOf(Integer.parseInt(doc.getValue()))) < 1 || docNum > 32500)) {
                    DialogScreen dialog = ComponentFactory.getInstance().createDialog(DialogType.Error, B.get((String)"Provider.paystat.doc.error"), 10, DC.cases((int)1), UserCase.Ok);
                    PayStatusInputModule.this.context.showDialog((DialogInterface)dialog);
                    ModuleHelper.invoke(cancelListener);
                    return;
                }
                int n = pnt = point == null ? PayStatusInputModule.this.environment.getPoint().getId() : Integer.parseInt(point.getValue());
                if (pnt < 1 || pnt > 32000) {
                    DialogScreen dialog = ComponentFactory.getInstance().createDialog(DialogType.Error, B.get((String)"Provider.paystat.point.error"), 10, DC.cases((int)1), UserCase.Ok);
                    PayStatusInputModule.this.context.showDialog((DialogInterface)dialog);
                    ModuleHelper.invoke(cancelListener);
                    return;
                }
                PayStatusInputModule.this.context.getTaskExecutor().execute(new RequestTask(account.getValue(), sum, sdf.format(d), docNum, (short)pnt));
            } else {
                PayStatusInputModule.this.cancel(null);
            }
        }
    }
}

