/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.module.input.ntssnack;

import i18n.B;
import java.util.Locale;
import org.apache.log4j.Logger;
import ru.softlogic.app.task.Task;
import ru.softlogic.module.input.ntssnack.StatusActionListener;
import snack.machine.api.SnackMachine;
import snack.machine.model.Answer.ResNumCntAnswer;
import snack.machine.model.StatusSM;

public class StatusTask
implements Task {
    private StatusActionListener actionListener;
    private String message;
    private Logger log;
    private Locale locale;

    public StatusTask(StatusActionListener actionListener, String message, Locale locale) {
        this.actionListener = actionListener;
        this.message = message;
        this.locale = locale;
        this.log = Logger.getLogger((String)"pay");
    }

    @Override
    public String getMessage() {
        return this.message;
    }

    @Override
    public Object execute() {
        this.log.info((Object)"Start snackomat status task");
        try {
            StatusSM status = SnackMachine.getDefaultInstance().getStatus();
            return status;
        }
        catch (Exception ex) {
            this.log.error((Object)ex, (Throwable)ex);
            return ex;
        }
    }

    @Override
    public void onResult(Object object) {
        this.log.info((Object)("Recived answer: " + object));
        if (object != null && object instanceof StatusSM) {
            StatusSM statusSM = (StatusSM)object;
            if (statusSM.getStatusError() != 0 || statusSM.getMode() != 2) {
                this.log.info((Object)"Status: error");
                this.actionListener.onError(statusSM);
            } else {
                this.log.info((Object)"Status: ok");
                this.actionListener.onSuccess();
            }
        } else if (object != null && object instanceof ResNumCntAnswer) {
            ResNumCntAnswer answer = (ResNumCntAnswer)object;
            if (answer.getResult() != 0) {
                this.log.info((Object)"Result: error");
                this.actionListener.onError(answer);
            } else {
                this.log.info((Object)"Result: ok");
                this.actionListener.onSuccess();
            }
        } else if (object != null && object instanceof ResNumCntAnswer[]) {
            ResNumCntAnswer[] answer = (ResNumCntAnswer[])object;
            this.log.info((Object)("Recived answer for snack dispense: " + answer[0]));
            this.log.info((Object)("Recived confirm for snack dispense : " + answer[1]));
            this.log.info((Object)("Dropstate: " + answer[1].getSnackNumber()));
            if ((answer[0].getResult() | answer[1].getResult()) != 0) {
                this.log.info((Object)("Result: error - " + B.get((String)("Module.processing.snack.dispense.error." + answer[1].getResult()), (Locale)this.locale)));
                this.actionListener.onError(answer);
            } else {
                this.log.info((Object)"Result: ok");
                this.actionListener.onSuccess();
            }
        } else {
            this.actionListener.onError(object);
        }
    }
}

