/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.module.input.ntspay;

import java.awt.EventQueue;
import org.apache.log4j.Logger;
import ru.softlogic.app.session.Session;
import ru.softlogic.cash.Keeper;
import ru.softlogic.cash.Sum;
import ru.softlogic.cash.manager.observer.KeeperObserver;
import ru.softlogic.gui2.screen.CommonSumScreen;
import ru.softlogic.gui2.screen.ScreenListener;
import ru.softlogic.module.input.ntspay.NtspayPayDetector;
import ru.softlogic.module.payment.CashMobuleHelper;
import ru.softlogic.reference.service.Service;
import ru.softlogic.service.comission.SumResult;

public class NtspayCurrencyKeeperListener
implements KeeperObserver {
    private CommonSumScreen css;
    private Sum requireSum;
    private Sum requireProvSum;
    private Service service;
    private NtspayPayDetector detector;
    private boolean autoFinishPayment;
    private ScreenListener listener;
    private Logger log;

    public NtspayCurrencyKeeperListener(CommonSumScreen css, Sum requireSum, Sum requireProvSum, Service service, NtspayPayDetector detector, boolean autoFinishPayment, ScreenListener listener) {
        this.css = css;
        this.requireSum = requireSum;
        this.requireProvSum = requireProvSum;
        this.service = service;
        this.detector = detector;
        this.autoFinishPayment = autoFinishPayment;
        this.listener = listener;
        this.log = Logger.getLogger((String)"pay");
    }

    public void update(Keeper keeper, Sum sum) {
        Session.getInstance().setCurrentKeeper(keeper);
        SumResult sr = this.detector.calculate(keeper);
        if (!keeper.getSum().isEmpty()) {
            this.log.info((Object)("--> Get sum : " + sum));
            this.log.info((Object)("Keeper      : " + keeper.getSum() + ", " + keeper));
            this.log.info((Object)("Amount      : " + sr));
            this.log.info((Object)("Require     : " + this.requireSum));
            this.log.info((Object)("RequireProv : " + this.requireProvSum));
        }
        EventQueue.invokeLater(new ViewUpdater(keeper, sr, this.detector.canPay(sr)));
    }

    public void updateLimits(Keeper keeper, Sum minSum, Sum newRequiredSum) {
        if (newRequiredSum != null) {
            this.requireSum = newRequiredSum;
        }
        this.detector.setMin(minSum);
        SumResult sr = this.detector.calculate(keeper);
        EventQueue.invokeLater(new ViewUpdater(keeper, sr, this.detector.canPay(sr)));
    }

    public void notifyNoMoreNeed() {
    }

    private class ViewUpdater
    implements Runnable {
        private Keeper keeper;
        private SumResult sr;
        private boolean canPay;

        public ViewUpdater(Keeper keeper, SumResult sr, boolean canPay) {
            this.keeper = keeper;
            this.sr = sr;
            this.canPay = canPay;
        }

        @Override
        public void run() {
            NtspayCurrencyKeeperListener.this.css.updateSums(this.keeper.getSum(), null, NtspayCurrencyKeeperListener.this.requireProvSum == null ? NtspayCurrencyKeeperListener.this.requireSum : NtspayCurrencyKeeperListener.this.requireProvSum, null, this.sr, new Sum(), this.canPay, this.sr.getIncome().isEmpty(), CashMobuleHelper.isAllowCBC(NtspayCurrencyKeeperListener.this.service, this.keeper == null ? false : !this.keeper.getCashSum().isEmpty()));
            if (NtspayCurrencyKeeperListener.this.autoFinishPayment && this.canPay) {
                EventQueue.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        NtspayCurrencyKeeperListener.this.listener.onAction("Next", null, new Runnable(){

                            @Override
                            public void run() {
                            }
                        });
                    }
                });
            }
        }
    }
}

