/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.module.input.ntscoffee;

import coffee.machine.api.CoffeeMachine;
import coffee.machine.model.Drink;
import coffee.machine.model.Ingredient;
import coffee.machine.model.StatusCM;
import coffee.machine.model.Topping;
import i18n.B;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import ru.softlogic.app.ProblemNotifier;
import ru.softlogic.app.context.ApplicationContext;
import ru.softlogic.app.task.Task;
import ru.softlogic.application.ContentScreenAdapter;
import ru.softlogic.cash.Sum;
import ru.softlogic.gui.factory.ComponentFactory;
import ru.softlogic.gui.screen.popup.dialog.DC;
import ru.softlogic.gui.screen.popup.dialog.DialogInterface;
import ru.softlogic.gui.screen.popup.dialog.DialogListener;
import ru.softlogic.gui.screen.popup.dialog.DialogScreen;
import ru.softlogic.gui.screen.popup.dialog.DialogType;
import ru.softlogic.gui.screen.popup.dialog.UserCase;
import ru.softlogic.gui.utils.menu.MenuByPropertyVisitor;
import ru.softlogic.gui.utils.menu.MenuUtils;
import ru.softlogic.gui.utils.menu.MenuVisitor;
import ru.softlogic.gui2.screen.ActionType;
import ru.softlogic.gui2.screen.CommonScreen;
import ru.softlogic.gui2.screen.CommonScreenStore;
import ru.softlogic.gui2.screen.ScreenAdapter;
import ru.softlogic.gui2.screen.ScreenHelper;
import ru.softlogic.gui2.screen.ScreenListener;
import ru.softlogic.input.model.Data;
import ru.softlogic.input.model.InputElement;
import ru.softlogic.input.model.TransactionSum;
import ru.softlogic.input.model.field.FieldSequence;
import ru.softlogic.input.model.field.InitException;
import ru.softlogic.input.model.field.numeric.NumericField;
import ru.softlogic.input.model.field.numeric.Range;
import ru.softlogic.input.model.field.selector.ItemsStore;
import ru.softlogic.input.model.field.selector.SelectorField;
import ru.softlogic.input.model.field.selector.SelectorItem;
import ru.softlogic.input.model.field.selector.StaticStore;
import ru.softlogic.input.model.field.text.DigitalFilter;
import ru.softlogic.input.model.field.text.Filter;
import ru.softlogic.input.model.field.text.Formatter;
import ru.softlogic.input.model.field.text.Keyboard;
import ru.softlogic.input.model.field.text.KeyboardType;
import ru.softlogic.input.model.field.text.Modificator;
import ru.softlogic.input.model.field.text.NumericRangeValidator;
import ru.softlogic.input.model.field.text.Validator;
import ru.softlogic.input.model.field.text.VoidFormatter;
import ru.softlogic.input.model.field.text.VoidModificator;
import ru.softlogic.input.model.screen.ButtonInit;
import ru.softlogic.input.model.screen.description.ScreenDescription;
import ru.softlogic.input.model.screen.description.SumScreenDescription;
import ru.softlogic.intent.Intent;
import ru.softlogic.media.MediaPlayer;
import ru.softlogic.module.ModuleHelper;
import ru.softlogic.module.Restorable;
import ru.softlogic.module.input.BaseInputModule;
import ru.softlogic.module.input.DescriptionException;
import ru.softlogic.module.input.Environment;
import ru.softlogic.module.input.InitModuleHelper;
import ru.softlogic.module.input.ModuleInitException;
import ru.softlogic.module.input.ntscoffee.CoffeeContextStub;
import ru.softlogic.module.input.ntscoffee.CoffeeHelper;
import ru.softlogic.module.input.ntscoffee.NtsCoffeeProcessingModule;
import ru.softlogic.module.input.ntscoffee.StatusActionListener;
import ru.softlogic.module.input.ntscoffee.StatusTask;
import ru.softlogic.reference.menu.MenuItem;

public class NtsCoffeeInputModule
extends BaseInputModule {
    private Environment environment;
    private Restorable parent;
    private Map<String, Drink> drinks;
    private Map<Integer, Topping> toppings;
    private CommonScreen currentScreen;
    private StatusActionListener statusActionListener;
    private Locale locale;
    private Map<String, Object> data = new LinkedHashMap<String, Object>();
    private CoffeeContextStub coffeeContext;
    private String paymentModuleName;
    private List<MenuItem> menuItems;
    private MenuItem currentMenuItem;
    private static final String TOPPING_NO = "toppingNo";

    public NtsCoffeeInputModule(ApplicationContext context) {
        super(context);
        this.statusActionListener = new LocalStatusListener();
        this.coffeeContext = new CoffeeContextStub(context);
    }

    @Override
    protected void _start(Environment environment, Restorable parent) throws DescriptionException, ModuleInitException {
        this.log.info((Object)"Start coffee sale");
        this.locale = environment.getLocale();
        environment.setProcessingModule(new NtsCoffeeProcessingModule((ApplicationContext)this.context));
        this.environment = environment;
        this.parent = parent;
        this.coffeeContext.getTaskExecutor().execute(new StatusTask(this.statusActionListener, B.get((String)"Module.input.coffee.request.wait", (Locale)this.locale), 2, this.locale));
        this.paymentModuleName = null;
        if (environment.getMenuItem() != null && environment.getMenuItem().getService() != null && environment.getMenuItem().getService().getModules() != null && environment.getMenuItem().getService().getModules().getPayment() != null && !environment.getMenuItem().getService().getModules().getPayment().isEmpty()) {
            this.paymentModuleName = environment.getMenuItem().getService().getModules().getPayment();
        }
        this.log.info((Object)("Redirect data: " + environment.getInitData()));
    }

    @Override
    protected void _restore() {
        ModuleHelper.invoke(this.cancelListener);
        this.context.showScreen(new ContentScreenAdapter(this.currentScreen));
    }

    @Override
    public void cancel(Intent intent) {
        super.cancel(intent);
    }

    private void toShowShelfProducts() {
        this.log.info((Object)"Show select products screen");
        if (this.drinks != null && !this.drinks.isEmpty()) {
            LinkedList<SelectorItem> items = new LinkedList<SelectorItem>();
            for (Drink d : this.drinks.values()) {
                SelectorItem si = new SelectorItem(d.getNameDrink(), Integer.toString(d.getId()));
                HashMap<String, Drink> data = new HashMap<String, Drink>();
                data.put("#coffee.drink", d);
                si.setCustomData(data);
                si.setData(new Data());
                si.getData().setSum(new TransactionSum((float)d.getCost()));
                items.add(si);
            }
            SelectorField sf = new SelectorField();
            sf.setStore((ItemsStore)new StaticStore(items));
            LinkedList<SelectorField> fields = new LinkedList<SelectorField>();
            fields.add(sf);
            ScreenDescription sd = new ScreenDescription("selector-coffee");
            sd.setTitle(B.get((String)"Module.input.coffee.products.title", (Locale)this.locale));
            if ("cashless-auto".equals(this.paymentModuleName)) {
                sd.setDecor("coffee-image");
            } else {
                sd.setDecor("coffee-image");
            }
            sd.setSequence(new FieldSequence(fields));
            sd.setButtons(InitModuleHelper.createKeyMap());
            CommonScreen cs = CommonScreenStore.getScreen((String)sd.getType());
            try {
                cs.init(sd, InitModuleHelper.buildScreenInit(this.environment, new HashMap<String, Object>()));
                cs.setListener((ScreenListener)new LocalSelectProductListener());
                this.context.showScreen(new ContentScreenAdapter(cs));
                this.currentScreen = cs;
                MediaPlayer.getInstance().play("select_drink.mp3");
            }
            catch (InitException ex) {
                this.log.info((Object)ex, (Throwable)ex);
            }
        } else {
            this.showError(B.get((String)"Module.input.coffee.products.empty", (Locale)this.locale));
        }
    }

    private void toShowProductPage(Drink drink) {
        this.currentMenuItem = null;
        if (drink != null) {
            for (MenuItem mi : this.menuItems) {
                if (!Integer.toString(drink.getId()).equals(mi.getService().getProperties().get("drink-id"))) continue;
                this.currentMenuItem = mi;
                break;
            }
            Keyboard kbr = new Keyboard(KeyboardType.Digital);
            NumericField nf = new NumericField();
            nf.setId("sugar");
            nf.setTitle(B.get((String)"Module.input.coffee.sugar.amount", (Locale)this.locale));
            nf.setKeyboard(kbr);
            nf.setFilter((Filter)new DigitalFilter(false));
            nf.setFormatter((Formatter)new VoidFormatter());
            nf.setDataFormatter((Formatter)new VoidFormatter());
            nf.setModificator((Modificator)new VoidModificator());
            nf.setValidator((Validator)new NumericRangeValidator(Collections.singletonList(new Range(0.0f, 6.0f))));
            nf.setUnitCount(1);
            nf.setDecimalCount(1);
            nf.setDefaultValue(drink.isNeedSugar() ? "2" : String.valueOf(drink.getSugar()));
            NumericField nfT = new NumericField();
            nfT.setId(TOPPING_NO);
            nfT.setTitle("Topping");
            nfT.setKeyboard(kbr);
            nfT.setFilter((Filter)new DigitalFilter(false));
            nfT.setFormatter((Formatter)new VoidFormatter());
            nfT.setDataFormatter((Formatter)new VoidFormatter());
            nfT.setModificator((Modificator)new VoidModificator());
            nfT.setValidator((Validator)new NumericRangeValidator(Collections.singletonList(new Range(0.0f, 3.0f))));
            nfT.setUnitCount(1);
            nfT.setDecimalCount(1);
            nfT.setDefaultValue(String.valueOf(drink.getToppingNoByRecipe()));
            FieldSequence fs = new FieldSequence();
            fs.setFields(Arrays.asList(nf, nfT));
            ScreenDescription sd = new ScreenDescription();
            sd.setTitle(drink.getFullNameDrink());
            sd.setSequence(fs);
            HashMap<String, ButtonInit> buttons = new HashMap<String, ButtonInit>();
            buttons.put("Prev", new ButtonInit(null));
            buttons.put("Exit", new ButtonInit(null));
            buttons.put("Next", new ButtonInit(null));
            sd.setButtons(buttons);
            String screenType = "coffee-info";
            if (drink.getToppingNoByRecipe() != 0) {
                screenType = "coffee-info-topping";
            }
            CommonScreen cs = CommonScreenStore.getScreen((String)screenType);
            try {
                HashMap<String, Object> hashMap = new HashMap<String, Object>();
                hashMap.put("#sugar", drink.isNeedSugar());
                hashMap.put("#drink-id", String.valueOf(drink.getId()));
                LinkedList<String> ings = new LinkedList<String>();
                if (drink.getIngredients() != null) {
                    for (Ingredient i : drink.getIngredients()) {
                        String[] name = CoffeeHelper.getIngredientName(i.getId());
                        if (name == null) continue;
                        ings.add(name[0] + ": " + i.getAmount() + " " + name[1]);
                    }
                }
                hashMap.put("#ingredients", ings);
                hashMap.put("#toppings", this.toppings);
                cs.init(ScreenHelper.processBack((ScreenDescription)sd, (boolean)true, (this.parent != null ? 1 : 0) != 0), InitModuleHelper.buildScreenInit(this.environment, hashMap));
                cs.setListener((ScreenListener)new LocalSelectSugarListener(drink));
                this.context.showScreen(new ContentScreenAdapter(cs));
                this.currentScreen = cs;
                MediaPlayer.getInstance().play("select_sugar.mp3");
            }
            catch (InitException ex) {
                this.log.info((Object)ex, (Throwable)ex);
            }
        } else {
            this.showError(B.get((String)"Module.input.coffee.products.notset", (Locale)this.locale));
        }
    }

    public void toPreparePayments(Drink drink) {
        Double paySum;
        this.log.info((Object)"Prepare payment");
        SumScreenDescription ssd = new SumScreenDescription();
        ssd.setType("sum-coffee");
        HashMap<String, Object> data = new HashMap<String, Object>();
        this.log.info((Object)("Redirect data: " + this.environment.getInitData()));
        if (this.environment.getInitData() != null) {
            ModuleHelper.fillStore(this.environment.getInitData(), data);
        }
        if (this.currentMenuItem != null) {
            data.put("id1", new InputElement("id1", B.get((String)"Module.input.coffee.drink.name", (Locale)this.locale), Integer.toString(drink.getId())));
        } else {
            data.put("id1", new InputElement("id1", B.get((String)"Module.input.coffee.drink.name", (Locale)this.locale), drink.getNameDrink()));
        }
        data.put("id2", new InputElement("id2", B.get((String)"Module.input.coffee.drink.cost", (Locale)this.locale), Double.toString(drink.getCost() + (double)this.toppings.get(drink.getAddToppingNo()).getCost())));
        data.put("sugar", new InputElement("sugar", B.get((String)"Module.input.coffee.drink.sugar", (Locale)this.locale), Integer.toString(drink.getSugar())));
        data.put("topping", new InputElement("topping", B.get((String)"Module.input.coffee.drink.topping", (Locale)this.locale), "" + drink.getAddTopping()));
        data.put("#coffee.drink", drink);
        Sum operationSum = null;
        Object obj = data.get("#newsum");
        if (obj instanceof InputElement) {
            InputElement ie = (InputElement)obj;
            try {
                operationSum = new Sum(Integer.parseInt(ie.getValue()));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (operationSum == null && (paySum = Double.valueOf(drink.getCost() + (double)this.toppings.get(drink.getAddToppingNo()).getCost())) != null) {
            operationSum = new Sum(paySum.doubleValue());
        }
        if (this.currentMenuItem != null) {
            this._startPayment(this.environment, ssd, data, operationSum, this.currentMenuItem.getService(), this.currentMenuItem.getCommission());
        } else {
            this._startPayment(this.environment, ssd, data, operationSum, null, null);
        }
    }

    private void showError(Object object) {
        String message = null;
        String eventMessage = null;
        if (object == null) {
            message = B.get((String)"Module.input.coffee.message.error", (Locale)this.locale);
            eventMessage = message = B.get((String)"Module.input.coffee.message.error", (Locale)Locale.ENGLISH);
        }
        if (object instanceof Exception) {
            message = B.get((String)"Module.input.coffee.message.error.connection", (Locale)this.locale);
            eventMessage = B.get((String)"Module.input.coffee.message.error.connection", (Locale)Locale.ENGLISH);
        }
        if (object instanceof StatusCM) {
            StatusCM scm = (StatusCM)object;
            message = B.get((String)("Module.input.coffee.message.error.status." + scm.getStatusError()), (Locale)this.locale, (String)B.get((String)"Module.input.coffee.message.error.status", (Locale)this.locale));
            eventMessage = B.get((String)("Module.input.coffee.message.error.status." + scm.getStatusError()), (Locale)Locale.ENGLISH, (String)B.get((String)"Module.input.coffee.message.error.status", (Locale)Locale.ENGLISH));
            this.log.info((Object)scm.toString());
        }
        if (object instanceof String) {
            message = (String)object;
            eventMessage = (String)object;
        }
        ProblemNotifier.getDefaultNotifier().onProblem("" + eventMessage);
        this.log.info((Object)"Show  error screen");
        DialogScreen dialog = ComponentFactory.getInstance().createDialog(DialogType.Custom, message, 10, DC.cases((int)1), UserCase.Ok);
        dialog.addListener((DialogListener)new LocalExitDialogListener());
        this.context.showDialog((DialogInterface)dialog);
    }

    private class LocalStatusListener
    implements StatusActionListener {
        private LocalStatusListener() {
        }

        @Override
        public void onSuccess() {
            NtsCoffeeInputModule.this.coffeeContext.getTaskExecutor().execute(new GetDrinksTask());
        }

        @Override
        public void onError(Object object) {
            NtsCoffeeInputModule.this.showError(object);
        }
    }

    private class LocalExitDialogListener
    implements DialogListener {
        public void dialogClosed(UserCase userCase) {
            NtsCoffeeInputModule.this.cancel(null);
        }
    }

    private class GetToppingsTask
    implements Task {
        private final Drink drink;

        public GetToppingsTask(Drink drink) {
            this.drink = drink;
        }

        @Override
        public Object execute() {
            try {
                HashMap<Integer, Topping> tpgs = new HashMap<Integer, Topping>();
                for (int i = 1; i < 4; ++i) {
                    Topping object = CoffeeMachine.getDefaultInstance().getTopping(i);
                    NtsCoffeeInputModule.this.log.info((Object)("\u041f\u0440\u0438 \u0437\u0430\u043f\u0440\u043e\u0441\u0435 \u0442\u043e\u043f\u043f\u0438\u043d\u0433\u0430 " + i + " \u043f\u043e\u043b\u0443\u0447\u0435\u043d object = " + object));
                    if (object == null) continue;
                    if (object instanceof Topping) {
                        Topping t = object;
                        tpgs.put(i, t);
                    }
                    tpgs.put(0, new Topping());
                }
                return tpgs;
            }
            catch (Exception ex) {
                NtsCoffeeInputModule.this.log.error((Object)ex, (Throwable)ex);
                Exception object = ex;
                return ex;
            }
        }

        @Override
        public void onResult(Object object) {
            if (object != null) {
                if (object instanceof Exception) {
                    NtsCoffeeInputModule.this.showError(object);
                } else if (object instanceof Map) {
                    NtsCoffeeInputModule.this.toppings = (Map)object;
                    NtsCoffeeInputModule.this.toShowProductPage(this.drink);
                }
            }
        }

        @Override
        public String getMessage() {
            return B.get((String)"Module.input.coffee.products.request.wait", (Locale)NtsCoffeeInputModule.this.locale);
        }
    }

    private class GetDrinksTask
    implements Task {
        @Override
        public Object execute() {
            Serializable object;
            try {
                object = CoffeeMachine.getDefaultInstance().getDrinks();
            }
            catch (Exception ex) {
                NtsCoffeeInputModule.this.log.error((Object)ex, (Throwable)ex);
                object = ex;
            }
            return object;
        }

        @Override
        public void onResult(Object object) {
            NtsCoffeeInputModule.this.log.info((Object)("Recived answer: " + object));
            if (object != null) {
                if (object instanceof Exception) {
                    NtsCoffeeInputModule.this.showError(object);
                } else if (object instanceof Map) {
                    NtsCoffeeInputModule.this.drinks = (Map)object;
                    MenuByPropertyVisitor visitor = new MenuByPropertyVisitor("drink-id");
                    MenuUtils.processMenu((MenuVisitor)visitor);
                    NtsCoffeeInputModule.this.menuItems = visitor.getItems();
                    if (NtsCoffeeInputModule.this.drinks != null && !NtsCoffeeInputModule.this.menuItems.isEmpty()) {
                        Iterator iterator = NtsCoffeeInputModule.this.drinks.entrySet().iterator();
                        while (iterator.hasNext()) {
                            Map.Entry e = iterator.next();
                            if (e.getValue() == null) {
                                iterator.remove();
                                continue;
                            }
                            boolean found = false;
                            for (MenuItem mi : NtsCoffeeInputModule.this.menuItems) {
                                if (!Integer.toString(((Drink)e.getValue()).getId()).equals(mi.getService().getProperties().get("drink-id"))) continue;
                                found = true;
                                break;
                            }
                            if (found) continue;
                            iterator.remove();
                        }
                    }
                    NtsCoffeeInputModule.this.toShowShelfProducts();
                }
            }
        }

        @Override
        public String getMessage() {
            return B.get((String)"Module.input.coffee.products.request.wait", (Locale)NtsCoffeeInputModule.this.locale);
        }
    }

    private class NeedCupAsksAccessTask
    implements Task {
        private final Drink drink;

        public NeedCupAsksAccessTask(Drink drink) {
            this.drink = drink;
        }

        @Override
        public String getMessage() {
            return B.get((String)"Module.input.coffee.products.request.wait", (Locale)NtsCoffeeInputModule.this.locale);
        }

        @Override
        public Object execute() {
            Serializable object;
            try {
                boolean needCupAsks = CoffeeMachine.getDefaultInstance().isNeedCupAsks();
                NtsCoffeeInputModule.this.log.info((Object)("show cup asking dialog: " + needCupAsks));
                object = Boolean.valueOf(needCupAsks);
            }
            catch (Exception ex) {
                NtsCoffeeInputModule.this.log.error((Object)ex, (Throwable)ex);
                object = ex;
            }
            return object;
        }

        @Override
        public void onResult(Object object) {
            if (((Boolean)object).booleanValue()) {
                DialogScreen dialog = ComponentFactory.getInstance().createDialog(DialogType.Custom, B.get((String)"Module.input.coffee.dialog.cup", (Locale)NtsCoffeeInputModule.this.locale), 15, DC.cases((int)24, (Locale)NtsCoffeeInputModule.this.locale, (Object[])new Object[0]), UserCase.Ok);
                dialog.addListener(new DialogListener(){

                    public void dialogClosed(UserCase userCase) {
                        NtsCoffeeInputModule.this.log.info((Object)("\u041f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u044c \u0432\u044b\u0431\u0440\u0430\u043b " + userCase));
                        if (userCase == UserCase.Ok) {
                            NeedCupAsksAccessTask.this.drink.setNeedCup(true);
                        } else {
                            NeedCupAsksAccessTask.this.drink.setNeedCup(false);
                        }
                        NtsCoffeeInputModule.this.toPreparePayments(NeedCupAsksAccessTask.this.drink);
                    }
                });
                NtsCoffeeInputModule.this.context.showDialog((DialogInterface)dialog);
            } else {
                this.drink.setNeedCup(true);
                NtsCoffeeInputModule.this.toPreparePayments(this.drink);
            }
        }
    }

    private class LocalSelectSugarListener
    extends ScreenAdapter {
        private final Drink drink;

        private LocalSelectSugarListener(Drink drink) {
            this.drink = drink;
        }

        public void onAction(String action, Map<String, Object> data, Runnable cancelListener) {
            NtsCoffeeInputModule.this.cancelListener = cancelListener;
            NtsCoffeeInputModule.this.log.info((Object)("Selector action: action = " + action + ", data = " + data));
            NtsCoffeeInputModule.this.log.info((Object)("Data: " + data));
            NtsCoffeeInputModule.this.data.putAll(data);
            if (ActionType.isPrev((String)action)) {
                NtsCoffeeInputModule.this.toShowShelfProducts();
            } else if (ActionType.isExit((String)action)) {
                NtsCoffeeInputModule.this.cancel(null);
            } else if (ActionType.isNext((String)action) && this.drink != null) {
                InputElement inputElement = (InputElement)data.get("sugar");
                int amountSugar = Integer.parseInt(inputElement.getValue());
                this.drink.setSugar(amountSugar);
                if (this.drink.getToppingNoByRecipe() != 0) {
                    inputElement = (InputElement)data.get(NtsCoffeeInputModule.TOPPING_NO);
                    int toppingNo = Integer.parseInt(inputElement.getValue());
                    this.drink.setAddToppingNo(toppingNo);
                    this.drink.setAddTopping((Topping)NtsCoffeeInputModule.this.toppings.get(toppingNo));
                }
                NtsCoffeeInputModule.this.coffeeContext.getTaskExecutor().execute(new NeedCupAsksAccessTask(this.drink));
            }
        }

        public void onLocale(Locale locale) {
            if (NtsCoffeeInputModule.this.environment != null) {
                NtsCoffeeInputModule.this.environment.setLocale(locale);
            }
        }
    }

    private class LocalSelectProductListener
    extends ScreenAdapter {
        private LocalSelectProductListener() {
        }

        public final void onAction(String action, Map<String, Object> data, final Runnable cancelListener) {
            NtsCoffeeInputModule.this.cancelListener = cancelListener;
            NtsCoffeeInputModule.this.log.info((Object)("Selector action: action = " + action));
            NtsCoffeeInputModule.this.log.info((Object)("Data: " + data));
            if (ActionType.isPrev((String)action) || ActionType.isExit((String)action)) {
                NtsCoffeeInputModule.this.cancel(null);
            } else if (ActionType.isNext((String)action)) {
                Drink drink = (Drink)data.get("#coffee.drink");
                if (drink.isAvailable()) {
                    NtsCoffeeInputModule.this.coffeeContext.getTaskExecutor().execute(new GetToppingsTask(drink));
                } else {
                    NtsCoffeeInputModule.this.log.info((Object)"Show warning screen.");
                    NtsCoffeeInputModule.this.log.info((Object)("" + drink.getNameDrink() + " is not available for prepare"));
                    DialogScreen dialog = ComponentFactory.getInstance().createDialog(DialogType.Custom, B.get((String)"Module.input.coffee.drink.available.false", (Locale)NtsCoffeeInputModule.this.locale), 3, DC.cases((int)8, (Locale)NtsCoffeeInputModule.this.locale, (Object[])new Object[0]), UserCase.Ok);
                    dialog.addListener(new DialogListener(){

                        public void dialogClosed(UserCase userCase) {
                            ModuleHelper.invoke(cancelListener);
                        }
                    });
                    NtsCoffeeInputModule.this.context.showDialog((DialogInterface)dialog);
                }
            }
        }

        public void onLocale(Locale locale) {
            if (NtsCoffeeInputModule.this.environment != null) {
                NtsCoffeeInputModule.this.environment.setLocale(locale);
            }
        }
    }
}

