/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.module.input.mobile;

import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;
import ru.softlogic.gui.utils.menu.MenuUtils;
import ru.softlogic.gui.utils.menu.MenuVisitor;
import ru.softlogic.gui.utils.menu.SearchMobileVisitor;
import ru.softlogic.input.model.screen.ExtraButton;
import ru.softlogic.module.input.mobile.Capacity;
import ru.softlogic.module.input.mobile.CapacityElement;
import ru.softlogic.module.input.mobile.CapacityUpdater;
import ru.softlogic.module.input.mobile.MobileDefectorsManager;
import ru.softlogic.provider.ProviderType;
import ru.softlogic.system.util.PathUtils;

public class FederalNumberValidator {
    private Capacity capacity;
    private Map<Integer, ExtraButton> extraButtons;
    private static FederalNumberValidator instance = new FederalNumberValidator();
    private Logger log = Logger.getLogger((String)"pay");

    private FederalNumberValidator() {
        Thread thread = new Thread(new CapacityUpdaterRunnable());
        thread.setDaemon(true);
        thread.start();
    }

    public static FederalNumberValidator getInstance() {
        return instance;
    }

    public Integer getProvider(String number) {
        if (this.capacity == null || this.capacity.getElements() == null) {
            return null;
        }
        if (number == null || number.length() != this.capacity.getNumberLenght()) {
            return null;
        }
        SearchMobileVisitor smv = new SearchMobileVisitor(ProviderType.Mobile);
        MenuUtils.processMenu((MenuVisitor)smv);
        Set services = smv.getCandidates();
        Integer prov = MobileDefectorsManager.getInstance().findDefector(number);
        if (prov != null && services.contains(prov)) {
            return prov;
        }
        for (CapacityElement el : this.capacity.getElements()) {
            if (!services.contains(el.getService()) || !el.includeRange(number, number)) continue;
            return el.getService();
        }
        return null;
    }

    public Map<Integer, ExtraButton> getExtraButtons() {
        return this.extraButtons;
    }

    private class CapacityUpdaterRunnable
    implements Runnable {
        private CapacityUpdaterRunnable() {
        }

        @Override
        public void run() {
            FederalNumberValidator.this.log.info((Object)"Try to load number capacities");
            CapacityUpdater updater = new CapacityUpdater(PathUtils.getAppHome() + "/capacity.xml");
            updater.read();
            FederalNumberValidator.this.extraButtons = updater.getExtraButtons();
            FederalNumberValidator.this.capacity = new Capacity();
            FederalNumberValidator.this.capacity.setElements(updater.getElements());
            FederalNumberValidator.this.capacity.setNumberLenght(updater.getNumberLenght() == null ? 10 : updater.getNumberLenght());
            FederalNumberValidator.this.log.info((Object)"Load success");
        }
    }
}

