/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.module.input.ecards;

import i18n.B;
import java.awt.EventQueue;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Locale;
import java.util.Map;
import ru.softlogic.app.context.ApplicationContext;
import ru.softlogic.application.ContentScreenAdapter;
import ru.softlogic.application.ContentScreenAdapterKbr;
import ru.softlogic.application.ExtKeyboardAdapter;
import ru.softlogic.application.tmm.Tmm;
import ru.softlogic.cash.Sum;
import ru.softlogic.ecard.AnswerListener;
import ru.softlogic.ecard.TPOListener;
import ru.softlogic.ecard.TransportModule;
import ru.softlogic.ecard.model.AmountParameter;
import ru.softlogic.ecard.model.BooleanParameter;
import ru.softlogic.ecard.model.CompoundParameter;
import ru.softlogic.ecard.model.DateTimeParameter;
import ru.softlogic.ecard.model.Detail;
import ru.softlogic.ecard.model.Display;
import ru.softlogic.ecard.model.NumericParameter;
import ru.softlogic.ecard.model.SubParameter;
import ru.softlogic.gui.factory.ComponentFactory;
import ru.softlogic.gui.screen.popup.dialog.DC;
import ru.softlogic.gui.screen.popup.dialog.DialogInterface;
import ru.softlogic.gui.screen.popup.dialog.DialogListener;
import ru.softlogic.gui.screen.popup.dialog.DialogScreen;
import ru.softlogic.gui.screen.popup.dialog.DialogType;
import ru.softlogic.gui.screen.popup.dialog.UserCase;
import ru.softlogic.gui.screen.popup.wait.WaitScreen;
import ru.softlogic.gui.useraction.UserAction;
import ru.softlogic.gui2.screen.ActionType;
import ru.softlogic.gui2.screen.CommonScreen;
import ru.softlogic.gui2.screen.CommonScreenStore;
import ru.softlogic.gui2.screen.ScreenAdapter;
import ru.softlogic.gui2.screen.ScreenListener;
import ru.softlogic.hdw.dev.keyboard.ExtKeyboard;
import ru.softlogic.hdw.dev.keyboard.ExtKeyboardKeyListener;
import ru.softlogic.input.model.Data;
import ru.softlogic.input.model.InputElement;
import ru.softlogic.input.model.TransactionSum;
import ru.softlogic.input.model.field.FieldSequence;
import ru.softlogic.input.model.field.InitException;
import ru.softlogic.input.model.field.numeric.NumericField;
import ru.softlogic.input.model.field.numeric.Range;
import ru.softlogic.input.model.field.selector.ItemsStore;
import ru.softlogic.input.model.field.selector.SelectorField;
import ru.softlogic.input.model.field.selector.SelectorItem;
import ru.softlogic.input.model.field.selector.StaticStore;
import ru.softlogic.input.model.field.text.Keyboard;
import ru.softlogic.input.model.field.text.KeyboardType;
import ru.softlogic.input.model.field.text.NumericRangeValidator;
import ru.softlogic.input.model.field.text.Validator;
import ru.softlogic.input.model.screen.description.InfoScreenDescription;
import ru.softlogic.input.model.screen.description.ScreenDescription;
import ru.softlogic.input.model.screen.description.SumScreenDescription;
import ru.softlogic.intent.Intent;
import ru.softlogic.module.Restorable;
import ru.softlogic.module.input.BaseInputModule;
import ru.softlogic.module.input.DescriptionException;
import ru.softlogic.module.input.Environment;
import ru.softlogic.module.input.InitModuleHelper;
import ru.softlogic.module.input.ModuleInitException;
import ru.softlogic.module.payment.ECardsPaymentModule;
import ru.softlogic.module.processing.ECardsProcessingModule;
import ru.softlogic.module.utils.ExitDialogListener;

public class ECardsInputModule
extends BaseInputModule {
    private Environment environment;
    private WaitScreen waitScreen;
    private TransportModule tm = Tmm.getInstance();
    private String seriaCard;
    private String numberCard;

    public ECardsInputModule(ApplicationContext context) {
        super(context);
        this.waitScreen = ComponentFactory.getInstance().createWaitScreen("");
    }

    @Override
    protected void _start(Environment environment, Restorable parent) throws DescriptionException, ModuleInitException {
        this.environment = environment;
        this.waitScreen.setText("\u041e\u0436\u0438\u0434\u0430\u0439\u0442\u0435, \u0438\u0434\u0435\u0442 \u0432\u044b\u043f\u043e\u043b\u043d\u0435\u043d\u0438\u0435 \u043e\u043f\u0435\u0440\u0430\u0446\u0438\u0438");
        this.context.showWait(this.waitScreen);
        if (this.tm != null) {
            this.tm.start((TPOListener)new LocalTPOListener());
        } else {
            this.log.info((Object)"Transport module is not present, show error");
            DialogScreen dialog = ComponentFactory.getInstance().createDialog(DialogType.Error, B.get((String)"Provider.ecard.nocm", (Locale)environment.getLocale()), 10, DC.cases((int)8, (Locale)environment.getLocale(), (Object[])new Object[0]), UserCase.Ok);
            dialog.addListener((DialogListener)new ExitDialogListener(this));
            this.context.showDialog((DialogInterface)dialog);
        }
    }

    @Override
    protected void _restore() {
    }

    @Override
    public void cancel(Intent intent) {
        super.cancel(intent);
    }

    private String inforRendering(Display display) {
        String result = "<html>";
        this.log.debug((Object)display);
        if (display != null) {
            if (display.getTransportCardType() != null) {
                result = result + display.getTransportCardType().getFullStringValue() + " (" + display.getTransportCardType().getCodeStringValue() + ")<br>";
            }
            result = result + "<br>";
            if (display.getBooleanParameter() != null) {
                for (BooleanParameter bp : display.getBooleanParameter()) {
                    result = result + bp.getStringValue() + " " + (Boolean.parseBoolean(bp.getValue()) ? "\u0434\u0430" : "\u043d\u0435\u0442") + "<br>";
                }
            }
            result = result + "<br>";
            if (display.getNumericParameter() != null) {
                for (NumericParameter np : display.getNumericParameter()) {
                    result = result + np.getName() + " " + np.getValue() + "<br>";
                    if ("Series".equals(np.getType())) {
                        this.seriaCard = np.getValue();
                        continue;
                    }
                    if (!"Systematic".equals(np.getType())) continue;
                    this.numberCard = np.getValue();
                }
            }
            result = result + "<br>";
            if (display.getCompoundParameter() != null) {
                for (CompoundParameter cp : display.getCompoundParameter()) {
                    result = result + cp.getName() + "<br>";
                    if (cp.getSubParameter() == null) continue;
                    for (SubParameter sp : cp.getSubParameter()) {
                        result = result + sp.getName() + "<br>";
                    }
                }
            }
            result = result + "<br>";
            if (display.getAmountParameter() != null) {
                for (AmountParameter ap : display.getAmountParameter()) {
                    result = result + ap.getName() + " " + ap.getValue() + "<br>";
                }
            }
            result = result + "<br>";
            if (display.getDiscountPercent() != null) {
                result = result + display.getDiscountPercent().getName() + " " + display.getDiscountPercent().getValue() + "<br>";
            }
            result = result + "<br>";
            if (display.getDateTimeParameter() != null) {
                for (DateTimeParameter dtp : display.getDateTimeParameter()) {
                    result = result + dtp.getName() + " " + dtp.getDay() + "." + dtp.getMonth() + "." + dtp.getYear() + "<br>";
                }
            }
        }
        return result;
    }

    private void toShowPaymentScreen(Detail detail, AnswerListener al, Sum oper) {
        if (detail != null && detail.getDisplay() != null) {
            this.log.info((Object)(">>>go to payment module with detail:" + detail));
            SumScreenDescription ssd = new SumScreenDescription();
            ssd.setType("sum");
            HashMap<String, Object> data = new HashMap<String, Object>();
            data.put("id1", new InputElement("id1", "\u041d\u043e\u043c\u0435\u0440 \u043a\u0430\u0440\u0442\u044b", this.seriaCard + " " + this.numberCard));
            this.environment.setPaymentModule(new ECardsPaymentModule((ApplicationContext)this.context, al));
            this.environment.setProcessingModule(new ECardsProcessingModule((ApplicationContext)this.context, al));
            this._startPayment(this.environment, ssd, data, oper, null, null);
        }
    }

    private class LocalInputNominalListener
    extends ScreenAdapter {
        private Detail detail;
        private AnswerListener al;

        public LocalInputNominalListener(Detail detail, AnswerListener al) {
            this.detail = detail;
            this.al = al;
        }

        public void onAction(String action, Map<String, Object> data, Runnable cancelListener) {
            ECardsInputModule.this.log.info((Object)("Digital action: action = " + action));
            ECardsInputModule.this.log.info((Object)("Data: " + data));
            if (ActionType.isPrev((String)action) || ActionType.isExit((String)action)) {
                ECardsInputModule.this.log.info((Object)"Cancel card module operation");
                this.al.onAction("Cancel");
                ECardsInputModule.this.cancel(null);
            } else if (ActionType.isNext((String)action)) {
                Sum nominal = new Sum(Double.parseDouble(((InputElement)data.get("nominal")).getValue()));
                ECardsInputModule.this.log.debug((Object)("entered nominal=" + nominal));
                ECardsInputModule.this.toShowPaymentScreen(this.detail, this.al, nominal);
            }
        }

        public void onLocale(Locale locale) {
            if (ECardsInputModule.this.environment != null) {
                ECardsInputModule.this.environment.setLocale(locale);
            }
        }
    }

    private class LocalSelectNominalListener
    extends ScreenAdapter {
        private Detail detail;
        private AnswerListener al;

        public LocalSelectNominalListener(Detail detail, AnswerListener al) {
            this.detail = detail;
            this.al = al;
        }

        public void onAction(String action, Map<String, Object> data, Runnable cancelListener) {
            ECardsInputModule.this.log.info((Object)("Selector action: action = " + action));
            ECardsInputModule.this.log.info((Object)("Data: " + data));
            if (ActionType.isPrev((String)action) || ActionType.isExit((String)action)) {
                ECardsInputModule.this.log.info((Object)"Cancel card module operation");
                this.al.onAction("Cancel");
                ECardsInputModule.this.cancel(null);
            } else if (ActionType.isNext((String)action)) {
                Sum nominal = (Sum)data.get("#ecard.nominal");
                ECardsInputModule.this.log.debug((Object)("selected nominal=" + nominal));
                ECardsInputModule.this.toShowPaymentScreen(this.detail, this.al, nominal);
            }
        }

        public void onLocale(Locale locale) {
            if (ECardsInputModule.this.environment != null) {
                ECardsInputModule.this.environment.setLocale(locale);
            }
        }
    }

    private class LocalInputModuleListener
    extends ScreenAdapter {
        private AnswerListener al;

        public LocalInputModuleListener(AnswerListener al) {
            this.al = al;
        }

        public void onAction(String action, Map<String, Object> data, Runnable cancelListener) {
            ECardsInputModule.this.log.info((Object)("Action on wait screen: " + action));
            UserAction.getInstance().update();
            if (!ActionType.isNext((String)action)) {
                ECardsInputModule.this.log.info((Object)"Cancel card module operation");
                this.al.onAction("Cancel");
                ECardsInputModule.this.cancel(null);
            } else {
                ECardsInputModule.this.log.info((Object)"Send netx action to tmm");
                this.al.onAction("Enter");
            }
        }
    }

    private class LocalTPOListener
    implements TPOListener {
        private LocalTPOListener() {
        }

        public void onEvent(int event, Detail detail, AnswerListener al) {
            ECardsInputModule.this.log.info((Object)("Event from transport module: event =" + event + " detail:" + detail));
            switch (event) {
                case 1: {
                    UserAction.getInstance().update();
                    ECardsInputModule.this.log.info((Object)">>>PRESENT_CARD_SCREEN");
                    ECardsInputModule.this.context.showWait(null);
                    CommonScreen cs = CommonScreenStore.getScreen((String)"card/info");
                    cs.setListener((ScreenListener)new LocalInputModuleListener(al));
                    try {
                        InfoScreenDescription isd = new InfoScreenDescription("info");
                        isd.setTitle(B.get((String)"Provider.ecard.require.title", (Locale)ECardsInputModule.this.environment.getLocale()));
                        isd.setInfo(B.get((String)"Provider.ecard.require.text", (Locale)ECardsInputModule.this.environment.getLocale()));
                        isd.setButtons(null);
                        cs.init((ScreenDescription)isd, InitModuleHelper.buildScreenInit(ECardsInputModule.this.environment, new HashMap<String, Object>()));
                        ECardsInputModule.this.context.showScreen(new ContentScreenAdapter(cs));
                    }
                    catch (InitException ex) {
                        ECardsInputModule.this.log.error((Object)ex, (Throwable)ex);
                    }
                    break;
                }
                case 2: {
                    ECardsInputModule.this.log.info((Object)">>>SHOW_CARD_INFO_SCREEN");
                    try {
                        CommonScreen cs = CommonScreenStore.getScreen((String)"info");
                        ExtKeyboard.getInstance().getFocus((ExtKeyboardKeyListener)new ExtKeyboardAdapter(cs.getKeyboardListener()));
                        cs.setListener((ScreenListener)new LocalInputModuleListener(al));
                        InfoScreenDescription isd = new InfoScreenDescription("info");
                        isd.setTitle(B.get((String)"Provider.ecard.confirm.title", (Locale)ECardsInputModule.this.environment.getLocale()));
                        if (detail != null) {
                            isd.setInfo(ECardsInputModule.this.inforRendering(detail.getDisplay()));
                            ECardsInputModule.this.log.debug((Object)isd.getInfo());
                        }
                        isd.setButtons(null);
                        cs.init((ScreenDescription)isd, InitModuleHelper.buildScreenInit(ECardsInputModule.this.environment, new HashMap<String, Object>()));
                        ECardsInputModule.this.context.showScreen(new ContentScreenAdapterKbr(cs));
                    }
                    catch (InitException ex) {
                        ECardsInputModule.this.log.info((Object)ex, (Throwable)ex);
                    }
                    break;
                }
                case 3: {
                    double minSum = 0.0;
                    double maxSum = 0.0;
                    double stepSum = 0.0;
                    double servMinSum = ECardsInputModule.this.environment.getMenuItem().getService().getMinSum().getSum();
                    double servMaxSum = ECardsInputModule.this.environment.getMenuItem().getService().getMaxSum().getSum();
                    if (detail.getDisplay().getAmountParameter() != null) {
                        for (AmountParameter param : detail.getDisplay().getAmountParameter()) {
                            if ("MinAmount".equals(param.getType().replace(",", "."))) {
                                minSum = Double.parseDouble(param.getValue());
                                continue;
                            }
                            if ("MaxAmount".equals(param.getType().replace(",", "."))) {
                                maxSum = Double.parseDouble(param.getValue());
                                continue;
                            }
                            if (!"StepAmount".equals(param.getType().replace(",", "."))) continue;
                            stepSum = Double.parseDouble(param.getValue());
                        }
                    }
                    if (minSum < servMinSum) {
                        minSum = servMinSum;
                    }
                    if (maxSum > servMaxSum) {
                        maxSum = servMaxSum;
                    }
                    if (stepSum == 0.0 && minSum != maxSum) {
                        ECardsInputModule.this.log.info((Object)">>>SHOW_SELECT_NOMINAL_SCREEN");
                        ScreenDescription sd = this.createSd(ECardsInputModule.this.environment.getLocale(), new Range((float)minSum, (float)maxSum));
                        CommonScreen cs = CommonScreenStore.getScreen((String)"digital");
                        try {
                            cs.init(sd, InitModuleHelper.buildScreenInit(ECardsInputModule.this.environment, new HashMap<String, Object>()));
                            cs.setListener((ScreenListener)new LocalInputNominalListener(detail, al));
                            ECardsInputModule.this.context.showScreen(new ContentScreenAdapter(cs));
                        }
                        catch (InitException ex) {
                            ECardsInputModule.this.log.info((Object)ex, (Throwable)ex);
                        }
                        break;
                    }
                    ECardsInputModule.this.log.info((Object)">>>SHOW_SELECT_NOMINAL_SCREEN");
                    LinkedList<SelectorItem> items = new LinkedList<SelectorItem>();
                    if (stepSum != 0.0) {
                        for (double nom = stepSum; nom < stepSum * 10.0 && !(nom > maxSum); nom += stepSum) {
                            if (nom < minSum) continue;
                            Sum nominal = new Sum(nom);
                            SelectorItem si = new SelectorItem(nominal.toString(), Double.toString(nom));
                            HashMap<String, Sum> data = new HashMap<String, Sum>();
                            data.put("#ecard.nominal", nominal);
                            si.setCustomData(data);
                            Data d = new Data();
                            d.setSum(new TransactionSum((float)nom));
                            si.setData(d);
                            items.add(si);
                        }
                    } else {
                        Sum nominal = new Sum(minSum);
                        SelectorItem si = new SelectorItem(nominal.toString(), Double.toString(minSum));
                        HashMap<String, Sum> data = new HashMap<String, Sum>();
                        data.put("#ecard.nominal", nominal);
                        si.setCustomData(data);
                        Data d = new Data();
                        d.setSum(new TransactionSum((float)minSum));
                        si.setData(d);
                        items.add(si);
                    }
                    SelectorField sf = new SelectorField();
                    sf.setStore((ItemsStore)new StaticStore(items));
                    LinkedList<SelectorField> fields = new LinkedList<SelectorField>();
                    fields.add(sf);
                    ScreenDescription sd = new ScreenDescription("selector");
                    sd.setTitle(B.get((String)"Module.input.ecard.select-nominal.title", (Locale)ECardsInputModule.this.environment.getLocale()));
                    sd.setSequence(new FieldSequence(fields));
                    sd.setButtons(InitModuleHelper.createKeyMap());
                    CommonScreen cs = CommonScreenStore.getScreen((String)sd.getType());
                    try {
                        cs.init(sd, InitModuleHelper.buildScreenInit(ECardsInputModule.this.environment, new HashMap<String, Object>()));
                        cs.setListener((ScreenListener)new LocalSelectNominalListener(detail, al));
                        ECardsInputModule.this.context.showScreen(new ContentScreenAdapter(cs));
                        break;
                    }
                    catch (InitException ex) {
                        ECardsInputModule.this.log.info((Object)ex, (Throwable)ex);
                    }
                }
            }
        }

        private ScreenDescription createSd(Locale locale, Range range) {
            ScreenDescription sd = new ScreenDescription("digital");
            sd.setDecor("info");
            sd.setTitle(B.get((String)"Module.payment.ecard.enter-nominal.message", (Locale)locale));
            sd.setButtons(null);
            NumericField nf = new NumericField();
            nf.setId("nominal");
            nf.setUnitCount(5);
            nf.setDecimalCount(2);
            nf.setHelp("\u041c\u0438\u043d\u0438\u043c\u0430\u043b\u044c\u043d\u0430\u044f \u0441\u0443\u043c\u043c\u0430: " + new Sum((double)range.getBegin()) + "<br>\u041c\u0430\u043a\u0441\u0438\u043c\u0430\u043b\u044c\u043d\u0430\u044f \u0441\u0443\u043c\u043c\u0430: " + new Sum((double)range.getEnd()));
            nf.setKeyboard(new Keyboard(KeyboardType.Digital, Character.valueOf('.')));
            nf.setValidator((Validator)new NumericRangeValidator(Arrays.asList(range)));
            sd.setSequence(new FieldSequence(Arrays.asList(nf)));
            return sd;
        }

        public void onError(long code, final String message) {
            ECardsInputModule.this.log.info((Object)("Error from transport module: code =" + code + " message:" + message));
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    DialogScreen dialog = ComponentFactory.getInstance().createDialog(DialogType.Error, message, 10, DC.cases((int)8, (Locale)ECardsInputModule.this.environment.getLocale(), (Object[])new Object[0]), UserCase.Ok);
                    dialog.addListener((DialogListener)new ExitDialogListener(ECardsInputModule.this));
                    ECardsInputModule.this.context.showDialog((DialogInterface)dialog);
                }
            });
        }

        public void onResult(Detail detail) {
            ECardsInputModule.this.log.info((Object)("Result from transport module: detail =" + detail));
            ECardsInputModule.this.cancel(null);
        }
    }
}

