/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.module.input.dynamic;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.apache.log4j.Logger;
import ru.softlogic.dynamic.input.model.field.CommonField;
import ru.softlogic.dynamic.input.model.field.Field;
import ru.softlogic.dynamic.input.model.field.FieldType;
import ru.softlogic.dynamic.input.model.field.impl.NumericField;
import ru.softlogic.dynamic.input.model.field.impl.SelectorElement;
import ru.softlogic.dynamic.input.model.field.impl.SelectorField;
import ru.softlogic.dynamic.input.model.field.impl.TextField;
import ru.softlogic.dynamic.input.model.screen.Screen;
import ru.softlogic.input.model.field.FieldSequence;
import ru.softlogic.input.model.field.IdentityField;
import ru.softlogic.input.model.field.numeric.Range;
import ru.softlogic.input.model.field.selector.ItemsStore;
import ru.softlogic.input.model.field.selector.SelectorItem;
import ru.softlogic.input.model.field.selector.StaticStore;
import ru.softlogic.input.model.field.text.Filter;
import ru.softlogic.input.model.field.text.Keyboard;
import ru.softlogic.input.model.field.text.KeyboardCase;
import ru.softlogic.input.model.field.text.KeyboardType;
import ru.softlogic.input.model.field.text.Modificator;
import ru.softlogic.input.model.field.text.NumericRangeValidator;
import ru.softlogic.input.model.field.text.RegexValidator;
import ru.softlogic.input.model.field.text.Validator;
import ru.softlogic.input.model.field.text.VoidFilter;
import ru.softlogic.input.model.field.text.VoidModificator;
import ru.softlogic.input.model.screen.ButtonInit;
import ru.softlogic.input.model.screen.description.ScreenDescription;
import ru.softlogic.input.model.screen.description.UniScreenDescription;
import ru.softlogic.module.input.dynamic.ScreenStatus;

public class DFHelper {
    private static Logger log = Logger.getLogger((String)"pay");

    public static List<ScreenStatus> convert(Screen screen) {
        log.info((Object)("Convert screen: " + screen));
        LinkedList<ScreenStatus> list = new LinkedList<ScreenStatus>();
        if (screen.getFieldBar() != null && screen.getFieldBar().getFields() != null) {
            boolean hasError = false;
            for (Field f : screen.getFieldBar().getFields()) {
                CommonField cf;
                if (!(f instanceof CommonField) || (cf = (CommonField)f).getErrorMessage() == null || cf.getErrorMessage().trim().isEmpty()) continue;
                hasError = true;
                break;
            }
            HashMap<String, ButtonInit> buttons = new HashMap<String, ButtonInit>();
            if (screen.getActionBar() != null) {
                if (screen.getActionBar().hasNext() || screen.getActionBar().hasNext()) {
                    buttons.put("Next", new ButtonInit(null));
                }
                if (screen.getActionBar().hasPrev()) {
                    buttons.put("Prev", new ButtonInit(null));
                }
                buttons.put("Exit", new ButtonInit(null));
            }
            UniScreenDescription sd = new UniScreenDescription();
            sd.setButtons(buttons);
            sd.setTitle(screen.getTitle());
            sd.setSubtitle(screen.getSubtitle());
            LinkedList<IdentityField> fs = new LinkedList<IdentityField>();
            ScreenStatus ss = new ScreenStatus((ScreenDescription)sd, null);
            for (Field f : screen.getFieldBar().getFields()) {
                if (!(f instanceof CommonField)) continue;
                CommonField cf = (CommonField)f;
                if (!hasError || hasError && cf.getErrorMessage() != null && !cf.getErrorMessage().trim().isEmpty()) {
                    if (f.getType() == FieldType.TEXT) {
                        fs.add(DFHelper.getTextField((TextField)f, (ScreenDescription)sd));
                    } else if (f.getType() == FieldType.NUMERIC) {
                        fs.add(DFHelper.getNumericField((NumericField)f, (ScreenDescription)sd));
                    } else if (f.getType() == FieldType.SELECTOR) {
                        fs.add(DFHelper.getSelectorField((SelectorField)f, (ScreenDescription)sd));
                    } else {
                        log.debug((Object)"FieldType unknown");
                    }
                }
                if (ss.getMessage() != null) continue;
                ss.setMessage(cf.getErrorMessage());
            }
            sd.setSequence(new FieldSequence(fs));
            list.add(ss);
        }
        return list;
    }

    private static IdentityField getTextField(TextField val, ScreenDescription sd) {
        String title = val.getTitle();
        if (title != null) {
            title = title.replace(":", "");
        }
        if (sd.getTitle() == null) {
            sd.setTitle(title);
        }
        ru.softlogic.input.model.field.text.TextField tf = new ru.softlogic.input.model.field.text.TextField();
        tf.setId(val.getCode());
        tf.setTitle(title);
        tf.setPrefix(val.getPrefix());
        tf.setPostfix(val.getPostfix());
        tf.setErrorMessage(val.getErrorMessage());
        tf.setMaxLength(val.getMaxLength() == null ? 40 : val.getMaxLength());
        tf.setExampleValue(val.getInfo().getExample());
        tf.setHelp(val.getInfo().getHelp() == null || val.getInfo().getHelp().isEmpty() ? val.getInfo().getHint() : val.getInfo().getHelp());
        tf.setReadOnly(val.getState().isReadonly());
        tf.setValidator((Validator)new RegexValidator(Collections.singletonList(val.getRegex() == null || val.getRegex().trim().isEmpty() ? "^.*$" : val.getRegex()), null));
        tf.setKeyboard(new Keyboard(KeyboardType.Any, Arrays.asList("ru", "en", "symb"), KeyboardCase.Upper, true, null));
        tf.setDefaultValue((String)val.getValue());
        return tf;
    }

    private static IdentityField getNumericField(NumericField val, ScreenDescription sd) {
        String title = val.getTitle();
        if (title != null) {
            title = title.replace(":", "");
        }
        if (sd.getTitle() == null) {
            sd.setTitle(title);
        }
        ru.softlogic.input.model.field.numeric.NumericField nf = new ru.softlogic.input.model.field.numeric.NumericField();
        nf.setId(val.getCode());
        nf.setTitle(title);
        nf.setUnitCount(5);
        nf.setDecimalCount(2);
        nf.setDefaultValue((String)val.getValue());
        nf.setKeyboard(new Keyboard(KeyboardType.Digital, null));
        nf.setModificator((Modificator)new VoidModificator());
        nf.setHelp(val.getInfo().getHelp() == null || val.getInfo().getHelp().isEmpty() ? val.getInfo().getHint() : val.getInfo().getHelp());
        LinkedList<Range> ranges = new LinkedList<Range>();
        ranges.add(new Range(val.getMin() == null ? 0.0f : (float)val.getMin().intValue(), val.getMax() == null ? 15000.0f : (float)val.getMax().intValue()));
        nf.setValidator((Validator)new NumericRangeValidator(ranges));
        nf.setFilter((Filter)new VoidFilter());
        return nf;
    }

    private static IdentityField getSelectorField(SelectorField val, ScreenDescription sd) {
        String title = val.getTitle();
        if (title != null) {
            title = title.replace(":", "");
        }
        if (sd.getTitle() == null) {
            sd.setTitle(title);
        }
        ru.softlogic.input.model.field.selector.SelectorField sf = new ru.softlogic.input.model.field.selector.SelectorField();
        sf.setId(val.getCode());
        sf.setTitle(title);
        LinkedList<SelectorItem> items = new LinkedList<SelectorItem>();
        for (SelectorElement el : val.getElements()) {
            SelectorItem si = new SelectorItem(el.getTitle(), el.getValue());
            items.add(si);
        }
        StaticStore ss = new StaticStore(items);
        sf.setStore((ItemsStore)ss);
        sf.setHelp(val.getInfo().getHelp() == null || val.getInfo().getHelp().isEmpty() ? val.getInfo().getHint() : val.getInfo().getHelp());
        return sf;
    }

    public static Set<String> getSumFields(Screen screen) {
        if (screen == null) {
            return null;
        }
        HashSet<String> s = new HashSet<String>();
        if (screen.getFieldBar() != null && screen.getFieldBar().getFields() != null) {
            for (Field f : screen.getFieldBar().getFields()) {
                NumericField nf;
                if (!(f instanceof NumericField) || !(nf = (NumericField)f).isSumPurchase()) continue;
                s.add(nf.getCode());
            }
        }
        return s;
    }
}

