/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.module.input.chcopy;

import i18n.B;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import ru.softlogic.app.configuration.AppDefaults;
import ru.softlogic.app.context.ApplicationContext;
import ru.softlogic.application.ContentScreenAdapterKbr;
import ru.softlogic.gui.factory.ComponentFactory;
import ru.softlogic.gui.screen.popup.dialog.DC;
import ru.softlogic.gui.screen.popup.dialog.DialogInterface;
import ru.softlogic.gui.screen.popup.dialog.DialogListener;
import ru.softlogic.gui.screen.popup.dialog.DialogScreen;
import ru.softlogic.gui.screen.popup.dialog.DialogType;
import ru.softlogic.gui.screen.popup.dialog.UserCase;
import ru.softlogic.gui2.screen.ActionType;
import ru.softlogic.gui2.screen.CommonScreen;
import ru.softlogic.gui2.screen.CommonScreenStore;
import ru.softlogic.gui2.screen.ScreenAdapter;
import ru.softlogic.gui2.screen.ScreenHelper;
import ru.softlogic.gui2.screen.ScreenListener;
import ru.softlogic.input.model.InputElement;
import ru.softlogic.input.model.field.InitException;
import ru.softlogic.input.model.form.Form;
import ru.softlogic.input.model.screen.description.ScreenDescription;
import ru.softlogic.module.Restorable;
import ru.softlogic.module.input.BaseInputModule;
import ru.softlogic.module.input.DescriptionException;
import ru.softlogic.module.input.Environment;
import ru.softlogic.module.input.InitModuleHelper;
import ru.softlogic.module.input.ModuleInitException;
import ru.softlogic.module.input.chcopy.RequestAccountTask;
import ru.softlogic.module.input.universal.FormHelper;
import ru.softlogic.module.utils.ExitDialogListener;
import ru.softlogic.parser.ParseException;

public class CheckCopyInputModule
extends BaseInputModule {
    private Environment environment;

    public CheckCopyInputModule(ApplicationContext context) {
        super(context);
    }

    @Override
    protected void _start(Environment environment, Restorable parent) throws DescriptionException, ModuleInitException {
        this.environment = environment;
        environment.getMenuItem().getService().setName(B.get((String)"Provider.chcopy.service.name", (Locale)environment.getLocale()));
        if (!environment.isPrinterError()) {
            try {
                Form f = FormHelper.parseUtility("checkcopy", environment.getLocale());
                if (f.getScreenSequence().getScreens().size() != 1) {
                    throw new ParseException("Wrong number of screens");
                }
                String defaultCheckFormDecor = AppDefaults.getInstance().getStringValue("Module.input.check.copy.decor");
                CommonScreen cs = CommonScreenStore.getScreen((String)"letter", (String)(defaultCheckFormDecor != null && !defaultCheckFormDecor.isEmpty() ? defaultCheckFormDecor : ((ScreenDescription)f.getScreenSequence().getScreens().get(0)).getDecor()));
                cs.init(ScreenHelper.processBack((ScreenDescription)((ScreenDescription)f.getScreenSequence().getScreens().get(0)), (boolean)true, (parent != null ? 1 : 0) != 0), InitModuleHelper.buildScreenInit(environment, new HashMap<String, Object>()));
                cs.setListener((ScreenListener)new LocalScreenListener());
                this.context.showScreen(new ContentScreenAdapterKbr(cs));
            }
            catch (InitException ex) {
                throw new ModuleInitException(ex);
            }
            catch (ParseException ex) {
                throw new DescriptionException(ex);
            }
        } else {
            DialogScreen dialog = ComponentFactory.getInstance().createDialog(DialogType.Error, B.get((String)"Provider.chcopy.error.paper"), 10, DC.cases((int)8), UserCase.Ok);
            dialog.addListener((DialogListener)new ExitDialogListener(this));
            this.context.showDialog((DialogInterface)dialog);
        }
    }

    @Override
    protected void _restore() {
    }

    private class LocalScreenListener
    extends ScreenAdapter {
        private LocalScreenListener() {
        }

        public void onAction(String action, Map<String, Object> data, Runnable cancelListener) {
            CheckCopyInputModule.this.cancelListener = cancelListener;
            if (ActionType.isNext((String)action)) {
                InputElement number = (InputElement)data.get("number");
                InputElement pin = (InputElement)data.get("pin");
                CheckCopyInputModule.this.context.getTaskExecutor().execute(new RequestAccountTask(CheckCopyInputModule.this.environment, CheckCopyInputModule.this.context, number.getValue(), pin.getValue(), cancelListener));
            } else {
                CheckCopyInputModule.this.cancel(null);
            }
        }
    }
}

