/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.module.input.calculate;

import i18n.B;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.apache.log4j.Logger;
import ru.softlogic.app.ProblemNotifier;
import ru.softlogic.app.context.ApplicationContext;
import ru.softlogic.application.ContentScreenAdapterKbr;
import ru.softlogic.cash.Sum;
import ru.softlogic.gui.factory.ComponentFactory;
import ru.softlogic.gui.screen.popup.dialog.DC;
import ru.softlogic.gui.screen.popup.dialog.DialogInterface;
import ru.softlogic.gui.screen.popup.dialog.DialogListener;
import ru.softlogic.gui.screen.popup.dialog.DialogScreen;
import ru.softlogic.gui.screen.popup.dialog.DialogType;
import ru.softlogic.gui.screen.popup.dialog.UserCase;
import ru.softlogic.gui2.screen.CommonScreen;
import ru.softlogic.gui2.screen.CommonScreenStore;
import ru.softlogic.gui2.screen.CommonSumScreen;
import ru.softlogic.gui2.screen.ScreenHelper;
import ru.softlogic.gui2.screen.ScreenListener;
import ru.softlogic.input.model.InputElement;
import ru.softlogic.input.model.advanced.AdvancedCommissionCalculator;
import ru.softlogic.input.model.advanced.AdvancedHardwareApi;
import ru.softlogic.input.model.advanced.AdvancedScreenDescription;
import ru.softlogic.input.model.advanced.AsyncTask;
import ru.softlogic.input.model.advanced.MethodType;
import ru.softlogic.input.model.advanced.OpenUrlTarget;
import ru.softlogic.input.model.advanced.Rounding;
import ru.softlogic.input.model.advanced.Scenario;
import ru.softlogic.input.model.advanced.actions.Action;
import ru.softlogic.input.model.advanced.actions.ActionContext;
import ru.softlogic.input.model.advanced.actions.ActionMap;
import ru.softlogic.input.model.advanced.actions.cardmodule.CardModuleRequestListener;
import ru.softlogic.input.model.advanced.actions.cardmodule.CardOperation;
import ru.softlogic.input.model.advanced.actions.dialog.DialogAction;
import ru.softlogic.input.model.advanced.actions.request.CardRequestListener;
import ru.softlogic.input.model.advanced.actions.request.ServerConnector;
import ru.softlogic.input.model.field.IdentityField;
import ru.softlogic.input.model.field.InitException;
import ru.softlogic.input.model.screen.ActionType;
import ru.softlogic.input.model.screen.ButtonInit;
import ru.softlogic.input.model.screen.description.ScreenDescription;
import ru.softlogic.module.ModuleHelper;
import ru.softlogic.module.input.ComplexScreenListener;
import ru.softlogic.module.input.Environment;
import ru.softlogic.module.input.InitModuleHelper;
import ru.softlogic.module.input.advanced.AdvCommissionCalculatorImpl;
import ru.softlogic.module.input.calculate.PaySumCalculatorListener;
import ru.softlogic.module.input.template.UtilityHelper;
import ru.softlogic.service.comission.SumResult;
import ru.softlogic.srv.api.event.Event;
import ru.softlogic.srv.api.event.EventType;

public class PaySumCalculator {
    private static final String CALCULATE_PAY_SUM_SCREEN = "calculator";
    private ApplicationContext context;
    private Environment env;
    private UtilityHelper utilityHelper;
    private Logger log;
    private PaySumCalculatorListener listenerPaySum;
    private LocalScreenListener localListener;
    private CommonScreen cs;
    Rounding rounding;
    private TerminalEnvironment te;
    private AdvancedScreenDescription asd;

    public PaySumCalculator(ApplicationContext context, Environment env) {
        this.context = context;
        this.env = env;
        this.log = Logger.getLogger((String)"pay");
        this.utilityHelper = new UtilityHelper("paycalculator");
        this.te = new TerminalEnvironment();
    }

    public void start(PaySumCalculatorListener listener) {
        this.listenerPaySum = listener;
        this.localListener = new LocalScreenListener(this.context);
        this.localListener.setEnvironment(this.env);
        this.toShowScreen();
    }

    private void toShowScreen() {
        try {
            ScreenDescription sd = this.getScreenDescription(CALCULATE_PAY_SUM_SCREEN);
            String roundingTmp = ((IdentityField)sd.getSequence().getFields().get(1)).getMessage();
            this.rounding = "NOMINAL".equals(roundingTmp) ? Rounding.NOMINAL : ("INTEGER".equals(roundingTmp) ? Rounding.INTEGER : Rounding.NONE);
            this.log.info((Object)("Rounding method set to: " + this.rounding));
            this.showScreen(sd, (ScreenListener)this.localListener, true);
        }
        catch (Exception ex) {
            this.log.error((Object)ex, (Throwable)ex);
            ProblemNotifier.getDefaultNotifier().onProblemOnce("PaySumCalculator " + ex.getMessage());
        }
    }

    private ScreenDescription getScreenDescription(String id) throws Exception {
        Scenario s = this.utilityHelper.getScenario(this.env.getLocale());
        this.asd = s.getScreenById(id);
        ScreenDescription sd = this.asd.getDescription();
        this.processButtons(sd, this.asd.getActionMap());
        return sd;
    }

    private void showScreen(ScreenDescription sd, ScreenListener listener, boolean canBack) throws InitException {
        this.log.info((Object)(">>>>>>" + sd.getType() + "," + sd.getTitle()));
        this.cs = CommonScreenStore.getScreen((String)sd.getType(), (String)sd.getDecor());
        this.log.info((Object)(">>>>>>" + this.cs));
        if (this.cs == null) {
            throw new InitException("Can't get screen type: " + sd.getType());
        }
        this.cs.setListener(listener);
        this.cs.init(ScreenHelper.processBack((ScreenDescription)sd, (boolean)true, (boolean)canBack), InitModuleHelper.buildScreenInit(this.env, new HashMap<String, Object>()));
        this.context.showScreen(new ContentScreenAdapterKbr(this.cs));
    }

    private ScreenDescription processButtons(ScreenDescription sd, ActionMap map) {
        HashMap<String, ButtonInit> buttons = new HashMap<String, ButtonInit>();
        for (Action a : map.getActions()) {
            buttons.put(a.getType(), new ButtonInit(a.getTitle()));
        }
        sd.setButtons(buttons);
        return sd;
    }

    private class TerminalEnvironment
    implements ru.softlogic.input.model.advanced.Environment {
        static final long serialVersionUID = 2440777066888511555L;

        private TerminalEnvironment() {
        }

        public void showScreen(String nextScreen, Map<String, Object> localData) {
            PaySumCalculator.this.log.info((Object)("Needs to show screen: " + nextScreen));
            if ("exit".equals(nextScreen)) {
                PaySumCalculator.this.listenerPaySum.onRestore();
            } else if ("previous".equals(nextScreen) || "previos".equals(nextScreen)) {
                PaySumCalculator.this.listenerPaySum.onPrev();
            } else if ("pay".equals(nextScreen)) {
                PaySumCalculator.this.listenerPaySum.onNext();
            } else {
                try {
                    PaySumCalculator.this.showScreen(PaySumCalculator.this.asd.getDescription(), (ScreenListener)PaySumCalculator.this.localListener, true);
                }
                catch (InitException ex) {
                    this.showError((Exception)((Object)ex));
                }
            }
        }

        public void showError(Exception ex) {
            PaySumCalculator.this.log.info((Object)"\u041f\u0440\u043e\u0438\u0437\u043e\u0448\u043b\u0430 \u043e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u043e\u0431\u0440\u0430\u0431\u043e\u0442\u043a\u0435 \u0441\u043a\u0440\u0438\u043f\u0442\u0430", (Throwable)ex);
        }

        public void handleError(Exception ex) {
            PaySumCalculator.this.log.error((Object)ex, (Throwable)ex);
        }

        public void showDialog(DialogAction action) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public void execute(AsyncTask at) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public void openUrl(String string, OpenUrlTarget out, MethodType mt, String string1, Map<String, String> map) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public void getCardTrack(int i, CardRequestListener cl) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public void executeCardModuleTask(CardOperation co, boolean bln, CardModuleRequestListener cl) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public void openService(short s, Map<String, Object> map) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public AdvancedCommissionCalculator getCommissionCalculator() {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public ServerConnector getConnector() {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public AdvancedHardwareApi getHardwareApi() {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public InputElement getValue(String string) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public String getOffer(String string) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public Map<String, String> getPointParams() {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public Short getOperator(String string) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public void play(String string) {
            throw new UnsupportedOperationException("Not supported yet.");
        }
    }

    private class LocalScreenListener
    extends ComplexScreenListener {
        public LocalScreenListener(ApplicationContext context) {
            super(context);
        }

        @Override
        public void _onAction(String action, Map<String, Object> data, Runnable cancelListener) {
            ModuleHelper.invoke(cancelListener);
            if (ActionType.isEdit((String)action)) {
                if (data != null) {
                    AdvCommissionCalculatorImpl acci = new AdvCommissionCalculatorImpl(PaySumCalculator.this.env);
                    if (data.get("input_sum") instanceof InputElement) {
                        InputElement ie = (InputElement)data.get("input_sum");
                        Double result = acci.calculateIncomeSum(Double.parseDouble(ie.getOriginalValue()), PaySumCalculator.this.rounding);
                        if (PaySumCalculator.this.cs instanceof CommonSumScreen) {
                            CommonSumScreen css = (CommonSumScreen)PaySumCalculator.this.cs;
                            Sum s = new Sum(0);
                            css.updateSums(new Sum(result.doubleValue()), s, s, s, new SumResult(), s, true, true, true);
                        }
                    }
                }
            } else {
                try {
                    Action act = PaySumCalculator.this.asd.getActionMap().getActionByType(action);
                    if (act == null) {
                        act = PaySumCalculator.this.asd.getActionMap().getActionByType(action.toLowerCase(PaySumCalculator.this.env.getLocale()));
                    }
                    PaySumCalculator.this.log.info((Object)("act = " + act));
                    ActionContext currentContext = new ActionContext((ru.softlogic.input.model.advanced.Environment)PaySumCalculator.this.te, cancelListener, act.getSequence(), data, 0);
                    currentContext.execute();
                }
                catch (Exception ex) {
                    PaySumCalculator.this.log.error((Object)ex, (Throwable)ex);
                    Event event = new Event(EventType.SoftwareFault, "Advanced: " + ex.getMessage());
                    PaySumCalculator.this.context.getServerConnector().sendEvent(event);
                    DialogScreen dialog = ComponentFactory.getInstance().createDialog(DialogType.Error, B.get((String)"Provider.advanced.process.error", (Locale)PaySumCalculator.this.env.getLocale()), 10, DC.cases((int)1), UserCase.Ok);
                    dialog.addListener(new DialogListener(){

                        public void dialogClosed(UserCase userCase) {
                            PaySumCalculator.this.listenerPaySum.onRestore();
                        }
                    });
                    PaySumCalculator.this.context.showDialog((DialogInterface)dialog);
                }
            }
        }
    }
}

