/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.module.input.advanced.attribute;

import java.io.IOException;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import ru.softlogic.input.model.InputElement;
import ru.softlogic.module.input.advanced.attribute.B;
import ru.softlogic.reference.ReferenceException;
import ru.softlogic.reference.ReferenceManager;
import ru.softlogic.reference.point.Dealer;
import ru.softlogic.reference.point.Point;
import ru.softlogic.reference.service.Service;
import ru.softlogic.system.util.TemplateProcessor;

public final class EnvAttributeProcessor {
    private static final String POINT = "point";
    private static final String SERVICE = "service";
    private static final String DEALER = "dealer";
    private static final String PACKAGE_PATH = "/ru/softlogic/module/input/advanced/attribute";
    private static Map<String, String> aliasMap;
    private static Map<String, Object> data;

    public static InputElement getValue(String code, Locale locale, Service service) {
        if (code != null) {
            String alias = EnvAttributeProcessor.getAliasMap().get(code);
            if (alias == null) {
                alias = code;
            }
            return EnvAttributeProcessor.getValue(code, alias, locale, EnvAttributeProcessor.buildDataMap(service));
        }
        return null;
    }

    private static InputElement getValue(String code, String alias, Locale locale, Map<String, Object> data) {
        String value;
        String velocityCode;
        String title = B.get(alias, code, locale);
        if (title == null || title.isEmpty()) {
            title = alias;
        }
        if (!(velocityCode = "$" + alias).equals(value = TemplateProcessor.processText(velocityCode, data, null))) {
            return new InputElement(code, title, value);
        }
        return null;
    }

    private static Map<String, Object> buildDataMap(Service service) {
        if (data == null) {
            data = new HashMap<String, Object>();
        }
        Point point = null;
        Dealer dealer = null;
        try {
            point = ReferenceManager.getInstance().getPoint();
            dealer = ReferenceManager.getInstance().getDealer();
        }
        catch (ReferenceException referenceException) {
            // empty catch block
        }
        data.put(SERVICE, service);
        data.put(POINT, point);
        data.put(DEALER, dealer);
        return data;
    }

    private static Map<String, String> getAliasMap() {
        if (aliasMap == null) {
            HashMap<String, String> tmpMap = new HashMap<String, String>();
            try {
                Properties prop = new Properties();
                prop.load(EnvAttributeProcessor.class.getResourceAsStream("/ru/softlogic/module/input/advanced/attribute/alias.properties"));
                for (Map.Entry<Object, Object> e : prop.entrySet()) {
                    tmpMap.put(String.valueOf(e.getKey()), String.valueOf(e.getValue()));
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            aliasMap = tmpMap;
        }
        return aliasMap;
    }
}

