/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.module.input.advanced;

import i18n.B;
import java.util.Locale;
import java.util.Map;
import org.apache.log4j.Logger;
import ru.softlogic.app.context.ApplicationContext;
import ru.softlogic.cards.v2.connector.model.CardData;
import ru.softlogic.cards.v2.model.CardModuleError;
import ru.softlogic.cards.v2.module.CardModule;
import ru.softlogic.cards.v2.module.CardModuleCardDataListener;
import ru.softlogic.cards.v2.module.UserInterfaceEvent;
import ru.softlogic.gui.factory.ComponentFactory;
import ru.softlogic.gui.screen.popup.dialog.DC;
import ru.softlogic.gui.screen.popup.dialog.DialogInterface;
import ru.softlogic.gui.screen.popup.dialog.DialogListener;
import ru.softlogic.gui.screen.popup.dialog.DialogScreen;
import ru.softlogic.gui.screen.popup.dialog.DialogType;
import ru.softlogic.gui.screen.popup.dialog.UserCase;
import ru.softlogic.input.model.advanced.actions.request.CardRequestListener;
import ru.softlogic.module.card.CardModuleStore;
import ru.softlogic.module.card.DataProvider;
import ru.softlogic.module.card.DataProviderAdapter;
import ru.softlogic.module.card.UniversalGuiListener;
import ru.softlogic.module.input.Environment;
import ru.softlogic.module.input.advanced.AdvancedInputModule;

public class CardReaderService {
    private static final Logger log = Logger.getLogger((String)"pay");
    private final ApplicationContext context;
    private final AdvancedInputModule module;
    private final DataProvider dataProvider;
    private int track;
    private Environment environment;
    private CardRequestListener listener;
    private CardModule cm;
    private LocalGuiListener guiListener;
    private volatile boolean invokeOperation;

    public CardReaderService(ApplicationContext context, AdvancedInputModule module) {
        this.context = context;
        this.module = module;
        this.dataProvider = new DataProviderAdapter(){

            @Override
            public Map<String, Object> getData() {
                return CardReaderService.this.module.getDataContext();
            }
        };
    }

    public void run(Environment environment, int track, CardRequestListener listener) {
        try {
            this.track = track;
            this.listener = listener;
            this.environment = environment;
            this.guiListener = new LocalGuiListener(this.context, environment, this.dataProvider);
            this.cm = CardModuleStore.getInstance().openSession(this.guiListener);
        }
        catch (Throwable e) {
            log.error((Object)e, e);
            this.cm = null;
        }
        if (this.cm == null && listener != null) {
            listener.onResult(null);
        } else {
            this.invokeOperation = true;
            this.cm.getCardData((CardModuleCardDataListener)new LocalCardDataListener());
        }
    }

    public void cancel() {
        log.info((Object)"Cancel CardReaderService");
        CardModule tcm = CardModuleStore.getInstance().getCurrentSession();
        if (tcm != null) {
            try {
                if (this.invokeOperation) {
                    tcm.cancelOperation();
                } else {
                    CardModuleStore.getInstance().closeSessionSafe(true);
                }
            }
            catch (IllegalStateException e) {
                CardModuleStore.getInstance().closeSessionSafe(true);
            }
        }
    }

    private class LocalCardDataListener
    implements CardModuleCardDataListener {
        private LocalCardDataListener() {
        }

        public void onError(CardModuleError cme, String mess) {
            String code;
            CardReaderService.this.invokeOperation = false;
            log.info((Object)("CardModuleError: " + cme + " " + mess));
            switch (cme) {
                case ERROR_NO_CARD_TIMEOUT: {
                    code = "Provider.advanced.crs.error.card-timeout";
                    break;
                }
                case ERROR_USER_CANCEL: {
                    code = "Provider.advanced.crs.error.cancel-by-user";
                    break;
                }
                case ERROR_CARD_READER: {
                    code = "Provider.advanced.crs.error.cardreader";
                    break;
                }
                case ERROR_CARD_WRONG: {
                    code = "Provider.advanced.crs.error.card-wrong";
                    break;
                }
                case ERROR_MODULE: {
                    code = "Provider.advanced.crs.error.unknown";
                    break;
                }
                default: {
                    code = null;
                }
            }
            if (code != null) {
                String message = B.get((String)code, (Locale)CardReaderService.this.environment.getLocale());
                if (cme == CardModuleError.ERROR_USER_CANCEL) {
                    this.onExitError(message);
                } else {
                    this.onError(message);
                }
            }
        }

        public void onCardData(CardData cd) {
            CardReaderService.this.invokeOperation = false;
            log.info((Object)("CardData: " + cd));
            String resultData = null;
            if (CardReaderService.this.track == 1 && cd.getTrack1() != null) {
                resultData = cd.getTrack1();
            } else if (CardReaderService.this.track == 2 && cd.getTrack2() != null) {
                resultData = cd.getTrack2();
            } else if (CardReaderService.this.track == 3 && cd.getTrack3() != null) {
                resultData = cd.getTrack3();
            }
            if (resultData == null) {
                if (CardReaderService.this.track > 0 && CardReaderService.this.track <= 3) {
                    this.onError(B.get((String)("Provider.advanced.crs.error.track" + CardReaderService.this.track), (Locale)CardReaderService.this.environment.getLocale()));
                } else {
                    this.onError(B.get((String)"Provider.advanced.crs.error.wrong-track", (Locale)CardReaderService.this.environment.getLocale()));
                }
            }
            CardReaderService.this.guiListener.setClosedListener(new ClosedListener(resultData));
            CardModuleStore.getInstance().closeSessionSafe(true);
        }

        void onError(String mess) {
            DialogScreen dialog = ComponentFactory.getInstance().createDialog(DialogType.Error, mess, 10, DC.cases((int)1), UserCase.Ok);
            dialog.addListener(new DialogListener(){

                public void dialogClosed(UserCase userCase) {
                    CardReaderService.this.guiListener.setClosedListener(new ClosedListener(null));
                    CardModuleStore.getInstance().closeSessionSafe(true);
                }
            });
            CardReaderService.this.context.showDialog((DialogInterface)dialog);
        }

        void onExitError(String mess) {
            DialogScreen dialog = ComponentFactory.getInstance().createDialog(DialogType.Error, mess, 10, DC.cases((int)1), UserCase.Ok);
            dialog.addListener(new DialogListener(){

                public void dialogClosed(UserCase userCase) {
                    CardReaderService.this.guiListener.setClosedListener(new Runnable(){

                        @Override
                        public void run() {
                            CardReaderService.this.module.cancel(null);
                        }
                    });
                    CardModuleStore.getInstance().closeSessionSafe(true);
                }
            });
            CardReaderService.this.context.showDialog((DialogInterface)dialog);
        }

        private final class ClosedListener
        implements Runnable {
            private final String resultData;

            public ClosedListener(String resultData) {
                this.resultData = resultData;
            }

            @Override
            public void run() {
                if (CardReaderService.this.listener != null) {
                    CardReaderService.this.listener.onResult(this.resultData);
                }
            }
        }
    }

    private class LocalGuiListener
    extends UniversalGuiListener {
        private Runnable closedListener;

        public LocalGuiListener(ApplicationContext context, Environment environment, DataProvider dataProvider) {
            super(context, environment, log, dataProvider);
        }

        public void setClosedListener(Runnable closedListener) {
            this.closedListener = closedListener;
        }

        @Override
        public void onEvent(UserInterfaceEvent uie, Runnable r) {
            if (uie == UserInterfaceEvent.CARD_CAPTURED_BY_HOST || uie == UserInterfaceEvent.CARD_CAPTURED_BY_TIMEOUT || uie == UserInterfaceEvent.CARD_CAPTURE_FAIL) {
                CardReaderService.this.guiListener.setClosedListener(new Runnable(){

                    @Override
                    public void run() {
                        if (CardReaderService.this.listener != null) {
                            CardReaderService.this.listener.onResult(null);
                        }
                    }
                });
            }
            super.onEvent(uie, r);
        }

        @Override
        public synchronized void _onClosed() {
            Runnable r = this.closedListener;
            if (r != null) {
                r.run();
                this.closedListener = null;
            } else {
                CardReaderService.this.module.cancel(null);
            }
        }
    }
}

