/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.module.input.admin;

import i18n.B;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.LinkedList;
import java.util.Locale;
import java.util.concurrent.TimeoutException;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.filechooser.FileNameExtensionFilter;
import org.apache.log4j.Logger;
import ru.softlogic.app.FrameStore;
import ru.softlogic.app.context.InputModuleContext;
import ru.softlogic.app.task.Task;
import ru.softlogic.cash.Sum;
import ru.softlogic.gui.factory.ComponentFactory;
import ru.softlogic.gui.screen.popup.dialog.DC;
import ru.softlogic.gui.screen.popup.dialog.DialogInterface;
import ru.softlogic.gui.screen.popup.dialog.DialogScreen;
import ru.softlogic.gui.screen.popup.dialog.DialogType;
import ru.softlogic.gui.screen.popup.dialog.UserCase;
import ru.softlogic.module.input.InputModule;
import ru.softlogic.module.input.admin.UnloadSync;
import ru.softlogic.module.input.admin.Unloader;
import ru.softlogic.module.input.admin.UnloaderPrintHelper;
import ru.softlogic.module.input.admin.panels.LabeledClickButton;
import ru.softlogic.operation.Operation;
import ru.softlogic.system.util.OsDetector;
import ru.softlogic.system.util.ThreadUtil;

public class UnloaderPayments {
    private static final long DAY = 86400000L;
    private InputModuleContext context;
    private InputModule inputModule;
    private Locale locale;
    private File lastFile;
    private Logger log;
    private LabeledClickButton button;
    private Sum[] ranges;
    private int timeOut;

    public UnloaderPayments(InputModuleContext context, InputModule inputModule, Locale locale, Logger log, LabeledClickButton button, int timeOutSec) {
        this.context = context;
        this.inputModule = inputModule;
        this.locale = locale;
        this.log = log;
        this.button = button;
        this.timeOut = timeOutSec;
        this.ranges = new Sum[7];
        this.ranges[0] = new Sum(0);
        this.ranges[1] = new Sum(10000);
        this.ranges[2] = new Sum(50000);
        this.ranges[3] = new Sum(100000);
        this.ranges[4] = new Sum(500000);
        this.ranges[5] = new Sum(1000000);
        this.ranges[6] = new Sum(1500100);
        this.lastFile = new File(".");
        if (OsDetector.current() == 1) {
            this.lastFile = new File("/media/./");
        }
    }

    public void unloadPayments() {
        JFileChooser fc = this.createJFileChooser();
        int returnVal = fc.showSaveDialog(FrameStore.getFrame());
        if (returnVal != 0) {
            this.log.info((Object)B.get((String)"Provider.admin.payments.unload.dialog.info.result.cancel", (Locale)this.locale));
            return;
        }
        this.lastFile = fc.getSelectedFile();
        if (this.lastFile.isFile()) {
            this.lastFile = this.lastFile.getParentFile();
        }
        this.context.getTaskExecutor().execute(new LocalUnloadPaymentsTask(fc.getSelectedFile().getAbsolutePath()));
    }

    private JFileChooser createJFileChooser() {
        JFileChooser fc = new JFileChooser(){

            @Override
            public void approveSelection() {
                File f = this.getSelectedFile();
                if (f.exists() && this.getDialogType() == 1) {
                    int result = JOptionPane.showConfirmDialog(this, B.get((String)"Provider.admin.payments.unload.dialog.confirm.message", (Locale)UnloaderPayments.this.locale), B.get((String)"Provider.admin.payments.unload.dialog.confirm.title", (Locale)UnloaderPayments.this.locale), 0);
                    switch (result) {
                        case 0: {
                            super.approveSelection();
                            return;
                        }
                        case 1: {
                            return;
                        }
                        case -1: {
                            return;
                        }
                    }
                }
                super.approveSelection();
            }
        };
        fc.setSelectedFile(this.lastFile);
        fc.setDialogTitle(B.get((String)"Provider.admin.payments.unload.dialog.title", (Locale)this.locale));
        fc.setMultiSelectionEnabled(false);
        fc.setDialogType(1);
        fc.setApproveButtonText(B.get((String)"Provider.admin.payments.unload.dialog.button", (Locale)this.locale));
        fc.setFileFilter(new FileNameExtensionFilter("\u0424\u0430\u0439\u043b\u044b *.csv", "csv"));
        return fc;
    }

    private Operation[] writePaymentsToCSV(Operation[] operations, String fileName) throws IOException {
        this.log.info((Object)"\u041e\u0431\u0440\u0430\u0431\u0430\u0442\u044b\u0432\u0430\u044e \u0434\u0430\u043d\u043d\u044b\u0435 \u0434\u043b\u044f \u0432\u044b\u0433\u0440\u0443\u0437\u043a\u0438");
        FileWriter writer = new FileWriter(fileName.endsWith(".csv") ? fileName : fileName + ".csv");
        Date min = new Date(Long.MAX_VALUE);
        Date max = new Date(Long.MIN_VALUE);
        for (Operation o : operations) {
            if (min.after(o.getDate())) {
                min = o.getDate();
            }
            if (!max.before(o.getDate())) continue;
            max = o.getDate();
        }
        min = new Date(min.getTime());
        min.setHours(0);
        min.setMinutes(0);
        min.setSeconds(-1);
        max = new Date(max.getTime());
        max.setHours(24);
        max.setMinutes(0);
        max.setSeconds(1);
        this.log.debug((Object)("min date = " + min.toString()));
        this.log.debug((Object)("max date = " + max.toString()));
        LinkedList<Operation> unloadOpers = new LinkedList<Operation>();
        Operation[] opers = new Operation[operations.length];
        SimpleDateFormat sdf = new SimpleDateFormat("dd.MM.yy");
        while (min.before(max)) {
            int i = 0;
            Date min2 = new Date(min.getTime() + 86400000L);
            for (Operation o : operations) {
                if (!min.before(o.getDate()) || !min2.after(o.getDate())) continue;
                opers[i++] = o;
            }
            if (i > 0) {
                int i2;
                writer.append(sdf.format(min2)).append('\n');
                Operation[] ops = new Operation[i];
                for (int k = 0; k < this.ranges.length - 1; ++k) {
                    i2 = 0;
                    for (int j = 0; j < i; ++j) {
                        if (opers[j].getKeeper() == null || opers[j].getKeeper().getSum().compareTo(this.ranges[k]) < 0 || opers[j].getKeeper().getSum().compareTo(this.ranges[k + 1]) >= 0) continue;
                        ops[i2++] = opers[j];
                        unloadOpers.add(opers[j]);
                    }
                    if (i2 <= 0) continue;
                    writer.append(this.ranges[k].toString() + " - " + this.ranges[k + 1].toString()).append('\n');
                    writer.append(UnloaderPrintHelper.printHeader(this.locale));
                    writer.append(UnloaderPrintHelper.printOperations(ops, i2, this.locale));
                }
                i2 = 0;
                writer.append('\n');
                for (int j = 0; j < i; ++j) {
                    if (opers[j].getKeeper() != null) continue;
                    ops[i2++] = opers[j];
                    unloadOpers.add(opers[j]);
                }
                if (i2 > 0) {
                    writer.append(UnloaderPrintHelper.printHeader(this.locale));
                    writer.append(UnloaderPrintHelper.printOperations(ops, i2, this.locale));
                    writer.append('\n');
                }
            }
            min = new Date(min.getTime() + 86400000L);
        }
        this.log.info((Object)("\u0421\u0442\u0430\u0440\u0442 \u0437\u0430\u043f\u0438\u0441\u0438 \u0434\u0430\u043d\u043d\u044b\u0445 \u0432 csv-\u0444\u0430\u0439\u043b: " + Arrays.toString(unloadOpers.toArray())));
        writer.flush();
        writer.close();
        this.log.info((Object)"\u0414\u0430\u043d\u043d\u044b\u0435 \u043e \u043f\u043b\u0430\u0442\u0435\u0436\u0430\u0445 \u0443\u0441\u043f\u0435\u0448\u043d\u043e \u0437\u0430\u043f\u0438\u0441\u0430\u043d\u044b \u0432 csv-\u0444\u0430\u0439\u043b");
        return unloadOpers.toArray(new Operation[unloadOpers.size()]);
    }

    public void setTimeOut(int timeOut) {
        this.timeOut = timeOut;
    }

    private class LocalUnloadPaymentsTask
    implements Task {
        private String fileAbsolutePath;

        public LocalUnloadPaymentsTask(String fileAbsolutePath) {
            this.fileAbsolutePath = fileAbsolutePath;
        }

        @Override
        public String getMessage() {
            return B.get((String)"Provider.admin.payments.unload.dialog.wait", (Locale)UnloaderPayments.this.locale);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object execute() {
            UnloadSync us;
            long tStart = System.currentTimeMillis();
            UnloaderPayments.this.log.info((Object)"\u041d\u0430\u0447\u0438\u043d\u0430\u044e \u0432\u044b\u043f\u043e\u043b\u043d\u0435\u043d\u0438\u0435 \u0437\u0430\u0434\u0430\u043d\u0438\u044f \u0432\u044b\u0433\u0440\u0443\u0437\u043a\u0438 \u043f\u043b\u0430\u0442\u0435\u0436\u0435\u0439");
            UnloadSync unloadSync = us = UnloadSync.getInstance();
            synchronized (unloadSync) {
                if (us.getUnloader() != null) {
                    return -1;
                }
                us.setUnloader(new Unloader(){

                    @Override
                    public Operation[] onUnload(Operation[] operations) throws IOException {
                        return UnloaderPayments.this.writePaymentsToCSV(operations, LocalUnloadPaymentsTask.this.fileAbsolutePath);
                    }
                });
            }
            UnloaderPayments.this.log.info((Object)"\u041f\u0435\u0440\u0435\u0434\u0430\u043b \u043c\u0435\u0442\u043e\u0434 \u0432\u044b\u0433\u0440\u0443\u0437\u043a\u0438 \u0432 UnloadSync");
            ThreadUtil.sleep((long)3000L);
            while (true) {
                unloadSync = us;
                synchronized (unloadSync) {
                    if (us.getUnloader() == null) {
                        return us.getResult();
                    }
                }
                long tCurr = System.currentTimeMillis();
                if (UnloaderPayments.this.timeOut != 0 && (tCurr - tStart) / 1000L > (long)UnloaderPayments.this.timeOut) {
                    return new TimeoutException(B.get((String)"Provider.admin.payments.unload.dialog.timeout"));
                }
                ThreadUtil.sleep((long)3000L);
            }
        }

        @Override
        public void onResult(Object object) {
            DialogType dt;
            UnloaderPayments.this.log.info((Object)"\u041e\u0431\u0440\u0430\u0431\u0430\u0442\u044b\u0432\u0430\u044e \u0440\u0435\u0437\u0443\u043b\u044c\u0442\u0430\u0442 \u0432\u044b\u0433\u0440\u0443\u0437\u043a\u0438 \u043f\u043b\u0430\u0442\u0435\u0436\u0435\u0439");
            if (UnloaderPayments.this.button != null) {
                UnloaderPayments.this.button.setEnabled(false);
            }
            String message = "";
            if (object instanceof Integer) {
                if ((Integer)object == -1) {
                    UnloaderPayments.this.log.info((Object)"\u0412\u044b\u0433\u0440\u0443\u0437\u043a\u0430 \u043f\u043b\u0430\u0442\u0435\u0436\u0435\u0439 \u0443\u0436\u0435 \u0432\u044b\u043f\u043e\u043b\u043d\u044f\u0435\u0442\u0441\u044f");
                    return;
                }
                message = MessageFormat.format(B.get((String)"Provider.admin.payments.unload.dialog.info.result.ok", (Locale)UnloaderPayments.this.locale), (Integer)object);
                dt = DialogType.Info;
            } else if (object instanceof IOException) {
                IOException ioe = (IOException)object;
                message = MessageFormat.format(B.get((String)"Provider.admin.payments.unload.dialog.info.result.error", (Locale)UnloaderPayments.this.locale), ioe.getMessage());
                UnloaderPayments.this.button.setEnabled(true);
                dt = DialogType.Error;
            } else if (object instanceof TimeoutException) {
                TimeoutException toe = (TimeoutException)object;
                message = MessageFormat.format(B.get((String)"Provider.admin.payments.unload.dialog.info.result.error", (Locale)UnloaderPayments.this.locale), toe.getMessage());
                UnloaderPayments.this.button.setEnabled(true);
                dt = DialogType.Error;
            } else if (object == null) {
                message = "\u0412 \u043e\u0447\u0435\u0440\u0435\u0434\u0438 \u043d\u0435\u0442 \u043f\u043b\u0430\u0442\u0435\u0436\u0435\u0439 \u0434\u043b\u044f \u0432\u044b\u0433\u0440\u0443\u0437\u043a\u0438";
                dt = DialogType.Info;
            } else {
                message = "Unknown error";
                dt = DialogType.Error;
            }
            UnloaderPayments.this.log.info((Object)("result message: " + message));
            UnloaderPayments.this.log.info((Object)"Show result screen");
            DialogScreen dialog = ComponentFactory.getInstance().createDialog(dt, message, 15, DC.cases((int)1), UserCase.Ok);
            UnloaderPayments.this.context.showDialog((DialogInterface)dialog);
        }
    }
}

