/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.module.input.admin;

import i18n.B;
import java.text.MessageFormat;
import ru.softlogic.app.context.InputModuleContext;
import ru.softlogic.app.task.Task;
import ru.softlogic.gui.factory.ComponentFactory;
import ru.softlogic.gui.screen.popup.dialog.DC;
import ru.softlogic.gui.screen.popup.dialog.DialogInterface;
import ru.softlogic.gui.screen.popup.dialog.DialogScreen;
import ru.softlogic.gui.screen.popup.dialog.DialogType;
import ru.softlogic.gui.screen.popup.dialog.UserCase;
import ru.softlogic.hardware.device.print.kkm.KkmOperation;
import ru.softlogic.hardware.device.print.kkm.ReportResult;
import ru.softlogic.hardware.device.print.queue.ReportRequest;

public class ReportTask
implements Task {
    private final KkmOperation operation;
    private final InputModuleContext context;

    public ReportTask(KkmOperation operation, InputModuleContext context) {
        this.operation = operation;
        this.context = context;
    }

    @Override
    public String getMessage() {
        return B.get((String)"ServiceMenu.report.wait");
    }

    @Override
    public Object execute() {
        try {
            return this.context.getPrinterQueue().reportAndWait(new ReportRequest(this.operation));
        }
        catch (Exception ex) {
            return ex;
        }
    }

    @Override
    public void onResult(Object object) {
        DialogScreen dialog = null;
        if (object instanceof ReportResult) {
            ReportResult result = (ReportResult)object;
            dialog = ComponentFactory.getInstance().createDialog(DialogType.Info, MessageFormat.format(B.get((String)"ServiceMenu.report.result"), result.getMessage(), result.getResult()), 15, DC.cases((int)1), UserCase.Ok);
        } else if (object instanceof Exception) {
            Exception ex = (Exception)object;
            dialog = ComponentFactory.getInstance().createDialog(DialogType.Error, MessageFormat.format(B.get((String)"ServiceMenu.report.failure"), ex), 15, DC.cases((int)1), UserCase.Ok);
        }
        this.context.showDialog((DialogInterface)dialog);
    }
}

