/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.module.input.admin;

import java.text.SimpleDateFormat;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableModel;
import ru.softlogic.hardware.device.cashin.MoneyCollection;

public class MoneyCollectionModel
implements TableModel {
    private MoneyCollection[] moneyCollections;
    private String[] columns;
    private SimpleDateFormat sdf;

    public MoneyCollectionModel(MoneyCollection[] moneyCollections, String number, String date, String sum) {
        this.moneyCollections = moneyCollections;
        this.columns = new String[3];
        this.columns[0] = number;
        this.columns[1] = date;
        this.columns[2] = sum;
        this.sdf = new SimpleDateFormat("dd.MM.yyyy HH:mm:ss");
    }

    @Override
    public int getRowCount() {
        return this.moneyCollections == null ? 0 : this.moneyCollections.length;
    }

    @Override
    public int getColumnCount() {
        return 3;
    }

    @Override
    public String getColumnName(int columnIndex) {
        return this.columns[columnIndex];
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        return String.class;
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return false;
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        MoneyCollection mc = this.moneyCollections[rowIndex];
        if (columnIndex == 0) {
            return mc.getId();
        }
        if (columnIndex == 1) {
            return this.sdf.format(mc.getDate());
        }
        if (columnIndex == 2) {
            return mc.getKeeper().getCashSum().toString();
        }
        return null;
    }

    @Override
    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
    }

    @Override
    public void addTableModelListener(TableModelListener l) {
    }

    @Override
    public void removeTableModelListener(TableModelListener l) {
    }

    public MoneyCollection[] getMoneyCollections() {
        return this.moneyCollections;
    }
}

