/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.module.input.admin;

import i18n.B;
import java.awt.EventQueue;
import java.io.File;
import java.text.MessageFormat;
import java.util.Locale;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.filechooser.FileNameExtensionFilter;
import ru.softlogic.app.FrameStore;
import ru.softlogic.gui.GuiContext;
import ru.softlogic.gui.factory.ComponentFactory;
import ru.softlogic.gui.screen.popup.dialog.DC;
import ru.softlogic.gui.screen.popup.dialog.DialogInterface;
import ru.softlogic.gui.screen.popup.dialog.DialogListener;
import ru.softlogic.gui.screen.popup.dialog.DialogScreen;
import ru.softlogic.gui.screen.popup.dialog.DialogType;
import ru.softlogic.gui.screen.popup.dialog.UserCase;
import ru.softlogic.module.input.InputModule;
import ru.softlogic.module.utils.ExitDialogListener;
import ru.softlogic.system.util.OsDetector;
import ru.softlogic.system.util.PathUtils;
import ru.softlogic.update.updater.AutoUpdateControl;
import ru.softlogic.update.updater.FileUpdateStore;
import ru.softlogic.update.updater.StateListener;
import ru.softlogic.update.updater.UpdateControl;
import ru.softlogic.update.updater.UpdateMetric;
import ru.softlogic.update.updater.UpdateRequest;
import ru.softlogic.update.updater.UpdateSize;
import ru.softlogic.update.updater.UpdateStore;
import ru.softlogic.update.updater.UpdateSystem;

public class LocalUpdater {
    private GuiContext context;
    private InputModule inputModule;
    private Locale locale;
    private JFrame parent;
    private File lastFile;

    public LocalUpdater(GuiContext context, InputModule inputModule, Locale locale) {
        this.context = context;
        this.inputModule = inputModule;
        this.locale = locale;
        this.lastFile = new File(".");
        if (OsDetector.current() == 1) {
            this.lastFile = new File("/media/./");
        }
    }

    public void checkUpdate() {
        JFileChooser fc = new JFileChooser();
        fc.setSelectedFile(this.lastFile);
        fc.setDialogTitle(B.get((String)"Provider.admin.update.local.dialog.title", (Locale)this.locale));
        fc.setMultiSelectionEnabled(false);
        fc.setDialogType(0);
        fc.setApproveButtonText(B.get((String)"Provider.admin.update.local.dialog.button", (Locale)this.locale));
        fc.setFileFilter(new FileNameExtensionFilter("\u0424\u0430\u0439\u043b\u044b *.crc", "crc"));
        int returnVal = fc.showOpenDialog(FrameStore.getFrame());
        if (returnVal != 0) {
            return;
        }
        this.lastFile = fc.getSelectedFile();
        if (this.lastFile.isFile()) {
            this.lastFile = this.lastFile.getParentFile();
        }
        UpdateRequest ur = new UpdateRequest((UpdateStore)new FileUpdateStore(this.lastFile), (UpdateControl)new AutoUpdateControl(1), new File(PathUtils.getAppHome()), new File(PathUtils.getAppHome(), "/update/"), (StateListener)new GuiStateListener());
        if (!UpdateSystem.getUpdateHandler().addUpdateRequest(ur)) {
            this.showDialog("Provider.admin.update.request.reject");
        }
    }

    private void showDialog(final String messageId) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                DialogScreen dialog = ComponentFactory.getInstance().createDialog(DialogType.Error, B.get((String)messageId, (Locale)LocalUpdater.this.locale), 6, DC.cases((int)8, (Locale)LocalUpdater.this.locale, (Object[])new Object[0]), UserCase.Ok);
                LocalUpdater.this.context.showDialog((DialogInterface)dialog);
            }
        });
    }

    private void showDialogMsg(final String message) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                DialogScreen dialog = ComponentFactory.getInstance().createDialog(DialogType.Error, B.get((String)message, (Locale)LocalUpdater.this.locale), 6, DC.cases((int)8, (Locale)LocalUpdater.this.locale, (Object[])new Object[0]), UserCase.Ok);
                LocalUpdater.this.context.showDialog((DialogInterface)dialog);
            }
        });
    }

    private class GuiStateListener
    implements StateListener {
        private GuiStateListener() {
        }

        public void onStart() {
        }

        public void onSkip() {
            LocalUpdater.this.showDialog("Provider.admin.update.skip");
        }

        public void onConfirm(UpdateSize updateSize) {
        }

        public void onSuccess(UpdateMetric updateMetric) {
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    DialogScreen dialog = ComponentFactory.getInstance().createDialog(DialogType.Info, B.get((String)"Provider.admin.update.success", (Locale)LocalUpdater.this.locale), 20, DC.cases((int)8, (Locale)LocalUpdater.this.locale, (Object[])new Object[0]), UserCase.Ok);
                    dialog.addListener((DialogListener)new ExitDialogListener(LocalUpdater.this.inputModule));
                    LocalUpdater.this.context.showDialog((DialogInterface)dialog);
                }
            });
        }

        public void onCancel() {
        }

        public void onLocalError(Exception ex, UpdateMetric updateMetric) {
            LocalUpdater.this.showDialogMsg(MessageFormat.format(B.get((String)"Provider.admin.update.error.local", (Locale)LocalUpdater.this.locale), ex.getMessage()));
        }

        public void onGlobalError(Exception ex) {
            LocalUpdater.this.showDialogMsg(MessageFormat.format(B.get((String)"Provider.admin.update.error.local", (Locale)LocalUpdater.this.locale), ex.getMessage()));
        }

        public void onProgress(String fileName, int total, int progress) {
        }
    }
}

