/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.module.input.admin;

import i18n.B;
import java.awt.Color;
import java.awt.EventQueue;
import java.io.File;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.swing.JTabbedPane;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Appender;
import org.apache.log4j.Logger;
import ru.softlogic.app.AppEnvironment;
import ru.softlogic.app.FrameStore;
import ru.softlogic.app.configuration.AppDefaults;
import ru.softlogic.app.configuration.SystemProp;
import ru.softlogic.app.context.ApplicationContext;
import ru.softlogic.app.session.ServiceZReportStorage;
import ru.softlogic.app.task.Task;
import ru.softlogic.application.ContentScreenAdapterKbr;
import ru.softlogic.application.FrameMaximizer;
import ru.softlogic.application.QueueAgentListener;
import ru.softlogic.application.SafeReboot;
import ru.softlogic.application.cdm.Cdm;
import ru.softlogic.application.collection.MoneyCollectionHandler;
import ru.softlogic.cash.Keeper;
import ru.softlogic.cash.Sum;
import ru.softlogic.cash.manager.CashManager;
import ru.softlogic.cash.unit.CashUnit;
import ru.softlogic.gui.factory.ComponentFactory;
import ru.softlogic.gui.screen.popup.dialog.DC;
import ru.softlogic.gui.screen.popup.dialog.DialogInterface;
import ru.softlogic.gui.screen.popup.dialog.DialogListener;
import ru.softlogic.gui.screen.popup.dialog.DialogScreen;
import ru.softlogic.gui.screen.popup.dialog.DialogType;
import ru.softlogic.gui.screen.popup.dialog.UserCase;
import ru.softlogic.gui2.screen.ActionType;
import ru.softlogic.gui2.screen.CommonScreen;
import ru.softlogic.gui2.screen.CommonScreenStore;
import ru.softlogic.gui2.screen.ScreenAdapter;
import ru.softlogic.gui2.screen.ScreenInit;
import ru.softlogic.gui2.screen.ScreenListener;
import ru.softlogic.hardware.device.DeviceClass;
import ru.softlogic.hardware.device.cashin.MoneyCollection;
import ru.softlogic.hardware.device.cashin.validator.status.ValidatorStatus;
import ru.softlogic.hardware.device.cashin.validator.status.ValidatorStatusListener;
import ru.softlogic.hardware.device.hopper.DispenseAdapter;
import ru.softlogic.hardware.device.hopper.DispenseListener;
import ru.softlogic.hardware.device.hopper.Hopper;
import ru.softlogic.hardware.device.hopper.HopperException;
import ru.softlogic.hardware.device.print.CustomData;
import ru.softlogic.hardware.device.print.PrinterType;
import ru.softlogic.hardware.device.print.kkm.KkmOperation;
import ru.softlogic.hardware.device.print.kkm.ReportByDate;
import ru.softlogic.hardware.device.print.status.PrinterStatus;
import ru.softlogic.hardware.device.print.status.PrinterStatusObserver;
import ru.softlogic.hardware.utils.SumFormatter;
import ru.softlogic.input.model.InputElement;
import ru.softlogic.input.model.field.FieldSequence;
import ru.softlogic.input.model.field.InitException;
import ru.softlogic.input.model.field.selector.ItemsStore;
import ru.softlogic.input.model.field.selector.SelectorField;
import ru.softlogic.input.model.field.selector.SelectorItem;
import ru.softlogic.input.model.field.selector.StaticStore;
import ru.softlogic.input.model.field.text.Keyboard;
import ru.softlogic.input.model.field.text.KeyboardCase;
import ru.softlogic.input.model.field.text.KeyboardType;
import ru.softlogic.input.model.field.text.RegexValidator;
import ru.softlogic.input.model.field.text.TextField;
import ru.softlogic.input.model.field.text.Validator;
import ru.softlogic.input.model.screen.description.ScreenDescription;
import ru.softlogic.input.model.screen.description.UniScreenDescription;
import ru.softlogic.module.ModuleHelper;
import ru.softlogic.module.ModuleTypeListener;
import ru.softlogic.module.Restorable;
import ru.softlogic.module.input.BaseInputModule;
import ru.softlogic.module.input.DescriptionException;
import ru.softlogic.module.input.Environment;
import ru.softlogic.module.input.ModuleInitException;
import ru.softlogic.module.input.admin.AdminListener;
import ru.softlogic.module.input.admin.AdminPanel;
import ru.softlogic.module.input.admin.BaseAdminScreen;
import ru.softlogic.module.input.admin.LocalUpdater;
import ru.softlogic.module.input.admin.LogListener;
import ru.softlogic.module.input.admin.NetworkUpdater;
import ru.softlogic.module.input.admin.PaymentsCollectionRecord;
import ru.softlogic.module.input.admin.ReportByDateTask;
import ru.softlogic.module.input.admin.ReportCopyTask;
import ru.softlogic.module.input.admin.ReportTask;
import ru.softlogic.module.input.admin.UnloaderPayments;
import ru.softlogic.module.input.admin.log.LimitLinesDocumentListener;
import ru.softlogic.module.input.admin.log.ViewAppender;
import ru.softlogic.module.input.admin.panels.CashPanel;
import ru.softlogic.module.input.admin.panels.CoffeMachinePanel;
import ru.softlogic.module.input.admin.panels.KkmOnlinePanel;
import ru.softlogic.module.input.admin.panels.KkmPanel;
import ru.softlogic.module.input.admin.panels.LogPanel;
import ru.softlogic.module.input.admin.panels.MainPanel;
import ru.softlogic.module.input.admin.panels.StatesPanel;
import ru.softlogic.module.input.ntscoffee.CoffeeMachineUtil;
import ru.softlogic.module.input.ntscoffee.FullnessStatusTask;
import ru.softlogic.module.input.ntscoffee.FullnessUpdateTask;
import ru.softlogic.module.input.ntscoffee.MakeFastDrinkTask;
import ru.softlogic.operation.GroupOperation;
import ru.softlogic.operation.Operation;
import ru.softlogic.provider.ProviderType;
import ru.softlogic.reference.point.ServerUser;
import ru.softlogic.srv.api.event.Event;
import ru.softlogic.srv.api.event.EventType;
import ru.softlogic.srv.connector.ConnectorException;
import ru.softlogic.system.util.DaemonUtil;
import ru.softlogic.system.util.OsDetector;
import ru.softlogic.system.util.PathUtils;
import ru.softlogic.system.util.ResourceLoader;
import ru.softlogic.system.util.UsersUtil;
import ru.softlogic.system.util.network.NetObserver;
import ru.softlogic.system.util.network.RemoteStatusObserver;
import ru.softlogic.system.util.os.OsApi;
import ru.softlogic.system.util.os.OsException;

public class AdminInputModule
extends BaseInputModule
implements NetObserver,
RemoteStatusObserver,
PrinterStatusObserver,
ValidatorStatusListener,
ModuleTypeListener {
    public static final String MENU_USER_KEY = "menu-user";
    private MoneyCollectionHandler cashCollectionHandler;
    private MoneyCollectionHandler coinCollectionHandler;
    private BaseAdminScreen adminScreen;
    private FrameMaximizer frameMaximizer;
    private ServerUser menuUser;
    private ValidatorStatus validatorStatus;
    private PrinterStatus printerStatus;
    private Integer remoteStatus;
    private Date lastConnect;
    private Integer errCount;
    private CashManager cashManager;
    private Color okColor = new Color(0, 127, 0);
    private MainPanel mainPanel;
    private StatesPanel statesPanel;
    private LogPanel logPanel;
    private List<LogListener> loggers;
    private QueueAgentListener queueAgentListener;
    private Environment environment;
    private Locale locale;
    private LocalAdminListener adminListener;

    public AdminInputModule(ApplicationContext context) {
        super(context);
        LogListener logListener;
        ViewAppender app;
        this.adminScreen = new BaseAdminScreen();
        this.mainPanel = this.adminScreen.getAdminPanel().getMainPanel();
        this.statesPanel = this.adminScreen.getAdminPanel().getStatesPanel();
        this.logPanel = this.adminScreen.getAdminPanel().getLogPanel();
        this.logPanel.getNetworkLogTextArea().getDocument().addDocumentListener(new LimitLinesDocumentListener(500));
        this.logPanel.getCashinLogTextArea().getDocument().addDocumentListener(new LimitLinesDocumentListener(500));
        this.logPanel.getPrintLogTextArea().getDocument().addDocumentListener(new LimitLinesDocumentListener(500));
        this.logPanel.getModemLogTextArea().getDocument().addDocumentListener(new LimitLinesDocumentListener(500));
        this.logPanel.getUpdateLogTextArea().getDocument().addDocumentListener(new LimitLinesDocumentListener(500));
        this.loggers = new LinkedList<LogListener>();
        Appender appender = Logger.getLogger((String)"net").getAppender("netview");
        if (appender instanceof ViewAppender) {
            app = (ViewAppender)appender;
            logListener = new LogListener(this.logPanel.getNetworkLogTextArea());
            logListener.setActive(!AppDefaults.getInstance().getBooleanProperty("loggers.admin.off", true));
            this.loggers.add(logListener);
            app.addListener(logListener);
        }
        if ((appender = Logger.getLogger((String)"cashin").getAppender("cashinview")) instanceof ViewAppender) {
            app = (ViewAppender)appender;
            logListener = new LogListener(this.logPanel.getCashinLogTextArea());
            logListener.setActive(!AppDefaults.getInstance().getBooleanProperty("loggers.admin.off", true));
            this.loggers.add(logListener);
            app.addListener(logListener);
        }
        if ((appender = Logger.getLogger((String)"print").getAppender("printview")) instanceof ViewAppender) {
            app = (ViewAppender)appender;
            logListener = new LogListener(this.logPanel.getPrintLogTextArea());
            logListener.setActive(!AppDefaults.getInstance().getBooleanProperty("loggers.admin.off", true));
            this.loggers.add(logListener);
            app.addListener(logListener);
        }
        if ((appender = Logger.getLogger((String)"modem").getAppender("modemview")) instanceof ViewAppender) {
            app = (ViewAppender)appender;
            logListener = new LogListener(this.logPanel.getModemLogTextArea());
            logListener.setActive(!AppDefaults.getInstance().getBooleanProperty("loggers.admin.off", true));
            this.loggers.add(logListener);
            app.addListener(logListener);
        }
        if ((appender = Logger.getLogger((String)"update").getAppender("updateview")) instanceof ViewAppender) {
            app = (ViewAppender)appender;
            logListener = new LogListener(this.logPanel.getUpdateLogTextArea());
            logListener.setActive(!AppDefaults.getInstance().getBooleanProperty("loggers.admin.off", true));
            this.loggers.add(logListener);
            app.addListener(logListener);
        }
        this.adminListener = new LocalAdminListener();
        this.adminScreen.addListener(this.adminListener);
        this.queueAgentListener = new LocalQueueAgentListener();
    }

    @Override
    public void onChange(int moduleType) {
        if (moduleType == 1 && AppDefaults.getInstance().getBooleanProperty("loggers.admin.off", true)) {
            for (LogListener ll : this.loggers) {
                if (!ll.isActive()) continue;
                ll.setActive(false);
            }
        }
    }

    public void setCollectionHandlers(MoneyCollectionHandler cashCollectionHandler, MoneyCollectionHandler coinCollectionHandler) {
        this.cashCollectionHandler = cashCollectionHandler;
        this.coinCollectionHandler = coinCollectionHandler;
    }

    public void setFrameMaximizer(FrameMaximizer frameMaximizer) {
        this.frameMaximizer = frameMaximizer;
    }

    public void setCashManager(CashManager cashManager) {
        this.cashManager = cashManager;
    }

    @Override
    protected void _start(Environment environment, Restorable parent) throws DescriptionException, ModuleInitException {
        this.environment = environment;
        this.locale = environment.getLocale();
        this.logPanel.getTabbedPane().setTitleAt(0, B.get((String)"AdminPanel.loggerPanel.net", (Locale)this.locale));
        this.logPanel.getTabbedPane().setTitleAt(1, B.get((String)"AdminPanel.loggerPanel.cashin", (Locale)this.locale));
        this.logPanel.getTabbedPane().setTitleAt(2, B.get((String)"AdminPanel.loggerPanel.print", (Locale)this.locale));
        this.logPanel.getTabbedPane().setTitleAt(3, B.get((String)"AdminPanel.loggerPanel.modem", (Locale)this.locale));
        this.logPanel.getTabbedPane().setTitleAt(4, B.get((String)"AdminPanel.loggerPanel.update", (Locale)this.locale));
        Keyboard keyboard = new Keyboard(KeyboardType.Any, Arrays.asList("en", "symb"), KeyboardCase.Lower, true, null);
        RegexValidator validator = new RegexValidator(Arrays.asList("^(\\W|\\w){6,}"), null);
        TextField lf = new TextField();
        lf.setId("login");
        lf.setKeyboard(keyboard);
        lf.setMaxLength(20);
        lf.setValidator((Validator)validator);
        lf.setTitle(B.get((String)"ServiceMenu.auth.login", (Locale)environment.getLocale()));
        TextField pf = new TextField();
        pf.setId("password");
        pf.setKeyboard(keyboard);
        pf.setMaxLength(20);
        pf.setSecure(true);
        pf.setValidator((Validator)validator);
        pf.setTitle(B.get((String)"ServiceMenu.auth.password", (Locale)environment.getLocale()));
        FieldSequence fs = new FieldSequence(Arrays.asList(lf, pf));
        UniScreenDescription sd = new UniScreenDescription("letter");
        sd.setSequence(fs);
        sd.setTitle(B.get((String)"ServiceMenu.auth.title", (Locale)environment.getLocale()));
        CommonScreen cs = CommonScreenStore.getScreen((String)"letter");
        ScreenInit si = new ScreenInit(environment.getMenuItem().getService(), environment.getMenuItem().getCommission(), environment.getDealer(), environment.getPoint(), new HashMap(), null, 0, 0, environment.getLocale(), null, null, environment.isPrinterError(), environment.getAllowedNotes(), environment.getAllowedCoins(), environment.getDateOfStartPayment(), null, environment.getMenuItem(), null);
        try {
            cs.init((ScreenDescription)sd, si);
            cs.setListener((ScreenListener)new CommonScreenListener());
            this.context.showScreen(new ContentScreenAdapterKbr(cs));
        }
        catch (InitException ex) {
            throw new ModuleInitException(ex);
        }
    }

    public void update(ValidatorStatus status) {
        if (!status.equals((Object)this.validatorStatus)) {
            this.validatorStatus = status;
            this.updateStates();
        }
    }

    public void update(int remoteStatus) {
        if (this.remoteStatus == null || this.remoteStatus != remoteStatus) {
            this.remoteStatus = remoteStatus;
            this.updateStates();
        }
    }

    public void update(DeviceClass deviceClass, PrinterStatus status) {
        if (!status.equals((Object)this.printerStatus)) {
            this.printerStatus = status;
            this.updateStates();
        }
    }

    public void update(boolean netError) {
        if (!netError) {
            this.errCount = 0;
            this.lastConnect = new Date();
        } else if (this.errCount == null) {
            this.errCount = 1;
        } else {
            Integer n = this.errCount;
            Integer n2 = this.errCount = Integer.valueOf(this.errCount + 1);
        }
    }

    private void initTabs(ServerUser user) {
        JTabbedPane pane;
        block21: {
            Iterator<LogListener> m;
            pane = this.adminScreen.getAdminPanel().getTabbedPane();
            pane.removeAll();
            this.adminScreen.init(this.locale);
            this.adminScreen.getAdminPanel().getCashPanel().setCashInfo(this.cashCollectionHandler.getBox(), this.coinCollectionHandler.getBox());
            if (UsersUtil.canShowTab(user, "main")) {
                Map pointAttributes;
                m = this.adminScreen.getAdminPanel().getMainPanel();
                pane.addTab(B.get((String)"AdminPanel.mainPanel.TabConstraints.tabTitle", (Locale)this.locale), ResourceLoader.getIcon((String)"/icon/x48/home.png"), ((MainPanel)((Object)m)).getPanel());
                ((MainPanel)((Object)m)).getCashMoneyCollection().setEnabled(UsersUtil.canShowButton(user, "main", "cashMoneyCollection"));
                ((MainPanel)((Object)m)).getCoinMoneyCollection().setEnabled(UsersUtil.canShowButton(user, "main", "coinMoneyCollection"));
                ((MainPanel)((Object)m)).getCoinMoneyCollectionNominal().setEnabled(UsersUtil.canShowButton(user, "main", "coinMoneyCollection"));
                ((MainPanel)((Object)m)).getFlowDownHopperButton().setEnabled(UsersUtil.canShowButton(user, "main", "coinMoneyCollection"));
                ((MainPanel)((Object)m)).getTestPrinter().setEnabled(UsersUtil.canShowButton(user, "main", "testPrinter"));
                ((MainPanel)((Object)m)).getTestNetwork().setEnabled(UsersUtil.canShowButton(user, "main", "testNetwork"));
                ((MainPanel)((Object)m)).getCheckBalance().setEnabled(UsersUtil.canShowButton(user, "main", "checkBalance"));
                ((MainPanel)((Object)m)).getCalibrateButton().setEnabled(UsersUtil.canShowButton(user, "main", "calibrate"));
                ((MainPanel)((Object)m)).getMinimizeSoftware().setEnabled(UsersUtil.canShowButton(user, "main", "minimizeSoftware"));
                ((MainPanel)((Object)m)).getRestartSoftware().setEnabled(UsersUtil.canShowButton(user, "main", "restartSoftware"));
                ((MainPanel)((Object)m)).getCloseSoftware().setEnabled(UsersUtil.canShowButton(user, "main", "closeSoftware"));
                ((MainPanel)((Object)m)).getRebootTerminal().setEnabled(UsersUtil.canShowButton(user, "main", "rebootTerminal"));
                ((MainPanel)((Object)m)).getPoweroffTerminal().setEnabled(UsersUtil.canShowButton(user, "main", "poweroffTerminal"));
                ((MainPanel)((Object)m)).getUpdateButton().setEnabled(UsersUtil.canShowButton(user, "main", "update"));
                ((MainPanel)((Object)m)).getLocalUpdateButton().setEnabled(UsersUtil.canShowButton(user, "main", "localUpdate"));
                ((MainPanel)((Object)m)).getUnloadPaymentsButton().setEnabled(this.context.getServerConnector().getQueue().getAllOperations() != null);
                ((MainPanel)((Object)m)).getUnloadPaymentsButton().setVisible(UsersUtil.canShowButton(user, "main", "unloadPayments"));
                ((MainPanel)((Object)m)).getControlPanelButton().setEnabled(UsersUtil.canShowButton(user, "main", "controlPanel"));
                ((MainPanel)((Object)m)).getStartConfig().setEnabled(UsersUtil.canShowButton(user, "main", "startConfig"));
                ((MainPanel)((Object)m)).getCoinHopperButton().setVisible(Hopper.getDefaultHopper() != null);
                ((MainPanel)((Object)m)).getFlowDownHopperButton().setVisible(Hopper.getDefaultHopper() != null && Hopper.getDefaultHopper().isFlowDownSupported());
                ((MainPanel)((Object)m)).getDispenserCollectionButton().setVisible(Cdm.getInstance() != null);
                ((MainPanel)((Object)m)).getStartCMSetupButton().setVisible(CoffeeMachineUtil.isCoffeeMachinePresent());
                ((MainPanel)((Object)m)).getCoinMoneyCollectionNominal().setVisible(Hopper.getDefaultHopper() != null);
                ((MainPanel)((Object)m)).getStartGSM().setVisible(AppDefaults.getInstance().getBooleanProperty("AdminPanel.startGSM.enabled", false));
                ((MainPanel)((Object)m)).getzReportService().setVisible(false);
                if (this.environment != null && this.environment.getPoint() != null && this.environment.getPoint().getAttributes() != null && "true".equals((pointAttributes = this.environment.getPoint().getAttributes()).get("zreport-service-enable"))) {
                    ((MainPanel)((Object)m)).getzReportService().setVisible(true);
                    String buttonTitle = (String)pointAttributes.get("zreport-service-name");
                    if (StringUtils.isNotBlank((String)buttonTitle)) {
                        if (!buttonTitle.contains("<html>")) {
                            ((MainPanel)((Object)m)).getzReportService().getTitleLabel().setText("<html>" + buttonTitle + "</html>");
                        } else {
                            ((MainPanel)((Object)m)).getzReportService().getTitleLabel().setText(buttonTitle);
                        }
                    }
                }
            }
            if (CoffeeMachineUtil.isCoffeeMachinePresent()) {
                m = this.adminScreen.getAdminPanel().getCoffeePanel();
                pane.addTab(B.get((String)"AdminPanel.coffeMachinePanel.TabConstraints.tabTitle", (Locale)this.locale), ResourceLoader.getIcon((String)"/icon/x48/coffee.png"), ((CoffeMachinePanel)((Object)m)).getPanel());
            }
            if (AppDefaults.getInstance().getBooleanProperty("loggers.admin.off", true)) {
                for (LogListener ll : this.loggers) {
                    if (ll == null) continue;
                    ll.setActive(true);
                }
            }
            if (UsersUtil.canShowTab(user, "kkm")) {
                Object k;
                if (this.context.getPrinterQueue().getPrinterType() == PrinterType.Kkm) {
                    k = this.adminScreen.getAdminPanel().getKkmPanel();
                    pane.addTab(B.get((String)"AdminPanel.kkmPanel.TabConstraints.tabTitle", (Locale)this.locale), ResourceLoader.getIcon((String)"/icon/x48/cash_register.png"), ((KkmPanel)k).getPanel());
                    ((KkmPanel)k).getzReport().setEnabled(UsersUtil.canShowButton(user, "kkm", "zReport"));
                    ((KkmPanel)k).getxReport().setEnabled(UsersUtil.canShowButton(user, "kkm", "xReport"));
                    ((KkmPanel)k).getzReportMem().setEnabled(UsersUtil.canShowButton(user, "kkm", "zReportMem"));
                    ((KkmPanel)k).getTestSellButton().setEnabled(UsersUtil.canShowButton(user, "kkm", "testSell"));
                    ((KkmPanel)k).getReportByRangeButton().setEnabled(UsersUtil.canShowButton(user, "kkm", "printDateRange"));
                    ((KkmPanel)k).getTestFiscalServer().setVisible(true);
                    try {
                        this.context.getPrinterQueue().getFiscalServerStatus();
                    }
                    catch (Exception ex) {
                        if (ex instanceof UnsupportedOperationException) {
                            ((KkmPanel)k).getTestFiscalServer().setVisible(false);
                        }
                        break block21;
                    }
                }
                if (this.context.getPrinterQueue().getPrinterType() == PrinterType.KkmOnline) {
                    k = this.adminScreen.getAdminPanel().getKkmOnlinePanel();
                    pane.addTab(B.get((String)"AdminPanel.kkmPanel.TabConstraints.tabTitle", (Locale)this.locale), ResourceLoader.getIcon((String)"/icon/x48/cash_register.png"), ((KkmOnlinePanel)k).getPanel());
                    ((KkmOnlinePanel)k).getzReport().setEnabled(UsersUtil.canShowButton(user, "kkm", "zReport"));
                    ((KkmOnlinePanel)k).getxReport().setEnabled(UsersUtil.canShowButton(user, "kkm", "xReport"));
                    ((KkmOnlinePanel)k).getzReportCopy().setEnabled(UsersUtil.canShowButton(user, "kkm", "zReportMem"));
                    ((KkmOnlinePanel)k).getTestSellButton().setEnabled(UsersUtil.canShowButton(user, "kkm", "testSell"));
                    ((KkmOnlinePanel)k).getTestFiscalServer().setVisible(true);
                    try {
                        this.context.getPrinterQueue().getFiscalServerStatus();
                    }
                    catch (Exception ex) {
                        if (!(ex instanceof UnsupportedOperationException)) break block21;
                        ((KkmOnlinePanel)k).getTestFiscalServer().setVisible(false);
                    }
                }
            }
        }
        if (Cdm.getInstance() != null) {
            // empty if block
        }
        if (UsersUtil.canShowTab(user, "collection")) {
            pane.addTab(B.get((String)"AdminPanel.collectionPanel.TabConstraints.tabTitle", (Locale)this.locale), ResourceLoader.getIcon((String)"/icon/x48/edit-copy.png"), this.adminScreen.getAdminPanel().getCollectionPanel().getPanel());
        }
        if (UsersUtil.canShowTab(user, "log")) {
            pane.addTab(B.get((String)"AdminPanel.logPanel.TabConstraints.tabTitle", (Locale)this.locale), ResourceLoader.getIcon((String)"/icon/x48/logs.png"), this.adminScreen.getAdminPanel().getLogPanel());
        }
        if (UsersUtil.canShowTab(user, "cash")) {
            CashPanel c = this.adminScreen.getAdminPanel().getCashPanel();
            pane.addTab(B.get((String)"AdminPanel.cashPanel.TabConstraints.tabTitle", (Locale)this.locale), ResourceLoader.getIcon((String)"/icon/x48/cash.png"), c.getPanel());
            c.getCashMoneyCollection().setEnabled(UsersUtil.canShowButton(user, "cash", "cashMoneyCollection"));
            c.getCoinMoneyCollection().setEnabled(UsersUtil.canShowButton(user, "cash", "coinMoneyCollection"));
        }
        pane.addTab(B.get((String)"AdminPanel.paymentsPanel.TabConstraints.tabTitle", (Locale)this.locale), ResourceLoader.getIcon((String)"/icon/x48/payments.png"), this.adminScreen.getAdminPanel().getPaymentsPanel().getPanel());
        if (UsersUtil.canShowTab(user, "states")) {
            pane.addTab(B.get((String)"AdminPanel.statesPanel.TabConstraints.tabTitle", (Locale)this.locale), ResourceLoader.getIcon((String)"/icon/x48/hwinfo.png"), this.adminScreen.getAdminPanel().getStatesPanel().getPanel());
        }
        this.context.showScreen(this.adminScreen);
    }

    public QueueAgentListener getQueueAgentListener() {
        return this.queueAgentListener;
    }

    @Override
    protected void _restore() {
        this.context.showScreen(this.adminScreen);
    }

    public void errorEvent(String comment) {
    }

    private void refreshNetworkInfo() {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                AdminInputModule.this.statesPanel.getDiskSpaceLabel().setText("" + (int)(new File(PathUtils.getAppHome()).getUsableSpace() / 0x100000L));
                if (AdminInputModule.this.errCount == null) {
                    AdminInputModule.this.statesPanel.getNetworkLabel().setText("-");
                    AdminInputModule.this.statesPanel.getNetworkLabel().setForeground(null);
                    AdminInputModule.this.statesPanel.getLastConnectLabel().setText("-");
                    AdminInputModule.this.statesPanel.getLastConnectLabel().setForeground(null);
                } else if (AdminInputModule.this.errCount == 0) {
                    AdminInputModule.this.statesPanel.getNetworkLabel().setText(B.get((String)"ServiceMenu.status.ok"));
                    AdminInputModule.this.statesPanel.getNetworkLabel().setForeground(AdminInputModule.this.okColor);
                    AdminInputModule.this.statesPanel.getLastConnectLabel().setText("" + (new Date().getTime() - AdminInputModule.this.lastConnect.getTime()) / 60000L);
                    AdminInputModule.this.statesPanel.getLastConnectLabel().setForeground(AdminInputModule.this.okColor);
                } else {
                    AdminInputModule.this.statesPanel.getNetworkLabel().setText(MessageFormat.format(B.get((String)"ServiceMenu.status.net-error"), AdminInputModule.this.errCount));
                    AdminInputModule.this.statesPanel.getNetworkLabel().setForeground(Color.red);
                    if (AdminInputModule.this.lastConnect != null) {
                        AdminInputModule.this.statesPanel.getLastConnectLabel().setText("" + (new Date().getTime() - AdminInputModule.this.lastConnect.getTime()) / 60000L);
                    } else {
                        AdminInputModule.this.statesPanel.getLastConnectLabel().setText("-");
                    }
                    AdminInputModule.this.statesPanel.getLastConnectLabel().setForeground(Color.red);
                }
                Operation[] ops = AdminInputModule.this.context.getServerConnector().getQueue().getAllOperations();
                AdminInputModule.this.statesPanel.getQueueLabel().setText("" + (ops == null ? 0 : ops.length));
                AdminInputModule.this.mainPanel.getUnloadPaymentsButton().setEnabled(ops != null);
            }
        });
    }

    private void updateStates() {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (AdminInputModule.this.validatorStatus == null) {
                    AdminInputModule.this.statesPanel.getCashLabel().setText("-");
                    AdminInputModule.this.statesPanel.getCashLabel().setForeground(null);
                } else if (AdminInputModule.this.validatorStatus.isError()) {
                    AdminInputModule.this.statesPanel.getCashLabel().setText(B.get((String)"ServiceMenu.status.error", (Locale)AdminInputModule.this.locale));
                    AdminInputModule.this.statesPanel.getCashLabel().setForeground(Color.red);
                } else {
                    AdminInputModule.this.statesPanel.getCashLabel().setText(B.get((String)"ServiceMenu.status.ok", (Locale)AdminInputModule.this.locale));
                    AdminInputModule.this.statesPanel.getCashLabel().setForeground(AdminInputModule.this.okColor);
                }
                if (AdminInputModule.this.printerStatus == null) {
                    AdminInputModule.this.statesPanel.getPrinterLabel().setText("-");
                    AdminInputModule.this.statesPanel.getPrinterLabel().setForeground(null);
                } else if (!AdminInputModule.this.printerStatus.isWork()) {
                    AdminInputModule.this.statesPanel.getPrinterLabel().setText(B.get((String)"ServiceMenu.status.error", (Locale)AdminInputModule.this.locale));
                    AdminInputModule.this.statesPanel.getPrinterLabel().setForeground(Color.red);
                } else {
                    AdminInputModule.this.statesPanel.getPrinterLabel().setText(B.get((String)"ServiceMenu.status.ok", (Locale)AdminInputModule.this.locale));
                    AdminInputModule.this.statesPanel.getPrinterLabel().setForeground(AdminInputModule.this.okColor);
                }
                if (AdminInputModule.this.remoteStatus == null) {
                    AdminInputModule.this.statesPanel.getStateLabel().setText("-");
                    AdminInputModule.this.statesPanel.getStateLabel().setForeground(null);
                } else if ((AdminInputModule.this.remoteStatus & 1) != 0) {
                    AdminInputModule.this.statesPanel.getStateLabel().setText(B.get((String)"ServiceMenu.status.lock", (Locale)AdminInputModule.this.locale));
                    AdminInputModule.this.statesPanel.getStateLabel().setForeground(Color.red);
                } else {
                    AdminInputModule.this.statesPanel.getStateLabel().setText(B.get((String)"ServiceMenu.status.ok", (Locale)AdminInputModule.this.locale));
                    AdminInputModule.this.statesPanel.getStateLabel().setForeground(AdminInputModule.this.okColor);
                }
            }
        });
    }

    private void dispenserCollection() {
    }

    public String toString() {
        return "AdminProvider";
    }

    private class CollectionNominalScreenListener
    extends ScreenAdapter {
        private CollectionNominalScreenListener() {
        }

        public void onAction(String action, Map<String, Object> data, Runnable cancelListener) {
            if (ActionType.isNext((String)action)) {
                Object obj = data.get("nominal");
                if (obj instanceof InputElement) {
                    InputElement ie = (InputElement)obj;
                    if (ie.getValue() != null && ie.getValue().matches("^\\d{1,5}$")) {
                        int nominal = Integer.parseInt(ie.getValue());
                        Keeper k = AdminInputModule.this.coinCollectionHandler.getBox().getKeeper();
                        final Keeper keeper = new Keeper();
                        CashUnit cu = null;
                        for (Map.Entry e : k.getCashUnits().entrySet()) {
                            if (nominal != ((CashUnit)e.getKey()).getNominal().getBasicSum()) continue;
                            cu = (CashUnit)e.getKey();
                            keeper.addCash((CashUnit)e.getKey(), ((Integer)e.getValue()).intValue());
                            break;
                        }
                        if (cu != null && !keeper.getSum().isEmpty()) {
                            if (AdminInputModule.this.coinCollectionHandler != null) {
                                AdminInputModule.this.coinCollectionHandler.onMoneyCollection(AdminInputModule.this.menuUser, cu);
                                AdminInputModule.this.adminScreen.getAdminPanel().getCashPanel().setCashInfo(AdminInputModule.this.cashCollectionHandler.getBox(), AdminInputModule.this.coinCollectionHandler.getBox());
                            }
                            if (Hopper.getDefaultHopper() != null) {
                                DialogScreen dialog = ComponentFactory.getInstance().createDialog(DialogType.Question, B.get((String)"ServiceMenu.collection.dispense.select", (Locale)AdminInputModule.this.locale), 20, DC.cases((int)16, (Locale)AdminInputModule.this.locale, (Object[])new Object[0]), UserCase.Cancel);
                                dialog.addListener(new DialogListener(){

                                    public void dialogClosed(UserCase userCase) {
                                        try {
                                            if (userCase == UserCase.Ok) {
                                                AdminInputModule.this.log.info((Object)"Dispense on top");
                                                Hopper.getDefaultHopper().clear((DispenseListener)new DispenseAdapter(false), 1, keeper);
                                            } else {
                                                AdminInputModule.this.log.info((Object)"Dispense on bottom");
                                                Hopper.getDefaultHopper().clear((DispenseListener)new DispenseAdapter(false), 0, keeper);
                                            }
                                        }
                                        catch (HopperException ex) {
                                            AdminInputModule.this.log.error((Object)ex, (Throwable)ex);
                                            DialogScreen d = ComponentFactory.getInstance().createDialog(DialogType.Question, MessageFormat.format(B.get((String)"ServiceMenu.collection.dispense.select", (Locale)AdminInputModule.this.locale), ex.getMessage()), 15, DC.cases((int)8, (Locale)AdminInputModule.this.locale, (Object[])new Object[0]), UserCase.Ok);
                                            AdminInputModule.this.context.showDialog((DialogInterface)d);
                                        }
                                        catch (IOException ex) {
                                            AdminInputModule.this.log.error((Object)ex, (Throwable)ex);
                                        }
                                    }
                                });
                                AdminInputModule.this.context.showDialog((DialogInterface)dialog);
                            }
                        } else {
                            AdminInputModule.this.log.info((Object)("\u041d\u043e\u043c\u0438\u043d\u0430\u043b " + nominal + " \u043e\u0442\u0441\u0443\u0442\u0441\u0442\u0432\u0443\u0435\u0442 \u0432 \u043a\u043e\u0448\u0435\u043b\u044c\u043a\u0435 " + k));
                        }
                    } else {
                        AdminInputModule.this.adminListener.onCoinMoneyCollection();
                    }
                } else {
                    AdminInputModule.this.adminListener.onCoinMoneyCollection();
                }
            }
            AdminInputModule.this._restore();
        }
    }

    private class RequestTestFiscalServer
    implements Task {
        private RequestTestFiscalServer() {
        }

        @Override
        public Object execute() {
            try {
                AdminInputModule.this.log.info((Object)"\u0417\u0430\u043f\u0440\u0430\u0448\u0438\u0432\u0430\u044e \u0441\u0442\u0430\u0442\u0443\u0441 \u0444\u0438\u0441\u043a\u0430\u043b\u044c\u043d\u043e\u0433\u043e \u0441\u0435\u0440\u0432\u0435\u0440\u0430");
                return AdminInputModule.this.context.getPrinterQueue().getFiscalServerStatus();
            }
            catch (Exception ex) {
                return ex;
            }
        }

        @Override
        public void onResult(Object object) {
            if (object instanceof Integer) {
                Integer val = (Integer)object;
                if (val == 0) {
                    DialogScreen dialog = ComponentFactory.getInstance().createDialog(DialogType.Info, B.get((String)"Module.print.fiscal.client.request.success", (Locale)AdminInputModule.this.locale), 15, DC.cases((int)1, (Locale)AdminInputModule.this.locale, (Object[])new Object[0]), UserCase.Ok);
                    AdminInputModule.this.context.showDialog((DialogInterface)dialog);
                } else {
                    DialogScreen dialog = ComponentFactory.getInstance().createDialog(DialogType.Info, MessageFormat.format(B.get((String)"Module.print.fiscal.client.request.error", (Locale)AdminInputModule.this.locale), val), 15, DC.cases((int)1, (Locale)AdminInputModule.this.locale, (Object[])new Object[0]), UserCase.Ok);
                    AdminInputModule.this.context.showDialog((DialogInterface)dialog);
                }
            } else if (object instanceof IOException) {
                DialogScreen dialog = ComponentFactory.getInstance().createDialog(DialogType.Error, MessageFormat.format(B.get((String)"Module.print.fiscal.client.request.failure", (Locale)AdminInputModule.this.locale), B.get((String)"Module.print.fiscal.client.notinit")), 15, DC.cases((int)1, (Locale)AdminInputModule.this.locale, (Object[])new Object[0]), UserCase.Ok);
                AdminInputModule.this.context.showDialog((DialogInterface)dialog);
            } else if (object instanceof UnsupportedOperationException) {
                DialogScreen dialog = ComponentFactory.getInstance().createDialog(DialogType.Error, MessageFormat.format(B.get((String)"Module.print.fiscal.client.request.failure", (Locale)AdminInputModule.this.locale), B.get((String)"Module.print.fiscal.client.notclient")), 15, DC.cases((int)1, (Locale)AdminInputModule.this.locale, (Object[])new Object[0]), UserCase.Ok);
                AdminInputModule.this.context.showDialog((DialogInterface)dialog);
            } else if (object instanceof Exception) {
                DialogScreen dialog = ComponentFactory.getInstance().createDialog(DialogType.Error, MessageFormat.format(B.get((String)"Module.print.fiscal.client.request.failure", (Locale)AdminInputModule.this.locale), object), 15, DC.cases((int)1, (Locale)AdminInputModule.this.locale, (Object[])new Object[0]), UserCase.Ok);
                AdminInputModule.this.context.showDialog((DialogInterface)dialog);
            }
        }

        @Override
        public String getMessage() {
            return B.get((String)"Request.wait", (Locale)AdminInputModule.this.locale);
        }
    }

    private class RequestMoneyCollections
    implements Task {
        private RequestMoneyCollections() {
        }

        @Override
        public Object execute() {
            try {
                AdminInputModule.this.log.info((Object)"\u0417\u0430\u043f\u0440\u0430\u0448\u0438\u0432\u0430\u044e \u0438\u043d\u043a\u0430\u0441\u0441\u0430\u0446\u0438\u0438 \u0441 \u0441\u0435\u0440\u0432\u0435\u0440\u0430");
                return AdminInputModule.this.context.getServerConnector().getCollections();
            }
            catch (Exception ex) {
                return ex;
            }
        }

        @Override
        public void onResult(Object object) {
            if (object instanceof MoneyCollection[]) {
                MoneyCollection[] mcs = (MoneyCollection[])object;
                if (mcs == null || mcs.length == 0) {
                    DialogScreen dialog = ComponentFactory.getInstance().createDialog(DialogType.Info, B.get((String)"ServiceMenu.collection.notfound", (Locale)AdminInputModule.this.locale), 15, DC.cases((int)1, (Locale)AdminInputModule.this.locale, (Object[])new Object[0]), UserCase.Ok);
                    AdminInputModule.this.context.showDialog((DialogInterface)dialog);
                } else {
                    AdminInputModule.this.adminScreen.setMoneyCollections(mcs);
                }
            } else if (object instanceof Exception) {
                DialogScreen dialog = ComponentFactory.getInstance().createDialog(DialogType.Error, MessageFormat.format(B.get((String)"ServiceMenu.collection.failure", (Locale)AdminInputModule.this.locale), object), 15, DC.cases((int)1, (Locale)AdminInputModule.this.locale, (Object[])new Object[0]), UserCase.Ok);
                AdminInputModule.this.context.showDialog((DialogInterface)dialog);
            }
        }

        @Override
        public String getMessage() {
            return B.get((String)"Request.wait", (Locale)AdminInputModule.this.locale);
        }
    }

    private class CheckBalanceTask
    implements Task {
        private CheckBalanceTask() {
        }

        @Override
        public Object execute() {
            try {
                return AdminInputModule.this.context.getServerConnector().getBalance(AdminInputModule.this.menuUser.getId());
            }
            catch (ConnectorException ex) {
                return ex;
            }
        }

        @Override
        public void onResult(Object object) {
            DialogType dt;
            String text = null;
            if (object instanceof Long) {
                text = MessageFormat.format(B.get((String)"ServiceMenu.balans.result", (Locale)AdminInputModule.this.locale), SumFormatter.format((int)((Long)object).intValue()));
                dt = DialogType.Info;
            } else if (object instanceof Exception) {
                text = MessageFormat.format(B.get((String)"ServiceMenu.balans.failure", (Locale)AdminInputModule.this.locale), object);
                dt = DialogType.Error;
            } else {
                text = "?";
                dt = DialogType.Error;
            }
            DialogScreen dialog = ComponentFactory.getInstance().createDialog(dt, text, 15, DC.cases((int)1, (Locale)AdminInputModule.this.locale, (Object[])new Object[0]), UserCase.Ok);
            AdminInputModule.this.context.showDialog((DialogInterface)dialog);
        }

        @Override
        public String getMessage() {
            return B.get((String)"Request.wait", (Locale)AdminInputModule.this.locale);
        }
    }

    private class NetworkTest
    implements Task {
        private NetworkTest() {
        }

        @Override
        public Object execute() {
            try {
                return AdminInputModule.this.context.getServerConnector().ping();
            }
            catch (ConnectorException ex) {
                return ex;
            }
        }

        @Override
        public void onResult(Object object) {
            DialogType dt;
            String text = null;
            if (object == null || object instanceof Date) {
                text = B.get((String)"ServiceMenu.network-test.result", (Locale)AdminInputModule.this.locale);
                dt = DialogType.Info;
            } else if (object instanceof Exception) {
                text = B.get((String)"ServiceMenu.network-test.failure", (Locale)AdminInputModule.this.locale);
                dt = DialogType.Error;
            } else {
                text = "?";
                dt = DialogType.Error;
            }
            DialogScreen dialog = ComponentFactory.getInstance().createDialog(dt, text, 15, DC.cases((int)1, (Locale)AdminInputModule.this.locale, (Object[])new Object[0]), UserCase.Ok);
            AdminInputModule.this.context.showDialog((DialogInterface)dialog);
        }

        @Override
        public String getMessage() {
            return B.get((String)"Request.wait");
        }
    }

    private class ReportByRangerScreenListener
    extends ScreenAdapter {
        private Date start;
        private Date end;
        private boolean detailed;

        public ReportByRangerScreenListener(Date start, Date end, boolean detailed) {
            this.start = start;
            this.end = end;
            this.detailed = detailed;
        }

        public void onAction(String action, Map<String, Object> data, Runnable cancelListener) {
            Object obj = data.get("password");
            if (obj instanceof InputElement) {
                InputElement ie = (InputElement)obj;
                AdminInputModule.this.context.getTaskExecutor().execute(new ReportByDateTask(new ReportByDate(this.start, this.end, this.detailed, ie.getValue()), AdminInputModule.this.context));
                AdminInputModule.this.updateStates();
                AdminInputModule.this.refreshNetworkInfo();
                AdminInputModule.this.initTabs(AdminInputModule.this.menuUser);
                if (UsersUtil.canShowTab(AdminInputModule.this.menuUser, "kkm")) {
                    AdminPanel adminPanel = AdminInputModule.this.adminScreen.getAdminPanel();
                    int idx = -1;
                    if (AdminInputModule.this.context.getPrinterQueue().getPrinterType() == PrinterType.Kkm) {
                        idx = adminPanel.getTabbedPane().indexOfComponent(adminPanel.getKkmPanel().getPanel());
                    } else if (AdminInputModule.this.context.getPrinterQueue().getPrinterType() == PrinterType.KkmOnline) {
                        idx = adminPanel.getTabbedPane().indexOfComponent(adminPanel.getKkmOnlinePanel().getPanel());
                    }
                    if (idx != -1) {
                        AdminInputModule.this.adminScreen.getAdminPanel().getTabbedPane().setSelectedIndex(idx);
                    }
                }
            }
        }
    }

    private class CommonScreenListener
    extends ScreenAdapter {
        private CommonScreenListener() {
        }

        public void onAction(String action, Map<String, Object> data, final Runnable cancelListener) {
            if (ActionType.isExit((String)action)) {
                AdminInputModule.this.cancel(null);
            } else if (ActionType.isPrev((String)action)) {
                AdminInputModule.this.cancel(null);
            } else if (ActionType.isNext((String)action)) {
                InputElement login = (InputElement)data.get("login");
                InputElement pass = (InputElement)data.get("password");
                AdminInputModule.this.menuUser = UsersUtil.authentication(login.getValue(), pass.getValue());
                if (AdminInputModule.this.menuUser != null && AdminInputModule.this.menuUser.getAccessList() != null && !AdminInputModule.this.menuUser.getAccessList().isEmpty()) {
                    AdminInputModule.this.log.info((Object)"Authentification procedure passed. Open service menu");
                    AdminInputModule.this.log.info((Object)("User permissions: " + AdminInputModule.this.menuUser.getAccessList()));
                    AdminInputModule.this.context.getServerConnector().sendEvent(new Event(EventType.ServiceMenuLogin, "login=" + AdminInputModule.this.menuUser.getLogin() + ",fio=" + AdminInputModule.this.menuUser.getFio()));
                    AdminInputModule.this.updateStates();
                    AdminInputModule.this.refreshNetworkInfo();
                    AdminInputModule.this.initTabs(AdminInputModule.this.menuUser);
                } else {
                    EventQueue.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            DialogScreen dialog = ComponentFactory.getInstance().createDialog(DialogType.Error, B.get((String)"ServiceMenu.open.error", (Locale)AdminInputModule.this.locale), 6, DC.cases((int)3, (Locale)AdminInputModule.this.locale, (Object[])new Object[0]), UserCase.Ok);
                            dialog.addListener(new DialogListener(){

                                public void dialogClosed(final UserCase userCase) {
                                    EventQueue.invokeLater(new Runnable(){

                                        @Override
                                        public void run() {
                                            if (userCase == UserCase.Cancel) {
                                                AdminInputModule.this.cancel(null);
                                            } else {
                                                ModuleHelper.invoke(cancelListener);
                                            }
                                        }
                                    });
                                }
                            });
                            AdminInputModule.this.context.showDialog((DialogInterface)dialog);
                        }
                    });
                }
            }
        }
    }

    private class LocalQueueAgentListener
    implements QueueAgentListener {
        private int prevSize;

        private LocalQueueAgentListener() {
        }

        @Override
        public void onPaymentsInfo(Operation[] operations, GroupOperation[] groupOperations, MoneyCollection[] moneyCollections) {
            int size = 0;
            if (operations != null) {
                size += operations.length;
            }
            if (groupOperations != null) {
                size += groupOperations.length;
            }
            if (moneyCollections != null) {
                size += moneyCollections.length;
            }
            if (this.prevSize == size) {
                return;
            }
            this.prevSize = size;
            LinkedList<PaymentsCollectionRecord> records = new LinkedList<PaymentsCollectionRecord>();
            if (operations != null) {
                for (Operation operation : operations) {
                    records.add(new PaymentsCollectionRecord(B.get((String)"AdminPanel.paymentsPanel.type.operation", (Locale)AdminInputModule.this.locale), operation.getDate(), (String)operation.getViews().get("id1"), operation.getSumResult().getIncome()));
                }
            }
            if (groupOperations != null) {
                for (Operation operation : groupOperations) {
                    records.add(new PaymentsCollectionRecord(B.get((String)"AdminPanel.paymentsPanel.type.operation", (Locale)AdminInputModule.this.locale), operation.getDate(), (String)operation.getViews().get("id1"), operation.getSumResult().getIncome()));
                }
            }
            if (moneyCollections != null) {
                for (Operation operation : moneyCollections) {
                    records.add(new PaymentsCollectionRecord(B.get((String)"AdminPanel.paymentsPanel.type.collection", (Locale)AdminInputModule.this.locale), operation.getDate(), "-", operation.getKeeper().getSum()));
                }
            }
            Collections.sort(records);
            AdminInputModule.this.adminScreen.setPaymentsCollection(records.toArray(new PaymentsCollectionRecord[records.size()]));
        }
    }

    private class LocalAdminListener
    implements AdminListener {
        private LocalAdminListener() {
        }

        @Override
        public void onCashMoneyCollection() {
            if (AdminInputModule.this.cashCollectionHandler != null) {
                AdminInputModule.this.cashCollectionHandler.onMoneyCollection(AdminInputModule.this.menuUser);
                AdminInputModule.this.adminScreen.getAdminPanel().getCashPanel().setCashInfo(AdminInputModule.this.cashCollectionHandler.getBox(), AdminInputModule.this.coinCollectionHandler.getBox());
                String moneyCollScript = SystemProp.getMoneyCollScript();
                if (moneyCollScript != null && !moneyCollScript.isEmpty()) {
                    try {
                        OsApi.getInstance().runScript(PathUtils.getAppHome() + "/bin/" + moneyCollScript, new String[]{Integer.toString(AdminInputModule.this.environment.getPoint().getId()), Integer.toString(AdminInputModule.this.menuUser.getId()), AdminInputModule.this.menuUser.getLogin(), AdminInputModule.this.menuUser.getPassword()});
                    }
                    catch (OsException ex) {
                        AdminInputModule.this.log.error((Object)"Cant unlock.", (Throwable)ex);
                    }
                }
            }
        }

        @Override
        public void onExitConfigurator() {
            AdminInputModule.this.log.info((Object)"\u0412\u044b\u0448\u043b\u0438 \u0432 \u0433\u043b\u0430\u0432\u043d\u043e\u0435 \u043c\u0435\u043d\u044e");
            AdminInputModule.this.cancel(null);
        }

        @Override
        public void onReportX() {
            AdminInputModule.this.context.getTaskExecutor().execute(new ReportTask(KkmOperation.FormReportX, AdminInputModule.this.context));
        }

        @Override
        public void onReportZ() {
            AdminInputModule.this.context.getTaskExecutor().execute(new ReportTask(KkmOperation.FormReportZ, AdminInputModule.this.context));
        }

        @Override
        public void onReportZMem() {
            AdminInputModule.this.context.getTaskExecutor().execute(new ReportTask(KkmOperation.FormReportZMem, AdminInputModule.this.context));
        }

        @Override
        public void onReportZCopy(int copyCount) {
            AdminInputModule.this.context.getTaskExecutor().execute(new ReportCopyTask(copyCount, AdminInputModule.this.context));
        }

        @Override
        public void onReportZService() {
            try {
                ServiceZReportStorage storage = ServiceZReportStorage.getInstance();
                AdminInputModule.this.log.info((Object)("onReportZService: \u0412\u0441\u0435\u0433\u043e \u0421\u0435\u0440\u0432\u0438\u0441\u043d\u044b\u0445 z-\u043e\u0442\u0447\u0451\u0442\u043e\u0432: " + storage.getSnapshots().size()));
                if (storage.getSnapshots().isEmpty()) {
                    AdminInputModule.this.log.info((Object)"No Snapshots of service z-report");
                    DialogScreen dlg = ComponentFactory.getInstance().createDialog(DialogType.Error, B.get((String)"AdminPanel.zreport.empty", (Locale)AdminInputModule.this.environment.getLocale()), 10, DC.cases((int)1), UserCase.Ok);
                    AdminInputModule.this.context.showDialog((DialogInterface)dlg);
                } else {
                    Sum historySum = new Sum(0);
                    int historyCount = 0;
                    for (int i = 0; i < storage.getSnapshots().size(); ++i) {
                        ServiceZReportStorage.ServiceZReportSnapshot snap = (ServiceZReportStorage.ServiceZReportSnapshot)storage.getSnapshots().get(i);
                        historySum = historySum.add(snap.getAllCurrentSum());
                        historyCount += snap.getAllCurrentCount();
                        CustomData doc = new CustomData();
                        doc.setTemplate("service-z-report");
                        doc.setCustomData(new HashMap());
                        if (AdminInputModule.this.environment != null && AdminInputModule.this.environment.getPoint() != null && AdminInputModule.this.environment.getPoint().getAttributes() != null) {
                            doc.getCustomData().putAll(AdminInputModule.this.environment.getPoint().getAttributes());
                        }
                        doc.getCustomData().put("zreportdate", snap.getCreatedDate().toString());
                        doc.getCustomData().put("user", AdminInputModule.this.menuUser);
                        doc.getCustomData().put("coinboxkeeper", AdminInputModule.this.coinCollectionHandler.getBox().getKeeper());
                        doc.getCustomData().put("cashboxkeeper", AdminInputModule.this.cashCollectionHandler.getBox().getKeeper());
                        doc.getCustomData().putAll(snap.toMap());
                        doc.getCustomData().put("resultsum", historySum);
                        doc.getCustomData().put("resultcount", historySum);
                        AdminInputModule.this.log.info((Object)("doc.getCustomData() = " + (doc != null && doc.getCustomData() != null ? doc.getCustomData().toString() : "")));
                        AdminInputModule.this.context.getPrinterQueue().printCustomDocument(doc);
                    }
                }
            }
            catch (Exception ex) {
                AdminInputModule.this.log.error((Object)ex.getMessage());
                AdminInputModule.this.log.error((Object)("onReportZService.exception = " + Arrays.toString(ex.getStackTrace())));
            }
        }

        @Override
        public void onRebootTerminal() {
            AdminInputModule.this.log.info((Object)"\u041f\u0435\u0440\u0435\u0437\u0430\u0433\u0440\u0443\u0437\u043a\u0430 \u0442\u0435\u0440\u043c\u0438\u043d\u0430\u043b\u0430. \u041f\u0440\u043e\u0448\u0443 \u043f\u043e\u0434\u0442\u0432\u0435\u0440\u0436\u0434\u0435\u043d\u0438\u044f");
            DialogScreen dialog = ComponentFactory.getInstance().createDialog(DialogType.Question, B.get((String)"ServiceMenu.reboot.confirm", (Locale)AdminInputModule.this.locale), 15, DC.cases((int)2, (Locale)AdminInputModule.this.locale, (Object[])new Object[0]), UserCase.Cancel);
            dialog.addListener(new DialogListener(){

                public void dialogClosed(UserCase userCase) {
                    if (userCase == UserCase.Ok) {
                        AdminInputModule.this.log.info((Object)"\u041f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u044c \u043f\u043e\u0434\u0442\u0432\u0435\u0440\u0434\u0438\u043b \u043f\u0435\u0440\u0435\u0437\u0430\u0433\u0440\u0443\u0437\u043a\u0443");
                        SafeReboot.getInstance().reboot();
                    } else {
                        AdminInputModule.this.log.info((Object)"\u041f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u044c \u043e\u0442\u043c\u0435\u043d\u0438\u043b \u043f\u0435\u0440\u0435\u0437\u0430\u0433\u0440\u0443\u0437\u043a\u0443");
                    }
                }
            });
            AdminInputModule.this.context.showDialog((DialogInterface)dialog);
        }

        @Override
        public void onRestartSoftware() {
            AdminInputModule.this.log.info((Object)"\u0417\u0430\u043a\u0440\u044b\u0442\u0438\u0435 \u041f\u041e. \u041f\u0440\u043e\u0448\u0443 \u043f\u043e\u0434\u0442\u0432\u0435\u0440\u0436\u0434\u0435\u043d\u0438\u044f");
            DialogScreen dialog = ComponentFactory.getInstance().createDialog(DialogType.Question, B.get((String)"ServiceMenu.restart.confirm", (Locale)AdminInputModule.this.locale), 15, DC.cases((int)2, (Locale)AdminInputModule.this.locale, (Object[])new Object[0]), UserCase.Cancel);
            dialog.addListener(new DialogListener(){

                public void dialogClosed(UserCase userCase) {
                    if (userCase == UserCase.Ok) {
                        DaemonUtil.createExitFlag((String)"_flag_servmenu");
                        AdminInputModule.this.log.info((Object)"\u041f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u044c \u043f\u043e\u0434\u0442\u0432\u0435\u0440\u0434\u0438\u043b \u0437\u0430\u043a\u0440\u044b\u0442\u0438\u0435 \u041f\u041e");
                        System.exit(0);
                    } else {
                        AdminInputModule.this.log.info((Object)"\u041f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u044c \u043e\u0442\u043c\u0435\u043d\u0438\u043b \u0437\u0430\u043a\u0440\u044b\u0442\u0438\u0435 \u041f\u041e");
                    }
                }
            });
            AdminInputModule.this.context.showDialog((DialogInterface)dialog);
        }

        @Override
        public void onConnect() {
        }

        @Override
        public void onMinimizeSoftware() {
            if (AdminInputModule.this.frameMaximizer != null) {
                AdminInputModule.this.frameMaximizer.setMinimized(true);
            }
            FrameStore.getFrame().setState(1);
        }

        @Override
        public void onCoinMoneyCollection() {
            final Keeper keeper = AdminInputModule.this.coinCollectionHandler.getBox().getKeeper();
            if (AdminInputModule.this.coinCollectionHandler != null) {
                AdminInputModule.this.coinCollectionHandler.onMoneyCollection(AdminInputModule.this.menuUser);
                AdminInputModule.this.adminScreen.getAdminPanel().getCashPanel().setCashInfo(AdminInputModule.this.cashCollectionHandler.getBox(), AdminInputModule.this.coinCollectionHandler.getBox());
            }
            if (Hopper.getDefaultHopper() != null) {
                DialogScreen dialog = ComponentFactory.getInstance().createDialog(DialogType.Question, B.get((String)"ServiceMenu.collection.dispense.select", (Locale)AdminInputModule.this.locale), 20, DC.cases((int)16, (Locale)AdminInputModule.this.locale, (Object[])new Object[0]), UserCase.Cancel);
                dialog.addListener(new DialogListener(){

                    public void dialogClosed(UserCase userCase) {
                        try {
                            if (userCase == UserCase.Ok) {
                                AdminInputModule.this.log.info((Object)"Dispense on top");
                                Hopper.getDefaultHopper().clear((DispenseListener)new DispenseAdapter(false), 1, keeper);
                            } else {
                                AdminInputModule.this.log.info((Object)"Dispense on bottom");
                                Hopper.getDefaultHopper().clear((DispenseListener)new DispenseAdapter(false), 0, keeper);
                            }
                        }
                        catch (HopperException ex) {
                            AdminInputModule.this.log.error((Object)ex, (Throwable)ex);
                            DialogScreen d = ComponentFactory.getInstance().createDialog(DialogType.Error, MessageFormat.format(B.get((String)"ServiceMenu.collection.dispense.failure", (Locale)AdminInputModule.this.locale), ex.getMessage()), 15, DC.cases((int)8, (Locale)AdminInputModule.this.locale, (Object[])new Object[0]), UserCase.Ok);
                            AdminInputModule.this.context.showDialog((DialogInterface)d);
                        }
                        catch (IOException ex) {
                            AdminInputModule.this.log.error((Object)ex, (Throwable)ex);
                        }
                    }
                });
                AdminInputModule.this.context.showDialog((DialogInterface)dialog);
            }
        }

        @Override
        public void onCoinMoneyCollectionNominal() {
            Keeper keeper = AdminInputModule.this.coinCollectionHandler.getBox().getKeeper();
            if (keeper.getSum().isEmpty()) {
                DialogScreen dialog = ComponentFactory.getInstance().createDialog(DialogType.Info, B.get((String)"ServiceMenu.collection.keeper.empty", (Locale)AdminInputModule.this.locale), 15, DC.cases((int)8, (Locale)AdminInputModule.this.locale, (Object[])new Object[0]), UserCase.Cancel);
                AdminInputModule.this.context.showDialog((DialogInterface)dialog);
                return;
            }
            SelectorField sf = new SelectorField();
            sf.setId("nominal");
            sf.setTitle(B.get((String)"ServiceMenu.collection.nominal.title", (Locale)AdminInputModule.this.environment.getLocale()));
            sf.setHelp(B.get((String)"ServiceMenu.collection.nominal.help", (Locale)AdminInputModule.this.environment.getLocale()));
            LinkedList<SelectorItem> items = new LinkedList<SelectorItem>();
            for (Map.Entry e : keeper.getCashUnits().entrySet()) {
                if (e.getValue() == null || (Integer)e.getValue() <= 0) continue;
                items.add(new SelectorItem(((CashUnit)e.getKey()).getNominal().toString(), "" + ((CashUnit)e.getKey()).getNominal().getBasicSum()));
            }
            items.add(new SelectorItem(B.get((String)"ServiceMenu.collection.nominal.all", (Locale)AdminInputModule.this.environment.getLocale()), null));
            sf.setStore((ItemsStore)new StaticStore(items));
            FieldSequence fs = new FieldSequence(Arrays.asList(sf));
            UniScreenDescription sd = new UniScreenDescription("selector");
            sd.setDecor("button");
            sd.setSequence(fs);
            sd.setTitle(B.get((String)"ServiceMenu.collection.screen.title", (Locale)AdminInputModule.this.environment.getLocale()));
            CommonScreen cs = CommonScreenStore.getScreen((String)"selector");
            ScreenInit si = new ScreenInit(AdminInputModule.this.environment.getMenuItem().getService(), AdminInputModule.this.environment.getMenuItem().getCommission(), AdminInputModule.this.environment.getDealer(), AdminInputModule.this.environment.getPoint(), new HashMap(), null, 0, 0, AdminInputModule.this.environment.getLocale(), null, null, AdminInputModule.this.environment.isPrinterError(), AdminInputModule.this.environment.getAllowedNotes(), AdminInputModule.this.environment.getAllowedCoins(), AdminInputModule.this.environment.getDateOfStartPayment(), null, AdminInputModule.this.environment.getMenuItem(), null);
            try {
                cs.init((ScreenDescription)sd, si);
                cs.setListener((ScreenListener)new CollectionNominalScreenListener());
                AdminInputModule.this.context.showScreen(new ContentScreenAdapterKbr(cs));
            }
            catch (InitException ex) {
                AdminInputModule.this.log.error((Object)ex, (Throwable)ex);
            }
        }

        @Override
        public void onFlowDownCoinMoneyCollection() {
            if (AdminInputModule.this.coinCollectionHandler != null) {
                AdminInputModule.this.coinCollectionHandler.onFlowDownMoneyCollection(AdminInputModule.this.menuUser);
            }
        }

        @Override
        public void onPowerOffTerminal() {
            AdminInputModule.this.log.info((Object)"\u0412\u044b\u043a\u043b\u044e\u0447\u0435\u043d\u0438\u0435 \u0442\u0435\u0440\u043c\u0438\u043d\u0430\u043b\u0430");
            DialogScreen dialog = ComponentFactory.getInstance().createDialog(DialogType.Question, B.get((String)"ServiceMenu.poweroff.confirm", (Locale)AdminInputModule.this.locale), 15, DC.cases((int)2, (Locale)AdminInputModule.this.locale, (Object[])new Object[0]), UserCase.Cancel);
            dialog.addListener(new DialogListener(){

                public void dialogClosed(UserCase userCase) {
                    if (userCase == UserCase.Ok) {
                        AdminInputModule.this.log.info((Object)"\u041f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u044c \u043f\u043e\u0434\u0442\u0432\u0435\u0440\u0434\u0438\u043b \u0432\u044b\u043a\u043b\u044e\u0447\u0435\u043d\u0438\u0435 \u0442\u0435\u0440\u043c\u0438\u043d\u0430\u043b\u0430");
                        SafeReboot.getInstance().poweroff();
                    } else {
                        AdminInputModule.this.log.info((Object)"\u041f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u044c \u043e\u0442\u043c\u0435\u043d\u0438\u043b \u0432\u044b\u043a\u043b\u044e\u0447\u0435\u043d\u0438\u0435 \u0442\u0435\u0440\u043c\u0438\u043d\u0430\u043b\u0430");
                    }
                }
            });
            AdminInputModule.this.context.showDialog((DialogInterface)dialog);
        }

        @Override
        public void onCloseSoftware() {
            AdminInputModule.this.log.info((Object)"\u041f\u043e\u043b\u043d\u044b\u0439 \u043e\u0441\u0442\u0430\u043d\u043e\u0432 \u041f\u041e. \u041f\u0440\u043e\u0448\u0443 \u043f\u043e\u0434\u0442\u0432\u0435\u0440\u0436\u0434\u0435\u043d\u0438\u044f");
            DialogScreen dialog = ComponentFactory.getInstance().createDialog(DialogType.Question, B.get((String)"ServiceMenu.close.confirm", (Locale)AdminInputModule.this.locale), 15, DC.cases((int)2, (Locale)AdminInputModule.this.locale, (Object[])new Object[0]), UserCase.Cancel);
            dialog.addListener(new DialogListener(){

                public void dialogClosed(UserCase userCase) {
                    if (userCase == UserCase.Ok) {
                        DaemonUtil.createExitFlag((String)"_flag_servmenu");
                        AdminInputModule.this.log.info((Object)"\u041f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u044c \u043f\u043e\u0434\u0442\u0432\u0435\u0440\u0434\u0438\u043b \u043e\u0441\u0442\u0430\u043d\u043e\u0432 \u041f\u041e");
                        System.exit(15);
                    } else {
                        AdminInputModule.this.log.info((Object)"\u041f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u044c \u043e\u0442\u043c\u0435\u043d\u0438\u043b \u043e\u0441\u0442\u0430\u043d\u043e\u0432 \u041f\u041e");
                    }
                }
            });
            AdminInputModule.this.context.showDialog((DialogInterface)dialog);
        }

        @Override
        public void onTestPrinter() {
            AdminInputModule.this.log.info((Object)"\u0422\u0435\u0441\u0442\u0438\u0440\u0443\u044e \u043f\u0440\u0438\u043d\u0442\u0435\u0440");
            MoneyCollection mc = new MoneyCollection(-1, new Keeper(), DeviceClass.CashAcceptor, null, AdminInputModule.this.menuUser);
            AdminInputModule.this.context.getPrinterQueue().print(mc);
        }

        @Override
        public void onTestNetwork() {
            AdminInputModule.this.log.info((Object)"\u0422\u0435\u0441\u0442\u0438\u0440\u0443\u044e \u0441\u0435\u0442\u044c");
            AdminInputModule.this.context.getTaskExecutor().execute(new NetworkTest());
        }

        @Override
        public void onStartConfig() {
            AdminInputModule.this.log.info((Object)"\u0417\u0430\u043f\u0443\u0441\u043a\u0430\u044e \u043a\u043e\u043d\u0444\u0438\u0433\u0443\u0440\u0430\u0442\u043e\u0440. \u041f\u0440\u043e\u0448\u0443 \u043f\u043e\u0434\u0442\u0432\u0435\u0440\u0436\u0434\u0435\u043d\u0438\u044f");
            DialogScreen dialog = ComponentFactory.getInstance().createDialog(DialogType.Question, B.get((String)"ServiceMenu.configurator.confirm", (Locale)AdminInputModule.this.locale), 15, DC.cases((int)2, (Locale)AdminInputModule.this.locale, (Object[])new Object[0]), UserCase.Cancel);
            dialog.addListener(new DialogListener(){

                public void dialogClosed(UserCase userCase) {
                    if (userCase == UserCase.Ok) {
                        AdminInputModule.this.log.info((Object)"\u041f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u044c \u043f\u043e\u0434\u0442\u0432\u0435\u0440\u0434\u0438\u043b \u0437\u0430\u043f\u0443\u0441\u043a \u043a\u043e\u043d\u0444\u0438\u0433\u0443\u0440\u0430\u0442\u043e\u0440\u0430");
                        DaemonUtil.createExitFlag((String)"_flag_servmenu");
                        System.exit(16);
                    } else {
                        AdminInputModule.this.log.info((Object)"\u041f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u044c \u043e\u0442\u043c\u0435\u043d\u0438\u043b \u0437\u0430\u043f\u0443\u0441\u043a \u043a\u043e\u043d\u0444\u0438\u0433\u0443\u0440\u0430\u0442\u043e\u0440\u0430");
                    }
                }
            });
            AdminInputModule.this.context.showDialog((DialogInterface)dialog);
        }

        @Override
        public void onStartGSM() {
            AdminInputModule.this.log.info((Object)"\u0417\u0430\u043f\u0443\u0441\u043a\u0430\u044e \u0438\u0437\u043c\u0435\u0440\u0435\u043d\u0438\u0435 GSM");
            if (AdminInputModule.this.frameMaximizer != null) {
                AdminInputModule.this.frameMaximizer.setMinimized(true);
            }
            FrameStore.getFrame().setState(1);
            try {
                OsApi.getInstance().openControlGSM();
            }
            catch (OsException osException) {
                // empty catch block
            }
        }

        @Override
        public void onCheckDealerBalance() {
            AdminInputModule.this.log.info((Object)"\u041f\u0440\u043e\u0432\u0435\u0440\u044f\u044e \u0431\u0430\u043b\u0430\u043d\u0441");
            AdminInputModule.this.context.getTaskExecutor().execute(new CheckBalanceTask());
        }

        @Override
        public void onRequestMoneyCollections() {
            AdminInputModule.this.log.info((Object)"\u0417\u0430\u043f\u0440\u0430\u0448\u0438\u0432\u0430\u0435\u043c \u0438\u043d\u043a\u0430\u0441\u0441\u0430\u0446\u0438\u0438 \u0441 \u0441\u0435\u0440\u0432\u0435\u0440\u0430");
            AdminInputModule.this.context.getTaskExecutor().execute(new RequestMoneyCollections());
        }

        @Override
        public void onPrintMoneyCollections(MoneyCollection mc) {
            AdminInputModule.this.log.info((Object)("\u041f\u0435\u0447\u0430\u0442\u0430\u044e \u0434\u0443\u0431\u043b\u044c \u0438\u043d\u043a\u0430\u0441\u0441\u0430\u0446\u0438\u0438: " + mc));
            AdminInputModule.this.context.getPrinterQueue().print(mc);
        }

        @Override
        public void onRefreshNetworkInfo() {
            AdminInputModule.this.log.info((Object)"\u041e\u0431\u043d\u043e\u0432\u043b\u044f\u044e \u0438\u043d\u0444\u043e\u0440\u043c\u0430\u0446\u0438\u044e \u043f\u043e \u0441\u0432\u044f\u0437\u0438");
            AdminInputModule.this.refreshNetworkInfo();
        }

        @Override
        public void onReportByRange(Date start, Date end, boolean detailed) {
            TextField pf = new TextField();
            pf.setId("password");
            pf.setKeyboard(new Keyboard(KeyboardType.Any, Arrays.asList("en", "symb"), KeyboardCase.Lower, true, null));
            pf.setMaxLength(20);
            pf.setSecure(true);
            pf.setValidator((Validator)new RegexValidator(Arrays.asList("^.*$"), null));
            pf.setTitle(B.get((String)"ServiceMenu.auth.password", (Locale)AdminInputModule.this.environment.getLocale()));
            FieldSequence fs = new FieldSequence(Arrays.asList(pf));
            UniScreenDescription sd = new UniScreenDescription("letter");
            sd.setSequence(fs);
            sd.setTitle(B.get((String)"ServiceMenu.auth.password", (Locale)AdminInputModule.this.environment.getLocale()));
            CommonScreen cs = CommonScreenStore.getScreen((String)"letter");
            ScreenInit si = new ScreenInit(AdminInputModule.this.environment.getMenuItem().getService(), AdminInputModule.this.environment.getMenuItem().getCommission(), AdminInputModule.this.environment.getDealer(), AdminInputModule.this.environment.getPoint(), new HashMap(), null, 0, 0, AdminInputModule.this.environment.getLocale(), null, null, AdminInputModule.this.environment.isPrinterError(), AdminInputModule.this.environment.getAllowedNotes(), AdminInputModule.this.environment.getAllowedCoins(), AdminInputModule.this.environment.getDateOfStartPayment(), null, AdminInputModule.this.environment.getMenuItem(), null);
            try {
                cs.init((ScreenDescription)sd, si);
                cs.setListener((ScreenListener)new ReportByRangerScreenListener(start, end, detailed));
                AdminInputModule.this.context.showScreen(new ContentScreenAdapterKbr(cs));
            }
            catch (InitException ex) {
                AdminInputModule.this.log.error((Object)ex, (Throwable)ex);
            }
        }

        @Override
        public void onCashManagerControl(boolean enable) {
            AdminInputModule.this.log.info((Object)("\u0423\u043f\u0440\u0430\u0432\u043b\u044f\u0435\u043c \u043f\u0440\u0438\u043d\u044f\u0442\u0438\u0435\u043c \u043a\u0443\u043f\u044e\u0440: " + enable));
            if (enable) {
                CashManager.getDefaultInstance().enable(null, null, null, null, null, 65535, false);
            } else {
                AdminInputModule.this.cashManager.disable();
            }
        }

        @Override
        public void onNetworkUpdate() {
            AdminInputModule.this.log.info((Object)"Check network update from menu");
            NetworkUpdater updater = new NetworkUpdater(AdminInputModule.this.context, AdminInputModule.this, AdminInputModule.this.locale, AdminInputModule.this.adminScreen.getAdminPanel().getProgressBar());
            updater.checkUpdate();
        }

        @Override
        public void onLocalUpdate() {
            AdminInputModule.this.log.info((Object)"Check local update from menu");
            boolean top = false;
            if (AdminInputModule.this.frameMaximizer != null) {
                top = AdminInputModule.this.frameMaximizer.isTop();
                AdminInputModule.this.log.info((Object)("Change \"on_top flag\" for open OS explorer. Old value=" + top + ", set value=false"));
                AdminInputModule.this.frameMaximizer.setTop(false);
            }
            LocalUpdater updater = new LocalUpdater(AdminInputModule.this.context, AdminInputModule.this, AdminInputModule.this.locale);
            updater.checkUpdate();
            if (AdminInputModule.this.frameMaximizer != null) {
                AdminInputModule.this.log.info((Object)("Change \"on_top flag\" for open OS explorer. New value=" + top));
                AdminInputModule.this.frameMaximizer.setTop(top);
            }
        }

        @Override
        public void onCalibrate() {
            if (OsDetector.current() == 1) {
                String cPath = null;
                if (new File(PathUtils.getAppHome() + "/bin/calib").exists()) {
                    cPath = PathUtils.getAppHome() + "/bin/calib";
                } else if (new File(SystemProp.getUserHome() + "/bin/calib").exists()) {
                    cPath = SystemProp.getUserHome() + "/bin/calib";
                } else if (new File(SystemProp.getUserHome() + "/xic").exists()) {
                    cPath = SystemProp.getUserHome() + "/xic";
                }
                if (cPath != null) {
                    try {
                        Runtime.getRuntime().exec(cPath);
                    }
                    catch (IOException ex) {
                        AdminInputModule.this.log.error((Object)ex, (Throwable)ex);
                        DialogScreen dialog = ComponentFactory.getInstance().createDialog(DialogType.Error, B.get((String)"Provider.admin.caliberror"), 15, DC.cases((int)8, (Locale)AdminInputModule.this.locale, (Object[])new Object[0]), UserCase.Ok);
                        AdminInputModule.this.context.showDialog((DialogInterface)dialog);
                    }
                } else {
                    DialogScreen dialog = ComponentFactory.getInstance().createDialog(DialogType.Error, B.get((String)"Provider.admin.nocalib"), 15, DC.cases((int)8, (Locale)AdminInputModule.this.locale, (Object[])new Object[0]), UserCase.Ok);
                    AdminInputModule.this.context.showDialog((DialogInterface)dialog);
                }
            } else if (OsDetector.current() == 2) {
                try {
                    Runtime.getRuntime().exec("control panel");
                }
                catch (IOException ex) {
                    AdminInputModule.this.log.error((Object)ex, (Throwable)ex);
                    DialogScreen dialog = ComponentFactory.getInstance().createDialog(DialogType.Error, B.get((String)"Provider.admin.caliberror"), 15, DC.cases((int)8, (Locale)AdminInputModule.this.locale, (Object[])new Object[0]), UserCase.Cancel);
                    AdminInputModule.this.context.showDialog((DialogInterface)dialog);
                }
            } else {
                AdminInputModule.this.log.error((Object)"\u041d\u0435\u0432\u043e\u0437\u043c\u043e\u0436\u043d\u043e \u043e\u043f\u0440\u0435\u0434\u0435\u043b\u0438\u0442\u044c \u0442\u0438\u043f \u041e\u0421");
                DialogScreen dialog = ComponentFactory.getInstance().createDialog(DialogType.Error, B.get((String)"Provider.admin.nocalib"), 15, DC.cases((int)8, (Locale)AdminInputModule.this.locale, (Object[])new Object[0]), UserCase.Cancel);
                AdminInputModule.this.context.showDialog((DialogInterface)dialog);
            }
        }

        @Override
        public void onOpenControlPanel() {
            if (AdminInputModule.this.frameMaximizer != null) {
                AdminInputModule.this.frameMaximizer.setMinimized(true);
            }
            FrameStore.getFrame().setState(1);
            try {
                OsApi.getInstance().openControlPanel();
            }
            catch (OsException osException) {
                // empty catch block
            }
        }

        @Override
        public void onFillCoinHopper() {
            AppEnvironment.getInstance().open(ProviderType.CoinHopperProvider, Collections.singletonMap(AdminInputModule.MENU_USER_KEY, AdminInputModule.this.menuUser));
        }

        @Override
        public void onTestFiscalClient() {
            AdminInputModule.this.log.info((Object)"\u0417\u0430\u043f\u0440\u0430\u0448\u0438\u0432\u0430\u0435\u043c \u0438\u043d\u043a\u0430\u0441\u0441\u0430\u0446\u0438\u0438 \u0441 \u0441\u0435\u0440\u0432\u0435\u0440\u0430");
            AdminInputModule.this.context.getTaskExecutor().execute(new RequestTestFiscalServer());
        }

        @Override
        public void onPrintCoffeeFullness() {
            AdminInputModule.this.context.getTaskExecutor().execute(new FullnessStatusTask((ApplicationContext)AdminInputModule.this.context, AdminInputModule.this.locale, AdminInputModule.this.log));
        }

        @Override
        public void onUpdateCoffeeFullness() {
            AdminInputModule.this.context.getTaskExecutor().execute(new FullnessUpdateTask(AdminInputModule.this, (ApplicationContext)AdminInputModule.this.context, AdminInputModule.this.environment));
        }

        @Override
        public void onMakeCoffeeDrink() {
            String login = AdminInputModule.this.menuUser == null ? "-" : AdminInputModule.this.menuUser.getLogin();
            String fio = AdminInputModule.this.menuUser == null ? "-" : AdminInputModule.this.menuUser.getFio();
            AdminInputModule.this.context.getTaskExecutor().execute(new MakeFastDrinkTask(AdminInputModule.this, (ApplicationContext)AdminInputModule.this.context, AdminInputModule.this.environment, fio, login));
        }

        @Override
        public void onUnloadPayments() {
            UnloaderPayments unloader = new UnloaderPayments(AdminInputModule.this.context, AdminInputModule.this, AdminInputModule.this.locale, AdminInputModule.this.log, AdminInputModule.this.mainPanel.getUnloadPaymentsButton(), 180);
            unloader.unloadPayments();
        }

        @Override
        public void onSwitchCoffeeMode() {
        }

        @Override
        public void onDispenserMoneyCollection() {
            if (Cdm.getInstance() != null) {
                AdminInputModule.this.dispenserCollection();
            }
        }

        @Override
        public void onStartCMSetup() {
            if (AdminInputModule.this.frameMaximizer != null) {
                AdminInputModule.this.frameMaximizer.setMinimized(true);
            }
            FrameStore.getFrame().setState(1);
            try {
                OsApi.getInstance().startCMSetup(Short.toString(AdminInputModule.this.menuUser.getId()), AdminInputModule.this.menuUser.getLogin());
            }
            catch (OsException osException) {
                // empty catch block
            }
        }
    }
}

