/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.module.input;

import java.util.HashMap;
import java.util.Map;
import ru.softlogic.app.session.Pack;
import ru.softlogic.app.session.Session;
import ru.softlogic.cash.Keeper;
import ru.softlogic.cash.Sum;
import ru.softlogic.cash.currency.CurrencyUtil;
import ru.softlogic.gui2.screen.ScreenInit;
import ru.softlogic.input.model.InputElement;
import ru.softlogic.input.model.screen.ButtonInit;
import ru.softlogic.input.model.screen.description.SumScreenDescription;
import ru.softlogic.module.Restorable;
import ru.softlogic.module.input.Environment;
import ru.softlogic.module.input.ModuleInitException;
import ru.softlogic.reference.menu.MenuItem;
import ru.softlogic.reference.service.Service;
import ru.softlogic.service.comission.Commission;
import ru.softlogic.service.comission.FeeSum;

public class InitModuleHelper {
    public static void check(Environment environment, Restorable parent) throws ModuleInitException {
        if (environment == null) {
            throw new ModuleInitException("Enviroment is not set");
        }
        if (parent == null) {
            throw new ModuleInitException("Parent is not set");
        }
    }

    public static ScreenInit buildScreenInit(Environment environment, Map<String, Object> data) {
        MenuItem menuItem = environment.getMenuItem();
        return InitModuleHelper.buildScreenInit(environment, data, menuItem.getService(), menuItem.getCommission());
    }

    public static ScreenInit buildScreenInit(Environment environment, Map<String, Object> data, Service service, Commission commission) {
        Keeper ck = Session.getInstance().getCurrentKeeper();
        Sum cs = ck == null ? null : ck.getSum();
        Pack pack = Session.getInstance().getPack();
        FeeSum fs = pack == null ? null : pack.getProviderFee();
        Double rate = null;
        rate = service == null ? Double.valueOf(1.0) : CurrencyUtil.getRate((String)service.getCurrencyCode(), (int)service.getId());
        ScreenInit si = new ScreenInit(service, commission, environment.getDealer(), environment.getPoint(), data, null, 0, 0, environment.getLocale(), environment.getServiceType(), rate, environment.isPrinterError(), environment.getAllowedNotes(), environment.getAllowedCoins(), environment.getDateOfStartPayment(), cs, environment.getMenuItem(), fs);
        return si;
    }

    public static SumScreenDescription createSumScreenDescription() {
        SumScreenDescription sd = new SumScreenDescription();
        sd.setId("sum");
        HashMap<String, ButtonInit> buttons = new HashMap<String, ButtonInit>();
        buttons.put("Prev", new ButtonInit(null));
        buttons.put("Exit", new ButtonInit(null));
        buttons.put("Next", new ButtonInit(null));
        buttons.put("Cbc", new ButtonInit(null));
        buttons.put("Commission", new ButtonInit(null));
        sd.setButtons(buttons);
        return sd;
    }

    public static Map<String, ButtonInit> createKeyMap() {
        HashMap<String, ButtonInit> buttons = new HashMap<String, ButtonInit>();
        buttons.put("Commission", new ButtonInit(null));
        buttons.put("Prev", new ButtonInit(null));
        buttons.put("Exit", new ButtonInit(null));
        buttons.put("Next", new ButtonInit(null));
        return buttons;
    }

    public static Map<String, ButtonInit> createBarcodeKeyMap() {
        HashMap<String, ButtonInit> buttons = new HashMap<String, ButtonInit>();
        buttons.put("Prev", new ButtonInit(null));
        buttons.put("Exit", new ButtonInit(null));
        buttons.put("Next", new ButtonInit(null));
        buttons.put("Skip", new ButtonInit(null));
        return buttons;
    }

    public static void processData(Map<String, Object> data) {
        InputElement ie;
        if (data == null) {
            return;
        }
        HashMap<String, String> values = new HashMap<String, String>();
        for (Object obj : data.values()) {
            if (!(obj instanceof InputElement) || (ie = (InputElement)obj).getKey() == null || ie.getValue() == null) continue;
            values.put(ie.getKey(), ie.getValue());
        }
        for (Object obj : data.values()) {
            if (!(obj instanceof InputElement)) continue;
            ie = (InputElement)obj;
            for (String key : values.keySet()) {
                if (ie.getKeyTitle() != null && ie.getKeyTitle().contains("${") || ie.getValue() != null && ie.getValue().contains("${") || ie.getValueTitle() != null && ie.getValueTitle().contains("${")) {
                    ie = new InputElement(ie.getKey(), ie.getKeyTitle(), ie.getOriginalValue(), ie.getValue(), ie.getValueTitle(), ie.getFlags());
                    data.put(ie.getKey(), ie);
                }
                if (ie.getKeyTitle() != null) {
                    ie.setKeyTitle(ie.getKeyTitle().replace("${" + key + "}", (CharSequence)values.get(key)));
                }
                if (ie.getValue() != null) {
                    ie.setValue(ie.getValue().replace("${" + key + "}", (CharSequence)values.get(key)));
                }
                if (ie.getValueTitle() == null) continue;
                ie.setValueTitle(ie.getValueTitle().replace("${" + key + "}", (CharSequence)values.get(key)));
            }
        }
    }
}

