/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.module.input;

import i18n.B;
import java.text.MessageFormat;
import java.util.Collections;
import java.util.Locale;
import java.util.Map;
import org.apache.log4j.Logger;
import ru.softlogic.app.AppEnvironment;
import ru.softlogic.app.context.ApplicationContext;
import ru.softlogic.gui.factory.ComponentFactory;
import ru.softlogic.gui.screen.popup.dialog.DC;
import ru.softlogic.gui.screen.popup.dialog.DialogInterface;
import ru.softlogic.gui.screen.popup.dialog.DialogListener;
import ru.softlogic.gui.screen.popup.dialog.DialogScreen;
import ru.softlogic.gui.screen.popup.dialog.DialogType;
import ru.softlogic.gui.screen.popup.dialog.UserCase;
import ru.softlogic.gui.screen.popup.dialog.screen.ScreenPopupDialog;
import ru.softlogic.gui2.screen.ActionType;
import ru.softlogic.gui2.screen.CommonScreen;
import ru.softlogic.gui2.screen.ScreenAdapter;
import ru.softlogic.gui2.screen.ScreenInit;
import ru.softlogic.gui2.screen.ScreenListener;
import ru.softlogic.input.model.InputElement;
import ru.softlogic.input.model.field.InitException;
import ru.softlogic.input.model.screen.description.ScreenDescription;
import ru.softlogic.module.ModuleHelper;
import ru.softlogic.module.input.Environment;
import ru.softlogic.provider.ProviderHelper;
import ru.softlogic.provider.ProviderType;
import ru.softlogic.reference.bwlist.PersonalNumber;
import ru.softlogic.reference.service.Service;
import ru.softlogic.srv.api.event.Event;
import ru.softlogic.srv.api.event.EventType;

public abstract class ComplexScreenListener
extends ScreenAdapter {
    private final ApplicationContext context;
    private Logger log;
    private Environment environment;
    private PersonalNumber[] personalNumbers;

    public ComplexScreenListener(ApplicationContext context) {
        this.context = context;
    }

    public void setEnvironment(Environment environment) {
        this.environment = environment;
        this.log = Logger.getLogger((String)"pay");
    }

    public void setPersonalNumbers(PersonalNumber[] personalNumbers) {
        this.personalNumbers = personalNumbers;
    }

    public final void onAction(final String action, final Map<String, Object> data, final Runnable cancelListener) {
        this.log.info((Object)("User action: " + action));
        this.log.info((Object)("Data: " + data));
        if (ActionType.isNext((String)action)) {
            Short stid;
            this.log.info((Object)"Check black list");
            Service service = this.environment.getMenuItem().getService();
            int sid = service == null ? -1 : service.getId();
            Short s = stid = service == null ? null : service.getServiceTypeId();
            if (ProviderHelper.isUnwantedClient(this.personalNumbers, data, sid, stid)) {
                this.log.info((Object)"It is unwanted client, show error");
                InputElement num = (InputElement)data.get("id1");
                DialogScreen dialog = ComponentFactory.getInstance().createDialog(DialogType.Info, MessageFormat.format(B.get((String)"Provider.mobile.phone.black", (Locale)this.environment.getLocale()), num != null ? num.getValueTitle() : ""), 20, DC.cases((int)8, (Locale)this.environment.getLocale(), (Object[])new Object[0]), UserCase.Ok);
                dialog.addListener(new DialogListener(){

                    public void dialogClosed(UserCase userCase) {
                        ModuleHelper.invoke(cancelListener);
                    }
                });
                this.context.showDialog((DialogInterface)dialog);
            } else if (this.environment != null && this.environment.getPoint() != null && this.environment.getPoint().getSecretPhone() != null && data != null) {
                this.log.info((Object)"Check secret phone");
                String phone = this.environment.getPoint().getSecretPhone();
                for (Object obj : data.values()) {
                    InputElement ie;
                    if (!(obj instanceof InputElement) || !phone.equals((ie = (InputElement)obj).getValue())) continue;
                    this.log.info((Object)("User input secret number: " + phone + ", show dialog"));
                    DialogScreen dialog = ComponentFactory.getInstance().createDialog(DialogType.Info, B.get((String)"ServiceMenu.open.question", (Locale)this.environment.getLocale()), 20, DC.cases((int)7, (Locale)this.environment.getLocale(), (Object[])new Object[0]), UserCase.Ok);
                    dialog.addListener(new DialogListener(){

                        public void dialogClosed(UserCase userCase) {
                            if (userCase == UserCase.Ok) {
                                ComplexScreenListener.this.log.info((Object)"Go to admin module");
                                AppEnvironment.getInstance().open(ProviderType.AdminProvider);
                            } else {
                                ComplexScreenListener.this.log.info((Object)"Skip admin module");
                                ComplexScreenListener.this._checkInvalide(action, data, cancelListener);
                            }
                        }
                    });
                    this.context.showDialog((DialogInterface)dialog);
                    return;
                }
                this._checkInvalide(action, data, cancelListener);
            } else {
                this.log.info((Object)"Make standart action");
                this._checkInvalide(action, data, cancelListener);
            }
        } else {
            this._onAction(action, data, cancelListener);
        }
    }

    private void _checkInvalide(final String action, final Map<String, Object> data, final Runnable cancelListener) {
        if (data.containsKey("#invalid")) {
            data.remove("#invalid");
            this.log.info((Object)"Invalid input data. Ask about payment");
            DialogScreen dialog = ComponentFactory.getInstance().createDialog(DialogType.Question, B.get((String)"Provider.universal.number.unknown", (Locale)this.environment.getLocale()), 20, DC.cases((int)6, (Locale)this.environment.getLocale(), (Object[])new Object[0]), UserCase.Cancel);
            dialog.addListener(new DialogListener(){

                public void dialogClosed(UserCase userCase) {
                    if (userCase == UserCase.Ok) {
                        ComplexScreenListener.this.log.info((Object)"User confirm wrong data");
                        ComplexScreenListener.this.context.getServerConnector().sendEvent(new Event(EventType.NumberFault, ComplexScreenListener.this.environment.getMenuItem().getService().getName() + ": " + data.values()));
                        ComplexScreenListener.this._onAction(action, data, cancelListener);
                    } else {
                        ComplexScreenListener.this.log.info((Object)"Stayed here");
                        ModuleHelper.invoke(cancelListener);
                    }
                }
            });
            this.context.showDialog((DialogInterface)dialog);
        } else {
            this._onAction(action, data, cancelListener);
        }
    }

    public abstract void _onAction(String var1, Map<String, Object> var2, Runnable var3);

    public void onLocale(Locale locale) {
        if (this.environment != null) {
            this.environment.setLocale(locale);
        }
    }

    public void showPopup(ScreenDescription sd, ScreenInit si, ScreenListener listener) {
        CommonScreen sc = ComponentFactory.getInstance().create(sd.getType(), sd.getDecor());
        if (sc == null) {
            listener.onAction("Exit", Collections.EMPTY_MAP, null);
            return;
        }
        try {
            sc.init(sd, si);
            this.context.showDialog((DialogInterface)new ScreenPopupDialog(sc, 30, "Exit", true, listener));
        }
        catch (InitException ex) {
            listener.onAction("Exit", Collections.EMPTY_MAP, null);
        }
    }
}

