/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.module.input;

import i18n.B;
import java.text.MessageFormat;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;
import ru.softlogic.app.AppEnvironment;
import ru.softlogic.app.CommissionCalculator;
import ru.softlogic.app.LoggerId;
import ru.softlogic.app.ProblemNotifier;
import ru.softlogic.app.configuration.AppDefaults;
import ru.softlogic.app.context.ApplicationContext;
import ru.softlogic.app.context.InputModuleContext;
import ru.softlogic.app.session.Pack;
import ru.softlogic.app.session.Payment;
import ru.softlogic.app.session.Session;
import ru.softlogic.application.ContentScreenAdapterKbr;
import ru.softlogic.cash.Keeper;
import ru.softlogic.cash.Sum;
import ru.softlogic.cash.currency.CurrencyUtil;
import ru.softlogic.gui.factory.ComponentFactory;
import ru.softlogic.gui.screen.popup.dialog.DC;
import ru.softlogic.gui.screen.popup.dialog.DialogInterface;
import ru.softlogic.gui.screen.popup.dialog.DialogListener;
import ru.softlogic.gui.screen.popup.dialog.DialogScreen;
import ru.softlogic.gui.screen.popup.dialog.DialogType;
import ru.softlogic.gui.screen.popup.dialog.UserCase;
import ru.softlogic.gui.utils.VSTemplateProcessor;
import ru.softlogic.gui.utils.menu.MenuByServiceIdVisitor;
import ru.softlogic.gui.utils.menu.MenuUtils;
import ru.softlogic.gui.utils.menu.MenuVisitor;
import ru.softlogic.gui2.screen.ActionType;
import ru.softlogic.gui2.screen.CommonScreen;
import ru.softlogic.gui2.screen.CommonScreenStore;
import ru.softlogic.gui2.screen.CommonSumScreen;
import ru.softlogic.gui2.screen.ScreenAdapter;
import ru.softlogic.gui2.screen.ScreenHelper;
import ru.softlogic.gui2.screen.ScreenInit;
import ru.softlogic.gui2.screen.ScreenListener;
import ru.softlogic.hardware.device.cashin.CashDeviceManager;
import ru.softlogic.hardware.device.scanner.BarcodeScanner;
import ru.softlogic.hardware.device.scanner.BarcodeScannerListener;
import ru.softlogic.input.model.InputElement;
import ru.softlogic.input.model.StoreHelper;
import ru.softlogic.input.model.field.InitException;
import ru.softlogic.input.model.field.barcode.BarcodeData;
import ru.softlogic.input.model.field.barcode.BarcodeException;
import ru.softlogic.input.model.field.numeric.Range;
import ru.softlogic.input.model.field.text.NumericExternalValidator;
import ru.softlogic.input.model.screen.description.InfoScreenDescription;
import ru.softlogic.input.model.screen.description.ScreenDescription;
import ru.softlogic.input.model.screen.description.SumScreenDescription;
import ru.softlogic.intent.ExitIntent;
import ru.softlogic.intent.Intent;
import ru.softlogic.module.ModuleHelper;
import ru.softlogic.module.PackUtility;
import ru.softlogic.module.Restorable;
import ru.softlogic.module.input.DescriptionException;
import ru.softlogic.module.input.Environment;
import ru.softlogic.module.input.FiscalRequestListener;
import ru.softlogic.module.input.FiscalRequestTask;
import ru.softlogic.module.input.InitModuleHelper;
import ru.softlogic.module.input.InputModule;
import ru.softlogic.module.input.ModuleInitException;
import ru.softlogic.module.input.advanced.TaskAdapter;
import ru.softlogic.module.input.calculate.PaySumCalculator;
import ru.softlogic.module.input.calculate.PaySumCalculatorListener;
import ru.softlogic.module.input.template.TemplateModule;
import ru.softlogic.module.input.template.TemplateModuleListener;
import ru.softlogic.module.utils.managerpl.ServiceIdListener;
import ru.softlogic.provider.ProviderHelper;
import ru.softlogic.reference.ReferenceException;
import ru.softlogic.reference.ReferenceManager;
import ru.softlogic.reference.menu.MenuItem;
import ru.softlogic.reference.service.Service;
import ru.softlogic.service.comission.Commission;
import ru.softlogic.service.comission.SumResult;
import ru.softlogic.system.util.PathUtils;

public abstract class BaseInputModule
implements InputModule {
    protected final Logger log = LoggerId.PAY;
    protected InputModuleContext context;
    protected Runnable cancelListener;
    private ApplicationContext ctx;
    private Environment env;
    private Set<ServiceIdListener> listeners;
    private Restorable parent;
    private VSTemplateProcessor processor;
    private TemplateModule templateModule;
    protected ru.softlogic.input.model.field.barcode.BarcodeScanner barcodeScanner;
    protected final BarcodeScannerListener barcodeListener;

    public BaseInputModule(ApplicationContext context) {
        this.context = context;
        this.ctx = context;
        this.listeners = new HashSet<ServiceIdListener>();
        try {
            this.processor = new VSTemplateProcessor(PathUtils.getAppHome());
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        this.barcodeListener = new LocalBarcodeScannerListener();
    }

    public void setContext(ApplicationContext context) {
        this.context = context;
        this.ctx = context;
    }

    @Override
    public int getInactivityTimeout() {
        return 120;
    }

    @Override
    public int getType() {
        return 2;
    }

    public void back() {
        Sum change;
        Keeper keeper = Session.getInstance().getPack().getKeeper();
        Sum sum = change = keeper == null ? null : keeper.getSum();
        if (change != null && !change.isEmpty()) {
            this.log.info((Object)"User want break payout payment, show dialog");
            DialogScreen dialog = this.createPayoutBreakDialog(change);
            this.context.showDialog((DialogInterface)dialog);
        } else if (this.templateModule != null && !this.templateModule.isActive()) {
            this.templateModule.restore();
        } else if (this.parent != null && (change == null || change.isEmpty())) {
            this.parent.restore();
        } else {
            this.ctx.toMainMenu();
        }
    }

    @Override
    public void cancel(Intent intent) {
        Sum change;
        Pack pack = Session.getInstance().getPack();
        PackUtility.printPack("On cancel input module", pack);
        Sum sum = change = pack.getKeeper() == null ? null : pack.getKeeper().getSum();
        if (change != null && !change.isEmpty()) {
            this.log.info((Object)"User want break payout payment, show dialog");
            DialogScreen dialog = this.createPayoutBreakDialog(change);
            this.context.showDialog((DialogInterface)dialog);
        } else {
            this._cancel(intent);
        }
    }

    private void _cancel(Intent intent) {
        if (intent != null) {
            intent.process();
        } else {
            this.ctx.toMainMenu(intent);
        }
    }

    @Override
    public final void start(Environment environment, Restorable parent) throws DescriptionException, ModuleInitException {
        Session.getInstance().getPaymentTemplateState().reset();
        this.env = environment;
        Session.getInstance().getPaymentTemplateState().setSkipInput(this.env.getInitData() != null && this.env.getInitData().containsKey("#service-id") && this.env.getInitData().containsKey("template-id"));
        this.log.info((Object)B.get((String)"Module.input", (Locale)environment.getLocale()));
        Keeper k = Session.getInstance().getPack().getKeeper();
        this.log.info((Object)("Keeper: " + (k != null && !k.getSum().isEmpty() ? k : "-")));
        this.log.info((Object)("Parent: " + (parent != null ? "present" : "not present")));
        this.log.info((Object)("Flags: " + String.format("0x%02x", environment.getMenuItem().getFlags())));
        this.log.info((Object)("Printer error: " + environment.isPrinterError()));
        this.log.info((Object)("Service currency: " + environment.getMenuItem().getService().getCurrencyCode()));
        this.log.info((Object)("Currency rate: " + CurrencyUtil.getRate((String)environment.getMenuItem().getService().getCurrencyCode(), (int)environment.getMenuItem().getService().getId())));
        this.setRecommendedSum(environment.getInitData());
        MenuItem menuItem = environment.getMenuItem();
        if (menuItem != null && menuItem.getService() != null) {
            Service service = menuItem.getService();
            Sum minSum = service.getMinSum();
            Sum maxSum = service.getMaxSum();
            if (minSum != null && maxSum != null) {
                this.log.info((Object)("getMinSum: " + minSum));
                this.log.info((Object)("getMaxSum: " + maxSum));
                Commission comm = menuItem.getCommission();
                if (comm != null) {
                    maxSum = CommissionCalculator.calculateMaxPurchase((Sum)maxSum, (Commission)comm, (Date)new Date(), (String)"CASH");
                }
                Range range = new Range((float)minSum.getSum(), (float)maxSum.getSum());
                NumericExternalValidator.setRange((Range)range);
            }
        }
        environment.setInputModule(this);
        this.context.setModule(this);
        BarcodeScanner.getScanner().addListener(this.barcodeListener);
        String offer = null;
        if (environment.getMenuItem().getService().getOferta() != null && !environment.getMenuItem().getService().getOferta().trim().isEmpty()) {
            offer = this.getOffer("/resources/offers/" + environment.getMenuItem().getService().getOferta(), environment.getLocale());
        }
        if (offer != null) {
            CommonScreen currentScreen = CommonScreenStore.getScreen((String)"info-context", (String)"soffer");
            if (currentScreen != null) {
                try {
                    InfoScreenDescription sd = new InfoScreenDescription();
                    sd.setKey("offer");
                    currentScreen.init(ScreenHelper.processBack((ScreenDescription)sd, (boolean)true, (boolean)true), InitModuleHelper.buildScreenInit(environment, Collections.singletonMap("offer", new InputElement("offer", "offer", offer))));
                    currentScreen.setListener((ScreenListener)new LocalOfferListener(parent));
                    this.context.showScreen(new ContentScreenAdapterKbr(currentScreen));
                }
                catch (Exception ex) {
                    this.log.error((Object)ex);
                    this.cancel(null);
                }
            }
        } else {
            this.parent = parent;
            this._checkTemplates(environment, parent);
            for (ServiceIdListener listener : this.listeners) {
                listener.onServiceIdChange(environment.getMenuItem().getService().getId());
            }
        }
    }

    public void showOffer() {
        CommonScreen currentScreen;
        String offer = null;
        if (this.env.getMenuItem().getService().getOferta() != null && !this.env.getMenuItem().getService().getOferta().trim().isEmpty()) {
            offer = this.getOffer("/resources/offers/" + this.env.getMenuItem().getService().getOferta(), this.env.getLocale());
        }
        if (offer != null && (currentScreen = CommonScreenStore.getScreen((String)"info-context", (String)"soffer")) != null) {
            try {
                InfoScreenDescription sd = new InfoScreenDescription();
                sd.setKey("offer");
                currentScreen.init(ScreenHelper.processBack((ScreenDescription)sd, (boolean)true, (boolean)true), InitModuleHelper.buildScreenInit(this.env, Collections.singletonMap("offer", new InputElement("offer", "offer", offer))));
                currentScreen.setListener((ScreenListener)new LocalOfferListener(this.parent));
                this.context.showScreen(new ContentScreenAdapterKbr(currentScreen));
            }
            catch (Exception ex) {
                this.log.error((Object)ex);
                this.cancel(null);
            }
        }
    }

    private void _checkTemplates(final Environment environment, final Restorable parent) throws DescriptionException, ModuleInitException {
        boolean isEnterFromTemplateList;
        boolean bl = isEnterFromTemplateList = this.env.getInitData() != null && this.env.getInitData().containsKey("#service-id") && this.env.getInitData().containsKey("template-id");
        if ("true".equalsIgnoreCase((String)environment.getMenuItem().getService().getProperties().get("keeper.template.save")) && !isEnterFromTemplateList) {
            if (this.templateModule == null) {
                this.templateModule = new TemplateModule();
            }
            this.env.setTemplateModule(this.templateModule);
            this.templateModule.init(this.ctx, this.env);
            this.templateModule.start(new TemplateModuleListener(){

                @Override
                public void onResult(Map<String, Object> data) {
                    BaseInputModule.this.log.info((Object)("Start payment with data " + data));
                    BaseInputModule.this.env.setInitData(data);
                    try {
                        BaseInputModule.this.templateModule.setActive(false);
                        BaseInputModule.this._start(BaseInputModule.this.env, BaseInputModule.this.templateModule);
                    }
                    catch (Exception ex) {
                        BaseInputModule.this.log.error((Object)ex, (Throwable)ex);
                        BaseInputModule.this.log.info((Object)"Show error dialog and go to main menu");
                        DialogScreen dlg = ComponentFactory.getInstance().createDialog(DialogType.Error, B.get((String)"Module.entry.create.init", (Locale)environment.getLocale()), 10, DC.cases((int)1), UserCase.Ok);
                        dlg.addListener(new DialogListener(){

                            public void dialogClosed(UserCase userCase) {
                                BaseInputModule.this.cancel(new ExitIntent(BaseInputModule.this.ctx, 2));
                            }
                        });
                        BaseInputModule.this.context.showDialog((DialogInterface)dlg);
                    }
                }

                @Override
                public void onRestore() {
                    BaseInputModule.this.back();
                }

                @Override
                public void onMainMenu() {
                    BaseInputModule.this.ctx.toMainMenu();
                }

                @Override
                public void onCalculate() {
                    PaySumCalculator paySumcalculate = new PaySumCalculator(BaseInputModule.this.ctx, BaseInputModule.this.env);
                    paySumcalculate.start(new PaySumCalculatorListener(){

                        @Override
                        public void onNext() {
                            try {
                                BaseInputModule.this._start(environment, parent);
                            }
                            catch (Exception ex) {
                                BaseInputModule.this.log.error((Object)ex, (Throwable)ex);
                                BaseInputModule.this.cancel(new ExitIntent(BaseInputModule.this.ctx));
                            }
                        }

                        @Override
                        public void onRestore() {
                            BaseInputModule.this.back();
                        }

                        @Override
                        public void onPrev() {
                            if (BaseInputModule.this.templateModule != null) {
                                BaseInputModule.this.templateModule.clearData(BaseInputModule.this.getDataContext());
                                BaseInputModule.this.templateModule.showChooseTemplateScreen();
                            }
                        }
                    });
                }

                @Override
                public void onOffer() {
                    BaseInputModule.this.showOffer();
                }

                @Override
                public void onCancel() {
                    BaseInputModule.this.cancel(null);
                }
            });
        } else {
            if (!isEnterFromTemplateList) {
                this.templateModule = null;
                this.env.setTemplateModule(null);
            }
            this._start(environment, parent);
        }
    }

    protected abstract void _start(Environment var1, Restorable var2) throws DescriptionException, ModuleInitException;

    @Override
    public final void restore() {
        if (this.templateModule != null) {
            this.templateModule.clearData(this.getDataContext());
        }
        this._restore();
        this.context.setModule(this);
    }

    @Override
    public BarcodeScannerListener getBarcodeScannerListener() {
        return null;
    }

    protected void _redirect(int serviceId) {
        this._redirect(serviceId, null);
    }

    protected void _redirect(int serviceId, Map<String, Object> params) {
        this.log.info((Object)("Requested redirect to service: " + serviceId));
        if (this.env.getRedirectProxy() != null) {
            this.env.getRedirectProxy().redirect(serviceId, params);
        } else {
            MenuItem mi = null;
            try {
                MenuByServiceIdVisitor mbsiv = new MenuByServiceIdVisitor(serviceId, AppDefaults.getInstance().getBooleanProperty("Module.input.redirect.childs", true));
                MenuUtils.processMenu((MenuVisitor)mbsiv);
                mi = mbsiv.getMenuItem();
            }
            catch (Exception e) {
                this.log.error((Object)e, (Throwable)e);
            }
            if (mi != null) {
                this.log.info((Object)("Found service: " + mi.getService().getName()));
                Keeper k = Session.getInstance().getPack().getKeeper();
                this.log.info((Object)("Redirect with keeper: " + k));
                AppEnvironment.getInstance().open(mi, params);
            } else {
                ProblemNotifier.getDefaultNotifier().onProblem("Redirect to service " + serviceId + " not found");
                this.log.info((Object)"Service not found, show dialog");
                DialogScreen dialog = ComponentFactory.getInstance().createDialog(DialogType.Error, B.get((String)"Module.input.redirect.notfound", (Locale)this.env.getLocale()), 10, DC.cases((int)8, (Locale)this.env.getLocale(), (Object[])new Object[0]), UserCase.Ok);
                this.context.showDialog((DialogInterface)dialog);
            }
        }
    }

    protected void _startPayment(Environment environment, SumScreenDescription ssd, Map<String, Object> data) {
        this._startPayment(environment, ssd, data, null, null, null);
    }

    public void _repeatPayment(Environment environment, SumScreenDescription ssd, List<Payment> payments, Sum oper, Service srv, Commission comm) {
        Service service;
        if (payments == null || payments.isEmpty()) {
            throw new IllegalArgumentException("Payments: " + payments);
        }
        Service service2 = service = srv == null ? environment.getMenuItem().getService() : srv;
        if (service.isFiscalService()) {
            LocalFiscalRequestListener l = new LocalFiscalRequestListener(environment, ssd, null, payments, oper, srv, comm);
            this.context.getTaskExecutor().execute(new TaskAdapter(new FiscalRequestTask(service.getId(), this.ctx, l, null, payments, environment.getLocale()), environment.getLocale()));
        } else {
            this._repeatToPayment(environment, ssd, payments, oper, srv, comm);
        }
    }

    private void _repeatToPayment(Environment environment, SumScreenDescription ssd, List<Payment> payments, Sum oper, Service srv, Commission comm) {
        Service s;
        this.log.info((Object)"Pre-payment actions (repeat to payment)");
        Service service = s = srv == null ? environment.getMenuItem().getService() : srv;
        if (comm != null) {
            Session.getInstance().getPack().setCommission(comm);
        } else {
            Session.getInstance().getPack().setCommission(environment.getMenuItem().getCommission());
        }
        Session.getInstance().getPack().setService(s);
        Session.getInstance().getPack().getPayments().clear();
        Session.getInstance().getPack().setOperationSum(oper);
        for (Payment p : payments) {
            Payment np = new Payment();
            np.setData(p.getData());
            np.setOperationSum(p.getOperationSum());
            Session.getInstance().getPack().getPayments().add(np);
        }
        CommonSumScreen css = (CommonSumScreen)CommonScreenStore.getSumScreen((SumScreenDescription)ssd, (MenuItem)environment.getMenuItem(), (boolean)true);
        try {
            ScreenInit si = InitModuleHelper.buildScreenInit(environment, payments.get(0).getData(), s, Session.getInstance().getPack().getCommission());
            si.setPayments(Session.getInstance().getPack().getPayments());
            if (CashDeviceManager.getInstance() != null) {
                si.getData().put("coin-enable", String.valueOf(CashDeviceManager.getInstance().getDefaultCoinValidator() != null && CashDeviceManager.getInstance().getDefaultCoinValidator().isEnabled()));
            }
            css.init((ScreenDescription)ssd, si);
            this.log.info((Object)"Start payment");
            environment.getPaymentModule().startPayment(environment, css);
        }
        catch (InitException ex) {
            ProblemNotifier.getDefaultNotifier().onError((Exception)((Object)ex));
        }
    }

    public void _startPayment(final Environment environment, final SumScreenDescription ssd, final Map<String, Object> data, final Sum oper, final Service srv, final Commission comm) {
        if (this.templateModule != null) {
            this.templateModule.save(this.getDataContext(), new TemplateModuleListener(){

                @Override
                public void onResult(Map<String, Object> localData) {
                    data.putAll(localData);
                    BaseInputModule.this._beforeStartToPayment(environment, ssd, data, oper, srv, comm);
                }

                @Override
                public void onRestore() {
                    BaseInputModule.this.restore();
                }

                @Override
                public void onMainMenu() {
                    BaseInputModule.this.ctx.toMainMenu();
                }

                @Override
                public void onCalculate() {
                }

                @Override
                public void onOffer() {
                }

                @Override
                public void onCancel() {
                    BaseInputModule.this.back();
                }
            });
        } else {
            this._beforeStartToPayment(environment, ssd, data, oper, srv, comm);
        }
    }

    public void _beforeStartToPayment(Environment environment, SumScreenDescription ssd, Map<String, Object> data, Sum oper, Service srv, Commission comm) {
        LinkedHashMap<String, Object> d;
        Service service = srv == null ? environment.getMenuItem().getService() : srv;
        LinkedHashMap<String, Object> linkedHashMap = d = data == null ? new LinkedHashMap<String, Object>() : data;
        if (service.isFiscalService()) {
            LocalFiscalRequestListener l = new LocalFiscalRequestListener(environment, ssd, d, null, oper, srv, comm);
            this.context.getTaskExecutor().execute(new TaskAdapter(new FiscalRequestTask(service.getId(), this.ctx, l, d, null, environment.getLocale()), environment.getLocale()));
        } else {
            this._startToPayment(environment, ssd, d, oper, srv, comm);
        }
    }

    protected void prePayment(Environment environment, Map<String, Object> data, Sum oper, Service srv, Commission comm) {
        this.log.info((Object)"Pre-payment actions");
        Pack pack = Session.getInstance().getPack();
        Payment payment = new Payment();
        payment.setData(data);
        Service s = srv == null ? environment.getMenuItem().getService() : srv;
        Commission personal = ProviderHelper.getPersonalCommission(data, s.getId(), s.getServiceTypeId());
        if (personal != null) {
            this.log.info((Object)("Set personal commission: " + personal));
            pack.setCommission(personal);
        } else if (comm != null) {
            pack.setCommission(comm);
        } else {
            pack.setCommission(environment.getMenuItem().getCommission());
        }
        pack.setService(s);
        pack.getPayments().clear();
        pack.setOperationSum(oper);
        pack.getPayments().add(payment);
    }

    private void _startToPayment(Environment environment, SumScreenDescription ssd, Map<String, Object> data, Sum oper, Service srv, Commission comm) {
        this.prePayment(environment, data, oper, srv, comm);
        CommonSumScreen css = (CommonSumScreen)CommonScreenStore.getSumScreen((SumScreenDescription)ssd, (MenuItem)environment.getMenuItem(), (boolean)true);
        try {
            Pack pack = Session.getInstance().getPack();
            ScreenInit si = InitModuleHelper.buildScreenInit(environment, data, pack.getService(), pack.getCommission());
            si.setPayments(pack.getPayments());
            si.getData().put("pernumbers", ReferenceManager.getInstance().getPersonalNumbers(environment.getMenuItem().getService()));
            if (CashDeviceManager.getInstance() != null) {
                si.getData().put("coin-enable", String.valueOf(CashDeviceManager.getInstance().getDefaultCoinValidator() != null && CashDeviceManager.getInstance().getDefaultCoinValidator().isEnabled()));
            }
            css.init((ScreenDescription)ssd, si);
            this.log.info((Object)"Start payment");
            environment.getPaymentModule().startPayment(environment, css);
        }
        catch (InitException | ReferenceException ex) {
            ProblemNotifier.getDefaultNotifier().onError((Exception)ex);
        }
    }

    public void addListener(ServiceIdListener listener) {
        if (listener != null) {
            this.listeners.add(listener);
        }
    }

    protected abstract void _restore();

    protected Map<String, Object> getDataContext() {
        return null;
    }

    protected void mergeData(Map<String, Object> data) {
        this.log.info((Object)"This input module does not have implementation of mergeData method");
    }

    protected void showNextScreen() {
        this.log.info((Object)"This input module does not have implementation of showNextScreen method");
    }

    protected void showCurrentScreen() {
        this.log.info((Object)"This input module does not have implementation of showCurrentScreen method");
    }

    public String getOffer(String fileName, Locale locale) {
        String res;
        if (fileName == null) {
            fileName = "offer";
        }
        if ((res = this.processor.process(fileName + (locale != null ? "_" + locale.getLanguage() : "") + ".html")) != null) {
            return res;
        }
        return this.processor.process(fileName + ".html");
    }

    private DialogScreen createPayoutBreakDialog(Sum change) {
        String message = this.getChangeVarCount(Session.getInstance().getPack().getService().getChangeType()) > 1 ? B.get((String)"Module.input.payout.select", (Locale)this.env.getLocale()) : B.get((String)"Module.input.payout.break", (Locale)this.env.getLocale());
        DialogScreen dialog = ComponentFactory.getInstance().createDialog(DialogType.Question, MessageFormat.format(message, change), 20, DC.cases((int)6, (Locale)this.env.getLocale(), (Object[])new Object[0]), UserCase.Cancel);
        dialog.addListener((DialogListener)new LocalBackDialogListener());
        return dialog;
    }

    protected void setRecommendedSum(Map<String, Object> data) {
        if (data == null) {
            return;
        }
        Object ieRecommendedSum = data.get("sum");
        if (ieRecommendedSum instanceof InputElement) {
            InputElement ie = (InputElement)ieRecommendedSum;
            try {
                int parseInt = Integer.parseInt(ie.getValue());
                if (parseInt > 0) {
                    Pack pack = Session.getInstance().getPack();
                    Sum sum = new Sum(parseInt);
                    if (ie.hasFlag(1024)) {
                        pack.setOperationSum(sum);
                        this.log.info((Object)("Set operationSum: " + sum));
                    } else {
                        pack.setRecommendedSum(sum);
                        this.log.info((Object)("Set recommendedSum: " + sum));
                    }
                } else {
                    this.log.warn((Object)"Input-element 'sum' - negative integer value");
                }
            }
            catch (Exception ex) {
                this.log.warn((Object)"Input-element 'sum'- invalid integer value");
            }
        }
    }

    private int getChangeVarCount(int mask) {
        int count = 0;
        for (int i = 0; i < 4; ++i) {
            if ((mask & 1 << i) <= 0) continue;
            ++count;
        }
        return count;
    }

    protected void continuePayment(Runnable cancelListener) {
        this.log.info((Object)"Continue payment");
        ModuleHelper.invoke(cancelListener);
        BarcodeScanner.getScanner().addListener(this.barcodeListener);
    }

    private class LocalOfferListener
    extends ScreenAdapter {
        private final Restorable parent;

        public LocalOfferListener(Restorable parent) {
            this.parent = parent;
        }

        public void onAction(String action, Map<String, Object> data, Runnable cancelListener) {
            if (ActionType.isNext((String)action)) {
                try {
                    BaseInputModule.this._checkTemplates(BaseInputModule.this.env, this.parent);
                    for (ServiceIdListener listener : BaseInputModule.this.listeners) {
                        listener.onServiceIdChange(BaseInputModule.this.env.getMenuItem().getService().getId());
                    }
                    cancelListener.run();
                }
                catch (Exception ex) {
                    ModuleHelper.invoke(cancelListener);
                }
            } else if (ActionType.isPrev((String)action)) {
                BaseInputModule.this.back();
            } else if (ActionType.isExit((String)action)) {
                BaseInputModule.this.cancel(null);
            }
        }

        public void onRedirect(int serviceId) {
            BaseInputModule.this._redirect(serviceId);
        }
    }

    private class LocalBackDialogListener
    implements DialogListener {
        private LocalBackDialogListener() {
        }

        public void dialogClosed(UserCase userCase) {
            if (userCase == UserCase.Ok) {
                BaseInputModule.this.continuePayment(BaseInputModule.this.cancelListener);
            } else {
                BaseInputModule.this.log.info((Object)"Break payment");
                Pack pack = Session.getInstance().getPack();
                Payment payment = new Payment();
                if (BaseInputModule.this.env.getMenuItem().getService().getId() != 0) {
                    pack.setService(BaseInputModule.this.env.getMenuItem().getService());
                }
                pack.setCommission(BaseInputModule.this.env.getMenuItem().getCommission());
                payment.setSumOut(new Sum());
                Map<String, Object> elements = BaseInputModule.this.getDataContext();
                if (elements == null) {
                    elements = new HashMap<String, Object>();
                }
                if (elements.get("id1") == null) {
                    elements.put("id1", new InputElement("id1", "", "payback"));
                }
                payment.setData(elements);
                Keeper keeper = pack.getKeeper();
                Sum changeSum = keeper.getSum();
                Keeper change = new Keeper();
                change.addPayback(changeSum);
                Sum s0 = new Sum();
                pack.setSumResult(new SumResult(keeper.getCashSum(), keeper.getCashlessSum(), s0, s0, s0, changeSum, null, null));
                pack.getPayments().clear();
                pack.getPayments().add(payment);
                pack.setCancel(true);
                pack.setChange(change);
                BaseInputModule.this.env.getPayoutModule().startPayout(BaseInputModule.this.env);
            }
        }
    }

    private class LocalFiscalRequestListener
    implements FiscalRequestListener {
        private final Environment environment;
        private final SumScreenDescription ssd;
        private final Map<String, Object> data;
        private final Sum oper;
        private final Service srv;
        private final Commission comm;
        List<Payment> payments;

        public LocalFiscalRequestListener(Environment environment, SumScreenDescription ssd, Map<String, Object> data, List<Payment> payments, Sum oper, Service srv, Commission comm) {
            this.environment = environment;
            this.ssd = ssd;
            this.data = data;
            this.payments = payments;
            this.oper = oper;
            this.srv = srv;
            this.comm = comm;
        }

        @Override
        public void onResult(Map<String, Object> resData) {
            if (this.data != null) {
                this.data.putAll(resData);
                BaseInputModule.this._startToPayment(this.environment, this.ssd, this.data, this.oper, this.srv, this.comm);
            } else if (this.payments != null) {
                for (Payment p : this.payments) {
                    p.getData().putAll(this.data);
                }
                BaseInputModule.this._repeatToPayment(this.environment, this.ssd, this.payments, this.oper, this.srv, this.comm);
            }
        }

        @Override
        public void onRestore() {
            BaseInputModule.this.restore();
        }
    }

    private class LocalBarcodeScannerListener
    implements BarcodeScannerListener {
        private LocalBarcodeScannerListener() {
        }

        public void onData(String barcode) {
            block6: {
                BaseInputModule.this.log.info((Object)("Received barcode: " + barcode));
                ru.softlogic.input.model.field.barcode.BarcodeScanner bs = BaseInputModule.this.barcodeScanner;
                if (bs != null) {
                    BaseInputModule.this.log.info((Object)"Try to parce:");
                    try {
                        BarcodeData bd = bs.getParser().parse(barcode);
                        BaseInputModule.this.log.info((Object)("Result: " + bd));
                        BaseInputModule.this.mergeData(StoreHelper.convertObj((List)bd.getElements()));
                        if (ru.softlogic.input.model.field.barcode.BarcodeScanner.isRefresh((String)bs.getOnSuccess())) {
                            BaseInputModule.this.showCurrentScreen();
                            break block6;
                        }
                        BaseInputModule.this.showNextScreen();
                    }
                    catch (BarcodeException be) {
                        if (bs.isShowError()) {
                            DialogScreen dialog = ComponentFactory.getInstance().createDialog(DialogType.Error, B.get((String)"Module.input.barcode.error", (Locale)BaseInputModule.this.env.getLocale()), 10, DC.cases((int)8, (Locale)BaseInputModule.this.env.getLocale(), (Object[])new Object[0]), UserCase.Ok);
                            BaseInputModule.this.context.showDialog((DialogInterface)dialog);
                        }
                        BaseInputModule.this.log.error((Object)"Error on process barcode", (Throwable)be);
                    }
                } else {
                    BaseInputModule.this.log.info((Object)"Parser is missing");
                }
            }
        }
    }
}

