/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.module.entry;

import i18n.B;
import java.text.MessageFormat;
import java.util.Locale;
import org.apache.log4j.Logger;
import ru.softlogic.app.LoggerId;
import ru.softlogic.app.configuration.AppDefaults;
import ru.softlogic.app.context.BaseApplicationContext;
import ru.softlogic.app.context.PaymentHelper;
import ru.softlogic.app.session.Session;
import ru.softlogic.cash.Keeper;
import ru.softlogic.gui.factory.ComponentFactory;
import ru.softlogic.gui.screen.popup.dialog.DC;
import ru.softlogic.gui.screen.popup.dialog.DialogInterface;
import ru.softlogic.gui.screen.popup.dialog.DialogListener;
import ru.softlogic.gui.screen.popup.dialog.DialogScreen;
import ru.softlogic.gui.screen.popup.dialog.DialogType;
import ru.softlogic.gui.screen.popup.dialog.UserCase;
import ru.softlogic.gui.useraction.UserAction;
import ru.softlogic.module.Module;
import ru.softlogic.module.PackUtility;
import ru.softlogic.reference.ReferenceException;
import ru.softlogic.reference.ReferenceManager;
import ru.softlogic.srv.connector.ClientInterface;
import ru.softlogic.system.util.ThreadUtil;

public class ChangeCancelManager
implements Runnable {
    private static final Logger log = LoggerId.PAY;
    private static int TIMEOUT = 30;
    private static boolean SHOW_TIMEOUT_DIALOG = false;
    private final ClientInterface ci;
    private final BaseApplicationContext context;

    public ChangeCancelManager(ClientInterface ci, BaseApplicationContext context) {
        this.ci = ci;
        this.context = context;
        log.setAdditivity(false);
        TIMEOUT = AppDefaults.getInstance().getIntegerValue("Manager.change.cancel.timeout", 30);
        SHOW_TIMEOUT_DIALOG = AppDefaults.getInstance().getBooleanProperty("Manager.change.cancel.timeout.show-dialog", false);
    }

    @Override
    public void run() {
        while (!Thread.currentThread().isInterrupted()) {
            Keeper kp;
            Module module = this.context.getModuleStore().getModule();
            if (module != null && (module.getType() == 1 || module.getType() == 0) && UserAction.getInstance().isElapsed(TIMEOUT) && (kp = Session.getInstance().getCurrentKeeper()) != null && !kp.getSum().isEmpty()) {
                UserAction.getInstance().update();
                log.info((Object)("\u0412\u044b\u0448\u0435\u043b \u0442\u0430\u0439\u043c\u0430\u0443\u0442 \u0437\u0430\u0447\u0438\u0441\u043b\u0435\u043d\u0438\u044f \u0441\u0434\u0430\u0447\u0438 " + kp));
                if (SHOW_TIMEOUT_DIALOG) {
                    log.info((Object)"\u0421\u043f\u0440\u0430\u0448\u0438\u0432\u0430\u0435\u043c \u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u044f \u043d\u0443\u0436\u043d\u043e \u043b\u0438 \u0435\u043c\u0443 \u0435\u0449\u0435 \u0432\u0440\u0435\u043c\u044f");
                    DialogScreen dialog = ComponentFactory.getInstance().createDialog(DialogType.Question, B.get((String)"Dialog.change.cancel.timeout.dialog", (Locale)Locale.getDefault()), 20, DC.cases((int)24, (Locale)Locale.getDefault(), (Object[])new Object[0]), UserCase.Cancel);
                    dialog.addListener(new DialogListener(){

                        public void dialogClosed(UserCase userCase) {
                            log.info((Object)("\u041f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u044c \u0432\u044b\u0431\u0440\u0430\u043b " + userCase));
                            if (userCase == UserCase.Cancel) {
                                log.info((Object)"\u041e\u0442\u043f\u0440\u0430\u0432\u043b\u044f\u0435\u043c \u043e\u0441\u0442\u0430\u0442\u043e\u043a \u043d\u0430 \u0441\u0435\u0440\u0432\u0438\u0441 \u0441\u0431\u0435\u0440\u0435\u0436\u0435\u043d\u0438\u044f \u0441\u0440\u0435\u0434\u0441\u0442\u0432");
                                ChangeCancelManager.this.sendFaultPayment();
                            }
                        }
                    });
                    this.context.showDialog((DialogInterface)dialog);
                } else {
                    log.info((Object)"\u041e\u0442\u043f\u0440\u0430\u0432\u043b\u044f\u0435\u043c \u043e\u0441\u0442\u0430\u0442\u043e\u043a \u043d\u0430 \u0441\u0435\u0440\u0432\u0438\u0441 \u0441\u0431\u0435\u0440\u0435\u0436\u0435\u043d\u0438\u044f \u0441\u0440\u0435\u0434\u0441\u0442\u0432");
                    this.sendFaultPayment();
                }
            }
            ThreadUtil.sleep((long)2000L);
        }
    }

    public static int getTimeout() {
        return TIMEOUT;
    }

    private void sendFaultPayment() {
        PackUtility.printPack("\u041f\u043e\u0441\u043b\u0435\u0434\u043d\u0438\u0435 \u0434\u0430\u043d\u043d\u044b\u0435", Session.getInstance().getPack());
        PaymentHelper.sendFaultPayment(this.ci, true);
        Session.getInstance().setChangeDate(null);
        Session.getInstance().setCurrentKeeper(null);
        String support = "";
        try {
            support = ReferenceManager.getInstance().getDealer().getSupport();
        }
        catch (ReferenceException referenceException) {
            // empty catch block
        }
        DialogScreen dialog = ComponentFactory.getInstance().createDialog(DialogType.Info, MessageFormat.format(B.get((String)"Dialog.change.cancel.timeout", (Locale)Locale.getDefault()), support), 20, DC.cases((int)8, (Locale)Locale.getDefault(), (Object[])new Object[0]), UserCase.Ok);
        dialog.addListener(new DialogListener(){

            public void dialogClosed(UserCase userCase) {
                ChangeCancelManager.this.context.toMainMenu();
            }
        });
        this.context.showDialog((DialogInterface)dialog);
    }
}

