/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.module.completive;

import i18n.B;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import org.apache.log4j.Logger;
import ru.softlogic.app.context.ApplicationContext;
import ru.softlogic.app.session.Pack;
import ru.softlogic.app.session.Payment;
import ru.softlogic.app.session.Session;
import ru.softlogic.gui.factory.ComponentFactory;
import ru.softlogic.gui.screen.content.dialog.CustomContentDialog;
import ru.softlogic.gui.screen.popup.dialog.DC;
import ru.softlogic.gui.screen.popup.dialog.DialogInterface;
import ru.softlogic.gui.screen.popup.dialog.DialogListener;
import ru.softlogic.gui.screen.popup.dialog.DialogScreen;
import ru.softlogic.gui.screen.popup.dialog.DialogType;
import ru.softlogic.gui.screen.popup.dialog.UserCase;
import ru.softlogic.gui.screen.popup.dialog.custom.CompleteInit;
import ru.softlogic.gui.screen.popup.dialog.custom.CompletePanel;
import ru.softlogic.gui.screen.popup.dialog.custom.CustomDialogListener;
import ru.softlogic.gui.screen.popup.dialog.custom.CustomPanel;
import ru.softlogic.gui.utils.menu.MenuUtils;
import ru.softlogic.gui.utils.menu.MenuVisitor;
import ru.softlogic.gui.utils.menu.PopularServiceVisitor;
import ru.softlogic.input.model.advanced.AdvancedScreenDescription;
import ru.softlogic.input.model.advanced.Scenario;
import ru.softlogic.input.model.screen.description.SumScreenDescription;
import ru.softlogic.module.PackUtility;
import ru.softlogic.module.Paths;
import ru.softlogic.module.completive.BaseCompletiveModule;
import ru.softlogic.module.input.BaseInputModule;
import ru.softlogic.module.input.Environment;
import ru.softlogic.parser.ParseException;
import ru.softlogic.parser.adv.ScenarioStore;
import ru.softlogic.reference.menu.MenuItem;
import ru.softlogic.service.comission.Commission;

public class MainCompletiveModule
extends BaseCompletiveModule {
    private Logger log = Logger.getLogger((String)"pay");
    private ScenarioStore scenarioStore = new ScenarioStore(Paths.getScenarioPath(), Paths.getAutoCompletePath());
    private Scenario scenario;
    private SumScreenDescription sumDescription;
    private Environment env;
    private final CompletePanel popularServicePanel = (CompletePanel)ComponentFactory.getInstance().createDialogPanel("popular-services");
    private String sumType;

    public MainCompletiveModule(ApplicationContext context) {
        super(context);
    }

    @Override
    protected void _start(Environment env) {
        block14: {
            this.env = env;
            if (env.getTargetServiceId() != null) {
                this.toMenu(env.getTargetServiceId(), null);
            } else if (env.getTargetGroupLabel() != null) {
                this.toMenu(null, env.getTargetGroupLabel());
            } else if (Session.getInstance().getPack().getService().isPaymentSameDetails()) {
                this.paymentSameDetail(env);
            } else if (Session.getInstance().getPack().getService().getTogetherServicesId() != null && this.popularServicePanel != null) {
                try {
                    String[] servs = Session.getInstance().getPack().getService().getTogetherServicesId().split(",");
                    HashSet<Integer> list = new HashSet<Integer>();
                    for (String s : servs) {
                        try {
                            list.add(Integer.parseInt(s.trim()));
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    PopularServiceVisitor psv = new PopularServiceVisitor(list);
                    MenuUtils.processMenu((MenuVisitor)psv);
                    Set candidates = psv.getCandidates();
                    if (candidates == null || candidates.isEmpty()) {
                        this.toMenu(null, null);
                        break block14;
                    }
                    HashMap<String, Object> data = new HashMap<String, Object>();
                    data.put("env", env);
                    data.put("services", candidates);
                    data.put("pack", Session.getInstance().getPack());
                    this.popularServicePanel.init(new CompleteInit(null, env.getMenuItem().getService(), env.getMenuItem().getCommission(), null, data, env.getLocale(), env.getDateOfStartPayment(), PackUtility.getPaymentTool(Session.getInstance().getPack().getPaymentTool()), env.getMenuItem()));
                    CustomContentDialog dialog = new CustomContentDialog((CustomPanel)this.popularServicePanel, 10);
                    dialog.addListener(new CustomDialogListener(){

                        public void onClose(Object obj) {
                            MainCompletiveModule.this.log.info((Object)("Dialog closed with " + obj));
                            MainCompletiveModule.this.toMenu(((MenuItem)obj).getService().getId(), null);
                        }
                    });
                    this.context.showDialog((DialogInterface)dialog);
                }
                catch (Exception ex) {
                    this.log.error((Object)ex, (Throwable)ex);
                    this.toMenu(null, null);
                }
            } else {
                this.toMenu(null, null);
            }
        }
    }

    private void toMenu(Integer targetId, Integer groupId) {
        this.log.info((Object)"Goto main menu");
        if (targetId != null) {
            this.context.toMainMenu(targetId);
        } else if (groupId != null) {
            this.context.toMainMenuGroup(groupId);
        } else {
            this.context.toMainMenu();
        }
        Logger.getLogger((String)"pay").info((Object)B.get((String)"Module.finish", (Locale)this.env.getLocale()));
    }

    private void paymentSameDetail(final Environment environment) {
        this.sumDescription = null;
        try {
            this.log.info((Object)"Defining type of sum sreen");
            this.log.info((Object)"Load scenario");
            this.scenario = this.scenarioStore.getScenario(Session.getInstance().getPack().getService().getCode(), environment.getLocale());
            this.log.info((Object)"Success");
            for (String key : this.scenario.getScreens().keySet()) {
                if (!(((AdvancedScreenDescription)this.scenario.getScreens().get(key)).getDescription() instanceof SumScreenDescription)) continue;
                this.sumDescription = (SumScreenDescription)((AdvancedScreenDescription)this.scenario.getScreens().get(key)).getDescription();
                break;
            }
            if (this.sumDescription == null) {
                this.sumDescription = new SumScreenDescription();
                this.sumDescription.setType("sum");
            }
            this.sumType = this.sumDescription.getType();
            this.log.info((Object)("Sum screen type: " + this.sumDescription.getType()));
        }
        catch (ParseException ex) {
            this.log.error((Object)ex, (Throwable)ex);
        }
        this.log.info((Object)"\u0421\u043e\u0432\u0435\u0440\u0448\u0438\u0442\u044c \u0435\u0449\u0435 \u043e\u0434\u0438\u043d \u043f\u043b\u0430\u0442\u0435\u0436 \u043d\u0430 \u0442\u0435 \u0436\u0435 \u0440\u0435\u043a\u0432\u0438\u0437\u0438\u0442\u044b?");
        DialogScreen dialog = null;
        dialog = ComponentFactory.getInstance().createDialog(DialogType.Question, B.get((String)"Dialog.payment.yet", (Locale)environment.getLocale()), 10, DC.cases((int)24, (Locale)environment.getLocale(), (Object[])new Object[0]), UserCase.Cancel);
        this.sumDescription = new SumScreenDescription();
        if (this.sumType != null) {
            this.sumDescription.setType(this.sumType);
        } else {
            this.sumDescription.setType("sum");
        }
        dialog.addListener(new DialogListener(){

            public void dialogClosed(UserCase userCase) {
                MainCompletiveModule.this.log.info((Object)("User make choise " + userCase));
                if (userCase == UserCase.Ok) {
                    if (environment.getInputModule() instanceof BaseInputModule) {
                        BaseInputModule bim = (BaseInputModule)environment.getInputModule();
                        Commission comm = Session.getInstance().getPack().getCommission() != null ? Session.getInstance().getPack().getCommission() : environment.getMenuItem().getCommission();
                        MainCompletiveModule.this.log.info((Object)("Go to payment module with environment: " + environment));
                        Pack pack = Session.getInstance().getPack();
                        pack.setCbc(null);
                        bim._startPayment(environment, MainCompletiveModule.this.sumDescription, ((Payment)Session.getInstance().getPack().getPayments().get(0)).getData(), null, pack.getService(), comm);
                    }
                } else {
                    MainCompletiveModule.this.log.info((Object)"Goto main menu");
                    MainCompletiveModule.this.context.toMainMenu();
                    Logger.getLogger((String)"pay").info((Object)B.get((String)"Module.finish", (Locale)environment.getLocale()));
                }
            }
        });
        dialog.show(this.context.getShell());
    }
}

