/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.module.card;

import i18n.B;
import java.text.MessageFormat;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.Callable;
import org.apache.log4j.Logger;
import ru.softlogic.app.context.ApplicationContext;
import ru.softlogic.app.context.InputModuleContext;
import ru.softlogic.application.ContentScreenAdapter;
import ru.softlogic.application.ContentScreenAdapterKbr;
import ru.softlogic.cards.v2.connector.model.AccountInfo;
import ru.softlogic.cards.v2.connector.model.Amount;
import ru.softlogic.cards.v2.connector.model.AmountType;
import ru.softlogic.cards.v2.connector.model.OperationBalanceResult;
import ru.softlogic.cards.v2.module.CardInfo;
import ru.softlogic.cards.v2.module.CardModule;
import ru.softlogic.cards.v2.module.CashRequireListener;
import ru.softlogic.cards.v2.module.DialogListener;
import ru.softlogic.cards.v2.module.InputFormListener;
import ru.softlogic.cards.v2.module.SelectItemListener;
import ru.softlogic.cards.v2.module.UserInterfaceEvent;
import ru.softlogic.cards.v2.module.UserInterfaceEventListener;
import ru.softlogic.gui.factory.ComponentFactory;
import ru.softlogic.gui.screen.popup.dialog.DC;
import ru.softlogic.gui.screen.popup.dialog.DialogInterface;
import ru.softlogic.gui.screen.popup.dialog.DialogScreen;
import ru.softlogic.gui.screen.popup.dialog.DialogType;
import ru.softlogic.gui.screen.popup.dialog.DisplayedUserCase;
import ru.softlogic.gui.screen.popup.dialog.UserCase;
import ru.softlogic.gui.screen.popup.wait.WaitScreen;
import ru.softlogic.gui.useraction.UserAction;
import ru.softlogic.gui2.screen.ActionType;
import ru.softlogic.gui2.screen.CommonDynamicScreen;
import ru.softlogic.gui2.screen.CommonScreen;
import ru.softlogic.gui2.screen.CommonScreenStore;
import ru.softlogic.gui2.screen.ScreenAdapter;
import ru.softlogic.gui2.screen.ScreenHelper;
import ru.softlogic.gui2.screen.ScreenInit;
import ru.softlogic.gui2.screen.ScreenListener;
import ru.softlogic.hardware.device.print.CustomData;
import ru.softlogic.hardware.utils.SumFormatter;
import ru.softlogic.input.model.InputElement;
import ru.softlogic.input.model.StoreHelper;
import ru.softlogic.input.model.advanced.AdvancedScreenDescription;
import ru.softlogic.input.model.advanced.actions.Action;
import ru.softlogic.input.model.advanced.actions.ActionMap;
import ru.softlogic.input.model.field.FieldSequence;
import ru.softlogic.input.model.field.InitException;
import ru.softlogic.input.model.field.selector.ItemsStore;
import ru.softlogic.input.model.field.selector.SelectorField;
import ru.softlogic.input.model.field.selector.SelectorItem;
import ru.softlogic.input.model.field.selector.StaticStore;
import ru.softlogic.input.model.screen.ButtonInit;
import ru.softlogic.input.model.screen.description.InfoScreenDescription;
import ru.softlogic.input.model.screen.description.ScreenDescription;
import ru.softlogic.input.model.screen.description.UniScreenDescription;
import ru.softlogic.module.ModuleHelper;
import ru.softlogic.module.card.CardFormHelper;
import ru.softlogic.module.card.CardModuleStore;
import ru.softlogic.module.card.DataProvider;
import ru.softlogic.module.card.DataProviderAdapter;
import ru.softlogic.module.input.ComplexScreenListener;
import ru.softlogic.module.input.Environment;
import ru.softlogic.module.input.InitModuleHelper;
import ru.softlogic.system.util.ThreadUtil;

public abstract class UniversalGuiListener
implements UserInterfaceEventListener {
    private InputModuleContext context;
    private Environment env;
    private Logger log;
    private WaitScreen waitScreen;
    private CommonDynamicScreen pinScreen;
    private UserInterfaceEvent lastEvent;
    private DataProvider dataProvider;

    public UniversalGuiListener(ApplicationContext context, Environment env, Logger log) {
        this(context, env, log, null);
    }

    public UniversalGuiListener(ApplicationContext context, Environment env, Logger log, DataProvider dataProvider) {
        this.context = context;
        this.env = env;
        this.log = log;
        this.dataProvider = dataProvider;
        if (this.dataProvider == null) {
            this.dataProvider = new DataProviderAdapter();
        }
        this.waitScreen = ComponentFactory.getInstance().createWaitScreen("");
        this.pinScreen = (CommonDynamicScreen)CommonScreenStore.getScreen((String)"card/pin");
    }

    public void onEvent(UserInterfaceEvent uie, final Runnable r) {
        this.lastEvent = uie;
        this.log.info((Object)("Event: " + uie));
        switch (uie) {
            case CARD_REQUIRE: {
                this.log.info((Object)">>>onCardRequire");
                this.context.showWait(null);
                CommonScreen cs = CommonScreenStore.getScreen((String)"card/info");
                cs.setListener((ScreenListener)new LocalWaitListener());
                try {
                    InfoScreenDescription isd = new InfoScreenDescription("info");
                    isd.setId("card-require");
                    isd.setTitle(B.get((String)"Provider.card.require.title", (Locale)this.env.getLocale()));
                    isd.setInfo(B.get((String)"Provider.card.require.text", (Locale)this.env.getLocale()));
                    isd.setImage(B.get((String)"Provider.card.require.image", (Locale)this.env.getLocale()));
                    isd.setButtons(null);
                    cs.init((ScreenDescription)isd, InitModuleHelper.buildScreenInit(this.env, this.dataProvider.getData()));
                    this.context.showScreen(new ContentScreenAdapter(cs));
                }
                catch (InitException ex) {
                    this.log.error((Object)ex, (Throwable)ex);
                }
                ModuleHelper.invoke(r);
                break;
            }
            case TIPS_REQUIRE: {
                this.log.info((Object)">>>onTipsRequire");
                this.context.showWait(null);
                CommonScreen cs = CommonScreenStore.getScreen((String)"card/info", (String)"tips");
                cs.setListener((ScreenListener)new LocalWaitListener());
                try {
                    InfoScreenDescription isd = new InfoScreenDescription("info");
                    isd.setId("card-tips-require");
                    isd.setInfo(B.get((String)"Provider.card.tips.require.text", (Locale)this.env.getLocale()));
                    isd.setImage(B.get((String)"Provider.card.tips.require.image", (Locale)this.env.getLocale()));
                    isd.setButtons(null);
                    cs.init((ScreenDescription)isd, InitModuleHelper.buildScreenInit(this.env, this.dataProvider.getData()));
                    this.context.showScreen(new ContentScreenAdapter(cs));
                }
                catch (InitException ex) {
                    this.log.error((Object)ex, (Throwable)ex);
                }
                ModuleHelper.invoke(r);
                break;
            }
            case CARD_INSERT_TRY: {
                this.log.info((Object)"Card insert try");
                ModuleHelper.invoke(r);
                break;
            }
            case PIN_TRY_LEFT_1: {
                DialogScreen dialog = ComponentFactory.getInstance().createDialog(DialogType.Info, B.get((String)"Provider.card.pin-try-left1", (Locale)this.env.getLocale()), 10, DC.cases((int)8), UserCase.Ok);
                this.context.showDialog((DialogInterface)dialog);
                this.log.info((Object)"pin-try-left1");
                ModuleHelper.invoke(r);
                break;
            }
            case PIN_TRY_LEFT_2: {
                DialogScreen dialog = ComponentFactory.getInstance().createDialog(DialogType.Info, B.get((String)"Provider.card.pin-try-left2", (Locale)this.env.getLocale()), 10, DC.cases((int)8), UserCase.Ok);
                this.context.showDialog((DialogInterface)dialog);
                this.log.info((Object)"pin-try-left2");
                ModuleHelper.invoke(r);
                break;
            }
            case PIN_REQUIRE: {
                this.log.info((Object)">>>onPinRequire");
                this.context.showWait(null);
                this.pinScreen.setListener((ScreenListener)new LocalWaitListener());
                try {
                    ScreenDescription sd = new ScreenDescription("card/pin");
                    this.pinScreen.init(sd, InitModuleHelper.buildScreenInit(this.env, this.dataProvider.getData()));
                    this.context.showScreen(new ContentScreenAdapter((CommonScreen)this.pinScreen));
                }
                catch (InitException ex) {
                    this.log.error((Object)ex, (Throwable)ex);
                }
                ModuleHelper.invoke(r);
                break;
            }
            case ONLINE_REQUEST: {
                this.log.info((Object)">>>onStartNetworkRequest");
                this.waitScreen.setText(B.get((String)"Provider.card.wait", (Locale)this.env.getLocale()));
                this.context.showWait(this.waitScreen);
                ModuleHelper.invoke(r);
                break;
            }
            case TAKE_CARD: {
                ThreadUtil.sleep((long)100L);
                this.waitScreen.setText(B.get((String)"Provider.card.take-card", (Locale)this.env.getLocale()));
                this.context.showWait(this.waitScreen);
                this.log.info((Object)"Show take card");
                ModuleHelper.invoke(r);
                break;
            }
            case CARD_CAPTURED_BY_HOST: {
                this.context.showWait(null);
                this.log.info((Object)"CARD_CAPTURED_BY_HOST");
                ModuleHelper.invoke(r);
                break;
            }
            case CARD_CAPTURED_BY_TIMEOUT: {
                this.context.showWait(null);
                this.log.info((Object)"CARD_CAPTURED_BY_TIMEOUT");
                ModuleHelper.invoke(r);
                break;
            }
            case CARD_CAPTURE_FAIL: {
                this.context.showWait(null);
                this.log.info((Object)"CARD_CAPTURE_FAIL");
                ModuleHelper.invoke(r);
                break;
            }
            case CARD_RETURNED: {
                this.context.showWait(null);
                this.log.info((Object)"CARD_RETURNED");
                ModuleHelper.invoke(r);
                break;
            }
            case SESSION_CLOSED: {
                this.context.showWait(null);
                this.log.info((Object)"SESSION_CLOSED");
                this._onClosed();
                ModuleHelper.invoke(r);
                break;
            }
            case CARD_WRONG: {
                DialogScreen dialog = ComponentFactory.getInstance().createDialog(DialogType.Info, B.get((String)"Provider.card.wrong-card", (Locale)this.env.getLocale()), 10, DC.cases((int)8), UserCase.Ok);
                dialog.addListener(new ru.softlogic.gui.screen.popup.dialog.DialogListener(){

                    public void dialogClosed(UserCase userCase) {
                        ModuleHelper.invoke(r);
                    }
                });
                this.context.showDialog((DialogInterface)dialog);
                this.log.info((Object)"Wrong card");
                break;
            }
        }
        UserAction.getInstance().update();
    }

    public void onBalance(final OperationBalanceResult obr, final CardInfo ci, final Runnable r) {
        UserAction.getInstance().update();
        try {
            CommonScreen cs = CommonScreenStore.getScreen((String)"card/deposit");
            cs.setListener(new ScreenListener(){

                public void onAction(String action, Map<String, Object> data, Runnable cancelListener) {
                    if (ActionType.isNext((String)action)) {
                        ModuleHelper.invoke(r);
                    } else if (ActionType.isEdit((String)action)) {
                        UniversalGuiListener.this.log.info((Object)("OperationBalanceResult: " + obr));
                        UniversalGuiListener.this.log.info((Object)"Show question dialog");
                        DisplayedUserCase[] du = new DisplayedUserCase[]{new DisplayedUserCase(UserCase.Cancel, B.get((String)"Provider.card.balance.print", (Locale)UniversalGuiListener.this.env.getLocale())), new DisplayedUserCase(UserCase.Ok, B.get((String)"Provider.card.balance.screen", (Locale)UniversalGuiListener.this.env.getLocale()))};
                        DialogScreen dialog = ComponentFactory.getInstance().createDialog(DialogType.Question, B.get((String)"Provider.card.balance.question", (Locale)UniversalGuiListener.this.env.getLocale()), 20, du, UserCase.Ok);
                        dialog.addListener((ru.softlogic.gui.screen.popup.dialog.DialogListener)new LocalBalanceListener(obr, ci));
                        UniversalGuiListener.this.context.showDialog((DialogInterface)dialog);
                        ModuleHelper.invoke(cancelListener);
                    } else {
                        UniversalGuiListener.this.log.info((Object)"Cancel card module operation");
                        try {
                            CardModule cm = CardModuleStore.getInstance().getCurrentSession();
                            if (cm != null) {
                                cm.cancelOperation();
                            }
                        }
                        catch (Exception e) {
                            ModuleHelper.invoke(cancelListener);
                        }
                        UniversalGuiListener.this.log.info((Object)"Operation canceled");
                    }
                }

                public void onLocale(Locale locale) {
                }

                public void onRedirect(int serviceId) {
                }

                public void showPopup(ScreenDescription sd, ScreenInit si, ScreenListener listener) {
                }
            });
            ScreenDescription sd = new ScreenDescription();
            cs.init(ScreenHelper.processBack((ScreenDescription)sd, (boolean)true, (boolean)true), InitModuleHelper.buildScreenInit(this.env, Collections.EMPTY_MAP));
            this.context.showWait(null);
            this.context.showScreen(new ContentScreenAdapterKbr(cs));
        }
        catch (Exception e) {
            this.log.error((Object)e, (Throwable)e);
            this.context.getTaskExecutor().submit(new Callable(){

                public Object call() throws Exception {
                    ModuleHelper.invoke(r);
                    return null;
                }
            });
        }
    }

    public void onInputForm(String string, Map<String, String> initData, final InputFormListener il) {
        this.context.showWait(null);
        UserAction.getInstance().update();
        this.log.info((Object)("On input form " + string));
        try {
            AdvancedScreenDescription asd = CardFormHelper.getScenario(this.env.getLocale()).getScreenById(string);
            if (asd == null) {
                throw new InitException("Can't get screen: " + string);
            }
            ScreenDescription sd = asd.getDescription();
            UniversalGuiListener.processButtons(asd.getDescription(), asd.getActionMap());
            CommonScreen cs = CommonScreenStore.getScreen((String)sd.getType());
            if (cs == null) {
                throw new InitException("Can't get screen type: " + sd.getType());
            }
            cs.setListener((ScreenListener)new ScreenAdapter(){

                public void onAction(String action, final Map<String, Object> data, Runnable cancelListener) {
                    if (ActionType.isNext((String)action)) {
                        UniversalGuiListener.this.onFormData(data);
                        UniversalGuiListener.this.context.getTaskExecutor().submit(new Callable(){

                            public Object call() throws Exception {
                                il.onData(StoreHelper.convertDep((Map)data));
                                return null;
                            }
                        });
                    } else {
                        il.onCancel();
                    }
                }

                public void onLocale(Locale locale) {
                }

                public void onRedirect(int serviceId) {
                }
            });
            HashMap<String, Object> data = new HashMap<String, Object>();
            for (Map.Entry<String, String> entry : initData.entrySet()) {
                InputElement ie = new InputElement(entry.getKey(), entry.getKey(), entry.getValue());
                data.put(entry.getKey(), ie);
            }
            cs.init(ScreenHelper.processBack((ScreenDescription)sd, (boolean)true, (boolean)true), InitModuleHelper.buildScreenInit(this.env, data));
            this.context.showScreen(new ContentScreenAdapterKbr(cs));
        }
        catch (Exception ex) {
            this.log.error((Object)ex, (Throwable)ex);
            this.context.getTaskExecutor().submit(new Callable(){

                public Object call() throws Exception {
                    il.onCancel();
                    return null;
                }
            });
        }
    }

    public void onCashRequire(boolean isEmitent, AccountInfo ai, CashRequireListener cl) {
    }

    public void onSelectItem(String title, Map<String, Object> map, final SelectItemListener sl) {
        this.context.showWait(null);
        UserAction.getInstance().update();
        this.log.info((Object)("onSelectItem " + map));
        UniScreenDescription sd = new UniScreenDescription("selector");
        sd.setTitle(B.get((String)title, (Locale)this.env.getLocale(), (String)title));
        sd.setDecor("button");
        SelectorField sf = new SelectorField();
        sf.setId("items");
        LinkedList<SelectorItem> items = new LinkedList<SelectorItem>();
        for (String key : map.keySet()) {
            SelectorItem si = new SelectorItem(B.get((String)key, (Locale)this.env.getLocale(), (String)key), key);
            si.setCustomData(Collections.singletonMap(key, map.get(key)));
            items.add(si);
        }
        sf.setStore((ItemsStore)new StaticStore(items));
        sd.setSequence(new FieldSequence(Collections.singletonList(sf)));
        sd.setButtons(new HashMap());
        sd.getButtons().put("Next", new ButtonInit(null));
        sd.getButtons().put("Exit", new ButtonInit(null));
        sd.getButtons().put("Prev", null);
        CommonScreen cs = CommonScreenStore.getScreen((String)sd.getType());
        if (cs == null) {
            this.log.error((Object)("Can't get screen type: " + sd.getType()));
            this.context.getTaskExecutor().submit(new Callable(){

                public Object call() throws Exception {
                    sl.onCancel();
                    return null;
                }
            });
        }
        ComplexScreenListener cl = new ComplexScreenListener((ApplicationContext)this.context){

            @Override
            public void _onAction(String action, Map<String, Object> data, Runnable cancelListener) {
                if (ActionType.isNext((String)action)) {
                    try {
                        sl.onSelect(data.get(((InputElement)data.get("items")).getValue()));
                    }
                    catch (Throwable e) {
                        UniversalGuiListener.this.log.error((Object)e);
                        sl.onCancel();
                    }
                } else {
                    sl.onCancel();
                }
            }
        };
        cl.setEnvironment(this.env);
        cs.setListener((ScreenListener)cl);
        try {
            cs.init(ScreenHelper.processBack((ScreenDescription)sd, (boolean)true, (boolean)false), InitModuleHelper.buildScreenInit(this.env, this.dataProvider.getData()));
        }
        catch (InitException ex) {
            this.log.error((Object)ex);
            this.context.getTaskExecutor().submit(new Callable(){

                public Object call() throws Exception {
                    sl.onCancel();
                    return null;
                }
            });
        }
        this.context.showScreen(new ContentScreenAdapterKbr(cs));
    }

    public void onPinEdit(String string) {
        UserAction.getInstance().update();
        this.pinScreen.updateData(Collections.singletonMap("pin", string));
    }

    public void onDialog(String dialog, String message, Map<String, Object> map, final DialogListener dl) {
        this.log.info((Object)("Dialog=" + dialog + ", message=" + message + ", map=" + map + ", dl=" + dl));
        DialogScreen dlg = null;
        String m = B.get((String)("Module.card." + message), (Locale)this.env.getLocale());
        if (map != null && !map.isEmpty()) {
            m = MessageFormat.format(m, map.values().toArray());
        }
        if ("acquireFeeConfirm".equals(dialog)) {
            dlg = ComponentFactory.getInstance().createDialog(DialogType.Question, m, 20, DC.cases((int)2, (Locale)this.env.getLocale(), (Object[])new Object[0]), UserCase.Timeout);
        } else if ("acquireFeeWarning".equals(dialog)) {
            dlg = ComponentFactory.getInstance().createDialog(DialogType.Warning, m, 20, DC.cases((int)8, (Locale)this.env.getLocale(), (Object[])new Object[0]), UserCase.Timeout);
        }
        if (dlg != null) {
            dlg.addListener(new ru.softlogic.gui.screen.popup.dialog.DialogListener(){

                public void dialogClosed(UserCase userCase) {
                    if (userCase == UserCase.Ok) {
                        dl.onResult(1);
                    } else if (userCase == UserCase.Cancel) {
                        dl.onResult(0);
                    } else {
                        dl.onTimeout();
                    }
                }
            });
            this.context.showDialog((DialogInterface)dlg);
        } else {
            this.log.error((Object)("Dialog " + dialog + " not found."));
            this.context.getTaskExecutor().submit(new Callable(){

                public Object call() throws Exception {
                    dl.onResult(-2);
                    return null;
                }
            });
        }
    }

    public static ScreenDescription processButtons(ScreenDescription sd, ActionMap map) {
        HashMap<String, ButtonInit> buttons = new HashMap<String, ButtonInit>();
        for (Action a : map.getActions()) {
            buttons.put(a.getType(), new ButtonInit(a.getTitle()));
        }
        sd.setButtons(buttons);
        return sd;
    }

    public abstract void _onClosed();

    public void onFormData(Map<String, Object> data) {
    }

    private class LocalBalanceListener
    implements ru.softlogic.gui.screen.popup.dialog.DialogListener {
        private OperationBalanceResult balance;
        private CardInfo ci;

        public LocalBalanceListener(OperationBalanceResult balance, CardInfo ci) {
            this.balance = balance;
            this.ci = ci;
        }

        public void dialogClosed(UserCase userCase) {
            UniversalGuiListener.this.log.info((Object)("User selected " + userCase));
            int own = (int)this.balance.getBalance();
            int lim = 0;
            if (this.balance.getAdditionalAmounts() != null) {
                for (Amount a : this.balance.getAdditionalAmounts()) {
                    if (a.getAmountType() != AmountType.ExceedLimit) continue;
                    lim = (int)a.getValue();
                }
            }
            int total = own + lim;
            if (userCase == UserCase.Cancel) {
                UniversalGuiListener.this.log.info((Object)"Printing card balance");
                CustomData cd = new CustomData();
                HashMap<String, String> data = new HashMap<String, String>();
                data.put("balance", "" + SumFormatter.format((int)own));
                data.put("overdraft", "" + SumFormatter.format((int)lim));
                data.put("total", "" + SumFormatter.format((int)total));
                data.put("currency", "" + this.balance.getCurrency().getDigitCode());
                data.put("pan", this.ci.getPan());
                data.put("auth", "" + this.balance.getAuthIdentResponse());
                data.put("merchant", "" + this.balance.getMerchant());
                data.put("terminal", "" + this.balance.getTerminal());
                data.put("rrn", "" + this.balance.getRrn());
                data.put("stan", "" + this.balance.getStan());
                AccountInfo ai = this.ci.getAccountInfo();
                if (ai != null) {
                    data.put("account", ai.getNumber());
                }
                cd.setData(data);
                cd.setTemplate("card_balance.tpl");
                DialogScreen dialog = ComponentFactory.getInstance().createDialog(DialogType.Info, B.get((String)"Provider.card.balance.complete", (Locale)UniversalGuiListener.this.env.getLocale()), 5, DC.cases((int)8, (Locale)UniversalGuiListener.this.env.getLocale(), (Object[])new Object[0]), UserCase.Ok);
                UniversalGuiListener.this.context.showDialog((DialogInterface)dialog);
                UniversalGuiListener.this.context.getPrinterQueue().printCustomDocument(cd);
            } else {
                UniversalGuiListener.this.log.info((Object)"Show dialog with card balance");
                String curr = B.get((String)("Provider.card.balance.currency.code." + this.balance.getCurrency().getDigitCode()), (Locale)UniversalGuiListener.this.env.getLocale());
                DialogScreen dialog = ComponentFactory.getInstance().createDialog(DialogType.Info, MessageFormat.format(B.get((String)"Provider.card.balance.text", (Locale)UniversalGuiListener.this.env.getLocale()), SumFormatter.format((int)own), SumFormatter.format((int)lim), SumFormatter.format((int)total), curr), 20, DC.cases((int)8, (Locale)UniversalGuiListener.this.env.getLocale(), (Object[])new Object[0]), UserCase.Ok);
                UniversalGuiListener.this.context.showDialog((DialogInterface)dialog);
            }
        }
    }

    private class LocalWaitListener
    extends ScreenAdapter {
        private LocalWaitListener() {
        }

        public void onAction(String action, Map<String, Object> data, Runnable cancelListener) {
            UniversalGuiListener.this.log.info((Object)("Action on wait screen: " + action));
            if (!ActionType.isNext((String)action)) {
                UniversalGuiListener.this.log.info((Object)"Cancel card module operation");
                try {
                    CardModule cm = CardModuleStore.getInstance().getCurrentSession();
                    if (cm != null) {
                        cm.cancelOperation();
                    }
                }
                catch (Exception e) {
                    ModuleHelper.invoke(cancelListener);
                }
                UniversalGuiListener.this.log.info((Object)"Operation canceled");
            }
            UserAction.getInstance().update();
        }
    }
}

