/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.module.card;

import i18n.B;
import java.util.HashMap;
import java.util.Locale;
import java.util.concurrent.Callable;
import ru.softlogic.app.context.ApplicationContext;
import ru.softlogic.cards.v2.module.CardModule;
import ru.softlogic.gui.factory.ComponentFactory;
import ru.softlogic.gui.screen.popup.dialog.DC;
import ru.softlogic.gui.screen.popup.dialog.DialogInterface;
import ru.softlogic.gui.screen.popup.dialog.DialogListener;
import ru.softlogic.gui.screen.popup.dialog.DialogScreen;
import ru.softlogic.gui.screen.popup.dialog.DialogType;
import ru.softlogic.gui.screen.popup.dialog.UserCase;
import ru.softlogic.gui.screen.popup.wait.WaitScreen;
import ru.softlogic.input.model.InputElement;
import ru.softlogic.intent.Intent;
import ru.softlogic.io.utils.BU;
import ru.softlogic.module.ModuleHelper;
import ru.softlogic.module.Restorable;
import ru.softlogic.module.card.CardModuleStore;
import ru.softlogic.module.card.UniversalGuiListener;
import ru.softlogic.module.input.BaseInputModule;
import ru.softlogic.module.input.DescriptionException;
import ru.softlogic.module.input.Environment;
import ru.softlogic.module.input.ModuleInitException;
import ru.softlogic.module.utils.ExitDialogListener;

public abstract class BaseCardInputModule
extends BaseInputModule {
    protected final HashMap<String, Object> inputData = new HashMap();
    protected Environment environment;
    protected CardModule cm;
    protected volatile boolean invokeOperation;
    protected Locale locale;

    public BaseCardInputModule(ApplicationContext context) {
        super(context);
    }

    @Override
    protected void _start(final Environment environment, Restorable parent) throws DescriptionException, ModuleInitException {
        this.environment = environment;
        this.locale = environment.getLocale();
        this.inputData.clear();
        this.inputData.putAll(environment.getInitData());
        this.context.getTaskExecutor().submit(new Callable(){

            public Object call() throws Exception {
                try {
                    BaseCardInputModule.this._startModule(environment, (ApplicationContext)BaseCardInputModule.this.context);
                }
                catch (Throwable th) {
                    BaseCardInputModule.this.log.error((Object)"", th);
                }
                return null;
            }
        });
    }

    protected abstract void _startModule(Environment var1, ApplicationContext var2) throws DescriptionException, ModuleInitException;

    protected CardModule getCardModule(Environment environment, UniversalGuiListener guiListener) {
        this.context.showWait(this.createWaitScreen());
        try {
            CardModuleStore cardModuleStore = CardModuleStore.getInstance();
            if (!cardModuleStore.isReady()) {
                this.context.showDialog((DialogInterface)this.createNotReadyDialog());
                return null;
            }
            cardModuleStore.setReference(environment.getPoint());
            CardModule currentSession = cardModuleStore.getCurrentSession();
            if (currentSession != null) {
                this.cm = currentSession;
                cardModuleStore.setUserEventInterfaceListener(guiListener);
            } else {
                this.cm = cardModuleStore.openSession(guiListener);
            }
        }
        catch (Throwable e) {
            this.log.error((Object)e, e);
            this.cm = null;
        }
        this.context.showWait(null);
        return this.cm;
    }

    private WaitScreen createWaitScreen() {
        WaitScreen waitScreen = ComponentFactory.getInstance().createWaitScreen(B.get((String)"Dialog.wait", (Locale)this.environment.getLocale()));
        waitScreen.setText(B.get((String)"Dialog.wait"));
        return waitScreen;
    }

    protected DialogScreen createNotReadyDialog() {
        return this.createDialog("Provider.card.notready");
    }

    protected DialogScreen createNoCardModuleDialog() {
        this.log.info((Object)"Card module is not present, show error");
        return this.createDialog("Provider.card.nocm");
    }

    private DialogScreen createDialog(String textCode) {
        DialogScreen dialog = ComponentFactory.getInstance().createDialog(DialogType.Error, B.get((String)textCode, (Locale)this.locale), 10, DC.cases((int)8, (Locale)this.locale, (Object[])new Object[0]), UserCase.Ok);
        dialog.addListener((DialogListener)new ExitDialogListener(this));
        return dialog;
    }

    public void baseCancel(Intent intent) {
        super.cancel(intent);
    }

    @Override
    public synchronized void cancel(Intent intent) {
        block5: {
            try {
                CardModuleStore cardModuleStore = CardModuleStore.getInstance();
                if (cardModuleStore.getCurrentSession() == null) break block5;
                try {
                    if (this.invokeOperation) {
                        this.cm.cancelOperation();
                        break block5;
                    }
                    cardModuleStore.closeSessionSafe(true);
                }
                catch (IllegalStateException e) {
                    cardModuleStore.closeSessionSafe(true);
                }
            }
            catch (Exception e) {
                ModuleHelper.invoke(this.cancelListener);
            }
        }
    }

    @Override
    protected void continuePayment(Runnable cancelListener) {
        try {
            this.start(this.environment, this);
        }
        catch (DescriptionException ex) {
            this.log.error((Object)ex);
        }
        catch (ModuleInitException ex) {
            this.log.error((Object)ex);
        }
    }

    protected void setCardPanHash(byte[] sha1) {
        InputElement ieHash = new InputElement("hash-pan", B.get((String)"Module.card.hash", (Locale)this.locale, (String)"hash-pan"), BU.toHexString((byte[])sha1));
        this.inputData.put("hash-pan", ieHash);
    }
}

