/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.module;

import org.apache.log4j.Logger;
import ru.softlogic.app.configuration.AppDefaults;
import ru.softlogic.app.context.ApplicationContext;
import ru.softlogic.app.context.BaseApplicationContext;
import ru.softlogic.module.ModuleHelper;
import ru.softlogic.module.card.CardModuleStore;
import ru.softlogic.module.completive.CompletiveModule;
import ru.softlogic.module.ending.ContentEndingModule;
import ru.softlogic.module.ending.EndingModule;
import ru.softlogic.module.ending.SkipEndingModule;
import ru.softlogic.module.input.ncp.FiscalProcessingModule;
import ru.softlogic.module.input.ntscoffee.NtsCoffeeEndingModule;
import ru.softlogic.module.input.ntscoffee.NtsCoffeePresentModule;
import ru.softlogic.module.input.ntspay.NtspayCashPaymentModule;
import ru.softlogic.module.input.ntspay.NtspayCurrencyPaymentModule;
import ru.softlogic.module.input.ntssnack.NtspaySnackCashPaymentModule;
import ru.softlogic.module.input.telepay.SequenceProcessingModule;
import ru.softlogic.module.payment.BasePaymentModule;
import ru.softlogic.module.payment.CashAndCardPaymentModule;
import ru.softlogic.module.payment.CashlessAutoPaymentModule;
import ru.softlogic.module.payment.CreditCashPaymentModule;
import ru.softlogic.module.payment.PaymentModule;
import ru.softlogic.module.payout.PayoutModule;
import ru.softlogic.module.payout.PayoutModuleDispatcherV2;
import ru.softlogic.module.present.PresentModule;
import ru.softlogic.module.print.BanneredPrintModule;
import ru.softlogic.module.print.PrintModule;
import ru.softlogic.module.processing.AzerigasCardProcessingModule;
import ru.softlogic.module.processing.AzersuCardProcessingModule;
import ru.softlogic.module.processing.CardRevertProcessingModule;
import ru.softlogic.module.processing.ExbankProcessingModule;
import ru.softlogic.module.processing.ObsoleteProcessingModule;
import ru.softlogic.module.processing.ProcessingModule;
import ru.softlogic.module.processing.VirtualProcessingModule;
import ru.softlogic.module.processing.card.SmartCardProcessingModule;
import ru.softlogic.module.reinit.ReinitModule;
import ru.softlogic.reference.menu.MenuItem;

public class ModuleFactory {
    private static final String ENDING_MODULE = "Module.ending.name";
    private static final String PROCESSING_MODULE = "Module.processing.name";
    private static final String REINIT_MODULE = "Module.reinit.name";
    private static final String CARD_PROCESSING_MODULE = "Module.cardprocessing.name";
    private static final String CARD_ENDING_MODULE = "Module.cardending.name";
    private static final String CASH_CURRENCY_PAYMENT_MODULE = "Module.cashcurrencymodule.name";
    private static final String CASH_PAYMEN_MODULE = "Module.cashmodule.name";
    private static final String PAYMENT_MODULE = "Module.paymentmodule.name";
    private static final String PAYOUT_MODULE = "Module.payout.name";
    private static final String PRESENT_MODULE = "Module.present.name";
    private static final String PRINT_MODULE = "Module.print.name";
    private static final String COMPLETIVE_MODULE = "Module.completive.name";

    public static EndingModule createEndingModule(ApplicationContext context, MenuItem menuItem, EndingModule defaultModule) {
        String name = AppDefaults.getInstance().getProperty(ENDING_MODULE);
        if (menuItem != null && menuItem.getService() != null && menuItem.getService().getModules() != null && menuItem.getService().getModules().getEnding() != null && !menuItem.getService().getModules().getEnding().isEmpty()) {
            name = menuItem.getService().getModules().getEnding();
        }
        if ("content".equals(name)) {
            return new ContentEndingModule(context);
        }
        if ("nts-pay-coffee".equals(name)) {
            return new NtsCoffeeEndingModule(context);
        }
        if ("skip".equals(name)) {
            return new SkipEndingModule(context);
        }
        return defaultModule;
    }

    public static ProcessingModule createProcessingModule(ApplicationContext context, MenuItem menuItem, ProcessingModule defaultModule) {
        String name = menuItem != null && menuItem.getService() != null && menuItem.getService().getModules() != null && menuItem.getService().getModules().getProcess() != null && !menuItem.getService().getModules().getProcess().isEmpty() ? menuItem.getService().getModules().getProcess() : AppDefaults.getInstance().getProperty(PROCESSING_MODULE);
        if ("sequence".equals(name)) {
            return new SequenceProcessingModule(context);
        }
        if ("ncp-fiscal".equals(name)) {
            return new FiscalProcessingModule(context);
        }
        if ("exbank".equals(name)) {
            return new ExbankProcessingModule(context);
        }
        if ("SmartCardProcessingModule".equals(name)) {
            return new SmartCardProcessingModule(context);
        }
        if ("virtual".equals(name)) {
            return new VirtualProcessingModule(context);
        }
        if ("AzersuCardProcessingModule".equals(name)) {
            return new AzersuCardProcessingModule(context);
        }
        if ("AzerigasCardProcessingModule".equals(name)) {
            return new AzerigasCardProcessingModule(context);
        }
        return defaultModule;
    }

    public static ReinitModule createReinitModule(ApplicationContext context, MenuItem menuItem, ReinitModule defaultModule) {
        String name = AppDefaults.getInstance().getProperty(REINIT_MODULE);
        return defaultModule;
    }

    public static ProcessingModule createCardProcessingModule(ApplicationContext context, MenuItem menuItem, ProcessingModule defaultModule) {
        if (menuItem != null && menuItem.getService() != null && menuItem.getService().getModules() != null && menuItem.getService().getModules().getProcess() != null && !menuItem.getService().getModules().getProcess().isEmpty()) {
            String name = menuItem.getService().getModules().getProcess();
        } else {
            String name = AppDefaults.getInstance().getProperty(CARD_PROCESSING_MODULE);
        }
        return defaultModule;
    }

    public static EndingModule createCardEndingModule(ApplicationContext context, EndingModule defaultModule) {
        String name = AppDefaults.getInstance().getProperty(CARD_ENDING_MODULE);
        return defaultModule;
    }

    public static BasePaymentModule createCashCurrencyPaymentModule(ApplicationContext context, MenuItem menuItem, BasePaymentModule defaultModule) {
        String name = menuItem != null && menuItem.getService() != null && menuItem.getService().getModules() != null && menuItem.getService().getModules().getPayment() != null && !menuItem.getService().getModules().getPayment().isEmpty() ? menuItem.getService().getModules().getPayment() : AppDefaults.getInstance().getProperty(CASH_CURRENCY_PAYMENT_MODULE);
        if ("ntspay".equals(name)) {
            return new NtspayCurrencyPaymentModule(context);
        }
        return defaultModule;
    }

    public static BasePaymentModule createCashPaymentModule(ApplicationContext context, MenuItem menuItem, BasePaymentModule defaultModule) {
        String name = menuItem != null && menuItem.getService() != null && menuItem.getService().getModules() != null && menuItem.getService().getModules().getPayment() != null && !menuItem.getService().getModules().getPayment().isEmpty() ? menuItem.getService().getModules().getPayment() : AppDefaults.getInstance().getProperty(CASH_PAYMEN_MODULE);
        if ("ntspay".equals(name)) {
            return new NtspayCashPaymentModule(context);
        }
        if ("cashless-auto".equals(name)) {
            return new CashlessAutoPaymentModule(context);
        }
        if ("ntspay-snack".equals(name)) {
            return new NtspaySnackCashPaymentModule(context);
        }
        if ("make-credit".equals(name)) {
            return new CreditCashPaymentModule(context);
        }
        return defaultModule;
    }

    public static PaymentModule createPaymentModule(ApplicationContext context, MenuItem menuItem, PaymentModule defaultModule) {
        String name = menuItem != null && menuItem.getService() != null && menuItem.getService().getModules() != null && menuItem.getService().getModules().getPayment() != null && !menuItem.getService().getModules().getPayment().isEmpty() ? menuItem.getService().getModules().getPayment() : AppDefaults.getInstance().getProperty(PAYMENT_MODULE);
        try {
            if ("cash-and-card".equals(name)) {
                return new CashAndCardPaymentModule(context);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return defaultModule;
    }

    public static PayoutModule createPayoutModule(ApplicationContext context, MenuItem menuItem, PayoutModule defaultModule) {
        String name = menuItem != null && menuItem.getService() != null && menuItem.getService().getModules() != null && menuItem.getService().getModules().getPayout() != null && !menuItem.getService().getModules().getPayout().isEmpty() ? menuItem.getService().getModules().getPayout() : AppDefaults.getInstance().getProperty(PAYOUT_MODULE);
        if ("v2".equals(name)) {
            return new PayoutModuleDispatcherV2(context);
        }
        return defaultModule;
    }

    public static PresentModule createPresentModule(ApplicationContext context, MenuItem menuItem, PresentModule defaultModule) {
        String name = menuItem != null && menuItem.getService() != null && menuItem.getService().getModules() != null && menuItem.getService().getModules().getPresent() != null && !menuItem.getService().getModules().getPresent().isEmpty() ? menuItem.getService().getModules().getPresent() : AppDefaults.getInstance().getProperty(PRESENT_MODULE);
        if ("nts-pay-coffee".equals(name)) {
            return new NtsCoffeePresentModule(context);
        }
        return defaultModule;
    }

    public static PrintModule createPrintModule(ApplicationContext context, MenuItem menuItem, PrintModule defaultModule) {
        String name = menuItem != null && menuItem.getService() != null && menuItem.getService().getModules() != null && menuItem.getService().getModules().getPrint() != null && !menuItem.getService().getModules().getPrint().isEmpty() ? menuItem.getService().getModules().getPrint() : AppDefaults.getInstance().getProperty(PRINT_MODULE);
        try {
            if ("ShowcasePrintModule".equals(name)) {
                return new BanneredPrintModule(context);
            }
        }
        catch (Throwable e) {
            Logger.getLogger((String)"pay").error((Object)e);
        }
        return defaultModule;
    }

    public static CompletiveModule createCompletiveModule(ApplicationContext context, MenuItem menuItem, CompletiveModule defaultModule) {
        return defaultModule;
    }

    public static ProcessingModule getDefaultProcessingModule(BaseApplicationContext context) {
        try {
            if (ModuleHelper.isCardRevert() && CardModuleStore.getInstance().isInit()) {
                return new CardRevertProcessingModule(context);
            }
            return new ObsoleteProcessingModule(context);
        }
        catch (Throwable e) {
            e.printStackTrace();
            return new ObsoleteProcessingModule(context);
        }
    }
}

