/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.application.system;

import com.sun.management.OperatingSystemMXBean;
import java.awt.DisplayMode;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Rectangle;
import java.io.File;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.util.Date;
import java.util.LinkedList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.io.FileUtils;
import ru.softlogic.app.DaemonVersion;
import ru.softlogic.app.configuration.SystemProp;
import ru.softlogic.application.system.LinuxSystem;
import ru.softlogic.application.system.WindowsSystem;
import ru.softlogic.hardware.device.DeviceInfo;
import ru.softlogic.hardware.device.DeviceType;
import ru.softlogic.security.RiskFactors;
import ru.softlogic.security.Service;
import ru.softlogic.security.SystemChecker;
import ru.softlogic.srv.api.oth.FileInfo;
import ru.softlogic.srv.api.oth.SystemInfo;
import ru.softlogic.srv.api.security.EnvRiskFactors;
import ru.softlogic.srv.api.security.SystemService;
import ru.softlogic.system.util.DaemonUtil;
import ru.softlogic.system.util.HashUtils;
import ru.softlogic.system.util.OsDetector;
import ru.softlogic.system.util.PathUtils;
import ru.softlogic.system.util.hwd.SerialExtractorApi;

public class PcInfoCollector {
    public static EnvRiskFactors getEvnRiskFactors() {
        RiskFactors rf = SystemChecker.check();
        LinkedList<FileInfo> infos = new LinkedList<FileInfo>();
        LinkedList<SystemService> ssrvs = new LinkedList<SystemService>();
        for (Service s : rf.getServices()) {
            File f = s.getDriver();
            if (!f.canRead()) continue;
            infos.add(new FileInfo(s.getDriver().getAbsolutePath(), s.getDriver().length(), s.getDriver().lastModified(), HashUtils.calculateCRC32Checksum((File)s.getDriver())));
            ssrvs.add(new SystemService(s.getName(), s.getDescription(), f));
        }
        return new EnvRiskFactors(rf.getFactors(), infos.toArray(new FileInfo[infos.size()]), ssrvs.toArray(new SystemService[ssrvs.size()]), rf.getPorts());
    }

    public static DeviceInfo getSensorInfo() {
        DeviceInfo info = new DeviceInfo(DeviceType.TouchScreen);
        String src = PcInfoCollector.readTextFile(PathUtils.getAppHome() + "/resources/dmi/touchscreen");
        if (src != null) {
            info.setVendor(PcInfoCollector.readParam(src, "ID_VENDOR=(.+)"));
            info.setModel(PcInfoCollector.readParam(src, "ID_MODEL=(.+)"));
            info.setPort(PcInfoCollector.readParam(src, "DEVNAME=(.+)"));
            info.setSerial(PcInfoCollector.readParam(src, "ID_SERIAL=(.+)"));
            info.setInfo("rev=" + PcInfoCollector.readParam(src, "ID_REVISION=(.+)"));
        }
        return info;
    }

    public static SystemInfo getPcInfo() {
        SystemInfo si = null;
        si = OsDetector.current() == 2 ? WindowsSystem.getPcInfo() : LinuxSystem.getPcInfo();
        PcInfoCollector.setCommonInfo(si);
        return si;
    }

    private static void setCommonInfo(SystemInfo info) {
        String name;
        String mb;
        OperatingSystemMXBean bean = (OperatingSystemMXBean)ManagementFactory.getOperatingSystemMXBean();
        info.setOsType(OsDetector.current());
        info.setJavaVersion(SystemProp.getJavaVersion());
        info.setMemSize((int)(bean.getTotalPhysicalMemorySize() / 1024L / 1024L));
        info.setSwapSize((int)(bean.getTotalSwapSpaceSize() / 1024L / 1024L));
        info.setHddSerial(SerialExtractorApi.getInstance().getHddSerial());
        info.setAppVersion(DaemonVersion.version + "/" + DaemonUtil.getUpdateBuild());
        info.setAppMem((int)(Runtime.getRuntime().maxMemory() / 1024L / 1024L));
        String cpu = PcInfoCollector.readTextFile(PathUtils.getAppHome() + "/resources/dmi/cpu");
        if (cpu != null) {
            String cores;
            info.setCpuName(PcInfoCollector.readParam(cpu, "Version: (.+)"));
            String speed = PcInfoCollector.readParam(cpu, "Max Speed: (\\d+) MHz");
            if (speed != null && speed.matches("^\\d+$")) {
                info.setCpuFreq(Short.parseShort(speed));
            }
            if ((cores = PcInfoCollector.readParam(cpu, "Core Count: (\\d+)")) != null && cores.matches("^\\d+$")) {
                info.setCpuCount((int)Short.parseShort(cores));
            }
        }
        if (info.getCpuName() == null || info.getCpuName().trim().isEmpty()) {
            String procName = SerialExtractorApi.getInstance().getProcessorName();
            info.setCpuName(procName == null ? null : procName.trim());
        }
        if (info.getCpuCount() == 0) {
            info.setCpuCount(bean.getAvailableProcessors());
        }
        if ((mb = PcInfoCollector.readTextFile(PathUtils.getAppHome() + "/resources/dmi/motherboard")) != null) {
            info.setMbVendor(PcInfoCollector.readParam(mb, "Manufacturer: (.+)"));
            info.setMbModel(PcInfoCollector.readParam(mb, "Product Name: (.+)"));
            info.setMbSerial(PcInfoCollector.readParam(mb, "Serial Number: (.+)"));
        }
        if ((name = PcInfoCollector.readTextFile(PathUtils.getAppHome() + "/resources/dmi/video")) != null) {
            if ((name = name.trim()).matches("^.*VGA compatible controller:.*$")) {
                name = PcInfoCollector.readParam(name, ".*VGA compatible controller: (.+)");
            }
            info.setVideoCard(name.replaceAll("\\p{C}", "?"));
        }
        if ((mb = PcInfoCollector.readTextFile(PathUtils.getAppHome() + "/resources/dmi/mem")) != null) {
            try {
                info.setMemFreq(Short.valueOf(Short.parseShort(PcInfoCollector.readParam(mb, "Speed: (.+) MHz"))));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        try {
            GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
            GraphicsDevice[] gs = ge.getScreenDevices();
            info.setDisplaysCount(gs.length);
            for (int j = 0; j < gs.length && j < 2; ++j) {
                GraphicsDevice gd = gs[j];
                Rectangle r = gd.getDefaultConfiguration().getBounds();
                String display = "" + r.width + "x" + r.height;
                DisplayMode dm = gd.getDisplayMode();
                if (dm != null) {
                    display = display + "," + dm.getBitDepth() + "," + dm.getRefreshRate();
                }
                if (j == 0) {
                    info.setDisplay1(display);
                    continue;
                }
                info.setDisplay2(display);
            }
        }
        catch (Exception ge) {
            // empty catch block
        }
        File cnf = PathUtils.getFilePath((String)"configuration.xml");
        info.setCnfCrc(HashUtils.calculateCRC32Checksum((File)cnf));
        info.setCnfModificationDate(new Date(cnf.lastModified()));
    }

    private static String readTextFile(String filePath) {
        try {
            return FileUtils.readFileToString((File)new File(filePath), (String)"utf-8");
        }
        catch (IOException ex) {
            return null;
        }
    }

    private static String readParam(String data, String ptn) {
        Pattern pattern = Pattern.compile(ptn);
        Matcher matcher = pattern.matcher(data);
        if (matcher.find()) {
            return matcher.group(1).trim();
        }
        return null;
    }
}

