/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.application.system;

import com.sun.management.OperatingSystemMXBean;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.util.Date;
import java.util.LinkedList;
import java.util.Properties;
import org.apache.commons.io.FileUtils;
import org.apache.log4j.Logger;
import ru.softlogic.srv.api.oth.FileInfo;
import ru.softlogic.srv.api.oth.SystemInfo;
import ru.softlogic.system.util.HashUtils;
import ru.softlogic.system.util.OsDetector;
import ru.softlogic.system.util.PathUtils;

class LinuxSystem {
    LinuxSystem() {
    }

    public static SystemInfo getPcInfo() {
        OperatingSystemMXBean bean = (OperatingSystemMXBean)ManagementFactory.getOperatingSystemMXBean();
        SystemInfo info = new SystemInfo();
        info.setOsType(OsDetector.current());
        info.setKernelVersion(bean.getVersion());
        Properties prop = new Properties();
        try {
            prop.load(new FileReader("/etc/lsb-release"));
            info.setOsName(prop.getProperty("DISTRIB_ID"));
            info.setOsVersion(prop.getProperty("DISTRIB_RELEASE"));
        }
        catch (Exception ex) {
            try {
                String release = FileUtils.readFileToString((File)new File("/etc/redhat-release"));
                String[] paths = release.split(" ");
                if (paths.length >= 3) {
                    info.setOsName(paths[0].trim());
                    info.setOsVersion(paths[2].trim());
                }
            }
            catch (IOException ex1) {
                try {
                    String release = FileUtils.readFileToString((File)new File("/etc/issue")).trim();
                    String[] paths = release.split(" ");
                    if (paths.length >= 3) {
                        info.setOsName(paths[0].trim());
                        info.setOsVersion(paths[2].trim());
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
        File cnf = PathUtils.getFilePath((String)"configuration.xml");
        info.setCnfCrc(HashUtils.calculateCRC32Checksum((File)cnf));
        info.setCnfModificationDate(new Date(cnf.lastModified()));
        try {
            LinkedList<FileInfo> files = new LinkedList<FileInfo>();
            for (File f : PathUtils.getFiles()) {
                files.add(new FileInfo(f.getAbsolutePath().replace(PathUtils.getAppHome() + File.separator, ""), f.length(), f.lastModified(), HashUtils.calculateCRC32Checksum((File)f)));
            }
            info.setFiles(files.toArray(new FileInfo[files.size()]));
        }
        catch (Exception e) {
            Logger.getLogger((String)"app").error((Object)(e.getMessage() + " AppHome='" + PathUtils.getAppHome() + "' " + PathUtils.getFiles()));
        }
        return info;
    }
}

