/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.application.collection;

import i18n.B;
import java.io.IOException;
import java.text.MessageFormat;
import org.apache.log4j.Logger;
import ru.softlogic.app.AppEnvironment;
import ru.softlogic.app.DeviceSummary;
import ru.softlogic.app.configuration.AppDefaults;
import ru.softlogic.app.context.BaseApplicationContext;
import ru.softlogic.app.session.Session;
import ru.softlogic.application.collection.MoneyCollectionHandler;
import ru.softlogic.application.collection.MoneyCollectionInitiator;
import ru.softlogic.cash.Keeper;
import ru.softlogic.gui.factory.ComponentFactory;
import ru.softlogic.gui.screen.popup.dialog.DC;
import ru.softlogic.gui.screen.popup.dialog.DialogInterface;
import ru.softlogic.gui.screen.popup.dialog.DialogListener;
import ru.softlogic.gui.screen.popup.dialog.DialogScreen;
import ru.softlogic.gui.screen.popup.dialog.DialogType;
import ru.softlogic.gui.screen.popup.dialog.UserCase;
import ru.softlogic.gui.useraction.UserAction;
import ru.softlogic.hardware.device.cashin.CashDeviceManager;
import ru.softlogic.hardware.device.cashin.validator.status.ValidatorStatus;
import ru.softlogic.hardware.device.cashin.validator.status.ValidatorStatusListener;
import ru.softlogic.hardware.device.print.PrinterType;
import ru.softlogic.hardware.device.print.kkm.KkmOperation;
import ru.softlogic.hardware.device.print.kkm.LastReportsReqest;
import ru.softlogic.hardware.device.print.kkm.ReportResult;
import ru.softlogic.hardware.device.print.queue.ReportRequest;
import ru.softlogic.hardware.device.print.queue.ReportResultListener;
import ru.softlogic.io.utils.BU;
import ru.softlogic.module.ModuleHelper;
import ru.softlogic.provider.ProviderType;
import ru.softlogic.reference.ReferenceException;
import ru.softlogic.reference.ReferenceManager;
import ru.softlogic.reference.point.PointOptions;
import ru.softlogic.reference.point.ServerUser;
import ru.softlogic.srv.api.event.Event;
import ru.softlogic.srv.api.event.EventType;
import ru.softlogic.system.util.CalibrationHelper;
import ru.softlogic.system.util.CheckCollectorPwdHelper;
import ru.softlogic.system.util.network.Ping;

public class MoneyCollectionObserver
implements ValidatorStatusListener {
    private MoneyCollectionHandler cashHandler;
    private MoneyCollectionHandler coinHandler;
    private BaseApplicationContext context;
    private Logger log;
    private boolean busy;
    private ValidatorStatus lastStatus;
    private ServerUser serverUser;

    public MoneyCollectionObserver(MoneyCollectionHandler cashHandler, MoneyCollectionHandler coinHandler) {
        if (cashHandler == null || coinHandler == null) {
            throw new IllegalArgumentException("\u041d\u0443\u0436\u0434\u0430\u044e\u0441\u044c \u0432 MoneyCollectionHandler");
        }
        this.cashHandler = cashHandler;
        this.coinHandler = coinHandler;
        this.log = Logger.getLogger((String)"maintenance");
    }

    public void update(ValidatorStatus status) {
        if (status == ValidatorStatus.StackOut) {
            if (this.lastStatus == null) {
                this.log.info((Object)"\u0421\u0442\u0430\u0440\u0442 \u0441\u043e \u0441\u043d\u044f\u0442\u044b\u043c \u0441\u0442\u0435\u043a\u0435\u0440\u043e\u043c");
                this.context.toMainMenu();
                this.lastStatus = status;
                return;
            }
            Keeper kp = Session.getInstance().getCurrentKeeper();
            if (kp != null && !kp.getSum().isEmpty()) {
                DialogScreen dialog = ComponentFactory.getInstance().createDialog(DialogType.Error, B.get((String)"Collection.keeper.notempty"), 20, DC.cases((int)8), UserCase.Ok);
                dialog.addListener(new DialogListener(){

                    public void dialogClosed(UserCase userCase) {
                        if (MoneyCollectionObserver.this.context.getModuleStore().getModule().getType() != 3) {
                            MoneyCollectionObserver.this.context.toMainMenu();
                        }
                    }
                });
                this.context.showDialog((DialogInterface)dialog);
                return;
            }
            if (!this.busy) {
                this.busy = true;
                String notes = ModuleHelper.formatKeeper(this.cashHandler.getBox().getKeeper());
                String coins = ModuleHelper.formatKeeper(this.coinHandler.getBox().getKeeper());
                String m = "StackOut.";
                if (!notes.isEmpty()) {
                    m = m + " Notes: " + notes + ", Total: " + this.cashHandler.getBox().getKeeper().getCashSum();
                }
                if (!coins.isEmpty()) {
                    m = m + "; Coins: " + coins + ", Total: " + this.coinHandler.getBox().getKeeper().getCashSum();
                }
                this.log.info((Object)m);
                this.context.getServerConnector().sendEvent(new Event(EventType.Warning, m));
                UserAction.getInstance().update();
                int strategy = 0;
                boolean checkColibration = false;
                try {
                    PointOptions po = ReferenceManager.getInstance().getPointOptions();
                    if (po != null) {
                        strategy = po.getCollectionStrategy2();
                        checkColibration = po.isCheckTouchScreen();
                    }
                }
                catch (ReferenceException referenceException) {
                    // empty catch block
                }
                this.log.info((Object)("Strategy: " + BU.toHex((int)strategy)));
                if (checkColibration) {
                    this.toCheckColibration(strategy);
                } else {
                    this.toCheckCollectorPassword(strategy);
                }
            } else {
                this.log.error((Object)"\u041e\u0431\u0440\u0430\u0431\u0430\u0442\u044b\u0432\u0430\u0435\u0442\u0441\u044f \u043f\u0440\u0435\u0434\u044b\u0434\u0443\u0449\u0430\u044f stack \u0438\u043d\u043a\u0430\u0441\u0441\u0430\u0446\u0438\u044f ");
            }
        }
        this.lastStatus = status;
    }

    public void setContext(BaseApplicationContext context) {
        this.context = context;
    }

    private void toCheckColibration(final int strategy) {
        this.log.info((Object)"\u0428\u0430\u0433 \u043f\u0440\u043e\u0432\u0435\u0440\u043a\u0438 \u043a\u0430\u043b\u0438\u0431\u0440\u043e\u0432\u043a\u0438");
        CalibrationHelper.checkCalibrate(this.context, strategy, null, new Runnable(){

            @Override
            public void run() {
                MoneyCollectionObserver.this.toCheckCollectorPassword(strategy);
            }
        });
    }

    private void toCheckCollectorPassword(final int strategy) {
        this.log.info((Object)"\u0428\u0430\u0433 \u043f\u0440\u043e\u0432\u0435\u0440\u043a\u0438 \u043f\u0430\u0440\u043e\u043b\u044f \u0438\u043d\u043a\u0430\u0441\u0441\u0430\u0442\u043e\u0440\u0430");
        this.serverUser = null;
        CheckCollectorPwdHelper.checkPassword(this.context, new Runnable(){

            @Override
            public void run() {
                if (CheckCollectorPwdHelper.isPasswordSet()) {
                    if (CheckCollectorPwdHelper.isCorrectPassword()) {
                        MoneyCollectionObserver.this.serverUser = CheckCollectorPwdHelper.getServerUser();
                        MoneyCollectionObserver.this.toCollectCashinStep(strategy);
                    } else if (CheckCollectorPwdHelper.isTimeout()) {
                        MoneyCollectionObserver.this.toCollectCashinStep(strategy);
                    } else {
                        MoneyCollectionObserver.this.log.info((Object)"\u041e\u0442\u043f\u0440\u0430\u0432\u043b\u044f\u0435\u043c \u043f\u0443\u0441\u0442\u0443\u044e \u0438\u043d\u043a\u0430\u0441\u0441\u0430\u0446\u0438\u044e");
                        MoneyCollectionObserver.this.context.getServerConnector().sendEvent(new Event(EventType.VoidMoneyCollection, "" + (Object)((Object)MoneyCollectionInitiator.CashInHardware) + "," + MoneyCollectionObserver.this.cashHandler.getBox().getDeviceClass()));
                        if (CheckCollectorPwdHelper.isCancel()) {
                            MoneyCollectionObserver.this.toGoToServiceStep(strategy);
                        } else {
                            MoneyCollectionObserver.this.log.info((Object)"\u0413\u043e\u0432\u043e\u0440\u0438\u043c \u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u044e, \u0447\u0442\u043e \u0432\u0432\u0435\u0434\u0435\u043d \u043d\u0435\u0432\u0435\u0440\u043d\u044b\u0439 \u043f\u0430\u0440\u043e\u043b\u044c");
                            DialogScreen dialog = ComponentFactory.getInstance().createDialog(DialogType.Error, B.get((String)"Collection.password.fail"), 23, DC.cases((int)1), UserCase.Ok);
                            dialog.addListener(new DialogListener(){

                                public void dialogClosed(UserCase userCase) {
                                    MoneyCollectionObserver.this.toGoToServiceStep(strategy);
                                }
                            });
                            MoneyCollectionObserver.this.context.showDialog((DialogInterface)dialog);
                        }
                    }
                } else {
                    MoneyCollectionObserver.this.toCollectCashinStep(strategy);
                }
            }
        }, 0);
    }

    private void onMoneyCollection(MoneyCollectionHandler mch) {
        if (mch == null) {
            return;
        }
        if (this.serverUser != null) {
            mch.onMoneyCollection(MoneyCollectionInitiator.CashInHardware, this.serverUser);
        } else {
            mch.onMoneyCollection();
        }
    }

    private void toCollectCashinStep(int strategy) {
        this.log.info((Object)"\u0428\u0430\u0433 \u0438\u043d\u043a\u0430\u0441\u0441\u0430\u0446\u0438\u0438 \u043a\u0443\u043f\u044e\u0440\u043e\u043f\u0440\u0438\u0435\u043c\u043d\u0438\u043a\u0430");
        if ((strategy & 1) > 0) {
            if ((strategy & 2) > 0) {
                this.toCollectCashinQuestion(strategy);
            } else {
                this.onMoneyCollection(this.cashHandler);
                this.toCollectCoinStep(strategy);
            }
        } else {
            this.toCollectCoinStep(strategy);
        }
    }

    private void toCollectCoinStep(int strategy) {
        this.log.info((Object)"\u0428\u0430\u0433 \u0438\u043d\u043a\u0430\u0441\u0441\u0430\u0446\u0438\u0438 \u043c\u043e\u043d\u0435\u0442\u043e\u043f\u0440\u0438\u0435\u043c\u043d\u0438\u043a\u0430");
        if (CashDeviceManager.getInstance().getDefaultCoinValidator() != null || !this.coinHandler.getBox().getKeeper().getSum().isEmpty()) {
            if ((strategy & 4) > 0) {
                if ((strategy & 8) > 0) {
                    this.toCollectCoinQuestion(strategy);
                } else {
                    this.onMoneyCollection(this.coinHandler);
                    this.toPrintZReportStep(strategy);
                }
            } else {
                this.toPrintZReportStep(strategy);
            }
        } else {
            this.toPrintZReportStep(strategy);
        }
    }

    private void toPrintZReportStep(int strategy) {
        PrinterType printerType = this.context.getPrinterQueue().getPrinterType();
        this.log.info((Object)("\u0428\u0430\u0433 \u0437\u0430\u043f\u0440\u043e\u0441\u0430 \u043f\u0435\u0447\u0430\u0442\u0438 Z\u043e\u0442\u0447\u0435\u0442\u0430, \u0422\u0438\u043f \u043f\u0440\u0438\u043d\u0442\u0435\u0440\u0430: " + printerType));
        if ((strategy & 0x10) > 0 && (printerType == PrinterType.Kkm || printerType == PrinterType.KkmOnline)) {
            if ((strategy & 0x20) > 0) {
                this.toZrepotMemQuestion(strategy);
            } else if (printerType == PrinterType.KkmOnline) {
                this.context.getPrinterQueue().printLastZreports(new LastReportsReqest(1, (ReportResultListener)new LocalZReportResultListener(strategy)));
            } else {
                this.context.getPrinterQueue().report(new ReportRequest(KkmOperation.FormReportZMem, (ReportResultListener)new LocalZReportResultListener(strategy)));
            }
        } else {
            this.toGoToServiceStep(strategy);
        }
    }

    private void toGoToServiceStep(int strategy) {
        this.log.info((Object)"\u0428\u0430\u0433 \u043f\u0435\u0440\u0435\u0445\u043e\u0434\u0430 \u0432 \u0441\u0435\u0440\u0432\u0438\u0441");
        if ((strategy & 0x40) > 0) {
            if ((strategy & 0x80) > 0) {
                this.toServiceMenuQuestion();
            } else {
                this.busy = false;
                AppEnvironment.getInstance().open(ProviderType.AdminProvider);
            }
        } else {
            this.busy = false;
            this.context.toMainMenu();
        }
    }

    private void toCollectCashinQuestion(final int strategy) {
        boolean printerOk = false;
        String modemStatus = "";
        try {
            printerOk = DeviceSummary.getPrinter().getStatus().isWork();
        }
        catch (IOException ex) {
            this.log.error((Object)ex, (Throwable)ex);
        }
        if (DeviceSummary.getModemState() != null) {
            int signal = DeviceSummary.getModemState().getSignalLevel();
            modemStatus = (signal > 0 ? "Ok" : "\u041d\u0435\u0442 \u0441\u0435\u0442\u0438") + " (" + signal + ")";
        } else {
            modemStatus = "\u041d\u0435\u0442 \u0434\u0430\u043d\u043d\u044b\u0445 \u043e \u043c\u043e\u0434\u0435\u043c\u0435";
        }
        this.log.info((Object)"\u0417\u0430\u0434\u0430\u0435\u043c \u0432\u043e\u043f\u0440\u043e\u0441 \u043f\u0440\u043e \u0438\u043d\u043a\u0430\u0441\u0441\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u044e \u0441\u0442\u0435\u043a\u0435\u0440\u0430");
        boolean showHWInfo = AppDefaults.getInstance().getBooleanProperty("collection.dialog.show.hwinfo", false);
        String msg = !showHWInfo ? B.get((String)"Collection.question") : MessageFormat.format(B.get((String)"Collection.question") + "<p aligng='left'><br/><br/\u041a\u0443\u043f\u044e\u0440\u043e\u043f\u0440\u0438\u0451\u043c\u043d\u0438\u043a: {0}<br/\u0421\u0443\u043c\u043c\u0430 \u0432 \u043a\u0443\u043f\u044e\u0440\u043e\u043f\u0440\u0438\u0451\u043c\u043d\u0438\u043a\u0435: {1}<br/\u0422\u0435\u0440\u043c\u043e\u043f\u0440\u0438\u043d\u0442\u0435\u0440: {2}<br/\u0421\u0435\u0442\u044c: {3}<br/\u0414\u0430\u0442\u0430 \u043f\u043e\u0441\u043b\u0435\u0434\u043d\u0435\u0439 \u0438\u043d\u043a\u0430\u0441\u0441\u0430\u0446\u0438\u0438: {4}</p>", this.lastStatus + " (" + CashDeviceManager.getInstance().getDefaultCashValidator().getInfo().getVendor() + " " + CashDeviceManager.getInstance().getDefaultCashValidator().getInfo().getModel() + ")", this.cashHandler.getBox().getKeeper().getCashSum(), printerOk ? "Ok" : "Error", Ping.isNetworkAlive() ? "Ok" : "\u041d\u0435\u0442 \u0441\u0435\u0442\u0438", this.cashHandler.getBox().getKeeper().getCreated() == null ? "\u041d\u0435\u0442 \u0434\u0430\u043d\u043d\u044b\u0445" : this.cashHandler.getBox().getKeeper().getCreated());
        DialogScreen dialog = ComponentFactory.getInstance().createDialog(DialogType.Info, msg, 23, DC.cases((int)2), UserCase.Ok);
        dialog.addListener(new DialogListener(){

            public void dialogClosed(UserCase userCase) {
                if (userCase == UserCase.Ok) {
                    MoneyCollectionObserver.this.log.info((Object)"\u041f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u044c \u043f\u043e\u0434\u0442\u0432\u0435\u0440\u0434\u0438\u043b \u043f\u0440\u043e\u0432\u0435\u0434\u0435\u043d\u0438\u0435 \u0438\u043d\u043a\u0430\u0441\u0441\u0430\u0446\u0438\u0438");
                    MoneyCollectionObserver.this.onMoneyCollection(MoneyCollectionObserver.this.cashHandler);
                } else {
                    MoneyCollectionObserver.this.context.getServerConnector().sendEvent(new Event(EventType.VoidMoneyCollection, "" + (Object)((Object)MoneyCollectionInitiator.CashInHardware) + "," + MoneyCollectionObserver.this.cashHandler.getBox().getDeviceClass()));
                }
                MoneyCollectionObserver.this.toCollectCoinStep(strategy);
            }
        });
        this.context.showDialog((DialogInterface)dialog);
    }

    private void toCollectCoinQuestion(final int strategy) {
        this.log.info((Object)"\u0417\u0430\u0434\u0430\u0435\u043c \u0432\u043e\u043f\u0440\u043e\u0441 \u043f\u043e \u0438\u043d\u043a\u0430\u0441\u0441\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u044e \u043c\u043e\u043d\u0435\u0442\u043e\u043f\u0440\u0438\u0435\u043c\u043d\u0438\u043a\u0430");
        DialogScreen dialog = ComponentFactory.getInstance().createDialog(DialogType.Question, B.get((String)"Collection.coin.question"), 23, DC.cases((int)2), UserCase.Ok);
        dialog.addListener(new DialogListener(){

            public void dialogClosed(UserCase userCase) {
                if (userCase == UserCase.Ok) {
                    MoneyCollectionObserver.this.log.info((Object)"\u041f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u044c \u043f\u043e\u0434\u0442\u0432\u0435\u0440\u0434\u0438\u043b \u043f\u0440\u043e\u0432\u0435\u0434\u0435\u043d\u0438\u0435 \u0438\u043d\u043a\u0430\u0441\u0441\u0430\u0446\u0438\u0438");
                    MoneyCollectionObserver.this.onMoneyCollection(MoneyCollectionObserver.this.coinHandler);
                } else {
                    MoneyCollectionObserver.this.context.getServerConnector().sendEvent(new Event(EventType.VoidMoneyCollection, "" + (Object)((Object)MoneyCollectionInitiator.CashInHardware) + "," + MoneyCollectionObserver.this.coinHandler.getBox().getDeviceClass()));
                }
                MoneyCollectionObserver.this.toPrintZReportStep(strategy);
            }
        });
        this.context.showDialog((DialogInterface)dialog);
    }

    private void toZrepotMemQuestion(final int strategy) {
        this.log.info((Object)"\u0417\u0430\u0434\u0430\u0435\u043c \u0432\u043e\u043f\u0440\u043e\u0441 \u043f\u043e \u0441\u043d\u044f\u0442\u0438\u044e Z-\u043e\u0442\u0447\u0435\u0442\u0430 \u0438\u0437 \u043f\u0430\u043c\u044f\u0442\u0438");
        DialogScreen dialog = ComponentFactory.getInstance().createDialog(DialogType.Question, B.get((String)"Collection.z-mem.question"), 23, DC.cases((int)2), UserCase.Ok);
        dialog.addListener(new DialogListener(){

            public void dialogClosed(UserCase userCase) {
                if (userCase == UserCase.Ok) {
                    MoneyCollectionObserver.this.log.info((Object)"\u041f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u044c \u043f\u043e\u0434\u0442\u0432\u0435\u0440\u0434\u0438\u043b \u0441\u043d\u044f\u0442\u0438\u0435 Z-\u043e\u0442\u0447\u0435\u0442\u043e\u0432 \u0438\u0437 \u043f\u0430\u043c\u044f\u0442\u0438");
                    if (MoneyCollectionObserver.this.context.getPrinterQueue().getPrinterType() == PrinterType.KkmOnline) {
                        MoneyCollectionObserver.this.context.getPrinterQueue().printLastZreports(new LastReportsReqest(1, (ReportResultListener)new LocalZReportResultListener(strategy)));
                    } else {
                        MoneyCollectionObserver.this.context.getPrinterQueue().report(new ReportRequest(KkmOperation.FormReportZMem, (ReportResultListener)new LocalZReportResultListener(strategy)));
                    }
                } else {
                    MoneyCollectionObserver.this.toGoToServiceStep(strategy);
                }
            }
        });
        this.context.showDialog((DialogInterface)dialog);
    }

    private void toServiceMenuQuestion() {
        UserAction.getInstance().update();
        this.log.info((Object)"\u0417\u0430\u0434\u0430\u0435\u043c \u0432\u043e\u043f\u0440\u043e\u0441 \u043d\u0430 \u0432\u0445\u043e\u0434 \u0432 \u0441\u0435\u0440\u0432\u0438\u0441\u043d\u043e\u0435 \u043c\u0435\u043d\u044e");
        DialogScreen dialog = ComponentFactory.getInstance().createDialog(DialogType.Question, B.get((String)"Collection.service"), 15, DC.cases((int)2), UserCase.Cancel);
        dialog.addListener(new DialogListener(){

            public void dialogClosed(UserCase userCase) {
                MoneyCollectionObserver.this.log.info((Object)("\u041f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u044c \u0432\u044b\u0431\u0440\u0430\u043b " + userCase));
                MoneyCollectionObserver.this.busy = false;
                if (userCase == UserCase.Ok) {
                    AppEnvironment.getInstance().open(ProviderType.AdminProvider);
                } else {
                    MoneyCollectionObserver.this.context.toMainMenu();
                }
            }
        });
        this.context.showDialog((DialogInterface)dialog);
    }

    private class LocalZReportResultListener2
    implements ReportResultListener {
        private int strategy;

        public LocalZReportResultListener2(int strategy) {
            this.strategy = strategy;
        }

        public void onResult(ReportResult result) {
            if (result.isError()) {
                DialogScreen dialog = ComponentFactory.getInstance().createDialog(DialogType.Error, MessageFormat.format(B.get((String)"Collection.report.result"), result.getMessage(), result.getResult()), 15, DC.cases((int)1), UserCase.Ok);
                dialog.addListener(new DialogListener(){

                    public void dialogClosed(UserCase userCase) {
                        MoneyCollectionObserver.this.toGoToServiceStep(LocalZReportResultListener2.this.strategy);
                    }
                });
                MoneyCollectionObserver.this.context.showDialog((DialogInterface)dialog);
            } else {
                MoneyCollectionObserver.this.toGoToServiceStep(this.strategy);
            }
        }

        public void onFailure(Exception ex) {
            DialogScreen dialog = ComponentFactory.getInstance().createDialog(DialogType.Error, MessageFormat.format(B.get((String)"Collection.report.failure"), ex), 15, DC.cases((int)1), UserCase.Ok);
            dialog.addListener(new DialogListener(){

                public void dialogClosed(UserCase userCase) {
                    MoneyCollectionObserver.this.toGoToServiceStep(LocalZReportResultListener2.this.strategy);
                }
            });
            MoneyCollectionObserver.this.context.showDialog((DialogInterface)dialog);
        }

        public void onUnsupport() {
            DialogScreen dialog = ComponentFactory.getInstance().createDialog(DialogType.Error, B.get((String)"Collection.report.unsupport"), 15, DC.cases((int)1), UserCase.Ok);
            dialog.addListener(new DialogListener(){

                public void dialogClosed(UserCase userCase) {
                    MoneyCollectionObserver.this.toGoToServiceStep(LocalZReportResultListener2.this.strategy);
                }
            });
            MoneyCollectionObserver.this.context.showDialog((DialogInterface)dialog);
        }
    }

    private class LocalZReportResultListener
    implements ReportResultListener {
        private int strategy;

        public LocalZReportResultListener(int strategy) {
            this.strategy = strategy;
        }

        public void onResult(ReportResult result) {
            if (result.isError()) {
                DialogScreen dialog = ComponentFactory.getInstance().createDialog(DialogType.Error, MessageFormat.format(B.get((String)"Collection.report.result"), result.getMessage(), result.getResult()), 15, DC.cases((int)1), UserCase.Ok);
                dialog.addListener(new DialogListener(){

                    public void dialogClosed(UserCase userCase) {
                        MoneyCollectionObserver.this.toGoToServiceStep(LocalZReportResultListener.this.strategy);
                    }
                });
                MoneyCollectionObserver.this.context.showDialog((DialogInterface)dialog);
            } else {
                DialogScreen dialog = ComponentFactory.getInstance().createDialog(DialogType.Question, MessageFormat.format(B.get((String)"Collection.z.question"), result.getMessage(), result.getResult()), 23, DC.cases((int)2), UserCase.Ok);
                dialog.addListener(new DialogListener(){

                    public void dialogClosed(UserCase userCase) {
                        if (userCase == UserCase.Ok) {
                            MoneyCollectionObserver.this.context.getPrinterQueue().report(new ReportRequest(KkmOperation.FormReportZ, (ReportResultListener)new LocalZReportResultListener2(LocalZReportResultListener.this.strategy)));
                        } else {
                            MoneyCollectionObserver.this.toGoToServiceStep(LocalZReportResultListener.this.strategy);
                        }
                    }
                });
                MoneyCollectionObserver.this.context.showDialog((DialogInterface)dialog);
            }
        }

        public void onFailure(Exception ex) {
            DialogScreen dialog = ComponentFactory.getInstance().createDialog(DialogType.Error, MessageFormat.format(B.get((String)"Collection.report.failure"), ex), 15, DC.cases((int)1), UserCase.Ok);
            dialog.addListener(new DialogListener(){

                public void dialogClosed(UserCase userCase) {
                    MoneyCollectionObserver.this.toGoToServiceStep(LocalZReportResultListener.this.strategy);
                }
            });
            MoneyCollectionObserver.this.context.showDialog((DialogInterface)dialog);
        }

        public void onUnsupport() {
            DialogScreen dialog = ComponentFactory.getInstance().createDialog(DialogType.Error, B.get((String)"Collection.report.unsupport"), 15, DC.cases((int)1), UserCase.Ok);
            dialog.addListener(new DialogListener(){

                public void dialogClosed(UserCase userCase) {
                    MoneyCollectionObserver.this.toGoToServiceStep(LocalZReportResultListener.this.strategy);
                }
            });
            MoneyCollectionObserver.this.context.showDialog((DialogInterface)dialog);
        }
    }
}

