/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.application;

import java.io.File;
import org.apache.log4j.Logger;
import ru.softlogic.app.configuration.AppDefaults;
import ru.softlogic.app.configuration.SystemProp;
import ru.softlogic.reference.ReferenceManager;
import ru.softlogic.reference.point.Point;
import ru.softlogic.reference.updater.UpdateOptions;
import ru.softlogic.system.util.OsDetector;
import ru.softlogic.system.util.PathUtils;
import ru.softlogic.system.util.network.RemoteStatusObserver;
import ru.softlogic.update.updater.AutoUpdateControl;
import ru.softlogic.update.updater.HttpUpdateStore;
import ru.softlogic.update.updater.StateListener;
import ru.softlogic.update.updater.UpdateControl;
import ru.softlogic.update.updater.UpdateHandler;
import ru.softlogic.update.updater.UpdateLocks;
import ru.softlogic.update.updater.UpdateMetric;
import ru.softlogic.update.updater.UpdateRequest;
import ru.softlogic.update.updater.UpdateSize;
import ru.softlogic.update.updater.UpdateStore;

public class UpdateChecker
implements Runnable,
RemoteStatusObserver {
    private static final int RESULT_OK = 0;
    private static final int RESULT_ERROR = 1;
    private static final int RESULT_GLOBAL_ERROR = 2;
    private UpdateHandler updateHandler;
    private boolean enabled;
    private long lastAwake;
    private int lastResult;
    private Logger log;

    public UpdateChecker(UpdateHandler updateHandler) {
        if (updateHandler == null) {
            throw new NullPointerException("UpdateHandler");
        }
        this.updateHandler = updateHandler;
        this.log = Logger.getLogger((String)"update");
        this.log.setAdditivity(false);
    }

    public void update(int remoteStatus) {
        boolean newEnabled;
        boolean bl = newEnabled = (remoteStatus & 2) > 0;
        if (this.enabled != newEnabled) {
            this.log.info((Object)("Change update flag: " + newEnabled));
            this.enabled = newEnabled;
            this.lastAwake = 0L;
        }
    }

    @Override
    public void run() {
        this.log.debug((Object)"Checker awake");
        if (!this.enabled) {
            if (UpdateLocks.getInstance().isSoftwareLocked()) {
                UpdateLocks.getInstance().setSoftwareLocked(false);
            }
            return;
        }
        long interval = (System.currentTimeMillis() - this.lastAwake) / 1000L / 60L;
        if (this.lastResult == 0 && interval < 180L) {
            this.log.debug((Object)"Continue to sleep[OK]");
            return;
        }
        if (this.lastResult == 1 && interval < 30L) {
            this.log.debug((Object)"Continue to sleep[ERROR]");
            return;
        }
        if (this.lastResult == 2 && interval < 360L) {
            this.log.debug((Object)"Continue to sleep[GLOBAL]");
            return;
        }
        try {
            UpdateOptions uo = ReferenceManager.getInstance().getUpdateOptions();
            Point point = ReferenceManager.getInstance().getPoint();
            if (uo == null) {
                this.log.error((Object)"Update needed, but have no update options");
                return;
            }
            if (uo.getUpdateUrl() == null || uo.getUpdateUrl().isEmpty()) {
                this.log.error((Object)"Update needed, but url update system is not specify");
                return;
            }
            if (point == null) {
                this.log.error((Object)"Update needed, but point is not specify");
                return;
            }
            this.log.debug((Object)uo.getUpdateUrl());
            UpdateRequest ur = new UpdateRequest((UpdateStore)new HttpUpdateStore(this.updateUrl(uo.getUpdateUrl()), uo.getUpdateLogin(), uo.getUpdatePassword(), point.getId(), AppDefaults.getInstance().getIntegerValue("system.update.socket.timeout")), (UpdateControl)new AutoUpdateControl(5), new File(PathUtils.getAppHome()), new File(PathUtils.getAppHome(), "/update/"), (StateListener)new LocalStateListener());
            if (this.updateHandler.addUpdateRequest(ur)) {
                this.log.info((Object)"Request succesfully added");
            } else {
                this.log.info((Object)"Another request processed");
            }
        }
        catch (Exception ex) {
            this.log.error((Object)"Error on process", (Throwable)ex);
        }
    }

    private String updateUrl(String url) {
        String version = "v5";
        String v = SystemProp.getUpdateVersion();
        if (v != null && !v.isEmpty()) {
            version = v;
        }
        if (OsDetector.current() == 1) {
            return url + "/" + version + "/linux/";
        }
        return url + "/" + version + "/windows/";
    }

    private class LocalStateListener
    implements StateListener {
        private LocalStateListener() {
        }

        public void onStart() {
            UpdateChecker.this.log.info((Object)"State: start update");
        }

        public void onLocalError(Exception ex, UpdateMetric updateMetric) {
            UpdateChecker.this.log.info((Object)("State: local error, metrics=" + updateMetric));
            UpdateChecker.this.lastAwake = System.currentTimeMillis();
            UpdateChecker.this.lastResult = 1;
        }

        public void onGlobalError(Exception ex) {
            UpdateChecker.this.log.info((Object)"State: global error");
            UpdateChecker.this.lastAwake = System.currentTimeMillis();
            UpdateChecker.this.lastResult = 2;
        }

        public void onSkip() {
            UpdateChecker.this.log.info((Object)"State: skip update");
            UpdateChecker.this.lastAwake = System.currentTimeMillis();
            UpdateChecker.this.lastResult = 0;
        }

        public void onSuccess(UpdateMetric updateMetric) {
            UpdateChecker.this.log.info((Object)("State: success " + updateMetric));
            UpdateChecker.this.lastAwake = System.currentTimeMillis();
            UpdateChecker.this.lastResult = 0;
        }

        public void onCancel() {
            UpdateChecker.this.log.info((Object)"State: cancel");
            UpdateChecker.this.lastAwake = System.currentTimeMillis();
            UpdateChecker.this.lastResult = 0;
        }

        public void onConfirm(UpdateSize updateSize) {
            UpdateChecker.this.log.info((Object)("State: update confirm, update size=" + updateSize));
        }

        public void onProgress(String fileName, int total, int progress) {
        }
    }
}

