/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.application;

import org.apache.log4j.Logger;
import ru.softlogic.app.session.Session;
import ru.softlogic.app.state.StateFacade;
import ru.softlogic.cash.Keeper;
import ru.softlogic.module.ModuleTypeListener;
import ru.softlogic.system.util.DaemonUtil;

public class SafeReboot
implements ModuleTypeListener {
    public static final int RESTART_FOR_UPDATE = 17;
    public static final int POWEROFF = 15;
    public static final int ACTION_REBOOT = 1;
    public static final int ACTION_RESTART = 2;
    public static final int ACTION_POWEROFF = 3;
    private static SafeReboot instance = new SafeReboot();
    private int moduleType;
    private volatile int action;
    private volatile int restartCode;
    private volatile String restartCause;
    private Logger log;
    private final Object sync = new Object();

    private SafeReboot() {
        this.log = Logger.getLogger((String)"app");
        Thread th = new Thread((Runnable)new Checker(), "SaveRebootChecker");
        th.setDaemon(true);
        th.start();
    }

    public static SafeReboot getInstance() {
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reboot() {
        this.log.info((Object)"Set reboot flag");
        this.action = 1;
        Object object = this.sync;
        synchronized (object) {
            this.sync.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void poweroff() {
        this.log.info((Object)"Set poweroff flag");
        this.action = 3;
        Object object = this.sync;
        synchronized (object) {
            this.sync.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void restart(int code) {
        this.log.info((Object)("Set restart software flag, code: " + code));
        this.action = 2;
        this.restartCode = code;
        Object object = this.sync;
        synchronized (object) {
            this.sync.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void restart(String cause) {
        this.log.info((Object)("Set restart software flag, cause: " + cause));
        this.action = 2;
        this.restartCause = cause;
        Object object = this.sync;
        synchronized (object) {
            this.sync.notifyAll();
        }
    }

    @Override
    public void onChange(int moduleType) {
        this.moduleType = moduleType;
    }

    private class Checker
    implements Runnable {
        private Checker() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            SafeReboot.this.log.info((Object)"Thread Start");
            while (!Thread.currentThread().isInterrupted()) {
                try {
                    String reason;
                    int i;
                    Object object = SafeReboot.this.sync;
                    synchronized (object) {
                        SafeReboot.this.sync.wait();
                    }
                    int act = SafeReboot.this.action;
                    int exitCode = SafeReboot.this.restartCode;
                    String exitCause = SafeReboot.this.restartCause;
                    if (act <= 0) continue;
                    SafeReboot.this.log.info((Object)("Process action " + act + " with code " + exitCode));
                    String currentReason = "";
                    for (i = 0; i < 600; ++i) {
                        Keeper k = Session.getInstance().getCurrentKeeper();
                        if ((SafeReboot.this.moduleType == 1 || SafeReboot.this.moduleType == 0) && (k == null || k.getSum().isEmpty())) break;
                        reason = "" + SafeReboot.this.moduleType + " " + k;
                        if (!currentReason.equals(reason)) {
                            currentReason = reason;
                            SafeReboot.this.log.info((Object)("Wait reason: " + reason));
                        }
                        Thread.sleep(1000L);
                    }
                    for (i = 0; i < 120; ++i) {
                        int error = StateFacade.getState().getErrorCode();
                        if (error == 13) {
                            reason = Integer.toString(SafeReboot.this.moduleType) + ", error=" + error;
                            if (!currentReason.equals(reason)) {
                                currentReason = reason;
                                SafeReboot.this.log.info((Object)("Wait reason: " + reason));
                            }
                            Thread.sleep(30000L);
                            continue;
                        }
                        Keeper k = Session.getInstance().getCurrentKeeper();
                        if ((SafeReboot.this.moduleType == 1 || SafeReboot.this.moduleType == 0) && (k == null || k.getSum().isEmpty())) break;
                        String reason2 = Integer.toString(SafeReboot.this.moduleType) + " " + k;
                        if (!currentReason.equals(reason2)) {
                            currentReason = reason2;
                            SafeReboot.this.log.info((Object)("Wait reason: " + reason2));
                        }
                        Thread.sleep(30000L);
                    }
                    SafeReboot.this.log.info((Object)"Software in main menu");
                    Thread.sleep(5000L);
                    if (act == 1) {
                        System.exit(20);
                        continue;
                    }
                    if (act == 2) {
                        SafeReboot.this.log.info((Object)"Exit");
                        if (exitCause != null) {
                            DaemonUtil.createExitFlag((String)exitCause);
                        }
                        System.exit(exitCode);
                        continue;
                    }
                    System.exit(21);
                }
                catch (InterruptedException ex) {
                    SafeReboot.this.log.error((Object)ex, (Throwable)ex);
                    Thread.currentThread().interrupt();
                }
                catch (Throwable ex) {
                    SafeReboot.this.log.error((Object)ex, ex);
                }
            }
            SafeReboot.this.log.info((Object)"Thread Stop");
        }
    }
}

