/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.application;

import java.util.Arrays;
import java.util.List;
import org.apache.log4j.Logger;
import ru.softlogic.application.SafeReboot;
import ru.softlogic.module.ModuleTypeListener;
import ru.softlogic.ppp.ConnectionManager;
import ru.softlogic.ppp.ConnectionState;
import ru.softlogic.ppp.ManagerFactory;
import ru.softlogic.ppp.OperationResult;
import ru.softlogic.reference.ReferenceException;
import ru.softlogic.reference.ReferenceManager;
import ru.softlogic.reference.point.PointOptions;
import ru.softlogic.system.util.DaemonUtil;
import ru.softlogic.system.util.ThreadUtil;

public class PppWatcher
implements Runnable,
ModuleTypeListener {
    private String connectionName;
    private Logger log;
    private long lastDisconnect;
    private ConnectionManager manager;
    private List<String> connections;
    private int currentModule;

    public PppWatcher(String connectionName) {
        this.connectionName = connectionName;
        this.manager = ManagerFactory.getInstance().getManager();
        this.lastDisconnect = System.currentTimeMillis();
        this.log = Logger.getLogger((String)"ppp");
        this.log.setAdditivity(false);
    }

    @Override
    public void onChange(int moduleType) {
        this.currentModule = moduleType;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        this.log.info((Object)"Thread start");
        this.connections = Arrays.asList(this.manager.getConnectionsList());
        this.log.info((Object)("\u0414\u043e\u0441\u0442\u0443\u043f\u043d\u044b\u0435 ppp-\u0441\u043e\u0435\u0434\u0438\u043d\u0435\u043d\u0438\u044f: " + this.connections));
        this.log.info((Object)("\u0421\u043e\u0435\u0434\u0438\u043d\u0435\u043d\u0438\u0435 \u0434\u043b\u044f \u0440\u0430\u0431\u043e\u0442\u044b \u041f\u041e: " + this.connectionName));
        this.connectionName = this.getConnectionName();
        this.log.info((Object)("\u0420\u0435\u0430\u043b\u044c\u043d\u043e\u0435 \u0441\u043e\u0435\u0434\u0438\u043d\u0435\u043d\u0438\u0435 \u0434\u043b\u044f \u0440\u0430\u0431\u043e\u0442\u044b \u041f\u041e: " + this.connectionName));
        ThreadUtil.sleep((long)15000L);
        int errCountRas = 0;
        int errCount756 = 0;
        while (!Thread.currentThread().isInterrupted()) {
            try {
                ConnectionManager connectionManager = this.manager;
                synchronized (connectionManager) {
                    long timeout = this.getTimeOut();
                    if (timeout > 0L && System.currentTimeMillis() - this.lastDisconnect > timeout && this.currentModule == 1) {
                        this.log.info((Object)"\u041d\u0435 \u0440\u0430\u0437\u0440\u044b\u0432\u0430\u043b\u0438 \u0441\u0432\u044f\u0437\u044c \u0432 \u0442\u0435\u0447\u0435\u043d\u0438\u0438 \u0437\u0430\u0434\u0430\u043d\u043d\u043e\u0433\u043e \u043f\u0435\u0440\u0438\u043e\u0434\u0430. \u041f\u0440\u043e\u0431\u0443\u044e \u0440\u0430\u0437\u043e\u0440\u0432\u0430\u0442\u044c");
                        this.lastDisconnect = System.currentTimeMillis();
                        this.log.info((Object)"\u041f\u044b\u0442\u0430\u044e\u0441\u044c \u043e\u0441\u0442\u0430\u043d\u043e\u0432\u0438\u0442\u044c \u0432\u0441\u0435 \u0441\u043e\u0435\u0434\u0438\u043d\u0435\u043d\u0438\u044f");
                        OperationResult or = this.manager.disconnectAll();
                        this.log.info((Object)("\u0420\u0435\u0437\u0443\u043b\u044c\u0442\u0430\u0442 \u043e\u0441\u0442\u0430\u043d\u043e\u0432\u0430: " + or));
                        this.log.info((Object)"\u0421\u043f\u0438\u043c 20 \u0441\u0435\u043a\u0443\u043d\u0434");
                        Thread.sleep(20000L);
                        this.log.info((Object)"\u041f\u0440\u043e\u0434\u043e\u043b\u0436\u0430\u0435\u043c \u043e\u043f\u0440\u043e\u0441 \u0441\u043e\u0435\u0434\u0438\u043d\u0435\u043d\u0438\u044f");
                    } else {
                        this.log.info((Object)"\u0417\u0430\u043f\u0440\u0430\u0448\u0438\u0432\u0430\u044e \u0441\u0442\u0430\u0442\u0443\u0441 \u0441\u043e\u0435\u0434\u0438\u043d\u0435\u043d\u0438\u044f: ");
                        int res = this.manager.getConnectionState(this.connectionName);
                        if (res == ConnectionState.ERROR) {
                            this.log.info((Object)("\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u043f\u043e\u043b\u0443\u0447\u0435\u043d\u0438\u0438 \u0441\u043e\u0441\u0442\u043e\u044f\u043d\u0438\u044f \u0441\u043e\u0435\u0434\u0438\u043d\u0435\u043d\u0438\u044f: " + res));
                            OperationResult lastError = this.manager.getLastError();
                            this.log.info((Object)("\u0420\u0430\u0441\u0448\u0438\u0444\u0440\u043e\u0432\u043a\u0430 \u043e\u0448\u0438\u0431\u043a\u0438: " + lastError));
                            if ((lastError.getResult() == 1722 || lastError.getResult() == 1727 || lastError.getResult() == 1723) && ++errCountRas == 2) {
                                this.log.info((Object)"\u0411\u043e\u043b\u0435\u0435 2 \u043f\u043e\u0441\u043b\u0435\u0434\u043e\u0432\u0430\u0442\u0435\u043b\u044c\u043d\u044b\u0445 \u043e\u0448\u0438\u0431\u043e\u043a \u0441 \u043a\u043e\u0434\u043e\u043c 1722(\u043e\u0442\u043a\u0430\u0437 \u0441\u043b\u0443\u0436\u0431\u044b RPC). \u041f\u043e\u0434\u043e\u0437\u0440\u0435\u043d\u0438\u0435 \u043d\u0430 \u0432\u0438\u0440\u0443\u0441\u044b. \u041f\u0435\u0440\u0435\u0437\u0430\u0433\u0440\u0443\u0436\u0430\u044e \u0442\u0435\u0440\u043c\u0438\u043d\u0430\u043b");
                                DaemonUtil.createExitFlag((String)"_flag_rpc");
                                SafeReboot.getInstance().reboot();
                            }
                        } else if (res == ConnectionState.OK_CONNECTED) {
                            errCountRas = 0;
                            this.log.info((Object)"\u0421\u043e\u0435\u0434\u0438\u043d\u0435\u043d\u0438\u0435 \u0443\u0436\u0435 \u0443\u0441\u0442\u0430\u043d\u043e\u0432\u043b\u0435\u043d\u043e. \u041d\u0435\u0442 \u043d\u0435\u043e\u0431\u0445\u043e\u0434\u0438\u043c\u043e\u0441\u0442\u0438 \u0432 \u0437\u0430\u043f\u0443\u0441\u043a\u0435");
                        } else if (res == ConnectionState.OK_DISCONNECTED) {
                            errCountRas = 0;
                            this.log.info((Object)"\u0421\u043e\u0435\u0434\u0438\u043d\u0435\u043d\u0438\u0435 \u043d\u0435 \u0443\u0441\u0442\u0430\u043d\u043e\u0432\u043b\u0435\u043d\u043e. \u0417\u0430\u043f\u0443\u0441\u043a\u0430\u044e");
                            OperationResult or = this.manager.connect(this.connectionName);
                            this.log.info((Object)("\u0417\u0430\u043f\u0443\u0441\u043a \u0441\u043e\u0435\u0434\u0438\u043d\u0435\u043d\u0438\u044f \u0437\u0430\u0432\u0435\u0440\u0448\u0438\u043b\u0441\u044f \u0441 \u0440\u0435\u0437\u0443\u043b\u044c\u0442\u0430\u0442\u043e\u043c: " + or));
                            if (or.getResult() == 756) {
                                if (++errCount756 == 5) {
                                    this.log.info((Object)"\u0411\u043e\u043b\u0435\u0435 5 \u043f\u043e\u0441\u043b\u0435\u0434\u043e\u0432\u0430\u0442\u0435\u043b\u044c\u043d\u044b\u0445 \u043e\u0448\u0438\u0431\u043e\u043a \u0441 \u043a\u043e\u0434\u043e\u043c 756. \u041f\u0435\u0440\u0435\u0437\u0430\u0433\u0440\u0443\u0436\u0430\u044e \u0442\u0435\u0440\u043c\u0438\u043d\u0430\u043b");
                                    DaemonUtil.createExitFlag((String)"_flag_neterror");
                                    SafeReboot.getInstance().reboot();
                                }
                            } else {
                                errCount756 = 0;
                            }
                        }
                    }
                }
            }
            catch (InterruptedException ex) {
                Thread.currentThread().interrupt();
            }
            catch (Throwable ex) {
                this.log.error((Object)"\u041d\u0435\u0438\u0437\u0432\u0435\u0441\u0442\u043d\u0430\u044f \u043e\u0448\u0438\u0431\u043a\u0430", ex);
            }
            this.log.info((Object)("\u0421\u043f\u0438\u0441\u043e\u043a \u0430\u043a\u0442\u0438\u0432\u043d\u044b\u0445 ppp \u0441\u043e\u0435\u0434\u0438\u043d\u0435\u043d\u0438\u0439: " + Arrays.toString(this.manager.getActiveConnectionsList())));
            ThreadUtil.sleep((long)120000L);
        }
        this.log.info((Object)"Thread stop");
    }

    private long getTimeOut() {
        long timeout = 0L;
        try {
            PointOptions po = ReferenceManager.getInstance().getPointOptions();
            if (po != null) {
                timeout = 1000L * (long)po.getDisconnectTimeout();
            }
        }
        catch (ReferenceException referenceException) {
            // empty catch block
        }
        return timeout;
    }

    private String getConnectionName() {
        if (this.connectionName != null && !this.connectionName.isEmpty()) {
            return this.connectionName;
        }
        if (this.connections != null && !this.connections.isEmpty()) {
            for (String name : this.connections) {
                if (!name.equalsIgnoreCase("paylogic") && !name.equalsIgnoreCase("telepay")) continue;
                return name;
            }
        }
        return null;
    }
}

