/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.application;

import java.net.InetAddress;
import java.net.NetworkInterface;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;
import org.apache.log4j.Logger;
import ru.softlogic.srv.api.iface.NetworkDevice;
import ru.softlogic.srv.connector.ClientInterface;
import ru.softlogic.system.util.ThreadUtil;

public class NetworkInterfaceObserver
implements Runnable {
    private ClientInterface clientInterface;
    private Set<NetworkDevice> last;
    private Logger log;

    public NetworkInterfaceObserver(ClientInterface clientInterface) {
        if (clientInterface == null) {
            throw new IllegalArgumentException("\u041d\u0443\u0436\u0434\u0430\u044e\u0441\u044c \u0432 ClientInterface");
        }
        this.clientInterface = clientInterface;
        this.log = Logger.getLogger((String)"app");
        this.log.setAdditivity(false);
    }

    @Override
    public void run() {
        this.log.info((Object)"Thread Start");
        while (!Thread.currentThread().isInterrupted()) {
            Enumeration<NetworkInterface> ni = null;
            try {
                ni = NetworkInterface.getNetworkInterfaces();
                HashSet<NetworkDevice> current = new HashSet<NetworkDevice>();
                if (ni != null) {
                    while (ni.hasMoreElements()) {
                        NetworkInterface eth = ni.nextElement();
                        if (eth.isLoopback()) continue;
                        String name = eth.getName();
                        int mtu = eth.getMTU();
                        String hwd = null;
                        if (eth.getHardwareAddress() != null && eth.getHardwareAddress().length > 5) {
                            byte[] addr = eth.getHardwareAddress();
                            hwd = String.format("%02x:%02x:%02x:%02x:%02x:%02x", addr[0], addr[1], addr[2], addr[3], addr[4], addr[5]);
                        }
                        Object ip = null;
                        if (eth.getInetAddresses() == null) continue;
                        Enumeration<InetAddress> addresses = eth.getInetAddresses();
                        while (addresses.hasMoreElements()) {
                            InetAddress ia = addresses.nextElement();
                            if (ia == null) continue;
                            current.add(new NetworkDevice(name, ia.toString(), hwd, mtu));
                        }
                    }
                    if (!current.equals(this.last) && current.size() > 0) {
                        this.clientInterface.sendNetworkDevices(current.toArray(new NetworkDevice[current.size()]));
                        this.last = current;
                    }
                }
            }
            catch (Throwable ex) {
                this.log.error((Object)"\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u0447\u0442\u0435\u043d\u0438\u0438 \u0441\u0435\u0442\u0435\u0432\u044b\u0445 \u0438\u043d\u0442\u0435\u0440\u0444\u0435\u0439\u0441\u043e\u0432", ex);
            }
            ThreadUtil.sleep((long)20000L);
        }
        this.log.info((Object)"Thread Stop");
    }
}

