/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.application;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.LinkedList;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.apache.commons.io.IOUtils;
import org.apache.log4j.Logger;
import ru.softlogic.app.configuration.AppDefaults;
import ru.softlogic.app.configuration.Configuration;
import ru.softlogic.gui.utils.menu.MenuByServiceIdVisitor;
import ru.softlogic.gui.utils.menu.MenuUtils;
import ru.softlogic.gui.utils.menu.MenuVisitor;
import ru.softlogic.reference.ReferenceException;
import ru.softlogic.reference.ReferenceManager;
import ru.softlogic.reference.point.Dealer;
import ru.softlogic.reference.point.Point;
import ru.softlogic.system.util.FtpSender;

public class ECardSender
implements Runnable {
    private Logger log = Logger.getLogger((String)"app");

    public ECardSender() {
        this.log.setAdditivity(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        block44: {
            this.log.info((Object)"\u0422\u0440\u0435\u0431\u0443\u0435\u0442\u0441\u044f \u043e\u0442\u0441\u044b\u043b\u043a\u0430 \u0434\u0430\u043d\u043d\u044b\u0445 Ecard");
            if (Configuration.getInstance().getMppkPath() == null) {
                this.log.error((Object)"\u0412 \u043a\u043e\u043d\u0444\u0438\u0433\u0443\u0440\u0430\u0446\u0438\u043e\u043d\u043d\u043e\u043c \u0444\u0430\u0439\u043b\u0435 \u043d\u0435 \u0443\u043a\u0430\u0437\u0430\u043d \u043f\u0443\u0442\u044c \u043a \u043f\u0430\u043f\u043a\u0435 \u0441 \u0434\u0430\u043d\u043d\u044b\u043c\u0438 Ecard");
                return;
            }
            String uploadPath = Configuration.getInstance().getMppkPath() + File.separator + "PathToUploadData";
            File uploadFolder = new File(uploadPath);
            if (!uploadFolder.exists()) {
                this.log.error((Object)("\u041d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d\u0430 \u043f\u0430\u043f\u043a\u0430 \u0441 \u0434\u0430\u043d\u043d\u044b\u043c\u0438 \u0434\u043b\u044f \u043e\u0442\u0441\u044b\u043b\u043a\u0438, \u0438\u0441\u043a\u043e\u043c\u044b\u0439 \u043f\u0443\u0442\u044c: " + uploadPath));
                return;
            }
            this.log.info((Object)("\u041f\u0443\u0442\u044c \u043a \u043f\u0430\u043f\u043a\u0435 \u0441 \u0434\u0430\u043d\u043d\u044b\u043c\u0438: " + uploadPath));
            Integer idService = AppDefaults.getInstance().getIntegerValue("Module.ecard.service.id");
            MenuByServiceIdVisitor visitor = new MenuByServiceIdVisitor(idService.intValue());
            MenuUtils.processMenu((MenuVisitor)visitor);
            Dealer provider = null;
            if (visitor.getMenuItem() == null) {
                this.log.info((Object)"\u0421\u0435\u0440\u0432\u0438\u0441 ecard \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d");
                return;
            }
            provider = visitor.getMenuItem().getService().getProvider();
            String address = null;
            if (provider == null || provider.getProperties() == null) {
                this.log.info((Object)"\u041d\u0430\u0441\u0442\u0440\u043e\u0439\u043a\u0438 \u043f\u0440\u043e\u0432\u0430\u0439\u0434\u0435\u0440\u0430 ecard \u043d\u0435 \u0437\u0430\u0434\u0430\u043d\u044b");
                return;
            }
            address = (String)provider.getProperties().get("ftp.address");
            try {
                URL ftp = new URL(address);
                FtpSender ftpSender = new FtpSender(ftp.getHost(), ftp.getPort(), ftp.getUserInfo().split(":")[0], ftp.getUserInfo().split(":")[1]);
                File[] files = uploadFolder.listFiles(new FileFilter(){

                    @Override
                    public boolean accept(File file) {
                        if (file.isDirectory()) {
                            return false;
                        }
                        return file.getAbsolutePath().endsWith(".enc");
                    }
                });
                LinkedList<File> sendedFiles = new LinkedList<File>();
                if (files != null && files.length > 0) {
                    for (File f : files) {
                        boolean flag = true;
                        for (int i = 0; i < 4; ++i) {
                            FileInputStream fis = null;
                            try {
                                fis = new FileInputStream(f);
                                this.log.info((Object)("\u041e\u0442\u043f\u0440\u0430\u0432\u043b\u044f\u044e \u0444\u0430\u0439\u043b: " + f.getAbsolutePath()));
                                ftpSender.send(fis, f.getName(), ftp.getPath());
                                flag = false;
                            }
                            catch (Throwable e) {
                                try {
                                    this.log.error((Object)e, e);
                                }
                                catch (Throwable throwable) {
                                    IOUtils.closeQuietly(fis);
                                    throw throwable;
                                }
                                IOUtils.closeQuietly((InputStream)fis);
                                continue;
                            }
                            IOUtils.closeQuietly((InputStream)fis);
                            break;
                        }
                        if (flag) {
                            this.log.info((Object)("\u041d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u043e\u0442\u043f\u0440\u0430\u0432\u0438\u0442\u044c \u0444\u0430\u0439\u043b: " + f.getAbsolutePath()));
                            continue;
                        }
                        sendedFiles.add(f);
                    }
                    if (sendedFiles.isEmpty()) break block44;
                    Point point = null;
                    try {
                        point = ReferenceManager.getInstance().getPoint();
                    }
                    catch (ReferenceException ex) {
                        this.log.error((Object)"\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u043e\u043b\u0443\u0447\u0435\u043d\u0438\u044f \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u043e\u0432 \u0430\u0432\u0442\u043e\u0440\u0438\u0437\u0430\u0446\u0438\u0438 \u043f\u043e\u0447\u0442\u044b", (Throwable)ex);
                    }
                    SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd_hh-mm");
                    File arc = new File(uploadPath + File.separator + sdf.format(new Date()) + ".zip");
                    arc.createNewFile();
                    byte[] buf = new byte[1000];
                    ZipOutputStream zos = null;
                    ZipEntry ze = null;
                    InputStream is = null;
                    boolean success = true;
                    try {
                        zos = new ZipOutputStream(new FileOutputStream(arc));
                        zos.setLevel(9);
                        String label = "\u0414\u0430\u043d\u043d\u044b\u0435 Ecard, \u0442\u043e\u0447\u043a\u0430: " + (point != null ? point.getId() + "/" + point.getName() : "<\u043d\u0435\u0438\u0437\u0432\u0435\u0441\u0442\u043d\u043e>") + ", localtime=" + new Date();
                        ze = new ZipEntry("label.txt");
                        zos.putNextEntry(ze);
                        zos.write(label.getBytes(), 0, label.getBytes().length);
                        zos.closeEntry();
                        for (File f : sendedFiles) {
                            this.log.info((Object)("\u0414\u043e\u0431\u0430\u0432\u043b\u044f\u044e \u0444\u0430\u0439\u043b: " + f.getAbsolutePath() + ", \u0438\u043c\u044f \u0432\u043b\u043e\u0436\u0435\u043d\u0438\u044f: " + f.getName()));
                            ze = new ZipEntry(f.getName());
                            is = null;
                            try {
                                int read;
                                zos.putNextEntry(ze);
                                is = new BufferedInputStream(new FileInputStream(f));
                                while ((read = is.read(buf)) >= 0) {
                                    zos.write(buf, 0, read);
                                }
                            }
                            catch (IOException ex) {
                                this.log.error((Object)"\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u0441\u043e\u0437\u0434\u0430\u043d\u0438\u0438 \u0430\u0440\u0445\u0438\u0432\u0430: ", (Throwable)ex);
                                success = false;
                                break;
                            }
                            finally {
                                try {
                                    if (is != null) {
                                        is.close();
                                    }
                                    zos.closeEntry();
                                }
                                catch (IOException ex) {
                                    success = false;
                                }
                            }
                        }
                    }
                    catch (IOException ex) {
                        this.log.error((Object)"\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u0441\u043e\u0437\u0434\u0430\u043d\u0438\u0438 \u0430\u0440\u0445\u0438\u0432\u0430: ", (Throwable)ex);
                        success = false;
                    }
                    finally {
                        if (zos != null) {
                            try {
                                zos.close();
                            }
                            catch (IOException ex) {
                                success = false;
                            }
                        }
                    }
                    if (success) {
                        for (File f : sendedFiles) {
                            f.delete();
                        }
                    }
                    break block44;
                }
                this.log.info((Object)"\u041d\u0435\u0442 \u0444\u0430\u0439\u043b\u043e\u0432 \u0434\u043b\u044f \u043e\u0442\u043f\u0440\u0430\u0432\u043a\u0438");
            }
            catch (Exception e) {
                this.log.error((Object)e);
            }
        }
    }
}

