/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.application;

import i18n.B;
import java.awt.EventQueue;
import java.text.MessageFormat;
import java.util.Locale;
import java.util.Map;
import org.apache.log4j.Logger;
import ru.softlogic.app.configuration.AppDefaults;
import ru.softlogic.app.context.ApplicationContext;
import ru.softlogic.app.state.StateFacade;
import ru.softlogic.app.state.TerminalState;
import ru.softlogic.gui.factory.ComponentFactory;
import ru.softlogic.gui.screen.content.menu.MenuListener;
import ru.softlogic.gui.screen.popup.dialog.DC;
import ru.softlogic.gui.screen.popup.dialog.DialogInterface;
import ru.softlogic.gui.screen.popup.dialog.DialogListener;
import ru.softlogic.gui.screen.popup.dialog.DialogScreen;
import ru.softlogic.gui.screen.popup.dialog.DialogType;
import ru.softlogic.gui.screen.popup.dialog.UserCase;
import ru.softlogic.provider.ProviderType;
import ru.softlogic.reference.menu.MenuItem;

public class CashDispMenuListener
implements MenuListener {
    private static final String WARNING_TIMEOUT_KEY = "cashdisp.warning.timeout";
    private ApplicationContext context;
    private MenuListener listener;
    private Logger log;
    private MenuItem mi;
    private Map<String, Object> initData;

    public CashDispMenuListener(ApplicationContext context, MenuListener listener) {
        if (context == null) {
            throw new IllegalArgumentException("\u041d\u0443\u0436\u0434\u0430\u044e\u0441\u044c \u0432 context");
        }
        if (listener == null) {
            throw new IllegalArgumentException("\u041d\u0443\u0436\u0434\u0430\u044e\u0441\u044c \u0432 listener");
        }
        this.context = context;
        this.listener = listener;
        this.log = Logger.getLogger((String)"pay");
    }

    public void init(Locale locale) {
    }

    public void onUserAction(final MenuItem menuItem, Map<String, Object> data) {
        this.mi = menuItem;
        this.initData = data;
        this.log.debug((Object)"----------------------------------------------------------");
        this.log.debug((Object)("Select service: " + menuItem.getService()));
        TerminalState terminalStatus = StateFacade.getState();
        this.log.debug((Object)("Terminal state: " + terminalStatus));
        if ((terminalStatus.getWarningMask() & 8) > 0) {
            this.log.info((Object)"\u041d\u0435\u0432\u043e\u0437\u043c\u043e\u0436\u043d\u043e \u0432\u044b\u0434\u0430\u0442\u044c \u0441\u0434\u0430\u0447\u0443 \u043d\u0438\u0447\u043d\u044b\u043c\u0438. \u0417\u0430\u0434\u0430\u044e \u0432\u043e\u043f\u0440\u043e\u0441 \u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u044e");
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    DialogScreen dialog = ComponentFactory.getInstance().createDialog(DialogType.Warning, MessageFormat.format(B.get((String)"Dialog.payment.cashdisp.warning"), menuItem.getService().getName()), AppDefaults.getInstance().getIntegerValue(CashDispMenuListener.WARNING_TIMEOUT_KEY, 30).intValue(), DC.cases((int)2), UserCase.Ok);
                    dialog.addListener(new DialogListener(){

                        public void dialogClosed(UserCase userCase) {
                            if (userCase == UserCase.Ok) {
                                CashDispMenuListener.this.toNextListener();
                            } else {
                                CashDispMenuListener.this.context.toMainMenu();
                            }
                        }
                    });
                    CashDispMenuListener.this.context.showDialog((DialogInterface)dialog);
                }
            });
        } else {
            this.toNextListener();
        }
    }

    void toNextListener() {
        this.listener.onUserAction(this.mi, this.initData);
    }

    public void onLangSelection(String lang) {
        this.listener.onLangSelection(lang);
    }

    public void onRedirect(int serviceId) {
        this.listener.onRedirect(serviceId);
    }

    public void onProvider(ProviderType type) {
        this.listener.onProvider(type);
    }

    public void onUserAction(String action) {
        this.listener.onUserAction(action);
    }
}

