/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.application;

import i18n.B;
import java.awt.EventQueue;
import java.text.MessageFormat;
import java.util.Locale;
import java.util.Map;
import org.apache.log4j.Logger;
import ru.softlogic.app.context.ApplicationContext;
import ru.softlogic.app.state.StateFacade;
import ru.softlogic.app.state.TerminalState;
import ru.softlogic.gui.factory.ComponentFactory;
import ru.softlogic.gui.screen.content.menu.MenuListener;
import ru.softlogic.gui.screen.popup.dialog.DC;
import ru.softlogic.gui.screen.popup.dialog.DialogInterface;
import ru.softlogic.gui.screen.popup.dialog.DialogListener;
import ru.softlogic.gui.screen.popup.dialog.DialogScreen;
import ru.softlogic.gui.screen.popup.dialog.DialogType;
import ru.softlogic.gui.screen.popup.dialog.UserCase;
import ru.softlogic.provider.ProviderType;
import ru.softlogic.reference.menu.MenuItem;

public class CashAccMenuListener
implements MenuListener {
    private ApplicationContext context;
    private MenuListener listener;
    private Logger log;
    private MenuItem mi;
    private Map<String, Object> initData;

    public CashAccMenuListener(ApplicationContext context, MenuListener listener) {
        if (context == null) {
            throw new IllegalArgumentException("\u041d\u0443\u0436\u0434\u0430\u044e\u0441\u044c \u0432 context");
        }
        if (listener == null) {
            throw new IllegalArgumentException("\u041d\u0443\u0436\u0434\u0430\u044e\u0441\u044c \u0432 listener");
        }
        this.context = context;
        this.listener = listener;
        this.log = Logger.getLogger((String)"pay");
    }

    public void init(Locale locale) {
    }

    public void onUserAction(final MenuItem menuItem, Map<String, Object> data) {
        boolean cashinError;
        this.mi = menuItem;
        this.initData = data;
        this.log.info((Object)"----------------------------------------------------------");
        this.log.info((Object)("Select service: " + menuItem.getService()));
        TerminalState terminalStatus = StateFacade.getState();
        this.log.info((Object)("Terminal state: " + terminalStatus));
        boolean isCash = (menuItem.getService().getPaymentSchemaFlags() & 1) > 0;
        boolean isCbc = (menuItem.getService().getPaymentSchemaFlags() & 2) > 0;
        boolean isCard = (menuItem.getService().getPaymentSchemaFlags() & 4) > 0;
        boolean bl = cashinError = (terminalStatus.getWarningMask() & 0x20) > 0;
        if ((terminalStatus.getWarningMask() & 2) > 0) {
            this.log.info((Object)"\u041d\u0435\u0432\u043e\u0437\u043c\u043e\u0436\u043d\u043e \u043f\u0440\u0438\u043d\u044f\u0442\u044c \u043a\u0443\u043f\u044e\u0440\u044b. \u0417\u0430\u0434\u0430\u044e \u0432\u043e\u043f\u0440\u043e\u0441 \u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u044e");
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    DialogScreen dialog = ComponentFactory.getInstance().createDialog(DialogType.Warning, MessageFormat.format(B.get((String)"Dialog.payment.cashacc.warning"), menuItem.getService().getName()), 10, DC.cases((int)2), UserCase.Ok);
                    dialog.addListener(new DialogListener(){

                        public void dialogClosed(UserCase userCase) {
                            if (userCase == UserCase.Ok) {
                                CashAccMenuListener.this.toNextListener();
                            } else {
                                CashAccMenuListener.this.context.toMainMenu();
                            }
                        }
                    });
                    CashAccMenuListener.this.context.showDialog((DialogInterface)dialog);
                }
            });
        } else if (cashinError && (isCash || isCbc)) {
            if (isCard) {
                this.log.info((Object)"\u041d\u0435\u0432\u043e\u0437\u043c\u043e\u0436\u043d\u043e \u043f\u0440\u0438\u043d\u044f\u0442\u044c \u043a\u0443\u043f\u044e\u0440\u044b, \u043d\u043e \u043d\u0430\u0441\u0442\u0440\u043e\u0435\u043d \u043a\u0430\u0440\u0442\u043e\u0447\u043d\u044b\u0439 \u043c\u043e\u0434\u0443\u043b\u044c. \u0417\u0430\u0434\u0430\u044e \u0432\u043e\u043f\u0440\u043e\u0441 \u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u044e");
                EventQueue.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        DialogScreen dialog = ComponentFactory.getInstance().createDialog(DialogType.Warning, MessageFormat.format(B.get((String)"Dialog.payment.cashacc.warning.card"), menuItem.getService().getName()), 10, DC.cases((int)2), UserCase.Ok);
                        dialog.addListener(new DialogListener(){

                            public void dialogClosed(UserCase userCase) {
                                if (userCase == UserCase.Ok) {
                                    CashAccMenuListener.this.toNextListener();
                                } else {
                                    CashAccMenuListener.this.context.toMainMenu();
                                }
                            }
                        });
                        CashAccMenuListener.this.context.showDialog((DialogInterface)dialog);
                    }
                });
            } else {
                DialogScreen dialog = ComponentFactory.getInstance().createDialog(DialogType.Error, B.get((String)"Dialog.payment.cashacc.error"), 10, DC.cases((int)8), UserCase.Ok);
                dialog.addListener(new DialogListener(){

                    public void dialogClosed(UserCase userCase) {
                        CashAccMenuListener.this.context.toMainMenu();
                    }
                });
                this.context.showDialog((DialogInterface)dialog);
            }
        } else {
            this.toNextListener();
        }
    }

    void toNextListener() {
        this.listener.onUserAction(this.mi, this.initData);
    }

    public void onLangSelection(String lang) {
        this.listener.onLangSelection(lang);
    }

    public void onRedirect(int serviceId) {
        this.listener.onRedirect(serviceId);
    }

    public void onProvider(ProviderType type) {
        this.listener.onProvider(type);
    }

    public void onUserAction(String action) {
        this.listener.onUserAction(action);
    }
}

