/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.application;

import org.apache.log4j.Logger;
import ru.softlogic.cards.v2.module.EmergencyEvent;
import ru.softlogic.cards.v2.module.EmergencyEventListener;
import ru.softlogic.srv.api.event.Event;
import ru.softlogic.srv.api.event.EventType;
import ru.softlogic.srv.connector.ClientInterface;

public class CardEmergencyEventListener
implements EmergencyEventListener {
    private static final Logger log = Logger.getLogger((String)"app");
    private final ClientInterface client;

    public CardEmergencyEventListener(ClientInterface client) {
        if (client == null) {
            throw new NullPointerException("Client interface is needed");
        }
        this.client = client;
    }

    public void onProblem(EmergencyEvent ee, String string) {
        String msg;
        log.error((Object)(ee + " " + string));
        switch (ee) {
            case CARD_CAPTURED: {
                msg = "Card captured " + this.formatMessage(string);
                break;
            }
            case EPP_MASTER_KEY_ABSENT: {
                msg = "Epp master key absent " + this.formatMessage(string);
                break;
            }
            case EPP_SESSION_KEYS_UPDATE_FAILED: {
                msg = "Epp session keys update error " + this.formatMessage(string);
                break;
            }
            default: {
                msg = ee.toString() + this.formatMessage(string);
            }
        }
        this.client.sendEvent(new Event(EventType.Warning, msg));
    }

    private String formatMessage(String message) {
        return message == null ? "" : " " + message;
    }
}

